/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.VisibleVirtualAcctHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import kd.tmc.mon.common.enums.StadimensionEnum;
import kd.tmc.mon.common.enums.StatisCycleEnum;
import kd.tmc.mon.report.helper.ReportCommonHelper;

public class FundFlowDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static Log logger = LogFactory.getLog(FundFlowDataListPlugin.class);

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        return null;
    }

    public DataSet query(ReportQueryParam queryParam) {
        String datasource;
        Map<String, Object> paramMap = ReportCommonHelper.transQueryParam(queryParam);
        DataSet queryDataSet = this.getQueryDataSet(paramMap, datasource = (String)paramMap.get("datasource"));
        if (queryDataSet != null && queryDataSet.copy().hasNext()) {
            DataSet toCharDataSet = this.getToCharDataSet(queryDataSet, paramMap);
            queryDataSet.close();
            DataSet groupByDataSet = this.getGroupByDataSet(toCharDataSet, paramMap);
            toCharDataSet.close();
            DataSet textNameDataSet = this.getTextNameDataSet(groupByDataSet, paramMap);
            groupByDataSet.close();
            DataSet exchDataSet = this.addExch(textNameDataSet, paramMap);
            textNameDataSet.close();
            DataSet lastDataSet = this.addTotol(exchDataSet, paramMap);
            exchDataSet.close();
            return lastDataSet;
        }
        return queryDataSet;
    }

    private QFilter[] initQFilter(Map<String, Object> paramMap) {
        String datasource;
        QFilter qFilterCurrency;
        ArrayList<QFilter> filter = new ArrayList<QFilter>(10);
        String filterStaperiod = (String)paramMap.get("filter_staperiod");
        DynamicObjectCollection filterCurrency = (DynamicObjectCollection)paramMap.get("filter_currency");
        DynamicObjectCollection filterSettlementtype = (DynamicObjectCollection)paramMap.get("filter_settlementtype");
        DynamicObjectCollection filterIntype = (DynamicObjectCollection)paramMap.get("filter_intype");
        DynamicObjectCollection filterOuttype = (DynamicObjectCollection)paramMap.get("filter_outtype");
        DynamicObjectCollection filterFunduse = (DynamicObjectCollection)paramMap.get("filter_funduse");
        Date bookStartDate = null;
        Date bookEndDate = null;
        Boolean isToDay = Boolean.FALSE;
        Date currDate = DateUtils.getCurrentDate();
        if (StringUtils.equals((CharSequence)StatisCycleEnum.LASTYEAR.getCode(), (CharSequence)filterStaperiod)) {
            bookStartDate = DateUtils.getFirstYearDate((Date)DateUtils.getLastYear((Date)currDate, (int)1));
            bookEndDate = DateUtils.getFirstDayOfCurYear();
        } else if (StringUtils.equals((CharSequence)StatisCycleEnum.THISYEAR.getCode(), (CharSequence)filterStaperiod)) {
            bookStartDate = DateUtils.getFirstDayOfCurYear();
            bookEndDate = DateUtils.getFirstYearDate((Date)DateUtils.getNextYear((Date)currDate, (int)1));
        } else if (StringUtils.equals((CharSequence)StatisCycleEnum.LASTMONTH.getCode(), (CharSequence)filterStaperiod)) {
            bookStartDate = DateUtils.getFirstDayOfMonth((Date)DateUtils.getLastMonth((Date)currDate, (int)1));
            bookEndDate = DateUtils.getFirstDayOfCurMonth();
        } else if (StringUtils.equals((CharSequence)StatisCycleEnum.THISMONTH.getCode(), (CharSequence)filterStaperiod)) {
            bookStartDate = DateUtils.getFirstDayOfCurMonth();
            bookEndDate = DateUtils.getFirstDayOfMonth((Date)DateUtils.getNextMonth((Date)currDate, (int)1));
        } else if (StringUtils.equals((CharSequence)StatisCycleEnum.TODAY.getCode(), (CharSequence)filterStaperiod)) {
            bookStartDate = currDate;
            bookEndDate = DateUtils.getNextDay((Date)currDate, (int)1);
            isToDay = Boolean.TRUE;
        } else if (StringUtils.equals((CharSequence)StatisCycleEnum.CONSTOM.getCode(), (CharSequence)filterStaperiod)) {
            bookStartDate = (Date)paramMap.get("filter_perioddate_startdate");
            bookEndDate = (Date)paramMap.get("filter_perioddate_enddate");
            bookEndDate = DateUtils.getNextDay((Date)bookEndDate, (int)1);
        } else {
            bookStartDate = DateUtils.getFirstYearDate((Date)currDate);
            bookEndDate = DateUtils.getLastYearDate((Date)currDate);
        }
        boolean statsInnerAcct = (Boolean)paramMap.get("statsinneracct");
        if (!statsInnerAcct) {
            QFilter acctFilter = new QFilter("inneracct", "=", (Object)0L);
            DynamicObjectCollection accts = QueryServiceHelper.query((String)"am_accountbank", (String)"id", (QFilter[])new QFilter[]{acctFilter});
            List acctIds = accts.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
            QFilter innerAcctFilter = new QFilter("accountbank", "in", acctIds);
            filter.add(innerAcctFilter);
        }
        paramMap.put("isToday", isToDay);
        QFilter qFilterBookStartDate = new QFilter(isToDay != false ? "createtime" : "bookdate", ">=", (Object)bookStartDate);
        QFilter qFilterBookEndDate = new QFilter(isToDay != false ? "createtime" : "bookdate", "<", (Object)bookEndDate);
        filter.add(qFilterBookStartDate);
        filter.add(qFilterBookEndDate);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)filterCurrency)) {
            qFilterCurrency = new QFilter("currency", "in", filterCurrency.stream().filter(EmptyUtil::isNoEmpty).map(e -> e.getLong("id")).collect(Collectors.toList()));
            filter.add(qFilterCurrency);
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)filterSettlementtype)) {
            qFilterCurrency = new QFilter("settlementtype", "in", filterSettlementtype.stream().filter(EmptyUtil::isNoEmpty).map(e -> e.getLong("id")).collect(Collectors.toList()));
            filter.add(qFilterCurrency);
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)filterIntype) || EmptyUtil.isNoEmpty((DynamicObjectCollection)filterOuttype)) {
            QFilter qFilterRecpaytype = null;
            List recpaytypeList = null;
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)filterIntype)) {
                recpaytypeList = filterIntype.stream().filter(EmptyUtil::isNoEmpty).map(e -> e.getLong("id")).collect(Collectors.toList());
                qFilterRecpaytype = new QFilter("recpaytypeid", "in", recpaytypeList).and(new QFilter("recpaytype", "=", (Object)"cas_receivingbilltype"));
            }
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)filterOuttype)) {
                recpaytypeList = filterOuttype.stream().filter(EmptyUtil::isNoEmpty).map(e -> e.getLong("id")).collect(Collectors.toList());
                QFilter qFilterPaymenttype = new QFilter("recpaytypeid", "in", recpaytypeList).and(new QFilter("recpaytype", "=", (Object)"cas_paymentbilltype"));
                if (qFilterRecpaytype != null) {
                    qFilterRecpaytype.or(qFilterPaymenttype);
                } else {
                    qFilterRecpaytype = qFilterPaymenttype;
                }
            }
            filter.add(qFilterRecpaytype);
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)filterFunduse)) {
            QFilter qFilterFundflowitem = new QFilter("entry.e_fundflowitem", "in", filterFunduse.stream().filter(EmptyUtil::isNoEmpty).map(e -> e.getLong("id")).collect(Collectors.toList()));
            filter.add(qFilterFundflowitem);
        }
        if ("directconnacct".equals(datasource = (String)paramMap.get("datasource"))) {
            ArrayList<String> typeList = new ArrayList<String>(2);
            QFilter qFilter = new QFilter("accountbank.issetbankinterface", "=", (Object)"0");
            typeList.add("1");
            typeList.add("3");
            QFilter qFilter1 = new QFilter("accountbank.finorgtype", "not in", typeList);
            filter.add(qFilter.and(qFilter1));
        }
        QFilter qFilterOrg = new QFilter("org", "in", (Object)this.getQueryOrgIds(this.getQueryParam()));
        filter.add(qFilterOrg);
        filter.add(VisibleVirtualAcctHelper.notVirtualAcctQfTOBankJournal());
        filter.add(new QFilter("accountbank.isvirtual", "=", (Object)"0"));
        return filter.toArray(new QFilter[filter.size()]);
    }

    private QFilter[] initTransDetailFilters(Map<String, Object> paramMap) {
        boolean statsInnerAcct;
        ArrayList<QFilter> filter = new ArrayList<QFilter>(10);
        String filterStaperiod = (String)paramMap.get("filter_staperiod");
        DynamicObjectCollection filterCurrency = (DynamicObjectCollection)paramMap.get("filter_currency");
        Date bookStartDate = null;
        Date bookEndDate = null;
        Boolean isToDay = Boolean.FALSE;
        Date currDate = DateUtils.getCurrentDate();
        if (StringUtils.equals((CharSequence)StatisCycleEnum.LASTYEAR.getCode(), (CharSequence)filterStaperiod)) {
            bookStartDate = DateUtils.getFirstYearDate((Date)DateUtils.getLastYear((Date)currDate, (int)1));
            bookEndDate = DateUtils.getFirstDayOfCurYear();
        } else if (StringUtils.equals((CharSequence)StatisCycleEnum.THISYEAR.getCode(), (CharSequence)filterStaperiod)) {
            bookStartDate = DateUtils.getFirstDayOfCurYear();
            bookEndDate = DateUtils.getFirstYearDate((Date)DateUtils.getNextYear((Date)currDate, (int)1));
        } else if (StringUtils.equals((CharSequence)StatisCycleEnum.LASTMONTH.getCode(), (CharSequence)filterStaperiod)) {
            bookStartDate = DateUtils.getFirstDayOfMonth((Date)DateUtils.getLastMonth((Date)currDate, (int)1));
            bookEndDate = DateUtils.getFirstDayOfCurMonth();
        } else if (StringUtils.equals((CharSequence)StatisCycleEnum.THISMONTH.getCode(), (CharSequence)filterStaperiod)) {
            bookStartDate = DateUtils.getFirstDayOfCurMonth();
            bookEndDate = DateUtils.getFirstDayOfMonth((Date)DateUtils.getNextMonth((Date)currDate, (int)1));
        } else if (StringUtils.equals((CharSequence)StatisCycleEnum.TODAY.getCode(), (CharSequence)filterStaperiod)) {
            bookStartDate = currDate;
            bookEndDate = DateUtils.getNextDay((Date)currDate, (int)1);
            isToDay = Boolean.TRUE;
        } else if (StringUtils.equals((CharSequence)StatisCycleEnum.CONSTOM.getCode(), (CharSequence)filterStaperiod)) {
            bookStartDate = (Date)paramMap.get("filter_perioddate_startdate");
            bookEndDate = (Date)paramMap.get("filter_perioddate_enddate");
            bookEndDate = DateUtils.getNextDay((Date)bookEndDate, (int)1);
        } else {
            bookStartDate = DateUtils.getFirstYearDate((Date)currDate);
            bookEndDate = DateUtils.getLastYearDate((Date)currDate);
        }
        ArrayList<QFilter> acctBankFilter = new ArrayList<QFilter>(2);
        String datasource = (String)paramMap.get("datasource");
        if ("directconnacct".equals(datasource)) {
            ArrayList<String> typeList = new ArrayList<String>(2);
            typeList.add("1");
            typeList.add("3");
            QFilter qFilter = new QFilter("issetbankinterface", "=", (Object)"1");
            QFilter qFilter1 = new QFilter("finorgtype", "in", typeList);
            acctBankFilter.add(qFilter.or(qFilter1));
        }
        if (!(statsInnerAcct = ((Boolean)paramMap.get("statsinneracct")).booleanValue())) {
            QFilter acctFilter = new QFilter("inneracct", "=", (Object)0L);
            acctBankFilter.add(acctFilter);
        }
        if (acctBankFilter.size() > 0) {
            DynamicObjectCollection accts = QueryServiceHelper.query((String)"am_accountbank", (String)"id", (QFilter[])acctBankFilter.toArray(new QFilter[acctBankFilter.size()]));
            List acctIds = accts.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
            QFilter acctFilter = new QFilter("accountbank.id", "in", acctIds);
            filter.add(acctFilter);
        }
        paramMap.put("isToday", isToDay);
        QFilter qFilterStartDate = new QFilter("bizdate", ">=", (Object)bookStartDate);
        QFilter qFilterEndDate = new QFilter("bizdate", "<", (Object)bookEndDate);
        filter.add(qFilterStartDate);
        filter.add(qFilterEndDate);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)filterCurrency)) {
            QFilter qFilterCurrency = new QFilter("currency", "in", filterCurrency.stream().filter(EmptyUtil::isNoEmpty).map(e -> e.getLong("id")).collect(Collectors.toList()));
            filter.add(qFilterCurrency);
        }
        QFilter qFilterOrg = new QFilter("company", "in", (Object)this.getQueryOrgIds(this.getQueryParam()));
        filter.add(qFilterOrg);
        filter.add(VisibleVirtualAcctHelper.notVirtualAcctQfTOBankJournal());
        filter.add(new QFilter("accountbank.isvirtual", "=", (Object)"0"));
        return filter.toArray(new QFilter[filter.size()]);
    }

    private DataSet getQueryDataSet(Map<String, Object> paramMap, String dataSource) {
        String filterStadimensionCode = (String)paramMap.get("filter_stadimension");
        String filterStaperiod = (String)paramMap.get("filter_staperiod");
        Boolean isToday = StringUtils.equals((CharSequence)StatisCycleEnum.TODAY.getCode(), (CharSequence)filterStaperiod);
        StringBuilder selectFileds = new StringBuilder();
        String groupByStr = "";
        String[] stadimensionStr = null;
        String showStr = "";
        String transDetailGroupBy = "";
        if (StringUtils.equals((CharSequence)StadimensionEnum.CURRENCY.getCode(), (CharSequence)filterStadimensionCode)) {
            groupByStr = "createtime,currency";
            transDetailGroupBy = "bizdate as createtime,currency";
            stadimensionStr = new String[]{"currency"};
            showStr = "currency";
        } else if (StringUtils.equals((CharSequence)StadimensionEnum.SETTLEMENTTYPE.getCode(), (CharSequence)filterStadimensionCode)) {
            groupByStr = "createtime,settlementtype,currency";
            transDetailGroupBy = "bizdate as createtime,0 as settlementtype,currency";
            stadimensionStr = new String[]{"settlementtype"};
            showStr = "settlementtypename";
        } else if (StringUtils.equals((CharSequence)StadimensionEnum.RECPAYTYPEID.getCode(), (CharSequence)filterStadimensionCode)) {
            groupByStr = "createtime,recpaytype,recpaytypeid,currency";
            transDetailGroupBy = "bizdate as createtime,'' as recpaytype,0 as recpaytypeid,currency";
            stadimensionStr = new String[]{"recpaytype", "recpaytypeid"};
            showStr = "name";
        } else if (StringUtils.equals((CharSequence)StadimensionEnum.FUNDFLOWITEM.getCode(), (CharSequence)filterStadimensionCode)) {
            groupByStr = "createtime,entry.e_fundflowitem as entrye_fundflowitem,entry.e_amount as entrye_amount,entry.e_currency entrye_currency,currency";
            transDetailGroupBy = "bizdate as createtime,0 as entrye_fundflowitem,0 as entrye_amount,0 as entrye_currency,currency";
            stadimensionStr = new String[]{"entrye_fundflowitem"};
            showStr = "fundflowitemname";
        }
        if (isToday.booleanValue()) {
            selectFileds.append(groupByStr);
        } else {
            selectFileds.append(groupByStr.replace("createtime", "bookdate as createtime"));
        }
        selectFileds.append(",debitamount,creditamount");
        DataSet queryDataSet = null;
        switch (dataSource) {
            case "bankjournal": {
                queryDataSet = this.queryBankJournal(paramMap, selectFileds.toString());
                break;
            }
            case "bankbalance": {
                selectFileds = new StringBuilder();
                selectFileds.append(transDetailGroupBy).append(",creditamount debitamount,debitamount creditamount");
                queryDataSet = this.queryTransDetail(paramMap, selectFileds.toString());
                break;
            }
            case "directconnacct": {
                DataSet queryJournal = this.queryBankJournal(paramMap, selectFileds.toString());
                selectFileds = new StringBuilder();
                selectFileds.append(transDetailGroupBy).append(",creditamount debitamount,debitamount creditamount");
                DataSet queryTransDetail = this.queryTransDetail(paramMap, selectFileds.toString());
                queryDataSet = queryJournal.union(queryTransDetail);
            }
        }
        if (StringUtils.equals((CharSequence)StadimensionEnum.FUNDFLOWITEM.getCode(), (CharSequence)filterStadimensionCode)) {
            groupByStr = "createtime,entrye_fundflowitem,currency";
            selectFileds.setLength(0);
            selectFileds.append("createtime");
            selectFileds.append(",entrye_fundflowitem");
            selectFileds.append(",case when debitamount > 0 then case when entrye_fundflowitem = 0 then debitamount else entrye_amount end else 0 end debitamount");
            selectFileds.append(",case when creditamount > 0 then case when entrye_fundflowitem = 0 then creditamount else entrye_amount end else 0 end creditamount");
            selectFileds.append(",case when entrye_fundflowitem = 0 then currency else entrye_currency end currency");
            if (queryDataSet != null) {
                queryDataSet = queryDataSet.select(selectFileds.toString());
            }
        }
        paramMap.put("groupByStr", groupByStr);
        paramMap.put("stadimensionStr", stadimensionStr);
        paramMap.put("showStr", showStr);
        return queryDataSet;
    }

    private DataSet queryTransDetail(Map<String, Object> paramMap, String selectFileds) {
        QFilter[] transDetailFilters = this.initTransDetailFilters(paramMap);
        DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bei_transdetail", (String)selectFileds, (QFilter[])transDetailFilters, null);
        return queryDataSet;
    }

    private DataSet queryBankJournal(Map<String, Object> paramMap, String selectFileds) {
        DataSet queryDataSet = null;
        QFilter[] qFilters = this.initQFilter(paramMap);
        queryDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cas_bankjournal", (String)selectFileds, (QFilter[])qFilters, null);
        return queryDataSet;
    }

    private DataSet getToCharDataSet(DataSet queryDataSet, Map<String, Object> paramMap) {
        String filterStaperiod = (String)paramMap.get("filter_staperiod");
        String groupByStr = (String)paramMap.get("groupByStr");
        String dataFmt = null;
        StringBuilder selectFileds = new StringBuilder();
        String hourStr = ResManager.loadKDString((String)"\u65f6", (String)"FundFlowFormListPlugin_24", (String)"tmc-mon-report", (Object[])new Object[0]);
        dataFmt = StringUtils.equals((CharSequence)StatisCycleEnum.LASTYEAR.getCode(), (CharSequence)filterStaperiod) ? "YYYY-MM" : (StringUtils.equals((CharSequence)StatisCycleEnum.THISYEAR.getCode(), (CharSequence)filterStaperiod) ? "YYYY-MM" : (StringUtils.equals((CharSequence)StatisCycleEnum.LASTMONTH.getCode(), (CharSequence)filterStaperiod) ? "YYYY-MM-dd" : (StringUtils.equals((CharSequence)StatisCycleEnum.THISMONTH.getCode(), (CharSequence)filterStaperiod) ? "YYYY-MM-dd" : (StringUtils.equals((CharSequence)StatisCycleEnum.TODAY.getCode(), (CharSequence)filterStaperiod) ? "HH" : (StringUtils.equals((CharSequence)StatisCycleEnum.CONSTOM.getCode(), (CharSequence)filterStaperiod) ? "YYYY-MM-dd" : "YYYY-MM")))));
        DataSet toCharDataSet = null;
        selectFileds.setLength(0);
        selectFileds.append("to_char(createtime, '").append(dataFmt).append("') ").append(groupByStr).append(",debitamount,creditamount");
        toCharDataSet = queryDataSet.select(selectFileds.toString());
        queryDataSet.close();
        if (StringUtils.equals((CharSequence)StatisCycleEnum.TODAY.getCode(), (CharSequence)filterStaperiod)) {
            selectFileds.setLength(0);
            selectFileds.append(groupByStr.replace("createtime", "case when Cast(createtime as Integer) < 8 then '08:00" + hourStr + "' else createtime + ':00" + hourStr + "' end createtime")).append(",debitamount,creditamount");
            toCharDataSet = toCharDataSet.select(selectFileds.toString());
        }
        return toCharDataSet;
    }

    private DataSet getGroupByDataSet(DataSet toCharDataSet, Map<String, Object> paramMap) {
        StringBuilder selectFileds = new StringBuilder();
        String groupByStr = (String)paramMap.get("groupByStr");
        String[] groupByArr = groupByStr.split(",");
        selectFileds.append(groupByStr).append(",debitamount/10000 debitamount,creditamount/10000 creditamount,case when creditamount != 0  then 1  else 0 end outamountcount,case when debitamount != 0 then 1  else 0 end inamountcount");
        DataSet groupByDataSet = toCharDataSet.select(selectFileds.toString()).groupBy(groupByArr).sum("debitamount").sum("creditamount").sum("outamountcount").sum("inamountcount").finish();
        groupByDataSet = groupByDataSet.addField(" debitamount + creditamount ", "amount");
        groupByDataSet = groupByDataSet.addField(" outamountcount + inamountcount", "amountcount");
        return groupByDataSet;
    }

    private DataSet getTextNameDataSet(DataSet groupByDataSet, Map<String, Object> paramMap) {
        DataSet textNameDataSet = null;
        String filterStadimensionCode = (String)paramMap.get("filter_stadimension");
        String[] leftFiled = groupByDataSet.getRowMeta().getFieldNames();
        String showStr = (String)paramMap.get("showStr");
        String[] rigthFiled = new String[]{showStr};
        if (StringUtils.equals((CharSequence)StadimensionEnum.SETTLEMENTTYPE.getCode(), (CharSequence)filterStadimensionCode)) {
            DataSet settlementTypeDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_settlementtype", (String)("id,name as " + showStr), (QFilter[])new QFilter[0], null);
            textNameDataSet = groupByDataSet.join(settlementTypeDataSet, JoinType.LEFT).on("settlementtype", "id").select(leftFiled, rigthFiled).finish();
            settlementTypeDataSet.close();
        } else if (StringUtils.equals((CharSequence)StadimensionEnum.RECPAYTYPEID.getCode(), (CharSequence)filterStadimensionCode)) {
            DataSet receivingDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cas_receivingbilltype", (String)("id," + showStr), (QFilter[])new QFilter[0], null);
            receivingDataSet = groupByDataSet.where(" recpaytype = 'cas_receivingbilltype' ").join(receivingDataSet, JoinType.LEFT).on("recpaytypeid", "id").select(leftFiled, rigthFiled).finish();
            DataSet paymentDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cas_paymentbilltype", (String)("id," + showStr), (QFilter[])new QFilter[0], null);
            paymentDataSet = groupByDataSet.where(" recpaytype = 'cas_paymentbilltype' ").join(paymentDataSet, JoinType.LEFT).on("recpaytypeid", "id").select(leftFiled, rigthFiled).finish();
            DataSet otherDataSet = groupByDataSet.where(" recpaytype not in ('cas_receivingbilltype' , 'cas_paymentbilltype') ");
            otherDataSet = otherDataSet.addField(" '' ", showStr);
            textNameDataSet = otherDataSet.union(new DataSet[]{receivingDataSet, paymentDataSet});
            otherDataSet.close();
            paymentDataSet.close();
            receivingDataSet.close();
        } else if (StringUtils.equals((CharSequence)StadimensionEnum.FUNDFLOWITEM.getCode(), (CharSequence)filterStadimensionCode)) {
            DataSet settlementTypeDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cas_fundflowitem", (String)("id,name as " + showStr), (QFilter[])new QFilter[0], null);
            textNameDataSet = groupByDataSet.join(settlementTypeDataSet, JoinType.LEFT).on("entrye_fundflowitem", "id").select(leftFiled, rigthFiled).finish();
            settlementTypeDataSet.close();
        } else {
            textNameDataSet = groupByDataSet.copy();
        }
        return textNameDataSet;
    }

    private DataSet addExch(DataSet textNameDataSet, Map<String, Object> paramMap) {
        DataSet currencySet = textNameDataSet.copy().groupBy(new String[]{"currency"}).sum("debitamount", "exchrate").finish();
        Long orgId = TmcOrgDataHelper.getCurrentOrgId();
        Date today = new Date();
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSetBuilder datasetBuilder = algo.createDataSetBuilder(currencySet.getRowMeta());
        Long reportCurrencyId = ((DynamicObject)paramMap.get("filter_statcurrency")).getLong("id");
        Long exchangeRateTableId = ((DynamicObject)paramMap.get("exratetable")).getLong("id");
        BigDecimal tempRate = null;
        Object[] rowData = null;
        Row row = null;
        Long currency = null;
        while (currencySet.hasNext()) {
            rowData = new Object[2];
            row = currencySet.next();
            currency = row.getLong("currency");
            rowData[1] = reportCurrencyId.equals(currency) ? BigDecimal.ONE : (EmptyUtil.isNoEmpty((BigDecimal)(tempRate = BaseDataServiceHelper.getExchangeRate((Long)exchangeRateTableId, (Long)currency, (Long)reportCurrencyId, (Date)today))) ? tempRate : BigDecimal.ZERO);
            rowData[0] = currency;
            datasetBuilder.append(rowData);
        }
        DataSet exchDataSet = datasetBuilder.build();
        exchDataSet = textNameDataSet.copy().join(exchDataSet, JoinType.LEFT).on("currency", "currency").select(textNameDataSet.getRowMeta().getFieldNames(), new String[]{"exchrate"}).finish();
        exchDataSet = exchDataSet.addField("debitamount * exchrate", "exchdebitamount").addField("creditamount * exchrate", "exchcreditamount").addField("amount * exchrate", "exchamount");
        return exchDataSet;
    }

    private DataSet addTotol(DataSet exchDataSet, Map<String, Object> paramMap) {
        int i;
        DynamicObject filterRepcurrency = (DynamicObject)paramMap.get("filter_statcurrency");
        String[] stadimensionStr = (String[])paramMap.get("stadimensionStr");
        String showStr = (String)paramMap.get("showStr");
        String showStrName = showStr + "show";
        String showFiled = null;
        String totolField = "totolField";
        String amtcurrency = "amtcurrency";
        DataSet createTimeGroupDataSet = exchDataSet.copy().groupBy(new String[]{"createtime"}).sum("exchdebitamount", "exchdebittotol").sum("exchcreditamount", "exchcredittotol").sum("outamountcount", "outamountcounttotol").sum("inamountcount", "inamountcounttotol").sum("exchamount", "exchamounttotol").sum("amountcount", "amountcounttotol").finish();
        String createtime = null;
        DataSet createTimeGroupRowDataSet = null;
        DataSet stadimensionDataSet = null;
        StringBuilder conditionStr = new StringBuilder();
        DataSet stadimensionRowDataSet = null;
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        RowMeta rowMeta = exchDataSet.getRowMeta();
        DataSetBuilder datasetBuilder = algo.createDataSetBuilder(rowMeta);
        DataSet lastDataSet = datasetBuilder.build();
        lastDataSet = lastDataSet.addNullField("createdate");
        if (!StringUtils.equals((CharSequence)"currency", (CharSequence)showStr)) {
            lastDataSet = lastDataSet.addNullField(showStrName);
        }
        lastDataSet = lastDataSet.addNullField(totolField);
        lastDataSet = lastDataSet.addNullField(amtcurrency);
        Row createTimeGroupRow = null;
        Row stadimensionRow = null;
        Object stadimension = null;
        int createTimeDataCount = 0;
        boolean addCreateDateFlag = false;
        BigDecimal totolexchdebitamount = BigDecimal.ZERO;
        BigDecimal totolexchcreditamount = BigDecimal.ZERO;
        BigDecimal totolexchamount = BigDecimal.ZERO;
        Integer totoloutcount = 0;
        Integer totolincount = 0;
        Integer totolcount = 0;
        Field[] f = null;
        Object[] oArr = null;
        Object o = null;
        String reportCurrencyName = filterRepcurrency.getString("name");
        String subTotolAmountStr = ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"FundFlowDataListPlugin_0", (String)"tmc-mon-report", (Object[])new Object[0]);
        String totolAmountStr = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"FundFlowDataListPlugin_1", (String)"tmc-mon-report", (Object[])new Object[0]);
        String allAmountStr = ResManager.loadKDString((String)"\u62a5\u544a\u5e01\u79cd\u603b\u8ba1", (String)"FundFlowDataListPlugin_7", (String)"tmc-mon-report", (Object[])new Object[0]);
        while (createTimeGroupDataSet.hasNext()) {
            createTimeGroupRow = createTimeGroupDataSet.next();
            createtime = createTimeGroupRow.getString("createtime");
            createTimeGroupRowDataSet = exchDataSet.where(" createtime =  '" + createtime + "'");
            if (!StringUtils.equals((CharSequence)"currency", (CharSequence)showStr)) {
                stadimensionDataSet = createTimeGroupRowDataSet.copy().groupBy(stadimensionStr).sum("exchdebitamount", "exchdebitsubtotol").sum("exchcreditamount", "exchcreditsubtotol").sum("outamountcount", "outamountcountsubtotol").sum("inamountcount", "inamountcountsubtotol").sum("exchamount", "exchamountsubtotol").sum("amountcount", "amountcountsubtotol").finish();
                addCreateDateFlag = true;
                while (stadimensionDataSet.hasNext()) {
                    stadimensionRow = stadimensionDataSet.next();
                    conditionStr.setLength(0);
                    for (i = 0; i < stadimensionStr.length; ++i) {
                        stadimension = stadimensionRow.get(stadimensionStr[i]);
                        if (stadimension instanceof String) {
                            stadimension = "'" + stadimension + "'";
                        }
                        conditionStr.append(stadimensionStr[i]).append(" = ").append(stadimension);
                        if (stadimensionStr.length <= i + 1) continue;
                        conditionStr.append(" and ");
                    }
                    stadimensionRowDataSet = createTimeGroupRowDataSet.where(conditionStr.toString());
                    if (addCreateDateFlag) {
                        createTimeDataCount = stadimensionRowDataSet.copy().count("createtime", false);
                        stadimensionRowDataSet = stadimensionRowDataSet.top(1).addField("createtime", "createdate").union(stadimensionRowDataSet.range(1, createTimeDataCount).addNullField("createdate"));
                        addCreateDateFlag = false;
                    } else {
                        stadimensionRowDataSet = stadimensionRowDataSet.addNullField("createdate");
                    }
                    createTimeDataCount = stadimensionRowDataSet.copy().count("createtime", false);
                    stadimensionRowDataSet = stadimensionRowDataSet.top(1).addField(showStr, showStrName).union(stadimensionRowDataSet.range(1, createTimeDataCount).addNullField(showStrName)).addField("0", totolField).addField("currency", amtcurrency);
                    lastDataSet = lastDataSet.union(stadimensionRowDataSet);
                    rowMeta = lastDataSet.getRowMeta();
                    f = rowMeta.getFields();
                    oArr = new Object[f.length];
                    showFiled = stadimensionRowDataSet.top(1).next().getString(showStr);
                    if (StringUtils.isEmpty((CharSequence)showFiled)) {
                        showFiled = "";
                    }
                    for (i = 0; i < f.length; ++i) {
                        o = null;
                        if ("debitamount".equals(f[i].getAlias())) {
                            o = stadimensionRow.get("exchdebitsubtotol");
                        } else if ("creditamount".equals(f[i].getAlias())) {
                            o = stadimensionRow.get("exchcreditsubtotol");
                        } else if ("outamountcount".equals(f[i].getAlias())) {
                            o = stadimensionRow.get("outamountcountsubtotol");
                        } else if ("inamountcount".equals(f[i].getAlias())) {
                            o = stadimensionRow.get("inamountcountsubtotol");
                        } else if ("amount".equals(f[i].getAlias())) {
                            o = stadimensionRow.get("exchamountsubtotol");
                        } else if ("amountcount".equals(f[i].getAlias())) {
                            o = stadimensionRow.get("amountcountsubtotol");
                        } else if (showStrName.equals(f[i].getAlias())) {
                            o = showFiled + reportCurrencyName + subTotolAmountStr;
                        } else if (totolField.equals(f[i].getAlias())) {
                            o = "1";
                        } else if (amtcurrency.equals(f[i].getAlias())) {
                            o = filterRepcurrency.getLong("id");
                        }
                        oArr[i] = o;
                    }
                    datasetBuilder = algo.createDataSetBuilder(rowMeta);
                    datasetBuilder.append(oArr);
                    lastDataSet = lastDataSet.union(datasetBuilder.build());
                }
            } else {
                createTimeDataCount = createTimeGroupRowDataSet.copy().count("createtime", false);
                lastDataSet = lastDataSet.union(createTimeGroupRowDataSet.top(1).addField("createtime", "createdate").union(createTimeGroupRowDataSet.range(1, createTimeDataCount).addNullField("createdate")).addField("0", totolField).addField("currency", amtcurrency));
            }
            rowMeta = lastDataSet.getRowMeta();
            f = rowMeta.getFields();
            oArr = new Object[f.length];
            for (i = 0; i < f.length; ++i) {
                o = null;
                if ("debitamount".equals(f[i].getAlias())) {
                    o = createTimeGroupRow.get("exchdebittotol");
                    totolexchdebitamount = totolexchdebitamount.add((BigDecimal)o);
                } else if ("creditamount".equals(f[i].getAlias())) {
                    o = createTimeGroupRow.get("exchcredittotol");
                    totolexchcreditamount = totolexchcreditamount.add((BigDecimal)o);
                } else if ("outamountcount".equals(f[i].getAlias())) {
                    o = createTimeGroupRow.get("outamountcounttotol");
                    totoloutcount = totoloutcount + (Integer)o;
                } else if ("inamountcount".equals(f[i].getAlias())) {
                    o = createTimeGroupRow.get("inamountcounttotol");
                    totolincount = totolincount + (Integer)o;
                } else if ("amount".equals(f[i].getAlias())) {
                    o = createTimeGroupRow.get("exchamounttotol");
                    totolexchamount = totolexchamount.add((BigDecimal)o);
                } else if ("amountcount".equals(f[i].getAlias())) {
                    o = createTimeGroupRow.get("amountcounttotol");
                    totolcount = totolcount + (Integer)o;
                } else if ("createdate".equals(f[i].getAlias())) {
                    o = createtime + reportCurrencyName + totolAmountStr;
                } else if (totolField.equals(f[i].getAlias())) {
                    o = "2";
                } else if (amtcurrency.equals(f[i].getAlias())) {
                    o = filterRepcurrency.getLong("id");
                }
                oArr[i] = o;
            }
            datasetBuilder = algo.createDataSetBuilder(rowMeta);
            datasetBuilder.append(oArr);
            lastDataSet = lastDataSet.union(datasetBuilder.build());
        }
        rowMeta = lastDataSet.getRowMeta();
        f = rowMeta.getFields();
        oArr = new Object[f.length];
        for (i = 0; i < f.length; ++i) {
            o = null;
            if ("debitamount".equals(f[i].getAlias())) {
                o = totolexchdebitamount;
            } else if ("creditamount".equals(f[i].getAlias())) {
                o = totolexchcreditamount;
            } else if ("outamountcount".equals(f[i].getAlias())) {
                o = totoloutcount;
            } else if ("inamountcount".equals(f[i].getAlias())) {
                o = totolincount;
            } else if ("amount".equals(f[i].getAlias())) {
                o = totolexchamount;
            } else if ("amountcount".equals(f[i].getAlias())) {
                o = totolcount;
            } else if ("createdate".equals(f[i].getAlias())) {
                o = allAmountStr;
            } else if (totolField.equals(f[i].getAlias())) {
                o = "3";
            } else if (amtcurrency.equals(f[i].getAlias())) {
                o = filterRepcurrency.getLong("id");
            }
            oArr[i] = o;
        }
        datasetBuilder = algo.createDataSetBuilder(rowMeta);
        datasetBuilder.append(oArr);
        lastDataSet = lastDataSet.union(datasetBuilder.build());
        createTimeGroupDataSet.close();
        if (EmptyUtil.isNoEmpty((Object)createTimeGroupRowDataSet)) {
            createTimeGroupRowDataSet.close();
        }
        if (EmptyUtil.isNoEmpty(stadimensionDataSet)) {
            stadimensionDataSet.close();
        }
        if (EmptyUtil.isNoEmpty(stadimensionRowDataSet)) {
            stadimensionRowDataSet.close();
        }
        return lastDataSet;
    }
}

