/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.ReportOrgQueryWayEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import kd.tmc.mon.report.helper.MonReportHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class GuaranteeStructDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final String LETTER_FIELDS = "id,org,org.name orgtext,entry_guaranteeorg.a_guaranteeorg as guaranteeorg,entry_guaranteeorg.a_guaranteeorgtext as guaranteeorgtext,guaranteeway,guaranteeway guaranteewaytext,currency,currency.name currencytext,entry_guaranteeorg.a_gamount as amount,begindate";
    private static final String TOTAL_FIELDS = "org,orgtext,guaranteeorg,guaranteeorgtext,guaranteeway,guaranteeway guaranteewaytext,currency,currencytext";
    private Map<String, Object> paramMap = null;
    private String groupString = null;
    private String orderString = null;
    private List<String> dimString = new ArrayList<String>(6);
    private Long statCurrency = null;
    private final List<QFilter> filterList = new ArrayList<QFilter>(12);
    private static final Long DEFAULTORGVIEWID = 8L;

    private void init(ReportQueryParam reportQueryParam) {
        this.paramMap = this.transQueryParam(reportQueryParam);
        this.paramMap.putAll(reportQueryParam.getCustomParam());
        this.statCurrency = (Long)((DynamicObject)this.paramMap.get("filter_statcurrency")).getPkValue();
        String dimension = (String)this.paramMap.get("filter_statdim");
        this.groupString = "guaranteeorg".equals(dimension) ? dimension + ',' + dimension + "text" : dimension;
        this.orderString = this.groupString;
        this.dimString = Arrays.asList(this.groupString.split(","));
        List orgIds = this.getQueryOrgIds(reportQueryParam);
        if (EmptyUtil.isNoEmpty((Object)orgIds)) {
            this.filterList.add(new QFilter("entry_guaranteeorg.a_guaranteeorg", "in", (Object)orgIds));
        } else {
            this.filterList.add(QFilter.of((String)"1!=1", (Object[])new Object[0]));
        }
        this.filterList.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        String guaranteeRelation = (String)this.paramMap.get("filter_guaranteerelation");
        if ("in_group_guarantee".equals(guaranteeRelation)) {
            this.filterList.add(new QFilter("entry_guaranteedorg.b_reguaranteetype", "in", Arrays.asList("bos_org", "tmc_org")));
        } else {
            this.filterList.add(new QFilter("entry_guaranteedorg.b_reguaranteetype", "not in", Arrays.asList("bos_org", "tmc_org")));
        }
    }

    public DataSet queryDataSet(ReportQueryParam param) {
        this.init(param);
        DataSet baseDataSet = this.queryBillData(true);
        DataSet baseEndDataSet = this.queryBillData(false);
        DataSet allDataSet = this.handleListDataSet(baseDataSet, baseEndDataSet);
        return this.modifyField(allDataSet);
    }

    public DataSet reDealResultDataSet(DataSet dataSet, ReportQueryParam queryParam) {
        if (dataSet.isEmpty()) {
            return dataSet;
        }
        dataSet = dataSet.updateField("changerate", "case when b_amount_report=0 then '-' else cast(round(changeamount_report*100/b_amount_report, 2) as String) end");
        if ("step".equals(this.paramMap.get("filter_showttype"))) {
            dataSet = dataSet.updateField("orgname", "guaranteeorgtext");
        }
        return dataSet;
    }

    protected DataSet addSubRowDataSet(DataSet bizDs, Map<String, Object> paramMap) {
        String showType = (String)paramMap.get("filter_showttype");
        String statdim = (String)this.getQueryParam().getCustomParam().get("filter_statdim");
        if ("guaranteeorg".equals(statdim) && "step".equals(showType)) {
            return bizDs;
        }
        return super.addSubRowDataSet(bizDs, paramMap);
    }

    private DataSet modifyField(DataSet dataSet) {
        if (this.isNeedOrgTree()) {
            dataSet = this.replenishOrgText(dataSet);
        }
        String statdim = (String)this.paramMap.get("filter_statdim");
        DataSet resultDataSet = dataSet.addField("statcurrency", "currency").removeFields(new String[]{"statcurrency", "pid", "rowid", "sumlevel"});
        switch (statdim) {
            case "guaranteeway": 
            case "guaranteedebt": {
                return resultDataSet;
            }
        }
        return resultDataSet.addField("guaranteeorg", "org");
    }

    private DataSet handleListDataSet(DataSet baseDataSet, DataSet baseEndDataSet) {
        DataSet groupBaseDataSet = this.AfterGroupAddField(this.groupByStatdim(baseDataSet, true));
        DataSet groupBaseEndDataSet = this.AfterGroupAddField(this.groupByStatdim(baseEndDataSet, false));
        CharSequence[] baseFieldNames = groupBaseDataSet.getRowMeta().getFieldNames();
        CharSequence[] baseEndFieldNames = groupBaseEndDataSet.getRowMeta().getFieldNames();
        DataSet totalBaseDataSet = this.addAllTotalDataSet(groupBaseDataSet, Collections.singletonList("b_amount"), this.dimString.get(0));
        DataSet totalBaseEndDataSet = this.addAllTotalDataSet(groupBaseEndDataSet, Collections.singletonList("be_amount"), this.dimString.get(0));
        DataSet newTotalBaseDataSet = totalBaseDataSet.copy().select(String.join((CharSequence)",", totalBaseDataSet.getRowMeta().getFieldNames()).replace("b_amount", "b_amount b_totalamount")).updateField("pid", "0");
        DataSet newTotalBaseEndDataSet = totalBaseEndDataSet.copy().select(String.join((CharSequence)",", totalBaseEndDataSet.getRowMeta().getFieldNames()).replace("be_amount", "be_amount be_totalamount")).updateField("pid", "0");
        groupBaseDataSet = groupBaseDataSet.leftJoin(newTotalBaseDataSet).on("pid", "pid").select((String[])baseFieldNames, new String[]{"b_totalamount"}).finish().select(String.join((CharSequence)",", baseFieldNames) + ",b_amount*100/b_totalamount b_ratio");
        groupBaseEndDataSet = groupBaseEndDataSet.leftJoin(newTotalBaseEndDataSet).on("pid", "pid").select((String[])baseEndFieldNames, new String[]{"be_totalamount"}).finish().select(String.join((CharSequence)",", baseEndFieldNames) + ",be_amount*100/be_totalamount be_ratio");
        String[] newBaseFieldNames = groupBaseDataSet.getRowMeta().getFieldNames();
        String[] newBaseEndFieldNames = groupBaseEndDataSet.getRowMeta().getFieldNames();
        String[] changeBaseEndFieldNames = new String[newBaseEndFieldNames.length];
        StringBuilder field = new StringBuilder();
        for (int i = 0; i < newBaseEndFieldNames.length; ++i) {
            String name = newBaseEndFieldNames[i];
            if ("be_amount,be_ratio".contains(name)) {
                changeBaseEndFieldNames[i] = name;
                continue;
            }
            changeBaseEndFieldNames[i] = name + " " + name + "1";
            field.append("case when ").append(name).append("=null then ").append(name).append("1").append(" else ").append(name).append(" end ").append(name).append(",");
        }
        String b_amount = "(case when b_amount=null then 0 else b_amount end)";
        String be_amount = "(case when be_amount=null then 0 else be_amount end)";
        field.append(b_amount).append(" b_amount,").append(be_amount).append(" be_amount,").append("case when b_ratio=null then 0 else b_ratio end b_ratio,case when be_ratio=null then 0 else be_ratio end be_ratio,").append(be_amount).append("-").append(b_amount).append(" changeamount,");
        field.append("case when b_amount=null or b_amount=0 then 0 else round((").append(be_amount).append("-").append(b_amount).append(")*100/").append("b_amount").append(",2) end changerate");
        DataSet allDateset = groupBaseDataSet.fullJoin(groupBaseEndDataSet).on(this.dimString.get(0), this.dimString.get(0)).select(newBaseFieldNames, changeBaseEndFieldNames).finish().select(field.toString());
        return allDateset;
    }

    private DataSet groupByStatdim(DataSet billDataSet, boolean isBase) {
        String sumField = isBase ? "b_amount" : "be_amount";
        DataSet currencyDataSet = this.getExChangeRateDs(billDataSet, this.paramMap);
        String unit = MonReportHelper.getUnit((String)this.paramMap.get("filter_currencyunit"));
        DataSet exBillDataSet = billDataSet.leftJoin(currencyDataSet).on("currency", "tarcurrency").select(TOTAL_FIELDS.split(","), new String[]{"tarcurrency", "rate", String.format("amount*rate/%s " + sumField, unit)}).finish();
        String dimension = (String)this.paramMap.get("filter_statdim");
        if (!"guaranteeorg".equals(dimension)) {
            return exBillDataSet == null ? MonReportHelper.createEmptyDs() : this.dealMultField(exBillDataSet, this.groupString).groupBy(this.groupString.split(",")).sum(sumField).finish();
        }
        return exBillDataSet == null ? MonReportHelper.createEmptyDs() : exBillDataSet.groupBy(this.groupString.split(",")).sum(sumField).finish();
    }

    private DataSet dealMultField(DataSet dataSet, final String Field2) {
        final RowMeta rowMeta = dataSet.getRowMeta();
        return dataSet.map(new MapFunction(){

            public Object[] map(Row row) {
                ArrayList<Object> rowInfo = new ArrayList<Object>();
                for (String fieldName : rowMeta.getFieldNames()) {
                    if (Field2.equals(fieldName)) {
                        List<String> multItems = Arrays.asList(row.getString(Field2).replace(",", " ").trim().split(" "));
                        Collections.sort(multItems);
                        rowInfo.add(String.join((CharSequence)",", multItems));
                        continue;
                    }
                    rowInfo.add(row.get(fieldName));
                }
                return rowInfo.toArray();
            }

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }
        });
    }

    public Pair<String, String> getBizAndReportOrgProp() {
        return Pair.of((Object)"org", (Object)"guaranteeorgtext");
    }

    public List<String> groupFields() {
        String statdim;
        ArrayList<String> list = new ArrayList<String>(8);
        switch (statdim = (String)this.paramMap.get("filter_statdim")) {
            case "guaranteeorg": {
                list.add("guaranteeorg");
                list.add("guaranteeorgtext");
                break;
            }
            case "guaranteeway": {
                list.add("guaranteeway");
                break;
            }
            case "guaranteedebt": {
                list.add("guaranteedebttext");
            }
        }
        list.add("currency");
        return list;
    }

    public String sumNameField() {
        String columnStr;
        String statdim;
        switch (statdim = (String)this.paramMap.get("filter_statdim")) {
            case "guaranteeorg": {
                columnStr = "guaranteeorgtext";
                break;
            }
            case "guaranteeway": {
                columnStr = "guaranteeway";
                break;
            }
            case "guaranteedebt": {
                columnStr = "guaranteedebttext";
                break;
            }
            default: {
                columnStr = "guaranteeorgtext";
            }
        }
        return columnStr;
    }

    protected List<String> orinalAmountField() {
        return Arrays.asList("b_amount", "be_amount", "changeamount");
    }

    public List<String> amountFields() {
        return Arrays.asList("b_amount_report", "be_amount_report", "changeamount_report");
    }

    public List<String> sumAmountFields() {
        return Arrays.asList("b_amount_report", "be_amount_report", "changeamount_report");
    }

    protected boolean isNeedOrgTree() {
        return "guaranteeorg".equals(this.paramMap.get("filter_statdim"));
    }

    protected boolean isOrgNeedAddRootNode() {
        return true;
    }

    private DataSet queryBillData(boolean isBase) {
        QFilter qFilter = this.getDateFilter(isBase);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(this.filterList);
        qFilters.add(qFilter);
        return QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "gm_guaranteecontract"), (String)"gm_guaranteecontract", (String)LETTER_FIELDS, (QFilter[])qFilters.toArray(new QFilter[0]), (String)this.orderString).distinct();
    }

    private QFilter getDateFilter(boolean isBase) {
        Date baseDate = (Date)this.paramMap.get("filter_basedate");
        Date cutoffDate = (Date)this.paramMap.get("filter_cutoffdate");
        Date date = isBase ? baseDate : cutoffDate;
        return new QFilter("begindate", "<=", (Object)date);
    }

    public DataSet AfterGroupAddField(DataSet sourceDataSet) {
        String[] fieldNames = sourceDataSet.getRowMeta().getFieldNames();
        ArrayList<Field> field = new ArrayList<Field>(fieldNames.length);
        for (int i = 0; i < fieldNames.length; ++i) {
            field.add(new Field(fieldNames[i], sourceDataSet.getRowMeta().getFieldDataType(i)));
        }
        field.add(new Field("statcurrency", (DataType)DataType.LongType));
        field.add(new Field("pid", (DataType)DataType.IntegerType));
        field.add(new Field("rowid", (DataType)DataType.LongType));
        field.add(new Field("sumlevel", (DataType)DataType.IntegerType));
        RowMeta rowMeta = new RowMeta(field.toArray(new Field[0]));
        Algo algo = Algo.create((String)"");
        DataSetBuilder dsBuilder = algo.createDataSetBuilder(rowMeta);
        Iterator it = sourceDataSet.copy().iterator();
        while (it.hasNext()) {
            ArrayList<Object> values = new ArrayList<Object>(field.size());
            Row row = (Row)it.next();
            for (int i = 0; i < fieldNames.length; ++i) {
                values.add(row.get(i));
            }
            values.add(String.valueOf(this.statCurrency));
            values.add("0");
            values.add(String.valueOf(DBServiceHelper.genGlobalLongId()));
            values.add("0");
            dsBuilder.append(values.toArray());
        }
        return dsBuilder.build();
    }

    private DataSet replenishOrgText(DataSet sourceDataSet) {
        DataSet orgDataSet;
        String queryWay = (String)this.paramMap.get("filter_queryway");
        if (ReportOrgQueryWayEnum.ORG.getValue().equals(queryWay)) {
            List orgIds = (List)this.paramMap.get("filter_org");
            orgDataSet = EmptyUtil.isNoEmpty((Object)orgIds) ? TmcOrgDataHelper.getOrgDateSet((Long)DEFAULTORGVIEWID).filter("orgid in (" + StringUtils.join((Collection)orgIds, (String)",") + ")") : TmcOrgDataHelper.getOrgDateSet((Long)DEFAULTORGVIEWID);
        } else {
            DynamicObject orgView = (DynamicObject)this.paramMap.get("filter_orgview");
            orgDataSet = TmcOrgDataHelper.getOrgDateSet((Long)orgView.getLong("id"));
        }
        DataSet tarDateSet = sourceDataSet.leftJoin(orgDataSet).on("guaranteeorg", "org").select(sourceDataSet.getRowMeta().getFieldNames(), new String[]{"orgname"}).finish();
        return tarDateSet.removeFields(new String[]{"guaranteeorgtext"}).addField("orgname", "guaranteeorgtext");
    }
}

