/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;

public class HugeFundFlowDtlDataPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final String TRANSDETAIL_SELECT = "company.name as org,bank.name as bank,currency,currency.name as currencyname,biztime as bizdate,description,case when creditamount!=0 and (debitamount=0 or debitamount=null) then '1' else '2' end as direction,creditamount as oriflowinamt,debitamount as oriflowoutamt";
    private static final String BANKJOURNAL_SELECT = "org.name as org,accountbank.bank.name as bank,currency,currency.name as currencyname,bookdate as bizdate,description,case when debitamount!=0 then '1' when creditamount!=0 then '2' else '' end as direction,debitamount as oriflowinamt,creditamount as oriflowoutamt";
    private String statDim;
    private String amtType;
    private BigDecimal startAmt;
    private BigDecimal endAmt;
    private String direction;

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paraMap = this.transQueryParam(queryParam);
        this.initParams(paraMap);
        List<QFilter> qFilters = this.buildQueryFilters(paraMap, this.getQueryOrgIds(queryParam));
        return this.queryPrimaryData(qFilters, paraMap);
    }

    private void initParams(Map<String, Object> paraMap) {
        this.statDim = (String)paraMap.get("filter_statdim");
        this.amtType = (String)paraMap.get("filter_amttype");
        this.startAmt = (BigDecimal)paraMap.get("filter_startamt");
        this.endAmt = (BigDecimal)paraMap.get("filter_endamt");
        this.direction = (String)paraMap.get("filter_direction");
    }

    public DataSet reDealResultDataSet(DataSet dataSet, ReportQueryParam queryParam) {
        if (dataSet == null || dataSet.isEmpty()) {
            return dataSet;
        }
        if (StringUtils.equals((CharSequence)"exc", (CharSequence)this.amtType)) {
            List<String> directionList = Arrays.asList(this.direction.split(","));
            if (EmptyUtil.isNoEmpty((BigDecimal)this.startAmt)) {
                dataSet = dataSet.filter(this.buildQfilterByAmt(directionList, ">=", this.startAmt));
            }
            if (EmptyUtil.isNoEmpty((BigDecimal)this.endAmt)) {
                dataSet = dataSet.filter(this.buildQfilterByAmt(directionList, "<=", this.endAmt));
            }
        }
        dataSet = dataSet.addField("0 as excpureamt", "excpureamt").updateField("excpureamt", "case when sumlevel!=0 then excflowinamt-excflowoutamt else excpureamt end");
        return dataSet;
    }

    protected List<String> orinalAmountField() {
        return Arrays.asList("oriflowinamt", "oriflowoutamt");
    }

    protected String getReportField(String field) {
        return field.replace("ori", "exc");
    }

    public String subNameField() {
        String subNameField = "org";
        if ("o".equals(this.statDim)) {
            subNameField = "bank";
        }
        return subNameField;
    }

    public String sumNameField() {
        String sumNameField = "org";
        if ("b".equals(this.statDim)) {
            sumNameField = "bank";
        } else if ("c".equals(this.statDim)) {
            sumNameField = "currencyname";
        }
        return sumNameField;
    }

    public List<String> groupFields() {
        ArrayList<String> groupFields = new ArrayList<String>(2);
        switch (this.statDim) {
            case "o": {
                groupFields.add("org");
                break;
            }
            case "b": {
                groupFields.add("bank");
                break;
            }
            case "c": {
                groupFields.add("currencyname");
                break;
            }
        }
        return groupFields;
    }

    public List<String> sumAmountFields() {
        return Arrays.asList("excflowinamt", "excflowoutamt");
    }

    public List<String> orderByFields() {
        String orderByField = "";
        switch (this.statDim) {
            case "o": {
                orderByField = "org,sumlevel,excflowinamt desc,excflowoutamt desc,bank";
                break;
            }
            case "b": {
                orderByField = "bank,sumlevel,excflowinamt desc,excflowoutamt desc,org";
                break;
            }
            case "c": {
                orderByField = "currencyname,sumlevel,excflowinamt desc,excflowoutamt desc,org";
                break;
            }
        }
        return Arrays.asList(orderByField.split(","));
    }

    private DataSet queryPrimaryData(List<QFilter> qFilters, Map<String, Object> paraMap) {
        DataSet dataSet = "A".equals(paraMap.get("filter_datasource")) ? QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bei_transdetail", (String)TRANSDETAIL_SELECT, (QFilter[])qFilters.toArray(new QFilter[0]), (String)"") : QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cas_bankjournal", (String)BANKJOURNAL_SELECT, (QFilter[])qFilters.toArray(new QFilter[0]), (String)"");
        return dataSet;
    }

    private List<QFilter> buildQueryFilters(Map<String, Object> paraMap, List<Long> orgIds) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        String description = (String)paraMap.get("filter_description");
        if (EmptyUtil.isNoEmpty((String)description)) {
            qFilters.add(new QFilter("description", "ftlike", (Object)description));
        }
        String direction = (String)paraMap.get("filter_direction");
        List<String> directionList = Arrays.asList(direction.split(","));
        this.buildAmtQfilter(paraMap, directionList, qFilters);
        this.buildSpecialQfilter(paraMap, directionList, qFilters, orgIds);
        return qFilters;
    }

    private void buildSpecialQfilter(Map<String, Object> paraMap, List<String> directionList, List<QFilter> qFilters, List<Long> orgIds) {
        Date startDate = (Date)paraMap.get("filter_startdate");
        Date endDate = (Date)paraMap.get("filter_enddate");
        String dataSource = (String)paraMap.get("filter_datasource");
        if ("A".equals(dataSource)) {
            List bankIds = (List)paraMap.get("filter_openbank");
            if (EmptyUtil.isNoEmpty((Object)bankIds)) {
                qFilters.add(new QFilter("bank", "in", (Object)bankIds));
            }
            qFilters.add(new QFilter("company", "in", orgIds));
            qFilters.add(new QFilter("biztime", ">=", (Object)startDate));
            qFilters.add(new QFilter("biztime", "<", (Object)endDate));
            if (directionList.contains("1") && !directionList.contains("2")) {
                qFilters.add(new QFilter("creditamount", "!=", (Object)0));
            } else if (directionList.contains("2") && !directionList.contains("1")) {
                qFilters.add(new QFilter("debitamount", "!=", (Object)0));
            }
        } else {
            List bankAcctIds = (List)paraMap.get("filter_bankacct");
            if (EmptyUtil.isNoEmpty((Object)bankAcctIds)) {
                qFilters.add(new QFilter("accountbank", "in", (Object)bankAcctIds));
            }
            qFilters.add(new QFilter("org", "in", orgIds));
            qFilters.add(new QFilter("bookdate", ">=", (Object)startDate));
            qFilters.add(new QFilter("bookdate", "<", (Object)endDate));
            if (directionList.contains("1") && !directionList.contains("2")) {
                qFilters.add(new QFilter("debitamount", "!=", (Object)0));
            } else if (directionList.contains("2") && !directionList.contains("1")) {
                qFilters.add(new QFilter("creditamount", "!=", (Object)0));
            }
        }
    }

    private void buildAmtQfilter(Map<String, Object> paraMap, List<String> directionList, List<QFilter> qFilters) {
        BigDecimal endAmt;
        if (!StringUtils.equals((CharSequence)"ori", (CharSequence)((String)paraMap.get("filter_amttype")))) {
            return;
        }
        BigDecimal startAmt = (BigDecimal)paraMap.get("filter_startamt");
        String dataSource = (String)paraMap.get("filter_datasource");
        if (EmptyUtil.isNoEmpty((BigDecimal)startAmt)) {
            QFilter startAmtFilter = this.buildQfilterByAmt(dataSource, directionList, ">=", startAmt);
            qFilters.add(startAmtFilter);
        }
        if (EmptyUtil.isNoEmpty((BigDecimal)(endAmt = (BigDecimal)paraMap.get("filter_endamt")))) {
            QFilter endAmtFilter = this.buildQfilterByAmt(dataSource, directionList, "<=", endAmt);
            qFilters.add(endAmtFilter);
        }
    }

    private QFilter buildQfilterByAmt(String dataSource, List<String> directionList, String compareCode, BigDecimal startAmt) {
        QFilter startAmtFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        if (directionList.contains("1") && !directionList.contains("2")) {
            startAmtFilter = new QFilter(this.getFilterColIn(dataSource), compareCode, (Object)startAmt);
        } else if (directionList.contains("2") && !directionList.contains("1")) {
            startAmtFilter = new QFilter(this.getFilterColOut(dataSource), compareCode, (Object)startAmt);
        } else if (directionList.contains("1") && directionList.contains("2")) {
            QFilter debitFilter = new QFilter("creditamount", "=", (Object)0);
            debitFilter.and(new QFilter("debitamount", compareCode, (Object)startAmt));
            QFilter creditFilter = new QFilter("debitamount", "=", (Object)0);
            creditFilter.and(new QFilter("creditamount", compareCode, (Object)startAmt));
            startAmtFilter = debitFilter.or(creditFilter);
        }
        return startAmtFilter;
    }

    private String buildQfilterByAmt(List<String> directionList, String compareCode, BigDecimal amt) {
        String filter = "1=1";
        if (directionList.contains("1") && !directionList.contains("2")) {
            filter = String.format("excflowinamt %1$s %2$s", compareCode, amt);
        } else if (directionList.contains("2") && !directionList.contains("1")) {
            filter = String.format("excflowoutamt %1$s %2$s", compareCode, amt);
        } else if (directionList.contains("1") && directionList.contains("2")) {
            filter = String.format("(excflowinamt %1$s %2$s and excflowoutamt=0) or (excflowoutamt %1$s %2$s and excflowinamt=0)", compareCode, amt);
        }
        return filter;
    }

    private String getFilterColIn(String dataSource) {
        return "A".equals(dataSource) ? "creditamount" : "debitamount";
    }

    private String getFilterColOut(String dataSource) {
        return "A".equals(dataSource) ? "debitamount" : "creditamount";
    }
}

