/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.data;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import kd.tmc.mon.common.enums.MonitorTypeEnum;
import kd.tmc.mon.report.helper.ReportCommonHelper;

public class MonitorResultDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final Log logger = LogFactory.getLog(MonitorResultDataListPlugin.class);
    private static final String[] orderFields = new String[]{"bookdate desc", "sourcebillnumber asc"};
    private static final String[] leftJoin = "sourcebillnumber,montype,org,direction,currency,amount, bookdate,oppunit,oppacctnumber".split(",");
    private static final String[] rightJoin = new String[]{"name as recpaytype"};

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        return null;
    }

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        Map<String, Object> paramMap = ReportCommonHelper.transQueryParam(reportQueryParam);
        QFilter[] filters = this.initQFilter(paramMap, "bankjournal");
        QFilter[] transDetailFilters = this.initQFilter(paramMap, "transdetail");
        DataSet result = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cas_bankjournal", (String)"sourcebillnumber,islargeamount,issensitive,isattention,isdoubt,org,recpaytype,recpaytypeid,currency,debitamount,creditamount,(debitamount+creditamount) as amount,to_char(bookdate,'yyyy-MM-dd') as bookdate,oppunit,oppacctnumber", (QFilter[])filters, (String)"");
        DataSet transBeiDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mon_transaction_bei", (String)"sourcebillnumber,islargeamount,issensitive,isattention,isdoubt,org,' ' as recpaytype,0 as recpaytypeid,currency,debitamount,creditamount,(debitamount+creditamount) as amount,to_char(bookdate,'yyyy-MM-dd') as bookdate,oppunit,oppacctnumber", (QFilter[])transDetailFilters, (String)"");
        result = result.union(transBeiDs);
        result = result.select("sourcebillnumber,concat(case when islargeamount then '" + ResManager.loadKDString((String)"\u5927\u989d\u4ea4\u6613", (String)"MonitorResultDataListPlugin_0", (String)"tmc-mon-report", (Object[])new Object[0]) + "'  else '' end, case when issensitive then '" + "," + ResManager.loadKDString((String)"\u654f\u611f\u4ea4\u6613", (String)"MonitorResultDataListPlugin_1", (String)"tmc-mon-report", (Object[])new Object[0]) + "'  else '' end,case when isattention then '" + "," + ResManager.loadKDString((String)"\u5173\u6ce8\u4ea4\u6613", (String)"MonitorResultDataListPlugin_2", (String)"tmc-mon-report", (Object[])new Object[0]) + "'  else '' end,case when isdoubt then '" + "," + ResManager.loadKDString((String)"\u53ef\u7591\u4ea4\u6613", (String)"MonitorResultDataListPlugin_3", (String)"tmc-mon-report", (Object[])new Object[0]) + "'  else '' end) as montype,org,recpaytype,recpaytypeid,case when debitamount > 0 then '" + ResManager.loadKDString((String)"\u501f", (String)"MonitorResultDataListPlugin_4", (String)"tmc-mon-report", (Object[])new Object[0]) + "' else '" + ResManager.loadKDString((String)"\u8d37", (String)"MonitorResultDataListPlugin_5", (String)"tmc-mon-report", (Object[])new Object[0]) + "' end as direction,currency,amount, bookdate,oppunit,oppacctnumber");
        DataSet receivingDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cas_receivingbilltype", (String)"id,name", (QFilter[])new QFilter[0], null);
        DataSet receiveResult = result.where(" recpaytype = 'cas_receivingbilltype' ").join(receivingDataSet, JoinType.LEFT).on("recpaytypeid", "id").select(leftJoin, rightJoin).finish();
        DataSet paymentDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cas_paymentbilltype", (String)"id,name", (QFilter[])new QFilter[0], null);
        DataSet paymentResult = result.where(" recpaytype = 'cas_paymentbilltype' ").join(paymentDataSet, JoinType.LEFT).on("recpaytypeid", "id").select(leftJoin, rightJoin).finish();
        DataSet otherDataSet = result.select("sourcebillnumber,montype,org,direction,currency,amount, bookdate,oppunit,oppacctnumber,recpaytype").where(" recpaytype not in ('cas_receivingbilltype' , 'cas_paymentbilltype') ").select("sourcebillnumber,montype,org,direction,currency,amount, bookdate,oppunit,oppacctnumber,'' as recpaytype");
        DataSet lastDataSet = receiveResult.union(new DataSet[]{paymentResult, otherDataSet}).orderBy(orderFields);
        return lastDataSet;
    }

    private QFilter[] initQFilter(Map<String, Object> paramMap, String type) {
        Object trancurrency;
        Date endDate;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        String montype = (String)paramMap.get("montypeselect");
        QFilter montypeFilter = null;
        if (montype.contains(MonitorTypeEnum.ISLARGEAMOUNT.getCode())) {
            montypeFilter = new QFilter("islargeamount", "=", (Object)"1");
        }
        if (montype.contains(MonitorTypeEnum.ISSENSITIVE.getCode())) {
            QFilter sensitiveFilter = new QFilter("issensitive", "=", (Object)"1");
            montypeFilter = EmptyUtil.isEmpty((Object)montypeFilter) ? sensitiveFilter : montypeFilter.or(sensitiveFilter);
        }
        if (montype.contains(MonitorTypeEnum.ISDOUBT.getCode())) {
            QFilter doubtFilter = new QFilter("isdoubt", "=", (Object)"1");
            montypeFilter = EmptyUtil.isEmpty((Object)montypeFilter) ? doubtFilter : montypeFilter.or(doubtFilter);
        }
        if (montype.contains(MonitorTypeEnum.ISATTENTION.getCode())) {
            QFilter attentionFilter = new QFilter("isattention", "=", (Object)"1");
            montypeFilter = EmptyUtil.isEmpty((Object)montypeFilter) ? attentionFilter : montypeFilter.or(attentionFilter);
        }
        filters.add(montypeFilter);
        Date startdate = (Date)paramMap.get("startdate");
        if (EmptyUtil.isNoEmpty((Object)startdate)) {
            QFilter startDateFilter = new QFilter("bookdate", ">=", (Object)startdate);
            filters.add(startDateFilter);
        }
        if (EmptyUtil.isNoEmpty((Object)(endDate = (Date)paramMap.get("enddate")))) {
            QFilter endDateFilter = new QFilter("bookdate", "<=", (Object)DateUtils.getDataFormat((Date)endDate, (boolean)false));
            filters.add(endDateFilter);
        }
        if (EmptyUtil.isNoEmpty((Object)(trancurrency = paramMap.get("currencyfield")))) {
            DynamicObjectCollection currencyid = (DynamicObjectCollection)trancurrency;
            QFilter currencyFilter = new QFilter("currency", "in", currencyid.stream().filter(EmptyUtil::isNoEmpty).map(e -> e.getLong("id")).collect(Collectors.toList()));
            filters.add(currencyFilter);
        }
        List orgIds = this.getQueryOrgIds(this.getQueryParam());
        logger.info("\u6709\u6743\u9650\u7684\u7ec4\u7ec7id\uff1a" + orgIds);
        filters.add(new QFilter("org", "in", (Object)orgIds));
        if ("bankjournal".equals(type)) {
            DynamicObjectCollection filterIntype = (DynamicObjectCollection)paramMap.get("intype");
            DynamicObjectCollection filterOuttype = (DynamicObjectCollection)paramMap.get("outtype");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)filterIntype) || EmptyUtil.isNoEmpty((DynamicObjectCollection)filterOuttype)) {
                QFilter qFilterRecpaytype = null;
                List recpaytypeList = null;
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)filterIntype)) {
                    recpaytypeList = filterIntype.stream().filter(EmptyUtil::isNoEmpty).map(e -> e.getLong("id")).collect(Collectors.toList());
                    qFilterRecpaytype = new QFilter("recpaytypeid", "in", recpaytypeList).and(new QFilter("recpaytype", "=", (Object)"cas_receivingbilltype"));
                }
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)filterOuttype)) {
                    recpaytypeList = filterOuttype.stream().filter(EmptyUtil::isNoEmpty).map(e -> e.getLong("id")).collect(Collectors.toList());
                    QFilter qFilterPaymenttype = new QFilter("recpaytypeid", "in", recpaytypeList).and(new QFilter("recpaytype", "=", (Object)"cas_paymentbilltype"));
                    if (qFilterRecpaytype != null) {
                        qFilterRecpaytype.or(qFilterPaymenttype);
                    } else {
                        qFilterRecpaytype = qFilterPaymenttype;
                    }
                }
                filters.add(qFilterRecpaytype);
            }
        }
        QFilter[] qFilters = new QFilter[filters.size()];
        filters.toArray(qFilters);
        return qFilters;
    }
}

