/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.form;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mon.common.enums.StatisCycleEnum;
import kd.tmc.mon.common.helper.BaseDataHelper;
import kd.tmc.mon.common.helper.OrgHelper;
import kd.tmc.mon.common.helper.PeriodHelper;
import kd.tmc.mon.report.helper.ReportCommonHelper;
import kd.tmc.mon.report.service.CPevalutionService;

public class CPevalutionFormListPlugin
extends AbstractReportFormPlugin {
    private static final String[] colors = new String[]{"#098BFF", "#00CCCC", "#6DD38B", "#87DB3D", "#C7E052", "#FFD72D", "#FFB91A", "#FF9900", "#FF8144", "#FF6666", "#C2489B", "#6733CC", "#511FCC", "#3300CC", "#1F06A3", "#09087C"};

    public void afterCreateNewData(EventObject e) {
        DynamicObjectCollection queryFisBankRollOrg;
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"bd_supplierflex"});
        this.getModel().setValue("filter_statcurrency", (Object)OrgHelper.getMainCurrency((long)TmcOrgDataHelper.getCurrentOrgId()));
        long orgId = RequestContext.get().getOrgId();
        String appId = this.getView().getFormShowParameter().getAppId();
        Long fisBankRollOrg = OrgHelper.getFisBankRollOrg((Long)orgId, (String)appId, (Long)RequestContext.get().getCurrUserId(), (String)"47150e89000000ac", (String)"mon_fundflow");
        if (fisBankRollOrg != null && !(queryFisBankRollOrg = QueryServiceHelper.query((String)"queryCashInit", (String)"cas_cashmgtinit", (String)"org as id", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)new Long[]{fisBankRollOrg}), new QFilter("isfinishinit", "=", (Object)"1")}, null)).isEmpty()) {
            DynamicObject initObj = PeriodHelper.getCasInitInfo((long)fisBankRollOrg);
            this.getModel().setValue("exratetable", initObj.getDynamicObject("exratetable").getPkValue());
        }
        FormShowParameter reportShowParameter = this.getView().getFormShowParameter();
        Map paramMap = reportShowParameter.getCustomParams();
        if ("mon_fundflow".equals(this.getView().getFormShowParameter().getParentFormId()) && EmptyUtil.isNoEmpty((Object)paramMap) && paramMap.size() > 0) {
            this.initQueryParam(paramMap);
            ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
            if (!EmptyUtil.isEmpty((Object)rptFilter)) {
                rptFilter.search();
            }
        }
    }

    private void initQueryParam(Map<String, Object> paramMap) {
        Object statCycle = paramMap.get("filter_staperiod");
        if (!StatisCycleEnum.TODAY.getCode().equals(statCycle)) {
            this.getModel().setValue("stattype", statCycle);
        }
        if (StatisCycleEnum.CONSTOM.getCode().equals(statCycle)) {
            this.getModel().setValue("daterangefield_startdate", paramMap.get("filter_perioddate_startdate"));
            this.getModel().setValue("daterangefield_enddate", paramMap.get("filter_perioddate_enddate"));
        }
        this.getModel().setValue("filter_statcurrency", paramMap.get("filter_repcurrency_id"));
        this.getModel().setValue("statcurrency", (Object)((JSONArray)paramMap.get("filter_currency_id")).toArray());
        this.getModel().setValue("filter_queryway", paramMap.get("filter_queryway"));
        this.getModel().setValue("filter_orgview", paramMap.get("filter_orgview_id"));
        this.getModel().setValue("filter_org", (Object)((JSONArray)paramMap.get("filter_org_id")).toArray());
        this.getModel().setValue("exratetable", paramMap.get("exratetable_id"));
        this.getModel().setValue("datasource", paramMap.get("datasource"));
        this.getModel().setValue("statsinneracct", paramMap.get("statsinneracct"));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ReportFilter rptFilter;
        String key = e.getProperty().getName();
        if ("changetype".equals(key)) {
            String afterChange = (String)this.getModel().getValue("changetype");
            this.getModel().setValue("recpayertype", (Object)afterChange);
        }
        String type = (String)this.getModel().getValue("recpayertype");
        String oldtype = (String)this.getModel().getValue("oldrecpayertype");
        if (("recpayertype".equals(key) && !type.equals(oldtype) || "topnum".equals(key)) && !EmptyUtil.isEmpty((Object)(rptFilter = (ReportFilter)this.getControl("reportfilterap")))) {
            rptFilter.search();
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject exRateTable;
        boolean verifyResult = true;
        String recpayertype = (String)this.getModel().getValue("recpayertype");
        FilterInfo filterInfo = queryParam.getFilter();
        filterInfo.addFilterItem("recpayertype", (Object)recpayertype);
        queryParam.setFilter(filterInfo);
        Map<String, Object> paramMap = ReportCommonHelper.transQueryParam(queryParam);
        this.initToOrgIds(queryParam);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        queryParam.getCustomParam().put("formid", parameter.getFormId());
        queryParam.getCustomParam().put("appid", parameter.getAppId());
        String statType = (String)paramMap.get("stattype");
        StringBuilder errorMessage = new StringBuilder(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9", (String)"CPevalutionFormList_0", (String)"tmc-mon-report", (Object[])new Object[0]));
        if (StatisCycleEnum.CONSTOM.getCode().equals(statType) && (EmptyUtil.isEmpty((Object)paramMap.get("daterangefield_startdate")) || EmptyUtil.isEmpty((Object)paramMap.get("daterangefield_enddate")))) {
            errorMessage.append(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u65f6\u95f4\u8303\u56f4", (String)"CPevalutionFormList_1", (String)"tmc-mon-report", (Object[])new Object[0]));
            verifyResult = false;
        }
        if (EmptyUtil.isEmpty((Object)paramMap.get("filter_statcurrency"))) {
            errorMessage.append(ResManager.loadKDString((String)"\u7edf\u8ba1\u5e01\u79cd", (String)"CPevalutionFormList_2", (String)"tmc-mon-report", (Object[])new Object[0]));
            verifyResult = false;
        }
        if ((exRateTable = (DynamicObject)this.getModel().getValue("exratetable")) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccountMoneyFormPlugin_2", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        if (!verifyResult) {
            this.getView().showTipNotification(errorMessage.toString());
            this.recoverRecpayerType();
            return verifyResult;
        }
        DataSet queryDataSet = CPevalutionService.getCurrentSet(queryParam);
        ArrayList<Long> sourceCurrencyIdLst = new ArrayList<Long>(10);
        Row row = null;
        while (queryDataSet.hasNext()) {
            row = queryDataSet.next();
            sourceCurrencyIdLst.add(row.getLong("currency"));
        }
        queryDataSet.close();
        boolean flag = BaseDataHelper.verifyExchangeRate(sourceCurrencyIdLst, (Long)((DynamicObject)paramMap.get("filter_statcurrency")).getLong("id"), (Long)TmcOrgDataHelper.getCurrentOrgId(), (Date)new Date(), (AbstractFormPlugin)this);
        if (!flag) {
            this.recoverRecpayerType();
        }
        return flag;
    }

    private void recoverRecpayerType() {
        String oldtype;
        String type = (String)this.getModel().getValue("recpayertype");
        if (!type.equals(oldtype = (String)this.getModel().getValue("oldrecpayertype"))) {
            this.getModel().setValue("changetype", (Object)oldtype);
        }
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"supplierlabelap", "reportlistap"});
        this.drawPiechart(queryParam);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"bd_supplierflex"});
        String afterChange = (String)this.getModel().getValue("changetype");
        String afterChangeName = afterChange.equals("bd_customer") ? ResManager.loadKDString((String)"\u5ba2\u6237", (String)"CPevalutionFormList_3", (String)"tmc-mon-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4f9b\u5e94\u5546", (String)"CPevalutionFormList_4", (String)"tmc-mon-report", (Object[])new Object[0]);
        ((Label)this.getControl("recpayertypenamelable")).setText(afterChangeName);
        this.getModel().setValue("oldrecpayertype", (Object)afterChange);
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        for (int i = 0; i < rowData.size(); ++i) {
            DynamicObject row = (DynamicObject)rowData.get(i);
            row.set("sortnum", (Object)(i + 1));
            rowData.set(i, (Object)row);
        }
    }

    private void drawPiechart(ReportQueryParam queryParam) {
        Map<String, Object> paramMap = ReportCommonHelper.transQueryParam(queryParam);
        String recpayertype = (String)paramMap.get("recpayertype");
        String recpayertypename = recpayertype.equals("bd_customer") ? ResManager.loadKDString((String)"\u5ba2\u6237", (String)"CPevalutionFormList_3", (String)"tmc-mon-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4f9b\u5e94\u5546", (String)"CPevalutionFormList_4", (String)"tmc-mon-report", (Object[])new Object[0]);
        PieChart pieChart = (PieChart)this.getControl("piechart");
        pieChart.clearData();
        pieChart.setShowTooltip(true);
        pieChart.setShowLegend(true);
        pieChart.setTitleAlign(XAlign.center, YAlign.center);
        DynamicObject currencyObject = (DynamicObject)paramMap.get("filter_statcurrency");
        DataSet resultSet = CPevalutionService.getDataByParam(queryParam, false);
        ArrayList<ItemValue> itemList = new ArrayList<ItemValue>(10);
        int topnum = Integer.parseInt((String)paramMap.get("topnum"));
        int i = 0;
        BigDecimal otherAmout = BigDecimal.ZERO;
        while (resultSet.hasNext()) {
            Row row = resultSet.next();
            if (i++ < topnum) {
                ItemValue tempValue = new ItemValue(row.getString(0), (Number)row.getBigDecimal(1), colors[i]);
                itemList.add(tempValue);
                continue;
            }
            otherAmout = otherAmout.add(row.getBigDecimal(1));
        }
        if (BigDecimal.ZERO.compareTo(otherAmout) != 0) {
            ItemValue otherItem = new ItemValue(ResManager.loadKDString((String)"\u5176\u4ed6", (String)"CPevalutionFormList_5", (String)"tmc-mon-report", (Object[])new Object[0]), (Number)otherAmout, "");
            itemList.add(otherItem);
        }
        if (EmptyUtil.isEmpty(itemList)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"piechart"});
        } else {
            PieSeries series = pieChart.createPieSeries(recpayertypename);
            ItemValue[] items = new ItemValue[itemList.size()];
            itemList.toArray(items);
            series.setData(items);
            series.setRadius("0%", "50%");
            series.setCenter("50%", "50%");
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"piechart"});
        }
        String currencySign = currencyObject.getString("sign");
        pieChart.addTooltip("formatter", (Object)new StringBuilder("{b0}: ").append(currencySign).append("{c0}(").append(ResManager.loadKDString((String)"\u4e07\u5143", (String)"CPevalutionFormList_6", (String)"tmc-mon-report", (Object[])new Object[0])).append(")<br/>{d0}%"));
        pieChart.setLegendPropValue("orient", (Object)"vertical");
        pieChart.setLegendPropValue("x", (Object)"right");
        pieChart.refresh();
        resultSet.close();
    }

    private void initToOrgIds(ReportQueryParam queryParam) {
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("filter_org");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)orgs)) {
            List orgIds = orgs.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
            queryParam.getFilter().getFilterItem("filter_org").setValue(orgIds);
        }
    }
}

