/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.form;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcAppCache;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mon.report.data.DebtsdueDataBuilder;
import kd.tmc.mon.report.helper.DebtsReportHelper;

public class DebtsdueSumFormListPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener {
    private Log logger = LogFactory.getLog(DebtsdueSumFormListPlugin.class);

    public void registerListener(EventObject e) {
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
        MulBasedataEdit org = (MulBasedataEdit)this.getControl("filter_org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        FilterInfo queryFilter = queryParam.getFilter();
        RequestContext context = RequestContext.get();
        if (queryParam.getFilter().getFilterItem("filter_org").getValue() == null) {
            String appId = this.getView().getFormShowParameter().getAppId();
            List orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)context.getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
            if (orgIds.size() <= 0) {
                throw new KDBizException(ResManager.loadKDString((String)"%s\u6ca1\u6709\u67e5\u8be2\u6743\u9650\u7684\u8d44\u91d1\u7ec4\u7ec7\u3002", (String)"DebtsdueSumFormListPlugin_1", (String)"tmc-mon-report", (Object[])new Object[]{this.getView().getFormShowParameter().getFormName()}));
            }
            queryFilter.addFilterItem("AuthorizedBankOrg", (Object)orgIds);
        }
        queryFilter.addFilterItem("filter_loginorg", (Object)context.getOrgId());
        String bizdateRanges = (String)this.getModel().getValue("filter_bizdateranges");
        if ("custom".equals(bizdateRanges) && EmptyUtil.isEmpty((Object)this.getModel().getValue("bizdateranges_startdate"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5230\u671f\u65e5\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DebtsdueSumFormListPlugin_2", (String)"tmc-mon-report", (Object[])new Object[0]));
        }
        Date startDate = (Date)this.getModel().getValue("bizdateranges_startdate");
        Date endDate = (Date)this.getModel().getValue("bizdateranges_enddate");
        if (endDate != null && endDate.before(startDate)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5230\u671f\u65e5\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u65e5\u671f", (String)"DebtsdueSumFormListPlugin_9", (String)"tmc-mon-report", (Object[])new Object[0]));
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("filter_statcurrency"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6298\u7b97\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DebtsdueSumFormListPlugin_3", (String)"tmc-mon-report", (Object[])new Object[0]));
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("filter_currencyunit"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d27\u5e01\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (String)"DebtsdueSumFormListPlugin_4", (String)"tmc-mon-report", (Object[])new Object[0]));
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("filter_biztype"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u79cd\u7c7b\u4e0d\u80fd\u4e3a\u7a7a", (String)"DebtsdueSumFormListPlugin_6", (String)"tmc-mon-report", (Object[])new Object[0]));
        }
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        List columns = reportList.getColumns();
        ArrayList<String> newGroupColumnKeys = new ArrayList<String>(columns.size());
        List<String> exitGroupCols = Arrays.asList("duedate", "bank", "org", "currency");
        for (AbstractReportColumn column : columns) {
            ReportColumn reportColumn = (ReportColumn)column;
            String fieldKey = reportColumn.getFieldKey();
            if (!exitGroupCols.contains(fieldKey) && !fieldKey.endsWith("_ek")) continue;
            newGroupColumnKeys.add(fieldKey);
        }
        String firstGroupField = (String)newGroupColumnKeys.get(0);
        if (!"duedate".equals(firstGroupField)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u62a5\u8868\u65b0\u589e\u7684\u5217%s\u4e0d\u80fd\u653e\u5728\u7edf\u8ba1\u7ef4\u5ea6[\u5230\u671f\u65e5]\u5b57\u6bb5\u4e4b\u524d", (String)"DebtsdueSumFormListPlugin_5", (String)"tmc-mon-report", (Object[])new Object[0]), firstGroupField));
        }
        queryParam.getCustomParam().put("newgroup_columnkeys", String.join((CharSequence)",", newGroupColumnKeys));
        super.beforeQuery(queryParam);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int index = evt.getRowIndex();
        ReportList reportList = (ReportList)evt.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        String fieldName = evt.getFieldName();
        DynamicObject rowData = reportModel.getRowData(index);
        ArrayList<String> totalCalNames = new ArrayList<String>();
        totalCalNames.add("cdmamt");
        totalCalNames.add("lcamt");
        totalCalNames.add("cfmrepayamt");
        totalCalNames.add("bondrepayamt");
        totalCalNames.add("cfminstamt");
        totalCalNames.add("bondinstamt");
        if (totalCalNames.contains(fieldName)) {
            this.dealTotalColHyLink(fieldName, rowData, Boolean.FALSE);
        } else if (fieldName.endsWith("_cdm") || fieldName.endsWith("_lc") || fieldName.endsWith("_cfmrepay") || fieldName.endsWith("_cfminst") || fieldName.endsWith("_bondrepay") || fieldName.endsWith("_bondinst")) {
            this.dealTotalColHyLink(fieldName, rowData, Boolean.TRUE);
        }
    }

    private void dealTotalColHyLink(String fieldName, DynamicObject rowData, Boolean isDynGenCol) {
        BillShowParameter showParameter;
        DynamicObjectCollection targetBills;
        String countBillTypeName;
        IAppCache iAppCache;
        Map countBillType;
        QFilter billFiler = new QFilter("billstatus", "=", (Object)"C");
        String debtsType = "";
        if (isDynGenCol.booleanValue()) {
            String[] splitStr = fieldName.split("_");
            debtsType = splitStr[splitStr.length - 1];
        } else {
            debtsType = fieldName.replace("amt", "").trim();
        }
        DebtsdueDataBuilder debtsBean = DebtsdueDataBuilder.getObjByDebtsType(debtsType);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date dueDate = DateUtils.getCurrentDate();
        try {
            dueDate = sdf.parse(rowData.getString("duedate"));
        }
        catch (ParseException e) {
            this.logger.error("\u6c47\u603b\u91d1\u989d\u5217\u8d85\u94fe\u63a5-\u65e5\u671f\u5904\u7406\u5f02\u5e38\uff1a", (Throwable)e);
        }
        DynamicObject bank = rowData.getDynamicObject("bank");
        DynamicObject org = rowData.getDynamicObject("org");
        if (EmptyUtil.isEmpty((DynamicObject)org) && EmptyUtil.isEmpty((DynamicObject)bank)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u884c\u4e0d\u652f\u6301\u8d85\u94fe\u63a5\u8df3\u8f6c", (String)"DebtsdueSumFormListPlugin_7", (String)"tmc-mon-report", (Object[])new Object[0]));
            return;
        }
        if (EmptyUtil.isEmpty((DynamicObject)bank)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u884c\u5408\u4f5c\u91d1\u878d\u673a\u6784\u4e3a\u7a7a\u4e0d\u652f\u6301\u8d85\u94fe\u63a5\u8df3\u8f6c", (String)"DebtsdueSumFormListPlugin_8", (String)"tmc-mon-report", (Object[])new Object[0]));
            return;
        }
        billFiler.and(debtsBean.getDuedate(), ">=", (Object)DateUtils.getDataFormat((Date)dueDate, (boolean)true)).and(debtsBean.getDuedate(), "<=", (Object)DateUtils.getDataFormat((Date)dueDate, (boolean)false)).and(debtsBean.getBank(), "=", bank.getPkValue()).and(debtsBean.getOrg(), "=", org.getPkValue()).and(debtsBean.getCurrency(), "=", rowData.getDynamicObject("currency").getPkValue());
        DebtsReportHelper.setBizBillFilter(billFiler, debtsBean, this.getBillGroupTypes(), true);
        String entiyCode = debtsBean.getEntiy();
        if (isDynGenCol.booleanValue() && EmptyUtil.isNoEmpty((Object)(countBillType = (Map)(iAppCache = TmcAppCache.get((String)"mon", (String)"mon_debtsdue", (String)"countbilltype")).get("mon_debtsdue_countbilltype", Map.class))) && EmptyUtil.isNoEmpty((String)(countBillTypeName = (String)countBillType.get(fieldName.substring(2))))) {
            billFiler.and(new QFilter(debtsBean.getCountbilltype() + ".name", "=", (Object)countBillTypeName.substring(2)));
        }
        if (EmptyUtil.isEmpty((DynamicObjectCollection)(targetBills = QueryServiceHelper.query((String)entiyCode, (String)"id", (QFilter[])new QFilter[]{billFiler})))) {
            return;
        }
        if (targetBills.size() == 1) {
            showParameter = new BillShowParameter();
            showParameter.setPkId(((DynamicObject)targetBills.get(0)).get("id"));
            showParameter.setFormId(entiyCode);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("isshowtoolbarap", (Object)"no");
            this.getView().showForm((FormShowParameter)showParameter);
        } else {
            showParameter = new ListShowParameter();
            showParameter.setIsolationOrg(false);
            showParameter.setBillFormId(entiyCode);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
            HashSet<Object> pks = new HashSet<Object>(targetBills.size());
            for (DynamicObject targetBill : targetBills) {
                pks.add(targetBill.get("id"));
            }
            qFilters.add(new QFilter("id", "in", pks));
            showParameter.getListFilterParameter().setQFilters(qFilters);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("isquerydefault", (Object)"no");
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private Map<String, DynamicObjectCollection> getBillGroupTypes() {
        HashMap<String, DynamicObjectCollection> typedatas = new HashMap<String, DynamicObjectCollection>(16);
        typedatas.put("cdm", (DynamicObjectCollection)this.getModel().getValue("filter_cdmbilltype"));
        typedatas.put("lc", (DynamicObjectCollection)this.getModel().getValue("filter_lcbilltype"));
        typedatas.put("cfm", (DynamicObjectCollection)this.getModel().getValue("filter_financingvarieties"));
        typedatas.put("bond", (DynamicObjectCollection)this.getModel().getValue("filter_bondvarieties"));
        return typedatas;
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "filter_org": {
                this.orgF7Evt(evt);
                break;
            }
        }
    }

    private void orgF7Evt(BeforeF7SelectEvent evt) {
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        String appId = this.getView().getFormShowParameter().getAppId();
        List comIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)comIdList));
    }
}

