/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.form;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.report.ReportList;
import kd.bos.report.events.TreeReportListEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositLiabFormPlugin
extends AbstractReportFormPlugin {
    public void setTreeReportList(TreeReportListEvent event) {
        super.setTreeReportList(event);
        event.setTreeReportList(true);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.dateTypeChgEvt();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldName;
        super.propertyChanged(e);
        switch (fieldName = e.getProperty().getName()) {
            case "filter_datetype": {
                this.dateTypeChgEvt();
                break;
            }
            case "filter_statdim": {
                this.autoSearch();
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        if (filterInfo != null) {
            Object qdate = filterInfo.getValue("filter_querydate");
            if (qdate == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DepositLiabFormPlugin_0", (String)"tmc-mon-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            Object drange = filterInfo.getValue("filter_dptrange");
            if (drange == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u6b3e\u6570\u636e\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DepositLiabFormPlugin_1", (String)"tmc-mon-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            Object lrange = filterInfo.getValue("filter_liabrange");
            if (lrange == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d1f\u503a\u6570\u636e\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DepositLiabFormPlugin_2", (String)"tmc-mon-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            Object statcur = this.getModel().getValue("filter_statcurrency");
            if (statcur == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7edf\u8ba1\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DepositLiabFormPlugin_3", (String)"tmc-mon-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
        }
        return true;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        this.addCustomFilter(queryParam);
        this.initQueryColumn();
    }

    private void autoSearch() {
        ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
        if (!EmptyUtil.isEmpty((Object)rptFilter)) {
            try {
                rptFilter.search();
            }
            catch (KDBizException bizEx) {
                this.getView().showErrorNotification(bizEx.getMessage());
            }
        }
    }

    private void addCustomFilter(ReportQueryParam queryParam) {
        String statDimStr = (String)this.getModel().getValue("filter_statdim");
        queryParam.getFilter().addFilterItem("filter_statdim", (Object)statDimStr);
        Date queryDate = (Date)this.getModel().getValue("filter_querydate");
        queryParam.getFilter().addFilterItem("filter_querydate", (Object)queryDate);
        FilterItemInfo finOrgInfoItem = queryParam.getFilter().getFilterItem("filter_finorginfo");
        if (EmptyUtil.isNoEmpty((Object)finOrgInfoItem) && EmptyUtil.isNoEmpty((Object)finOrgInfoItem.getValue())) {
            DynamicObjectCollection finOrgInfos = (DynamicObjectCollection)finOrgInfoItem.getValue();
            List ids = finOrgInfos.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            queryParam.getCustomParam().put("filter_finorginfo", ids);
        } else {
            queryParam.getCustomParam().remove("filter_finorginfo");
        }
        FilterItemInfo orgItem = queryParam.getFilter().getFilterItem("filter_org");
        if (EmptyUtil.isEmpty((Object)orgItem.getValue()) && EmptyUtil.isEmpty(queryParam.getCustomParam().get("filter_org"))) {
            String appId = this.getView().getFormShowParameter().getAppId();
            queryParam.getCustomParam().put("formid", this.getModel().getDataEntityType().getName());
            queryParam.getCustomParam().put("appid", appId);
        }
        this.addExRateOrgParam(queryParam);
    }

    private void addExRateOrgParam(ReportQueryParam queryParam) {
        DynamicObject companyView;
        String orgRootId;
        String orgQueryWay = (String)this.getModel().getValue("filter_queryway");
        Long exRateOrgId = StringUtils.equals((CharSequence)orgQueryWay, (CharSequence)"org") ? Long.valueOf(RequestContext.get().getOrgId()) : Long.valueOf(EmptyUtil.isEmpty((String)(orgRootId = TmcOrgDataHelper.getOrgRootId((Long)(companyView = (DynamicObject)this.getModel().getValue("filter_orgview")).getLong("id")))) ? 0L : Long.parseLong(orgRootId));
        queryParam.getFilter().addFilterItem("exRateOrgId", (Object)exRateOrgId);
    }

    private void dateTypeChgEvt() {
        String dateType = (String)this.getModel().getValue("filter_datetype");
        Date queryDate = null;
        boolean enable = false;
        if (StringUtils.equals((CharSequence)dateType, (CharSequence)"today")) {
            queryDate = DateUtils.getCurrentDate();
        } else if (StringUtils.equals((CharSequence)dateType, (CharSequence)"yesterday")) {
            queryDate = DateUtils.getLastDay((Date)DateUtils.getCurrentDate(), (int)1);
        } else {
            enable = true;
        }
        this.getModel().setValue("filter_querydate", (Object)queryDate);
        this.getView().setEnable(Boolean.valueOf(enable), new String[]{"filter_querydate"});
    }

    private void initQueryColumn() {
        ReportList listTable = (ReportList)this.getView().getControl("reportlistap");
        List columns = listTable.getColumns();
        String statDim = (String)this.getModel().getValue("filter_statdim");
        String hideField = StringUtils.equals((CharSequence)statDim, (CharSequence)"finorginfo") ? "orgname" : "finorginfoname";
        for (AbstractReportColumn column : columns) {
            if (!(column instanceof ReportColumn) || !((ReportColumn)column).getFieldKey().equals(hideField)) continue;
            ((ReportColumn)column).setHide(true);
            break;
        }
    }
}

