/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.form;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.ChartType;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mon.common.enums.StatisCycleEnum;
import kd.tmc.mon.common.helper.OrgHelper;
import kd.tmc.mon.common.helper.PeriodHelper;
import kd.tmc.mon.report.helper.ReportCommonHelper;
import kd.tmc.mon.report.service.FinOrgEvaService;

public class FinOrgEvaFormListPlugin
extends AbstractReportFormPlugin {
    private static Log logger = LogFactory.getLog(FinOrgEvaFormListPlugin.class);
    private static final String[] colors = new String[]{"#098BFF", "#29ACE6", "#00CCCC", "#6DD38B", "#87DB3D", "#C7E052", "#FFD72D", "#FFB91A", "#FF9900", "#FF8144", "#FF6666", "#C2489B", "#6733CC", "#511FCC", "#3300CC", "#1F06A3", "#09087C"};

    public void afterCreateNewData(EventObject e) {
        DynamicObjectCollection queryFisBankRollOrg;
        this.getModel().setValue("filter_statcurrency", (Object)OrgHelper.getMainCurrency((long)TmcOrgDataHelper.getCurrentOrgId()));
        long orgId = RequestContext.get().getOrgId();
        String appId = this.getView().getFormShowParameter().getAppId();
        Long fisBankRollOrg = OrgHelper.getFisBankRollOrg((Long)orgId, (String)appId, (Long)RequestContext.get().getCurrUserId(), (String)"47150e89000000ac", (String)"mon_fundflow");
        if (fisBankRollOrg != null && !(queryFisBankRollOrg = QueryServiceHelper.query((String)"queryCashInit", (String)"cas_cashmgtinit", (String)"org as id", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)new Long[]{fisBankRollOrg}), new QFilter("isfinishinit", "=", (Object)"1")}, null)).isEmpty()) {
            DynamicObject initObj = PeriodHelper.getCasInitInfo((long)fisBankRollOrg);
            this.getModel().setValue("exratetable", initObj.getDynamicObject("exratetable").getPkValue());
        }
        FormShowParameter reportShowParameter = this.getView().getFormShowParameter();
        Map paramMap = reportShowParameter.getCustomParams();
        if ("mon_fundflow".equals(this.getView().getFormShowParameter().getParentFormId()) && !EmptyUtil.isEmpty((Object)paramMap) && paramMap.size() > 0) {
            this.initQueryParam(paramMap);
            ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
            if (!EmptyUtil.isEmpty((Object)rptFilter)) {
                rptFilter.search();
            }
        }
    }

    private void initQueryParam(Map<String, Object> paramMap) {
        Object statCycle = paramMap.get("filter_staperiod");
        if (!StatisCycleEnum.TODAY.getCode().equals(statCycle)) {
            this.getModel().setValue("filter_staperiod", statCycle);
        }
        if (StatisCycleEnum.CONSTOM.getCode().equals(statCycle)) {
            this.getModel().setValue("filter_perioddate_startdate", paramMap.get("filter_perioddate_startdate"));
            this.getModel().setValue("filter_perioddate_enddate", paramMap.get("filter_perioddate_enddate"));
        }
        this.getModel().setValue("filter_statcurrency", paramMap.get("filter_repcurrency_id"));
        this.getModel().setValue("filter_currency", (Object)((JSONArray)paramMap.get("filter_currency_id")).toArray());
        this.getModel().setValue("filter_queryway", paramMap.get("filter_queryway"));
        this.getModel().setValue("filter_orgview", paramMap.get("filter_orgview_id"));
        this.getModel().setValue("filter_org", (Object)((JSONArray)paramMap.get("filter_org_id")).toArray());
        this.getModel().setValue("exratetable", paramMap.get("exratetable_id"));
        this.getModel().setValue("datasource", paramMap.get("datasource"));
        this.getModel().setValue("statsinneracct", paramMap.get("statsinneracct"));
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        Map<String, Object> paramMap = ReportCommonHelper.transQueryParam(queryParam);
        paramMap.putAll(queryParam.getCustomParam());
        DataSet chartDataSet = this.getChartDataSet(paramMap);
        int countbBankId = chartDataSet.copy().count("bank", false);
        if (!EmptyUtil.isEmpty((Object)chartDataSet) && countbBankId > 0) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"histogramchartap"});
            this.dealChart(chartDataSet, paramMap);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"histogramchartap"});
        }
        DataSet pieChartDataSet = this.getPieChartDataSet(paramMap);
        int countFinOrg = pieChartDataSet.copy().count("bank", false);
        if (!EmptyUtil.isEmpty((Object)pieChartDataSet) && countFinOrg > 0) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"piechartap"});
            this.dealPieChart(pieChartDataSet, paramMap);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"piechartap"});
        }
        chartDataSet.close();
        pieChartDataSet.close();
    }

    private DataSet getChartDataSet(Map<String, Object> paramMap) {
        return this.getOriginalDataSet(paramMap);
    }

    public DataSet addSortToDataSet(DataSet dataSet, String sortKey) {
        Algo algo = Algo.create((String)"addSort");
        DataSetBuilder datasetBuilder = algo.createDataSetBuilder(dataSet.getRowMeta());
        int i = 1;
        while (dataSet.hasNext()) {
            Object[] rowData = new Object[dataSet.getRowMeta().getFieldCount()];
            Field[] fields = dataSet.getRowMeta().getFields();
            Row row = dataSet.next();
            for (int j = 0; j < fields.length; ++j) {
                rowData[j] = fields[j].getAlias().equalsIgnoreCase(sortKey) ? Integer.valueOf(i) : row.get(j);
            }
            ++i;
            datasetBuilder.append(rowData);
        }
        dataSet = datasetBuilder.build();
        return dataSet;
    }

    private DataSet getPieChartDataSet(Map<String, Object> paramMap) {
        String businessRangeStr = (String)paramMap.get("filter_businessrange");
        DataSet dataSet = this.getOriginalDataSet(paramMap);
        String filedStr = "0";
        if (businessRangeStr.indexOf("01") != -1) {
            filedStr = filedStr + " + amount_set";
        }
        if (businessRangeStr.indexOf("02") != -1) {
            filedStr = filedStr + " + amount_credit";
        }
        if (businessRangeStr.indexOf("03") != -1) {
            filedStr = filedStr + " + amount_loan";
        }
        if (businessRangeStr.indexOf("04") != -1) {
            filedStr = filedStr + " + amount_acc";
        }
        if (businessRangeStr.indexOf("05") != -1) {
            filedStr = filedStr + " + amount_dis";
        }
        DataSet drawPieChartDataSet = dataSet.addField(filedStr, "amount").select(new String[]{"amount", "bank"});
        return drawPieChartDataSet;
    }

    private DataSet getOriginalDataSet(Map<String, Object> paramMap) {
        String businessRangeStr = (String)paramMap.get("filter_businessrange");
        int topnum = Integer.parseInt((String)paramMap.get("filter_topnum"));
        DataSet acctBankDS = FinOrgEvaService.getAcctBankDataSet(paramMap);
        DataSet allBankDS = FinOrgEvaService.getAllBankDataSet();
        DataSet bankJournalDataSet = FinOrgEvaService.getBankJournalDataSet(paramMap, acctBankDS.copy());
        QFilter[] creditLimitFilters = FinOrgEvaService.initCreditLimitQFilter(paramMap);
        DataSet creditLimitDataSet = FinOrgEvaService.getCreditLimitDataSet(creditLimitFilters, paramMap, allBankDS.copy());
        QFilter[] loanFilters = FinOrgEvaService.initLoanQFilter(paramMap);
        DataSet loanDataSet = FinOrgEvaService.getLoanDataSet(loanFilters, paramMap, allBankDS.copy());
        QFilter[] payableBillFilters = FinOrgEvaService.initPayableBillQFilter(paramMap);
        DataSet payableBillDataSet = FinOrgEvaService.getPayableBillDataSet(payableBillFilters, paramMap, acctBankDS.copy());
        QFilter[] drafttradeBillFilters = FinOrgEvaService.initDrafttradeBillQFilter(paramMap);
        DataSet drafttradeBillDataSet = FinOrgEvaService.getDrafttradeBillDataSet(drafttradeBillFilters, paramMap, acctBankDS.copy());
        DataSet dataSet = allBankDS.copy().groupBy(new String[]{"bank", "finorgtype"}).finish();
        String whereStr = "";
        if (businessRangeStr.indexOf("01") != -1) {
            dataSet = dataSet.join(bankJournalDataSet, JoinType.LEFT).on("bank", "bank").on("finorgtype", "finorgtype").select(dataSet.getRowMeta().getFieldNames(), new String[]{"amount_set", "sort_set"}).finish();
            whereStr = whereStr + "amount_set is not null ";
        } else {
            dataSet = dataSet.addFields(new String[]{"0", "0"}, new String[]{"amount_set", "sort_set"});
        }
        if (businessRangeStr.indexOf("02") != -1) {
            dataSet = dataSet.join(creditLimitDataSet, JoinType.LEFT).on("bank", "bank").on("finorgtype", "finorgtype").select(dataSet.getRowMeta().getFieldNames(), new String[]{"amount_credit", "sort_credit"}).finish();
            whereStr = whereStr + "or amount_credit is not null ";
        } else {
            dataSet = dataSet.addFields(new String[]{"0", "0"}, new String[]{"amount_credit", "sort_credit"});
        }
        if (businessRangeStr.indexOf("03") != -1) {
            dataSet = dataSet.join(loanDataSet, JoinType.LEFT).on("bank", "bank").on("finorgtype", "finorgtype").select(dataSet.getRowMeta().getFieldNames(), new String[]{"amount_loan", "sort_loan"}).finish();
            whereStr = whereStr + "or amount_loan is not null ";
        } else {
            dataSet = dataSet.addFields(new String[]{"0", "0"}, new String[]{"amount_loan", "sort_loan"});
        }
        if (businessRangeStr.indexOf("04") != -1) {
            dataSet = dataSet.join(payableBillDataSet, JoinType.LEFT).on("bank", "bank").on("finorgtype", "finorgtype").select(dataSet.getRowMeta().getFieldNames(), new String[]{"amount_acc", "sort_acc"}).finish();
            whereStr = whereStr + "or amount_acc is not null ";
        } else {
            dataSet = dataSet.addFields(new String[]{"0", "0"}, new String[]{"amount_acc", "sort_acc"});
        }
        if (businessRangeStr.indexOf("05") != -1) {
            dataSet = dataSet.join(drafttradeBillDataSet, JoinType.LEFT).on("bank", "bank").on("finorgtype", "finorgtype").select(dataSet.getRowMeta().getFieldNames(), new String[]{"amount_dis", "sort_dis"}).finish();
            whereStr = whereStr + "or amount_dis is not null ";
        } else {
            dataSet = dataSet.addFields(new String[]{"0", "0"}, new String[]{"amount_dis", "sort_dis"});
        }
        if (whereStr.startsWith("or")) {
            whereStr = whereStr.substring(2, whereStr.length());
        }
        dataSet = dataSet.where(whereStr);
        DataSet allBankDs = dataSet.filter("finorgtype = '0'").select(dataSet.getRowMeta().getFieldNames());
        DataSet otherFinDs = dataSet.filter("finorgtype != '0'").select(dataSet.getRowMeta().getFieldNames());
        DataSet finSumDataSet = otherFinDs.where(whereStr).groupBy(new String[]{"finorgtype"}).sum("amount_set").sum("sort_set").sum("amount_credit").sum("sort_credit").sum("amount_loan").sum("sort_loan").sum("amount_acc").sum("sort_acc").sum("amount_dis").sum("sort_dis").finish();
        finSumDataSet = finSumDataSet.addField("' '", "bank");
        DataSet select = finSumDataSet.select("bank,finorgtype,amount_set,sort_set,amount_credit,sort_credit,amount_loan,sort_loan,amount_acc,sort_acc,amount_dis,sort_dis");
        dataSet = select.union(allBankDs);
        dataSet = dataSet.orderBy(new String[]{"amount_set desc"});
        dataSet = this.addSortToDataSet(dataSet, "sort_set");
        dataSet = dataSet.orderBy(new String[]{"amount_credit desc"});
        dataSet = this.addSortToDataSet(dataSet, "sort_credit");
        dataSet = dataSet.orderBy(new String[]{"amount_loan desc"});
        dataSet = this.addSortToDataSet(dataSet, "sort_loan");
        dataSet = dataSet.orderBy(new String[]{"amount_acc desc"});
        dataSet = this.addSortToDataSet(dataSet, "sort_acc");
        dataSet = dataSet.orderBy(new String[]{"amount_dis desc"});
        dataSet = this.addSortToDataSet(dataSet, "sort_dis");
        dataSet = businessRangeStr.indexOf("01") != -1 ? dataSet.orderBy(new String[]{"amount_set desc"}) : (businessRangeStr.indexOf("02") != -1 ? dataSet.orderBy(new String[]{"amount_credit desc"}) : (businessRangeStr.indexOf("03") != -1 ? dataSet.orderBy(new String[]{"amount_loan desc"}) : (businessRangeStr.indexOf("04") != -1 ? dataSet.orderBy(new String[]{"amount_acc desc"}) : dataSet.orderBy(new String[]{"amount_dis desc"}))));
        dataSet = dataSet.top(topnum);
        QFilter finOrgTypeFilter = new QFilter("enable", "=", (Object)"1");
        DataSet finOrgTypeDs = QueryServiceHelper.queryDataSet((String)"bd_finorgtype", (String)"bd_finorgtype", (String)"type,name typeName", (QFilter[])new QFilter[]{finOrgTypeFilter}, null);
        if (!finOrgTypeDs.copy().isEmpty()) {
            dataSet = dataSet.leftJoin(finOrgTypeDs).on("finorgtype", "type").select(dataSet.getRowMeta().getFieldNames(), new String[]{"typeName"}).finish();
            dataSet = dataSet.updateField("bank", "case when finorgtype != '0' then typeName else bank end");
        }
        return dataSet;
    }

    private void dealChart(DataSet queryDataSet, Map<String, Object> paramMap) {
        String businessRangeStr = (String)paramMap.get("filter_businessrange");
        DataSet drawChartDataSet = this.getDrawChartDataSet(queryDataSet, paramMap);
        ArrayList<Map<String, Object>> chartDataList = new ArrayList<Map<String, Object>>(10);
        String[] fieldNames = drawChartDataSet.getRowMeta().getFieldNames();
        HashMap<String, Object> o = null;
        Row row = null;
        while (drawChartDataSet.hasNext()) {
            row = drawChartDataSet.next();
            o = new HashMap<String, Object>(16);
            for (String field : fieldNames) {
                o.put(field, row.get(field));
            }
            chartDataList.add(o);
        }
        drawChartDataSet.close();
        this.drawChart(businessRangeStr, chartDataList);
    }

    private DataSet getDrawChartDataSet(DataSet queryDataSet, Map<String, Object> paramMap) {
        StringBuilder selectFiledSb = new StringBuilder();
        selectFiledSb.append("bank");
        String businessRangeStr = (String)paramMap.get("filter_businessrange");
        if (businessRangeStr.indexOf("01") != -1) {
            selectFiledSb.append(",amount_set");
        }
        if (businessRangeStr.indexOf("02") != -1) {
            selectFiledSb.append(",amount_credit");
        }
        if (businessRangeStr.indexOf("03") != -1) {
            selectFiledSb.append(",amount_loan");
        }
        if (businessRangeStr.indexOf("04") != -1) {
            selectFiledSb.append(",amount_acc");
        }
        if (businessRangeStr.indexOf("05") != -1) {
            selectFiledSb.append(",amount_dis");
        }
        DataSet drawChartDataSet = queryDataSet.select(selectFiledSb.toString());
        return drawChartDataSet;
    }

    private HistogramChart getMainChart() {
        return (HistogramChart)this.getControl("histogramchartap");
    }

    private void drawChart(String businessRangeStr, List<Map<String, Object>> chartDataList) {
        HistogramChart customchart = this.getMainChart();
        customchart.setMerge(false);
        customchart.clearData();
        customchart.setMargin(Position.right, "110");
        customchart.setShowLegend(true);
        customchart.setLegendPropValue("left", (Object)"75%");
        customchart.setLegendPropValue("top", (Object)0);
        customchart.setLegendVertical(false);
        List<String> XData = this.getXData(chartDataList);
        Map<Group, List<Object>> YData = this.getYData(businessRangeStr, chartDataList);
        YData.forEach((group, data) -> this.createBarSeries((Group)group, (List<Object>)data));
        Axis xAxis = this.createCategoryAxis(ResManager.loadKDString((String)"\u91d1\u878d\u673a\u6784", (String)"FinOrgEvaFormListPlugin_8", (String)"tmc-mon-report", (Object[])new Object[0]), false);
        xAxis.setCategorys(XData);
        xAxis.setMax((Number)(XData.size() - 1));
        HashMap axisLabelx = Maps.newHashMap();
        axisLabelx.put("rotate", "0");
        xAxis.setPropValue("axisLabel", (Object)axisLabelx);
        HashMap xAxisPointer = Maps.newHashMap();
        xAxisPointer.put("show", true);
        xAxisPointer.put("type", "shadow");
        Label xAxisLabel = new Label();
        xAxisLabel.setShow(true);
        xAxisLabel.setBackgroundColor("black");
        xAxisPointer.put("label", xAxisLabel);
        xAxis.setPropValue("axisPointer", (Object)xAxisPointer);
        Axis yAxis = this.createValueAxis(ResManager.loadKDString((String)"\u91d1\u989d(\u4e07\u5143)", (String)"FinOrgEvaFormListPlugin_9", (String)"tmc-mon-report", (Object[])new Object[0]), true);
        HashMap axisLabel1 = Maps.newHashMap();
        axisLabel1.put("formatter", "{value} ");
        yAxis.setPropValue("axisLabel", (Object)axisLabel1);
        yAxis.setPropValue("minInterval", (Object)1);
        HashMap yAxisPointer = Maps.newHashMap();
        yAxisPointer.put("show", true);
        yAxisPointer.put("type", "line");
        Label yAxisLabel = new Label();
        yAxisLabel.setShow(true);
        yAxisLabel.setBackgroundColor("black");
        yAxisPointer.put("label", xAxisLabel);
        HashMap lineStyle = Maps.newHashMap();
        lineStyle.put("type", "dotted");
        yAxisPointer.put("lineStyle", lineStyle);
        yAxisPointer.put("triggerTooltip", false);
        yAxis.setPropValue("axisPointer", (Object)yAxisPointer);
        customchart.refresh();
    }

    private List<String> getXData(List<Map<String, Object>> chartDataList) {
        ArrayList<String> XData = new ArrayList<String>();
        if (EmptyUtil.isNoEmpty(chartDataList)) {
            for (int i = 0; i < chartDataList.size(); ++i) {
                String type = (String)chartDataList.get(i).get("bank");
                XData.add(type);
            }
        }
        return XData;
    }

    private Map<Group, List<Object>> getYData(String businessRangeStr, List<Map<String, Object>> chartDataList) {
        LinkedHashMap<Group, List<Object>> summaryResult = new LinkedHashMap<Group, List<Object>>();
        if (EmptyUtil.isNoEmpty(chartDataList)) {
            int i;
            String settlementStr = ResManager.loadKDString((String)"\u7ed3\u7b97\u91cf", (String)"FinOrgEvaFormListPlugin_10", (String)"tmc-mon-report", (Object[])new Object[0]);
            String creditStr = ResManager.loadKDString((String)"\u6388\u4fe1\u989d\u5ea6", (String)"FinOrgEvaFormListPlugin_11", (String)"tmc-mon-report", (Object[])new Object[0]);
            String loanStr = ResManager.loadKDString((String)"\u501f\u6b3e\u989d\u5ea6", (String)"FinOrgEvaFormListPlugin_12", (String)"tmc-mon-report", (Object[])new Object[0]);
            String acceptanceStr = ResManager.loadKDString((String)"\u7968\u636e\u627f\u5151\u989d\u5ea6", (String)"FinOrgEvaFormListPlugin_13", (String)"tmc-mon-report", (Object[])new Object[0]);
            String discountStr = ResManager.loadKDString((String)"\u7968\u636e\u8d34\u73b0\u989d\u5ea6", (String)"FinOrgEvaFormListPlugin_14", (String)"tmc-mon-report", (Object[])new Object[0]);
            Object o = "";
            if (businessRangeStr.indexOf("01") != -1) {
                ArrayList<BigDecimal> settlementList = new ArrayList<BigDecimal>(10);
                for (i = 0; i < chartDataList.size(); ++i) {
                    o = chartDataList.get(i).get("amount_set");
                    if (!EmptyUtil.isEmpty((Object)o)) {
                        settlementList.add(((BigDecimal)o).setScale(2, 4));
                        continue;
                    }
                    settlementList.add(null);
                }
                summaryResult.put(new Group(settlementStr, "#56ffaa", ChartType.bar, 0), settlementList);
            }
            if (businessRangeStr.indexOf("02") != -1) {
                ArrayList<BigDecimal> creditList = new ArrayList<BigDecimal>(10);
                for (i = 0; i < chartDataList.size(); ++i) {
                    o = chartDataList.get(i).get("amount_credit");
                    if (!EmptyUtil.isEmpty((Object)o)) {
                        creditList.add(((BigDecimal)o).setScale(2, 4));
                        continue;
                    }
                    creditList.add(null);
                }
                summaryResult.put(new Group(creditStr, "#56aaff", ChartType.bar, 0), creditList);
            }
            if (businessRangeStr.indexOf("03") != -1) {
                ArrayList<BigDecimal> loanList = new ArrayList<BigDecimal>(10);
                for (i = 0; i < chartDataList.size(); ++i) {
                    o = chartDataList.get(i).get("amount_loan");
                    if (!EmptyUtil.isEmpty((Object)o)) {
                        loanList.add(((BigDecimal)o).setScale(2, 4));
                        continue;
                    }
                    loanList.add(null);
                }
                summaryResult.put(new Group(loanStr, "#56ffde", ChartType.bar, 0), loanList);
            }
            if (businessRangeStr.indexOf("04") != -1) {
                ArrayList<BigDecimal> acceptanceList = new ArrayList<BigDecimal>(10);
                for (i = 0; i < chartDataList.size(); ++i) {
                    o = chartDataList.get(i).get("amount_acc");
                    if (!EmptyUtil.isEmpty((Object)o)) {
                        acceptanceList.add(((BigDecimal)o).setScale(2, 4));
                        continue;
                    }
                    acceptanceList.add(null);
                }
                summaryResult.put(new Group(acceptanceStr, "#56ccff", ChartType.bar, 0), acceptanceList);
            }
            if (businessRangeStr.indexOf("05") != -1) {
                ArrayList<BigDecimal> discountList = new ArrayList<BigDecimal>(10);
                for (i = 0; i < chartDataList.size(); ++i) {
                    o = chartDataList.get(i).get("amount_dis");
                    if (!EmptyUtil.isEmpty((Object)o)) {
                        discountList.add(((BigDecimal)o).setScale(2, 4));
                        continue;
                    }
                    discountList.add(null);
                }
                summaryResult.put(new Group(discountStr, "#56eeff", ChartType.bar, 0), discountList);
            }
        }
        return summaryResult;
    }

    private void createBarSeries(Group group, List<Object> data) {
        BarSeries barSeries = this.getMainChart().createBarSeries(group.groupName);
        Label label = new Label();
        label.setShow(true);
        label.setPosition(Position.right);
        barSeries.setLabel(label);
        barSeries.setBarWidth("10px");
        barSeries.setColor(group.color);
        barSeries.setType(group.chartType);
        barSeries.setAnimationDuration(2000);
        barSeries.setPropValue("yAxisIndex", (Object)group.yAxisIndex);
        barSeries.setData(data.toArray(new Number[0]));
    }

    private Axis createCategoryAxis(String name, boolean isX) {
        Axis axis = null;
        axis = isX ? this.getMainChart().createXAxis(name, AxisType.category) : this.getMainChart().createYAxis(name, AxisType.category);
        HashMap<String, Integer> axisTick = new HashMap<String, Integer>();
        axisTick.put("interval", 0);
        axis.setPropValue("axisTick", axisTick);
        this.setLineColor(axis, "#5F9EA0");
        return axis;
    }

    private Axis createValueAxis(String name, boolean isX) {
        Axis axis = null;
        axis = isX ? this.getMainChart().createXAxis(name, AxisType.value) : this.getMainChart().createYAxis(name, AxisType.value);
        HashMap axisTick = new HashMap();
        axis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", splitLine);
        this.setLineColor(axis, "#5F9EA0");
        this.getMainChart().setShowTooltip(true);
        return axis;
    }

    private void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }

    private void dealPieChart(DataSet drawPieChartDataSet, Map<String, Object> paramMap) {
        ArrayList<Object[]> chartDataList = new ArrayList<Object[]>(10);
        Object[] o = null;
        Row row = null;
        while (drawPieChartDataSet.hasNext()) {
            row = drawPieChartDataSet.next();
            o = new Object[row.size()];
            for (int i = 0; i < row.size(); ++i) {
                o[i] = row.get(i);
            }
            chartDataList.add(o);
        }
        drawPieChartDataSet.close();
        this.drawPieChart(chartDataList);
    }

    private void drawPieChart(List<Object[]> chartDataList) {
        if (!EmptyUtil.isEmpty(chartDataList)) {
            ItemValue[] items = new ItemValue[chartDataList.size()];
            ItemValue tempValue = null;
            String name = null;
            BigDecimal number = null;
            for (int i = 0; i < chartDataList.size(); ++i) {
                number = (BigDecimal)chartDataList.get(i)[0];
                name = (String)chartDataList.get(i)[1];
                items[i] = tempValue = new ItemValue(name, (Number)number.setScale(6, 4), colors[i % colors.length]);
            }
            PieChart pieChart = (PieChart)this.getControl("piechartap");
            pieChart.clearData();
            pieChart.setShowTooltip(true);
            pieChart.setShowLegend(true);
            PieSeries series = pieChart.createPieSeries("");
            series.setData(items);
            series.setRadius("0%", "50%");
            pieChart.addTooltip("formatter", (Object)"{b0}: {d0}%");
            pieChart.setLegendPropValue("orient", (Object)"vertical");
            pieChart.setLegendPropValue("x", (Object)"right");
            pieChart.refresh();
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        if (filterInfo != null) {
            String filterBusinessRange;
            this.initToOrgIds(queryParam);
            Map<String, Object> paramMap = ReportCommonHelper.transQueryParam(queryParam);
            FormShowParameter parameter = this.getView().getFormShowParameter();
            paramMap.put("formid", parameter.getFormId());
            paramMap.put("appid", parameter.getAppId());
            String filterStaperiod = (String)paramMap.get("filter_staperiod");
            if (EmptyUtil.isEmpty((String)filterStaperiod)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7edf\u8ba1\u5468\u671f\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FinOrgEvaFormListPlugin_16", (String)"tmc-mon-report", (Object[])new Object[0]));
                return false;
            }
            if (StringUtils.equals((CharSequence)StatisCycleEnum.CONSTOM.getCode(), (CharSequence)filterStaperiod)) {
                Date bookStartDate = (Date)paramMap.get("filter_perioddate_startdate");
                Date bookEndDate = (Date)paramMap.get("filter_perioddate_enddate");
                if (EmptyUtil.isEmpty((Object)bookStartDate) || EmptyUtil.isEmpty((Object)bookEndDate)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d77\u6b62\u65e5\u671f\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FinOrgEvaFormListPlugin_17", (String)"tmc-mon-report", (Object[])new Object[0]));
                    return false;
                }
            }
            if (EmptyUtil.isEmpty((String)(filterBusinessRange = (String)paramMap.get("filter_businessrange")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u8303\u56f4\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FinOrgEvaFormListPlugin_18", (String)"tmc-mon-report", (Object[])new Object[0]));
                return false;
            }
            DynamicObject filterRepcurrency = (DynamicObject)paramMap.get("filter_statcurrency");
            if (EmptyUtil.isEmpty((DynamicObject)filterRepcurrency)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7edf\u8ba1\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FinOrgEvaFormListPlugin_19", (String)"tmc-mon-report", (Object[])new Object[0]));
                return false;
            }
            DynamicObject exRateTable = (DynamicObject)this.getModel().getValue("exratetable");
            if (exRateTable == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccountMoneyFormPlugin_2", (String)"tmc-mon-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
        }
        return super.verifyQuery(queryParam);
    }

    private DataSet getDataSet(Map<String, Object> paramMap) {
        DataSet bankJournalDS = QueryServiceHelper.queryDataSet((String)"cas_bankjournal", (String)"cas_bankjournal", (String)"currency", (QFilter[])FinOrgEvaService.initBankJournalQFilter(paramMap), null);
        DataSet creditLimitDS = QueryServiceHelper.queryDataSet((String)"creditlimit", (String)"cfm_creditlimit", (String)"currency", (QFilter[])FinOrgEvaService.initCreditLimitQFilter(paramMap), null);
        DataSet loanDS = QueryServiceHelper.queryDataSet((String)"loancontractbill", (String)"cfm_loancontractbill", (String)"currency", (QFilter[])FinOrgEvaService.initLoanQFilter(paramMap), null);
        DataSet payableBillDS = QueryServiceHelper.queryDataSet((String)"payablebill", (String)"cdm_payablebill", (String)"currency", (QFilter[])FinOrgEvaService.initPayableBillQFilter(paramMap), null);
        DataSet drafttradeBillDS = QueryServiceHelper.queryDataSet((String)"drafttradebill", (String)"cdm_drafttradebill", (String)"currency", (QFilter[])FinOrgEvaService.initDrafttradeBillQFilter(paramMap), null);
        return bankJournalDS.union(creditLimitDS).union(loanDS).union(payableBillDS).union(drafttradeBillDS);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ReportFilter rptFilter;
        String key = e.getProperty().getName();
        if ("filter_topnum".equals(key) && !EmptyUtil.isEmpty((Object)(rptFilter = (ReportFilter)this.getControl("reportfilterap")))) {
            rptFilter.search();
        }
    }

    private void initToOrgIds(ReportQueryParam queryParam) {
        DynamicObject orgViewDo;
        String queryWay = (String)this.getModel().getValue("filter_queryway");
        if ("org".equalsIgnoreCase(queryWay)) {
            DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("filter_org");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)orgs)) {
                List orgIds = orgs.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
                queryParam.getFilter().getFilterItem("filter_org").setValue(orgIds);
            }
        } else if ("orgview".equalsIgnoreCase(queryWay) && EmptyUtil.isNoEmpty((DynamicObject)(orgViewDo = (DynamicObject)this.getModel().getValue("filter_orgview")))) {
            List orgIds = TmcOrgDataHelper.getOrgIds((Long)orgViewDo.getLong("id"));
            logger.info("orgids : {} ", (Object)orgIds);
            queryParam.getFilter().getFilterItem("filter_org").setValue((Object)orgIds);
        }
    }

    static class Group {
        private String groupName;
        private String color;
        private ChartType chartType;
        private Integer yAxisIndex;

        public Group(String groupName, String color, ChartType chartType, Integer yAxisIndex) {
            this.groupName = groupName;
            this.color = color;
            this.chartType = chartType;
            this.yAxisIndex = yAxisIndex;
        }
    }
}

