/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.form;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.report.ReportList;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mon.report.form.HugeFundFlowFormPlugin;

public class HugeFundFlowDtlFormPlugin
extends HugeFundFlowFormPlugin {
    @Override
    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        String direction = filter.getString("filter_direction");
        if (EmptyUtil.isEmpty((String)direction)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ea4\u6613\u65b9\u5411\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HugeFundFlowDtlFormPlugin_1", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        BigDecimal startAmt = filter.getBigDecimal("filter_startamt");
        BigDecimal endAmt = filter.getBigDecimal("filter_endamt");
        if (EmptyUtil.isNoEmpty((BigDecimal)startAmt) && EmptyUtil.isNoEmpty((BigDecimal)endAmt) && startAmt.compareTo(endAmt) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u3010\u91d1\u989d\u8303\u56f4\u5230\u3011\u9700\u5927\u4e8e\u7b49\u4e8e\u3010\u91d1\u989d\u8303\u56f4\u4ece\u3011\u3002", (String)"HugeFundFlowDtlFormPlugin_2", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    @Override
    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        this.addReportColumn(queryParam.getFilter());
    }

    public void beforeBindData(EventObject e) {
        super.afterBindData(e);
        Map paraMap = this.getView().getFormShowParameter().getCustomParams();
        this.setQueryFiltersAndSearch(paraMap);
    }

    private void setQueryFiltersAndSearch(Map<String, Object> paraMap) {
        if (EmptyUtil.isNoEmpty((Object)paraMap.get("fromSumReport"))) {
            this.getModel().setValue("filter_queryway", paraMap.get("filter_queryway"));
            this.getModel().setValue("filter_org", (Object)((List)paraMap.get("filter_org")).toArray());
            this.getModel().setValue("filter_orgview", paraMap.get("filter_orgview"));
            this.getModel().setValue("filter_finorginfo", (Object)((List)paraMap.get("filter_finorginfo")).toArray());
            this.getModel().setValue("filter_date", paraMap.get("filter_date"));
            this.getModel().setValue("start_date", paraMap.get("start_date"));
            this.getModel().setValue("end_date", paraMap.get("end_date"));
            this.getModel().setValue("filter_datasource", paraMap.get("filter_datasource"));
            this.getModel().setValue("filter_statdim", paraMap.get("filter_statdim"));
            this.getModel().setValue("filter_statcurrency", paraMap.get("filter_statcurrency"));
            this.getModel().setValue("filter_currencyunit", paraMap.get("filter_currencyunit"));
            this.autoSearch();
        }
    }

    private void addReportColumn(FilterInfo filter) {
        ReportList listTab = (ReportList)this.getControl("reportlistap");
        List columns = listTab.getColumns();
        String statdim = filter.getString("filter_statdim");
        String columnStr = "";
        switch (statdim) {
            case "o": {
                columnStr = "org,bank,currencyname";
                break;
            }
            case "b": {
                columnStr = "bank,org,currencyname";
                break;
            }
            case "c": {
                columnStr = "currencyname,org,bank";
                break;
            }
            default: {
                columnStr = "org,bank,currencyname";
            }
        }
        String[] colArr = columnStr.split(",");
        for (int i = 0; i < colArr.length; ++i) {
            ReportColumn reportColumn = new ReportColumn();
            reportColumn.setFieldType("text");
            reportColumn.setFieldKey(colArr[i]);
            reportColumn.setCaption(new LocaleString(this.getColumnName(colArr[i])));
            columns.add(i, reportColumn);
        }
    }

    private String getColumnName(String field) {
        String name = "";
        switch (field) {
            case "org": {
                name = ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7", (String)"HugeFundFlowSumFormPlugin_1", (String)"tmc-mon-report", (Object[])new Object[0]);
                break;
            }
            case "bank": {
                name = ResManager.loadKDString((String)"\u5f00\u6237\u94f6\u884c", (String)"HugeFundFlowSumFormPlugin_2", (String)"tmc-mon-report", (Object[])new Object[0]);
                break;
            }
            case "currencyname": {
                name = ResManager.loadKDString((String)"\u5e01\u79cd", (String)"HugeFundFlowSumFormPlugin_3", (String)"tmc-mon-report", (Object[])new Object[0]);
                break;
            }
        }
        return name;
    }
}

