/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.form;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mon.common.enums.StatisCycleEnum;

public class HugeFundFlowFormPlugin
extends AbstractReportFormPlugin {
    public void propertyChanged(PropertyChangedArgs e) {
        String field;
        switch (field = e.getProperty().getName()) {
            case "filter_statdim": 
            case "filter_banklevel": {
                this.autoSearch();
                break;
            }
            case "filter_date": {
                String dateType = Optional.ofNullable((String)this.getModel().getValue("filter_date")).orElse("");
                if (StatisCycleEnum.CONSTOM.getCode().equals(dateType)) break;
                this.getModel().setValue("start_date", null);
                this.getModel().setValue("end_date", null);
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        String dataSource;
        FilterInfo filter = queryParam.getFilter();
        DynamicObject statCurrency = (DynamicObject)this.getModel().getValue("filter_statcurrency");
        if (EmptyUtil.isEmpty((DynamicObject)statCurrency)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7edf\u8ba1\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HugeFundFlowFormPlugin_10", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        String dateType = filter.getString("filter_date");
        if (EmptyUtil.isEmpty((String)dateType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u671f\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HugeFundFlowFormPlugin_2", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        if (StatisCycleEnum.CONSTOM.getCode().equals(dateType)) {
            Date startDate = filter.getDate("start_date");
            Date endDate = filter.getDate("end_date");
            if (EmptyUtil.isEmpty((Object)startDate) || EmptyUtil.isEmpty((Object)endDate)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HugeFundFlowFormPlugin_3", (String)"tmc-mon-report", (Object[])new Object[0]));
                return false;
            }
        }
        if (EmptyUtil.isEmpty((String)(dataSource = filter.getString("filter_datasource")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HugeFundFlowFormPlugin_4", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterInfo filter = queryParam.getFilter();
        filter.addFilterItem("filter_statdim", this.getModel().getValue("filter_statdim"));
        this.resetDateRange(filter);
        this.addBankAcctFilter(filter);
    }

    private void resetDateRange(FilterInfo filter) {
        Date startDate;
        String dateType = filter.getString("filter_date");
        Date endDate = DateUtils.truncateDate((Date)new Date());
        switch (dateType) {
            case "04": {
                startDate = DateUtils.getFirstDayOfMonth((Date)endDate);
                break;
            }
            case "06": {
                startDate = DateUtils.getLastMonth((Date)endDate, (int)3);
                break;
            }
            case "07": {
                startDate = DateUtils.getLastMonth((Date)endDate, (int)6);
                break;
            }
            case "08": {
                startDate = DateUtils.getLastMonth((Date)endDate, (int)12);
                break;
            }
            case "99": {
                startDate = filter.getDate("start_date");
                endDate = filter.getDate("end_date");
                break;
            }
            default: {
                startDate = DateUtils.getFirstDayOfMonth((Date)endDate);
            }
        }
        filter.addFilterItem("filter_startdate", (Object)startDate);
        filter.addFilterItem("filter_enddate", (Object)DateUtils.getNextDay((Date)endDate, (int)1));
    }

    private void addBankAcctFilter(FilterInfo filter) {
        List bankIds;
        DynamicObjectCollection openBankCols = filter.getDynamicObjectCollection("filter_finorginfo");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)openBankCols)) {
            bankIds = openBankCols.stream().map(r -> r.getPkValue()).collect(Collectors.toList());
        } else {
            QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            qFilter.and(new QFilter("finorgtype.type", "=", (Object)FinOrgTypeEnum.BANK.getValue()));
            bankIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_finorginfo", (QFilter[])new QFilter[]{qFilter}, (String)"", (int)-1);
        }
        filter.addFilterItem("filter_openbank", bankIds);
        String dataSource = filter.getString("filter_datasource");
        if ("B".equals(dataSource)) {
            List bankAcctIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_accountbanks", (QFilter[])new QFilter[]{new QFilter("bank", "in", (Object)bankIds)}, (String)"", (int)-1);
            filter.addFilterItem("filter_bankacct", (Object)bankAcctIds);
        }
    }

    protected void autoSearch() {
        ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
        if (!EmptyUtil.isEmpty((Object)rptFilter)) {
            try {
                rptFilter.search();
            }
            catch (KDBizException bizEx) {
                this.getView().showErrorNotification(bizEx.getMessage());
            }
        }
    }
}

