/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.form;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.TreeReportListEvent;
import kd.tmc.mon.report.form.HugeFundFlowFormPlugin;

public class HugeFundFlowSumFormPlugin
extends HugeFundFlowFormPlugin {
    public void setTreeReportList(TreeReportListEvent event) {
        super.setTreeReportList(event);
        event.setTreeReportList(true);
    }

    @Override
    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterInfo filter = queryParam.getFilter();
        filter.addFilterItem("filter_banklevel", this.getModel().getValue("filter_banklevel"));
        this.setDynColumnFieldName(filter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (StringUtils.equals((CharSequence)"gotodetail", (CharSequence)operateKey) && args.getOperationResult().isSuccess()) {
            this.showDetailReport();
        }
    }

    private void showDetailReport() {
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("mon_hugefundflowdtlrpt");
        Map paraMap = showParameter.getCustomParams();
        paraMap.put("fromSumReport", "true");
        paraMap.put("filter_queryway", this.getModel().getValue("filter_queryway"));
        paraMap.put("filter_org", this.transferDynamicObjectCollection("filter_org"));
        paraMap.put("filter_orgview", this.transferDynamicObject("filter_orgview"));
        paraMap.put("filter_finorginfo", this.transferDynamicObjectCollection("filter_finorginfo"));
        paraMap.put("filter_date", this.getModel().getValue("filter_date"));
        paraMap.put("start_date", this.getModel().getValue("start_date"));
        paraMap.put("end_date", this.getModel().getValue("end_date"));
        paraMap.put("filter_datasource", this.getModel().getValue("filter_datasource"));
        paraMap.put("filter_statdim", this.getModel().getValue("filter_statdim"));
        paraMap.put("filter_statcurrency", this.transferDynamicObject("filter_statcurrency"));
        paraMap.put("filter_currencyunit", this.getModel().getValue("filter_currencyunit"));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private List<Object> transferDynamicObjectCollection(String fieldName) {
        DynamicObjectCollection dynCols = (DynamicObjectCollection)this.getModel().getValue(fieldName);
        return dynCols.stream().map(r -> r.getDynamicObject("fbasedataid")).map(r -> r.getPkValue()).collect(Collectors.toList());
    }

    private Object transferDynamicObject(String fieldName) {
        return Optional.ofNullable((DynamicObject)this.getModel().getValue(fieldName)).map(r -> r.getPkValue()).orElse(0);
    }

    private String getColumnName(String field) {
        String name = "";
        switch (field) {
            case "o": {
                name = ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7", (String)"HugeFundFlowSumFormPlugin_1", (String)"tmc-mon-report", (Object[])new Object[0]);
                break;
            }
            case "b": {
                name = ResManager.loadKDString((String)"\u5f00\u6237\u94f6\u884c", (String)"HugeFundFlowSumFormPlugin_2", (String)"tmc-mon-report", (Object[])new Object[0]);
                break;
            }
            case "c": {
                name = ResManager.loadKDString((String)"\u5e01\u79cd", (String)"HugeFundFlowSumFormPlugin_3", (String)"tmc-mon-report", (Object[])new Object[0]);
                break;
            }
        }
        return name;
    }

    private void setDynColumnFieldName(FilterInfo filter) {
        ReportList listTab = (ReportList)this.getControl("reportlistap");
        List columns = listTab.getColumns();
        String statdim = filter.getString("filter_statdim");
        for (int i = 0; i < columns.size(); ++i) {
            ReportColumn column = (ReportColumn)columns.get(i);
            if (!StringUtils.equals((CharSequence)"dyncol", (CharSequence)column.getFieldKey())) continue;
            column.setCaption(new LocaleString(this.getColumnName(statdim)));
            break;
        }
    }
}

