/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.form;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.ChartType;
import kd.bos.form.chart.GaugeChart;
import kd.bos.form.chart.GaugeSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.container.Container;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.enums.ReportOrgQueryWayEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mon.business.query.PoolMoneyService;
import kd.tmc.mon.common.helper.OrgHelper;
import kd.tmc.mon.common.helper.PeriodHelper;

public class PoolMoneyFormPlugin
extends AbstractReportFormPlugin {
    private static final Long DEFAULTORGVIEWID = 8L;
    private static Log logger = LogFactory.getLog(PoolMoneyFormPlugin.class);
    private static final String[] colors = new String[]{"#098BFF", "#00CCCC", "#6DD38B", "#87DB3D", "#C7E052", "#FFD72D", "#FFB91A", "#FF9900", "#FF8144", "#FF6666", "#C2489B", "#6733CC", "#511FCC", "#3300CC", "#1F06A3", "#09087C"};
    private static final BigDecimal TEN_THOUSAND = new BigDecimal(10000);

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        String statdim = (String)this.getModel().getValue("calculatestyle");
        filterInfo.addFilterItem("calculatestyle", (Object)statdim);
        this.setColumnOrder(statdim);
        ReportList list = (ReportList)this.getView().getControl("reportlistap");
        List columns = list.getColumns();
        ReportColumn c1 = (ReportColumn)columns.get(1);
        ReportColumn c2 = (ReportColumn)columns.get(2);
        ReportColumn c3 = (ReportColumn)columns.get(3);
        String[] sortFields = new String[]{c1.getFieldKey(), c2.getFieldKey(), c3.getFieldKey()};
        filterInfo.addFilterItem("sortFields", (Object)sortFields);
        queryParam.setFilter(filterInfo);
    }

    public void beforeBindData(EventObject e) {
        DynamicObjectCollection queryFisBankRollOrg;
        super.beforeBindData(e);
        long orgId = RequestContext.get().getOrgId();
        Long mainCurrency = OrgHelper.getMainCurrency((long)orgId);
        this.getModel().setValue("filter_statcurrency", (Object)mainCurrency);
        String appId = this.getView().getFormShowParameter().getAppId();
        Long fisBankRollOrg = OrgHelper.getFisBankRollOrg((Long)orgId, (String)appId, (Long)RequestContext.get().getCurrUserId(), (String)"47150e89000000ac", (String)"mon_poolmoney");
        if (fisBankRollOrg != null && !(queryFisBankRollOrg = QueryServiceHelper.query((String)"queryCashInit", (String)"cas_cashmgtinit", (String)"org as id", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)new Long[]{fisBankRollOrg}), new QFilter("isfinishinit", "=", (Object)"1")}, null)).isEmpty()) {
            DynamicObject initObj = PeriodHelper.getCasInitInfo((long)fisBankRollOrg);
            this.getModel().setValue("exratetable", initObj.getDynamicObject("exratetable").getPkValue());
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        DynamicObject reportCurrency = (DynamicObject)this.getModel().getValue("filter_statcurrency");
        Date balanceDate = filter.getDate("balancedate");
        if (reportCurrency == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7edf\u8ba1\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccountMoneyFormPlugin_0", (String)"tmc-mon-report", (Object[])new Object[0]), Integer.valueOf(2000));
            return false;
        }
        if (balanceDate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f59\u989d\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccountMoneyFormPlugin_1", (String)"tmc-mon-report", (Object[])new Object[0]), Integer.valueOf(2000));
            return false;
        }
        DynamicObject exRateTable = (DynamicObject)filter.getValue("exratetable");
        if (exRateTable == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccountMoneyFormPlugin_2", (String)"tmc-mon-report", (Object[])new Object[0]), Integer.valueOf(3000));
            return false;
        }
        return true;
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        List columns = event.getColumns();
        int sort = -1;
        int color = -1;
        int amount = -1;
        block10: for (int i = 0; i < columns.size(); ++i) {
            String fieldKey;
            ReportColumn column = (ReportColumn)columns.get(i);
            switch (fieldKey = column.getFieldKey()) {
                case "sort": {
                    sort = i;
                    continue block10;
                }
                case "color": {
                    color = i;
                    continue block10;
                }
                case "amount": {
                    amount = i;
                }
            }
        }
        ReportColumn cs = (ReportColumn)columns.get(sort);
        ReportColumn cc = (ReportColumn)columns.get(color);
        columns.remove(cs);
        columns.remove(cc);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap21"});
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        FilterInfo filter = queryParam.getFilter();
        String calcStyle = filter.getString("calculatestyle");
        String top = filter.getString("top");
        boolean sonacctispool = filter.getBoolean("sonacctispool");
        DynamicObject reportCurrency = filter.getDynamicObject("filter_statcurrency");
        Date balanceDate = filter.getDate("balancedate");
        String[] sortFields = (String[])filter.getValue("sortFields");
        long orgId = RequestContext.get().getOrgId();
        DynamicObjectCollection balanceCurrency = filter.getDynamicObjectCollection("balancecurrency");
        DynamicObjectCollection bankFi = filter.getDynamicObjectCollection("bankfi");
        long exchangeRateTableId = filter.getDynamicObject("exratetable").getLong("id");
        List<Long> orgIds = this.getQueryOrgIds(queryParam);
        String datasource = filter.getString("datasource");
        boolean statsInnerAcct = filter.getBoolean("statsinneracct");
        Object[] dataArr = this.getDataSet(datasource, calcStyle, sonacctispool, reportCurrency, balanceDate, sortFields, orgId, balanceCurrency, bankFi, orgIds, top, statsInnerAcct, exchangeRateTableId);
        GaugeChart gaugeChart = (GaugeChart)this.getControl("gaugechartap");
        this.drawGaugeChart(dataArr, gaugeChart);
        PieChart pieChart = (PieChart)this.getControl("piechartap");
        this.drawPiechart(calcStyle, dataArr, pieChart);
        Label curLab = (Label)this.getControl("cur");
        Label nopoolsumLab = (Label)this.getControl("nopoolsum");
        curLab.setText(reportCurrency.getString("name"));
        BigDecimal noPoolAmtSum = (BigDecimal)dataArr[3];
        nopoolsumLab.setText(String.valueOf(noPoolAmtSum.divide(TEN_THOUSAND, 2, 4)));
        HistogramChart hisChart = (HistogramChart)this.getControl("histogramchartap");
        DataSet nopoolDataSet = (DataSet)dataArr[2];
        Iterator nopoolIter = nopoolDataSet.iterator();
        ArrayList<String> XData = new ArrayList<String>();
        ArrayList<Object> YData = new ArrayList<Object>();
        while (nopoolIter.hasNext()) {
            Row row = (Row)nopoolIter.next();
            String rowCalcStyle = row.getString(calcStyle);
            BigDecimal rowAmt = row.getBigDecimal("amount");
            BigDecimal rowAmtW = rowAmt.divide(TEN_THOUSAND, 2, 4);
            logger.info("nopoolDataSet,rowCalcStyle={},rowAmt={}", (Object)rowCalcStyle, (Object)rowAmt);
            XData.add(rowCalcStyle);
            YData.add(rowAmtW);
        }
        logger.info("XData={},YData={}", (Object)JSON.toJSONString(XData), (Object)JSON.toJSONString(YData));
        this.drawHistogramChart(XData, YData, hisChart, calcStyle);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap21"});
        Container c = (Container)this.getControl("flexpanelap21");
        c.setCollapse(false);
    }

    private void drawGaugeChart(Object[] dataArr, GaugeChart gaugeChart) {
        gaugeChart.clearData();
        GaugeSeries gaugeSeries = gaugeChart.createSeries(ResManager.loadKDString((String)"\u8d44\u91d1\u96c6\u4e2d\u5ea6", (String)"PoolMoneyFormPlugin_6", (String)"tmc-mon-report", (Object[])new Object[0]));
        gaugeSeries.setPropValue("radius", (Object)"58%");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("formatter", "{value}%");
        HashMap<String, Integer> textStyleMap = new HashMap<String, Integer>();
        textStyleMap.put("fontSize", 13);
        map.put("textStyle", textStyleMap);
        gaugeSeries.setDetail(map);
        BigDecimal all = ((BigDecimal)dataArr[1]).add((BigDecimal)dataArr[3]);
        BigDecimal rate = BigDecimal.ZERO;
        if (all.compareTo(BigDecimal.ZERO) != 0) {
            rate = ((BigDecimal)dataArr[1]).divide(all, 4, 4);
        }
        ItemValue val = new ItemValue("", (Number)rate.multiply(new BigDecimal(100)), colors[0]);
        gaugeSeries.addData(val);
        HashMap axisLine = new HashMap();
        HashMap lineStyle = new HashMap();
        ArrayList<Object[]> colorList = new ArrayList<Object[]>();
        colorList.add(new Object[]{0.2, "#F57582"});
        colorList.add(new Object[]{0.5, "#FFC53B"});
        colorList.add(new Object[]{0.8, "#26C9C3"});
        colorList.add(new Object[]{1, "#40A9FF"});
        axisLine.put("lineStyle", lineStyle);
        lineStyle.put("color", colorList);
        gaugeSeries.setPropValue("axisLine", axisLine);
        gaugeChart.bindData(null);
        gaugeChart.refresh();
    }

    private void drawHistogramChart(List<String> XData, List<Object> YData, HistogramChart customchart, String calcStyle) {
        customchart.clearData();
        customchart.setMargin(Position.right, "110");
        customchart.setShowLegend(true);
        customchart.setLegendVertical(false);
        String xShow = "";
        switch (calcStyle) {
            case "currency": {
                xShow = "    " + ResManager.loadKDString((String)"\u5e01\u79cd", (String)"PoolMoneyFormPlugin_0", (String)"tmc-mon-report", (Object[])new Object[0]);
                break;
            }
            case "bank": {
                xShow = "              " + ResManager.loadKDString((String)"\u5f00\u6237\u884c\u7c7b\u522b", (String)"PoolMoneyFormPlugin_1", (String)"tmc-mon-report", (Object[])new Object[0]);
                break;
            }
            default: {
                xShow = "    " + ResManager.loadKDString((String)"\u516c\u53f8", (String)"PoolMoneyFormPlugin_2", (String)"tmc-mon-report", (Object[])new Object[0]);
            }
        }
        Axis xAxis = this.createCategoryAxis(xShow, false);
        xAxis.setCategorys(XData);
        xAxis.setMax((Number)(XData.size() - 1));
        HashMap axisLabelx = Maps.newHashMap();
        axisLabelx.put("rotate", "0");
        xAxis.setPropValue("axisLabel", (Object)axisLabelx);
        HashMap xAxisPointer = Maps.newHashMap();
        xAxisPointer.put("show", true);
        xAxisPointer.put("type", "shadow");
        kd.bos.form.chart.Label xAxisLabel = new kd.bos.form.chart.Label();
        xAxisLabel.setShow(true);
        xAxisLabel.setBackgroundColor("black");
        xAxisPointer.put("label", xAxisLabel);
        xAxis.setPropValue("axisPointer", (Object)xAxisPointer);
        BarSeries barSeries = customchart.createBarSeries("");
        kd.bos.form.chart.Label label = new kd.bos.form.chart.Label();
        label.setShow(true);
        label.setPosition(Position.right);
        barSeries.setLabel(label);
        barSeries.setBarWidth("15px");
        barSeries.setColor("#56ffaa");
        barSeries.setType(ChartType.bar);
        barSeries.setAnimationDuration(2000);
        barSeries.setPropValue("yAxisIndex", (Object)0);
        barSeries.setData(YData.toArray(new Number[0]));
        Axis yAxis = this.createValueAxis(ResManager.loadKDString((String)"\u91d1\u989d", (String)"PoolMoneyFormPlugin_3", (String)"tmc-mon-report", (Object[])new Object[0]), true);
        HashMap axisLabel1 = Maps.newHashMap();
        axisLabel1.put("formatter", new StringBuilder("{value}").append(ResManager.loadKDString((String)"\u4e07\u5143", (String)"PoolMoneyFormPlugin_4", (String)"tmc-mon-report", (Object[])new Object[0])));
        yAxis.setPropValue("axisLabel", (Object)axisLabel1);
        yAxis.setPropValue("minInterval", (Object)1);
        HashMap yAxisPointer = Maps.newHashMap();
        yAxisPointer.put("show", true);
        yAxisPointer.put("type", "line");
        kd.bos.form.chart.Label yAxisLabel = new kd.bos.form.chart.Label();
        yAxisLabel.setShow(true);
        yAxisLabel.setBackgroundColor("black");
        yAxisPointer.put("label", xAxisLabel);
        HashMap lineStyle = Maps.newHashMap();
        lineStyle.put("type", "dotted");
        yAxisPointer.put("lineStyle", lineStyle);
        yAxisPointer.put("triggerTooltip", false);
        yAxis.setPropValue("axisPointer", (Object)yAxisPointer);
        customchart.refresh();
    }

    private Axis createValueAxis(String name, boolean isX) {
        HistogramChart customchart = (HistogramChart)this.getControl("histogramchartap");
        Axis axis = null;
        axis = isX ? customchart.createXAxis(name, AxisType.value) : customchart.createYAxis(name, AxisType.value);
        HashMap axisTick = new HashMap();
        axis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", splitLine);
        return axis;
    }

    private Axis createCategoryAxis(String name, boolean isX) {
        HistogramChart customchart = (HistogramChart)this.getControl("histogramchartap");
        Axis axis = null;
        axis = isX ? customchart.createXAxis(name, AxisType.category) : customchart.createYAxis(name, AxisType.category);
        HashMap<String, Integer> axisTick = new HashMap<String, Integer>();
        axisTick.put("interval", 0);
        axis.setPropValue("axisTick", axisTick);
        return axis;
    }

    private void drawPiechart(String calcStyle, Object[] dataArr, PieChart pieChart) {
        pieChart.clearData();
        pieChart.setShowTooltip(true);
        pieChart.setShowLegend(true);
        pieChart.setTitleAlign(XAlign.center, YAlign.center);
        ArrayList<ItemValue> itemList = new ArrayList<ItemValue>();
        DataSet dataset = (DataSet)dataArr[0];
        Iterator poolIterator = dataset.iterator();
        int i = 0;
        while (poolIterator.hasNext()) {
            Row row = (Row)poolIterator.next();
            String rowCalcStyle = row.getString(calcStyle);
            BigDecimal rowAmt = row.getBigDecimal("amount").divide(TEN_THOUSAND, 2, 4);
            ItemValue val = new ItemValue(rowCalcStyle, (Number)rowAmt, colors[i]);
            itemList.add(val);
            if (i >= 15) {
                i = 0;
                continue;
            }
            ++i;
        }
        PieSeries series = pieChart.createPieSeries(ResManager.loadKDString((String)"\u6c60\u5185\u8d44\u91d1", (String)"PoolMoneyFormPlugin_5", (String)"tmc-mon-report", (Object[])new Object[0]));
        if (itemList.size() <= 0) {
            ItemValue val = new ItemValue(" ", (Number)BigDecimal.ZERO, colors[3]);
            itemList.add(val);
        }
        series.setRadius("0%", "58%");
        series.setData(itemList.toArray(new ItemValue[0]));
        pieChart.addTooltip("formatter", (Object)new StringBuilder("{b0}: ").append("{c0}(").append(ResManager.loadKDString((String)"\u4e07\u5143", (String)"PoolMoneyFormPlugin_4", (String)"tmc-mon-report", (Object[])new Object[0])).append(")<br/>{d0}%"));
        pieChart.setLegendPropValue("orient", (Object)"vertical");
        pieChart.setLegendPropValue("x", (Object)"right");
        pieChart.refresh();
    }

    private Object[] getDataSet(String datasource, String calcStyle, boolean sonacctispool, DynamicObject reportCurrency, Date balanceDate, String[] sortFields, long orgId, DynamicObjectCollection balanceCurrency, DynamicObjectCollection bankFi, List<Long> orgFiList, String top, boolean statsInnerAcct, long exchangeRateTableId) {
        Set allAcctIds = PoolMoneyService.queryAcctIds((DynamicObjectCollection)balanceCurrency, (DynamicObjectCollection)bankFi, orgFiList, (boolean)statsInnerAcct);
        Map acctGroupMap = PoolMoneyService.queryAcctGroups((DynamicObjectCollection)balanceCurrency, (DynamicObjectCollection)bankFi, orgFiList, (boolean)statsInnerAcct);
        HashMap poolMap = new HashMap(acctGroupMap.size());
        for (Map.Entry entry : acctGroupMap.entrySet()) {
            DynamicObject acctGroup = (DynamicObject)entry.getKey();
            Long groupAcctId = acctGroup.getDynamicObject("accountbank").getLong("id");
            Long groupCurId = acctGroup.getDynamicObject("currency").getLong("id");
            Set<Long> poolCurIds = poolMap.containsKey(groupCurId) ? (Set)poolMap.get(groupCurId) : new HashSet();
            poolCurIds.add(groupCurId);
            poolMap.put(groupAcctId, poolCurIds);
            Set subAcctIds = (Set)entry.getValue();
            if (!sonacctispool) continue;
            for (Long subAcctId : subAcctIds) {
                Set<Long> subCurIds = poolMap.containsKey(subAcctId) ? (Set)poolMap.get(subAcctId) : new HashSet();
                subCurIds.add(groupCurId);
                poolMap.put(subAcctId, subCurIds);
            }
        }
        DataSet dataSet = PoolMoneyService.queryBalanceDataSet((String)datasource, (Date)balanceDate, (DynamicObjectCollection)balanceCurrency, (DynamicObjectCollection)bankFi, orgFiList, new ArrayList(allAcctIds));
        DataSet[] detailData = PoolMoneyService.getDetailDataSet((DataSet)dataSet, (Set)allAcctIds, poolMap);
        DataSet poolDetail = detailData[0];
        DataSet outPoolDetail = detailData[1];
        Object[] poolArr = null;
        Object[] noPoolArr = null;
        int topSum = Integer.parseInt(top);
        if ("currency".equals(calcStyle)) {
            poolArr = this.queryByCurrency(reportCurrency, balanceDate, orgId, poolDetail, sortFields, exchangeRateTableId);
            noPoolArr = this.queryByCurrency(reportCurrency, balanceDate, orgId, outPoolDetail, sortFields, exchangeRateTableId);
        } else {
            poolArr = this.queryByOthers(calcStyle, reportCurrency, balanceDate, sortFields, orgId, poolDetail, exchangeRateTableId);
            noPoolArr = this.queryByOthers(calcStyle, reportCurrency, balanceDate, sortFields, orgId, outPoolDetail, exchangeRateTableId);
        }
        Object[] dataArr = new Object[]{poolArr[0], poolArr[1], ((DataSet)noPoolArr[0]).top(topSum), noPoolArr[1]};
        return dataArr;
    }

    private void setColumnOrder(String key) {
        ReportList list = (ReportList)this.getView().getControl("reportlistap");
        List columns = list.getColumns();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if ("currency".equals(key)) {
            for (int i = 0; i < columns.size(); ++i) {
                ReportColumn column = (ReportColumn)columns.get(i);
                String fieldKey = column.getFieldKey();
                if (!"currency".equals(fieldKey)) continue;
                map.put("currency", i);
            }
            ReportColumn c0 = (ReportColumn)columns.get(0);
            if (!"currency".equals(c0.getFieldKey())) {
                Integer i = (Integer)map.get("currency");
                ReportColumn ci = (ReportColumn)columns.get(i);
                columns.set(0, ci);
                columns.set(i, c0);
            }
        } else {
            for (int i = 0; i < columns.size(); ++i) {
                ReportColumn column = (ReportColumn)columns.get(i);
                String fieldKey = column.getFieldKey();
                if (!key.equals(fieldKey)) continue;
                map.put(key, i);
            }
            ReportColumn c0 = (ReportColumn)columns.get(0);
            if (!key.equals(c0.getFieldKey())) {
                Integer i = (Integer)map.get(key);
                ReportColumn ci = (ReportColumn)columns.get(i);
                columns.set(0, ci);
                columns.set(i, c0);
            }
            HashMap<String, Integer> map2 = new HashMap<String, Integer>();
            for (int i = 0; i < columns.size(); ++i) {
                ReportColumn column = (ReportColumn)columns.get(i);
                String fieldKey = column.getFieldKey();
                if (!"currency".equals(fieldKey)) continue;
                map2.put("currency", i);
            }
            ReportColumn c1 = (ReportColumn)columns.get(1);
            if (!"currency".equals(c1.getFieldKey())) {
                Integer i = (Integer)map2.get("currency");
                ReportColumn ci = (ReportColumn)columns.get(i);
                columns.set(1, ci);
                columns.set(i, c1);
            }
        }
    }

    private Object[] queryByCurrency(DynamicObject reportCurrency, Date balanceDate, long orgId, DataSet dataSet, String[] sortFields, Long exchangeRateTableId) {
        Long rptCurId = reportCurrency.getLong("id");
        DataSet copy = dataSet.copy();
        DataSet groupSet = copy.groupBy(new String[]{"cur", "currency"}).sum("amount").finish();
        Iterator it = groupSet.iterator();
        Field[] fields = dataSet.getRowMeta().getFields();
        BigDecimal totalAmt = BigDecimal.ZERO;
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            Long rowCurId = row.getLong("cur");
            BigDecimal rowAmt = row.getBigDecimal("amount");
            BigDecimal exRate = BigDecimal.ZERO;
            if (rowCurId.equals(rptCurId)) {
                exRate = BigDecimal.ONE;
            } else {
                exRate = BaseDataServiceHelper.getExchangeRate((Long)exchangeRateTableId, (Long)rowCurId, (Long)rptCurId, (Date)balanceDate);
                if (exRate == null) {
                    exRate = BigDecimal.ZERO;
                }
            }
            BigDecimal exAmt = rowAmt.multiply(exRate);
            totalAmt = totalAmt.add(exAmt);
            Object[] arr = new Object[fields.length];
            block11: for (int i = 0; i < fields.length; ++i) {
                String name;
                switch (name = fields[i].getName()) {
                    case "currency": {
                        arr[i] = row.get("currency");
                        continue block11;
                    }
                    case "amount": {
                        arr[i] = exAmt;
                        continue block11;
                    }
                    case "cur": {
                        arr[i] = rowCurId;
                    }
                }
            }
            list.add(arr);
        }
        DataSet totalDataSet = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(list, dataSet.getRowMeta());
        DataSet orderBy = totalDataSet.orderBy(new String[]{"amount desc"});
        Object[] returnArr = new Object[]{orderBy, totalAmt};
        return returnArr;
    }

    private Object[] queryByOthers(String calcStyle, DynamicObject reportCurrency, Date balanceDate, String[] sortFields, long orgId, DataSet dataSet, Long exchangeRateTableId) {
        Long rptCurId = reportCurrency.getLong("id");
        DataSet copy2 = dataSet.copy();
        DataSet calcGroup = copy2.groupBy(new String[]{"cur", "currency", calcStyle}).sum("amount").finish();
        Iterator it = calcGroup.iterator();
        HashMap<String, BigDecimal> calcAmtMap = new HashMap<String, BigDecimal>();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            Long rowCurId = row.getLong("cur");
            String rowStyle = row.getString(calcStyle);
            BigDecimal rowAmt = row.getBigDecimal("amount");
            BigDecimal bigDecimal = calcAmtMap.containsKey(rowStyle) ? (BigDecimal)calcAmtMap.get(rowStyle) : BigDecimal.ZERO;
            BigDecimal exRate = BigDecimal.ZERO;
            if (rowCurId.equals(rptCurId)) {
                exRate = BigDecimal.ONE;
            } else {
                exRate = BaseDataServiceHelper.getExchangeRate((Long)exchangeRateTableId, (Long)rowCurId, (Long)rptCurId, (Date)balanceDate);
                if (exRate == null) {
                    exRate = BigDecimal.ZERO;
                }
            }
            BigDecimal bigDecimal2 = bigDecimal.add(rowAmt.multiply(exRate));
            calcAmtMap.put(rowStyle, bigDecimal2);
        }
        BigDecimal amountTotal = BigDecimal.ZERO;
        Field[] fields = dataSet.getRowMeta().getFields();
        ArrayList<Object[]> list = new ArrayList<Object[]>(10);
        for (Map.Entry entry : calcAmtMap.entrySet()) {
            String styleVal = (String)entry.getKey();
            BigDecimal styleAmount = (BigDecimal)calcAmtMap.get(styleVal);
            amountTotal = amountTotal.add(styleAmount);
            Object[] styleArr = new Object[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                String name;
                switch (name = fields[i].getName()) {
                    case "amount": {
                        styleArr[i] = styleAmount;
                    }
                }
                if (!calcStyle.equals(name)) continue;
                styleArr[i] = styleVal == null ? " " : styleVal;
            }
            list.add(styleArr);
        }
        DataSet totalDataSet = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(list, dataSet.getRowMeta());
        DataSet dataSet2 = totalDataSet.orderBy(new String[]{"amount desc"});
        Object[] returnArr = new Object[]{dataSet2, amountTotal};
        return returnArr;
    }

    public List<Long> getQueryOrgIds(ReportQueryParam queryParam) {
        List orgIds = new ArrayList(10);
        Long userId = RequestContext.get().getCurrUserId();
        String formId = (String)queryParam.getCustomParam().get("formid");
        String appId = (String)queryParam.getCustomParam().get("appid");
        String queryWay = (String)queryParam.getFilter().getFilterItem("filter_queryway").getValue();
        if (ReportOrgQueryWayEnum.ORGVIEW.getValue().equals(queryWay)) {
            DynamicObject orgView = (DynamicObject)queryParam.getFilter().getFilterItem("filter_orgview").getValue();
            if (EmptyUtil.isNoEmpty((DynamicObject)orgView)) {
                orgIds = (List)queryParam.getFilter().getFilterItem("filter_org").getValue();
                orgIds = EmptyUtil.isEmpty(orgIds) ? TmcOrgDataHelper.getAuthorizedAndSubordinateOrgByView((Long)orgView.getLong("id"), (Long)userId, (String)appId, (String)formId, (String)"47150e89000000ac", (boolean)true, (boolean)true) : TmcOrgDataHelper.getAllSubordinateOrgs((Long)orgView.getLong("id"), orgIds, (boolean)true, (boolean)true);
            }
        } else {
            orgIds = (List)queryParam.getFilter().getFilterItem("filter_org").getValue();
            if (EmptyUtil.isEmpty(orgIds)) {
                orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)formId, (String)"47150e89000000ac");
            }
            if (queryParam.getFilter().containProp("filter_isincludelower") && ((Boolean)queryParam.getFilter().getFilterItem("filter_isincludelower").getValue()).booleanValue()) {
                orgIds = TmcOrgDataHelper.getAllSubordinateOrgsForCache((Long)DEFAULTORGVIEWID, orgIds, (boolean)true);
            }
        }
        return orgIds;
    }
}

