/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.form.funddaily;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.mon.report.form.funddaily.AbstractFundDailyReport;
import kd.tmc.mon.report.form.funddaily.dao.ComputeBalanceParam;
import kd.tmc.mon.report.form.funddaily.dao.NewRowsParam;
import kd.tmc.mon.report.form.funddaily.dao.QueryParam;
import kd.tmc.mon.report.helper.CountBalanceHelper;
import kd.tmc.mon.report.helper.FundDailyHelper;

public class FundDailyConvergeOrg
extends AbstractFundDailyReport {
    @Override
    protected String[] groupByFields(Map<String, List<String>> addColumns, Boolean isEndDeal) {
        ArrayList<String> groupByList = new ArrayList<String>(16);
        groupByList.add("fundorg");
        groupByList.add("orgid");
        groupByList.add("orgname");
        if (addColumns != null) {
            for (Map.Entry<String, List<String>> map : addColumns.entrySet()) {
                List<String> values = map.getValue();
                for (String value : values) {
                    groupByList.add(value);
                }
            }
        }
        if (!isEndDeal.booleanValue()) {
            groupByList.add("bookdate");
        }
        return groupByList.toArray(new String[0]);
    }

    @Override
    protected void addNewRowsDataSet(List<DataSet> listDateSet, NewRowsParam newRowsParam) {
        DataSet balanceData = newRowsParam.getBalanceData();
        Map<Long, String> orgNames = newRowsParam.getOrgNames();
        Date date = newRowsParam.getDate();
        Long orgId = newRowsParam.getOrgId();
        ArrayList<Field> field = new ArrayList<Field>(8);
        field.add(new Field("bookdate", (DataType)DataType.DateType));
        field.add(new Field("creditamount", (DataType)DataType.BigDecimalType));
        field.add(new Field("debitamount", (DataType)DataType.BigDecimalType));
        field.add(new Field("orgid", (DataType)DataType.LongType));
        field.add(new Field("orgname", (DataType)DataType.StringType));
        Object[] rowData = new Object[]{date, BigDecimal.ZERO, BigDecimal.ZERO, orgId, orgNames.get(orgId)};
        RowMeta rowMeta = new RowMeta(field.toArray(new Field[0]));
        Algo algo = Algo.create((String)"mon_getDataSet");
        DataSetBuilder dsBuilder = algo.createDataSetBuilder(rowMeta);
        dsBuilder.append(rowData);
        DataSet newDataSet = dsBuilder.build();
        DataSet addFields = balanceData.copy().join(newDataSet, JoinType.LEFT).on("orgid", "orgid").select(new String[]{"fundorg", "orgid", "orgname", "bookdate", "creditamount", "debitamount", "balance"}).finish();
        listDateSet.add(addFields);
    }

    @Override
    protected DataSet calculateBalance(DataSet transDataSet, List<String> countColumn, List<String> balanceColumn) {
        if (!this.isContext("balance").booleanValue()) {
            return transDataSet;
        }
        Iterator iterator = transDataSet.copy().iterator();
        DataSet avgBalanceDataSet = null;
        int balanceColumnSize = balanceColumn.size();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            Long orgId = row.getLong("orgid");
            BigDecimal count = BigDecimal.ZERO;
            for (String balance : balanceColumn) {
                if (row.getBigDecimal(balance) == null) {
                    count = count.add(BigDecimal.ZERO);
                    continue;
                }
                count = count.add(row.getBigDecimal(balance));
            }
            BigDecimal avgBalance = count.divide(new BigDecimal(balanceColumnSize), 4, RoundingMode.HALF_UP);
            DataSet filterDataSet = transDataSet.copy().filter("orgid = " + orgId).addField(avgBalance.toString(), "avgbalance");
            if (avgBalanceDataSet == null) {
                avgBalanceDataSet = filterDataSet.copy();
                continue;
            }
            avgBalanceDataSet = avgBalanceDataSet.union(filterDataSet.copy());
        }
        if (avgBalanceDataSet == null) {
            return transDataSet;
        }
        String[] selector = (String[])Arrays.stream(avgBalanceDataSet.copy().getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        DataSet finishDataSet = transDataSet.copy().join(avgBalanceDataSet).on("orgid", "orgid").select(selector).finish();
        countColumn.add("avgbalance");
        return finishDataSet;
    }

    @Override
    protected DataSet computeBankBalance(DataSet resultBankJournalData, List<DataSet> listDateSet, DataSet sameDataSet, ComputeBalanceParam param) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        DynamicObject period = param.getPeriod();
        Long orgId = param.getOrgId();
        Long currencyId = param.getCurrencyId();
        Date date = param.getDate();
        Boolean isCash = param.getCash();
        String source = param.getSource();
        Set<String> compareOrgDate = param.getCompareOrgDate();
        Map<Long, String> orgName = param.getOrgName();
        String[] resultBankSelector = (String[])Arrays.stream(resultBankJournalData.copy().getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        DynamicObjectCollection openOrgDoc = (DynamicObjectCollection)this.paramMap.get("filter_bankorg");
        List<Long> getOpenOrgIds = FundDailyHelper.getIdList(openOrgDoc);
        Boolean isInterface = "2".equals(source);
        List<Long> accountIds = null;
        List<Long> bankList = null;
        ArrayList<Long> orgIds = new ArrayList<Long>(16);
        orgIds.add(orgId);
        if (!isInterface.booleanValue()) {
            accountIds = CountBalanceHelper.getUsableAccountPks(orgIds, getOpenOrgIds);
        } else {
            Map<String, List<Long>> accountMap = CountBalanceHelper.getInterNormalAccountPks(orgIds, getOpenOrgIds);
            accountIds = accountMap.get("normal");
            bankList = accountMap.get("interface");
        }
        QueryParam queryParam = new QueryParam().setPeriod(period).setOrgId(orgId).setCurrencyId(currencyId).setDate(date).setAccountIds(accountIds).setRadixStr(this.radixStr).setOpenOrgIds(getOpenOrgIds);
        DataSet balanceData = CountBalanceHelper.getBalanceAmount(queryParam);
        if (isInterface.booleanValue()) {
            QueryParam sParam = new QueryParam().setAccountIds(bankList).setOpenOrgIds(getOpenOrgIds).setCurrencyId(currencyId).setDate(date).setRadixStr(this.radixStr);
            DataSet bankDataSet = CountBalanceHelper.countBalanceData(sParam);
            balanceData = balanceData.copy().union(bankDataSet);
            balanceData = balanceData.copy().groupBy(new String[]{"fundorg", "orgid"}).sum("factamt").sum("balance").finish();
        }
        if (isCash.booleanValue()) {
            QueryParam qParam = new QueryParam().setPeriod(period).setOrgIds(orgIds).setCurrencyId(currencyId).setDate(date).setRadixStr(this.radixStr);
            DataSet cashData = CountBalanceHelper.journalCashBalanceAmount(qParam);
            balanceData = balanceData.copy().union(cashData);
            balanceData = balanceData.copy().groupBy(new String[]{"fundorg", "orgid"}).sum("balance").finish();
        }
        String strDay = format.format(date);
        String key = orgId + "_" + strDay;
        Boolean isOldData = false;
        if (balanceData != null && compareOrgDate.contains(key)) {
            Date bDate = DateUtils.getDataFormat((Date)date, (boolean)true);
            Date eDate = DateUtils.getDataFormat((Date)date, (boolean)false);
            DataSet filterDataSet = resultBankJournalData.copy().filter("orgid = " + orgId + " and bookdate >= to_date('" + sdf.format(bDate) + "','yyyy-MM-dd HH:mm:ss.SSS')  and bookdate < to_date('" + sdf.format(eDate) + "','yyyy-MM-dd HH:mm:ss.SSS') ");
            if ((filterDataSet = filterDataSet.copy().join(balanceData.copy(), JoinType.LEFT).on("orgid", "orgid").select(resultBankSelector, new String[]{"balance"}).finish()).copy().hasNext()) {
                sameDataSet = sameDataSet == null ? filterDataSet : sameDataSet.union(filterDataSet.copy());
                isOldData = true;
            }
        }
        if (!isOldData.booleanValue()) {
            NewRowsParam newRowsParam = new NewRowsParam().setBalanceData(balanceData).setOrgNames(orgName).setDate(date).setOrgId(orgId);
            this.addNewRowsDataSet(listDateSet, newRowsParam);
        }
        return sameDataSet;
    }

    @Override
    protected DataSet computeCashBalance(DataSet resultBankJournalData, List<DataSet> listDateSet, DataSet sameDataSet, ComputeBalanceParam param) {
        return sameDataSet;
    }

    @Override
    protected DataSet joinExistData(DataSet sameDataSet, DataSet resultBankJournalData) {
        if (sameDataSet == null) {
            return resultBankJournalData;
        }
        String[] resultSelectors = (String[])Arrays.stream(resultBankJournalData.copy().getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        return resultBankJournalData.copy().join(sameDataSet, JoinType.LEFT).on("orgid", "orgid").on("bookdate", "bookdate").select(resultSelectors, new String[]{"balance"}).finish();
    }

    @Override
    protected void addCompareMap(Row row, Set<String> compareOrgDate) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        Long orgId = row.getLong("orgid");
        Date date = row.getDate("bookdate");
        String bookDateStr = format.format(date);
        String compareKey = orgId + "_" + bookDateStr;
        compareOrgDate.add(compareKey);
    }

    @Override
    protected String groupToConvert() {
        return "fundorg,orgid,orgname";
    }

    @Override
    protected String filterToNewColumn(Row row) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        Long fundOrg = row.getLong("fundorg");
        Date bookDate = row.getDate("bookdate");
        Date bDate = DateUtils.getDataFormat((Date)bookDate, (boolean)true);
        Date eDate = DateUtils.getDataFormat((Date)bookDate, (boolean)false);
        return "fundorg = " + fundOrg + " and bookdate  >= to_date('" + sdf.format(bDate) + "','yyyy-MM-dd HH:mm:ss.SSS') and bookdate < to_date('" + sdf.format(eDate) + "','yyyy-MM-dd HH:mm:ss.SSS')";
    }
}

