/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.form.funddaily;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.events.TreeReportListEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mon.report.helper.FundDailyHelper;

public class FundDailyReportFormPlugin
extends AbstractReportFormPlugin {
    public void setTreeReportList(TreeReportListEvent event) {
        super.setTreeReportList(event);
        event.setTreeReportList(true);
        event.setTreeExpandColId("orgname");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initCompanyF7();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.defaultFields();
    }

    public boolean verifyQuery(ReportQueryParam param) {
        Map<String, Object> params = FundDailyHelper.getParamMap(param);
        DynamicObject companyView = (DynamicObject)params.get("filter_compview");
        String searchType = (String)params.get("filter_searchtype");
        DynamicObject currencies = (DynamicObject)params.get("filter_currencies");
        DynamicObjectCollection org = (DynamicObjectCollection)params.get("filter_company");
        if ("queryorg".equals(searchType) && EmptyUtil.isEmpty((DynamicObjectCollection)org)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FundDailyReportFormPlugin_07", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        if (EmptyUtil.isEmpty((DynamicObject)currencies)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FundDailyReportFormPlugin_08", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        if ("queryorgview".equals(searchType) && EmptyUtil.isEmpty((DynamicObject)companyView)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d44\u91d1\u7ba1\u7406\u7ec4\u7ec7\u89c6\u56fe\u4e0d\u80fd\u4e3a\u7a7a", (String)"FundDailyReportFormPlugin_01", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        Date beginDate = (Date)params.get("filter_begindate");
        if (EmptyUtil.isEmpty((Object)beginDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FundDailyReportFormPlugin_02", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        Date endDate = (Date)params.get("filter_enddate");
        if (EmptyUtil.isEmpty((Object)endDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FundDailyReportFormPlugin_03", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        if (beginDate.after(endDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65e5\u671f", (String)"FundDailyReportFormPlugin_04", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        String searchContext = (String)params.get("filter_searchcontext");
        if (EmptyUtil.isEmpty((String)searchContext)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FundDailyReportFormPlugin_05", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        Integer columns = (Integer)params.get("columns");
        Integer days = DateUtils.getDiffDays((Date)beginDate, (Date)endDate);
        String splitContext = searchContext.substring(1, searchContext.length() - 1);
        String[] contexts = splitContext.split(",");
        Integer computeColumns = days * contexts.length;
        if (computeColumns.compareTo(columns) > 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c\u5c06\u8d85\u8fc7%1$s\u5217\uff0c\u6570\u636e\u91cf\u8fc7\u5927\uff0c\u8bf7\u51cf\u5c11\u67e5\u8be2\u5185\u5bb9\u6216\u7f29\u77ed\u65e5\u671f\u95f4\u9694", (String)"FundDailyReportFormPlugin_06", (String)"tmc-mon-report", (Object[])new Object[0]), columns));
            return false;
        }
        return true;
    }

    private void initCompanyF7() {
        BasedataEdit companyF7 = (BasedataEdit)this.getControl("filter_company");
        companyF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List authOrgList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"queryCashInit", (String)"cas_cashmgtinit", (String)"org as id", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)authOrgList)}, null);
            QFilter qFilterOfBank = new QFilter("id", "in", FundDailyHelper.getIdList(coll));
            showParameter.getListFilterParameter().setFilter(qFilterOfBank);
        });
    }

    private void defaultFields() {
        Long org = RequestContext.get().getOrgId();
        String appId = this.getView().getFormShowParameter().getAppId();
        List authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        this.getModel().setValue("filter_company", null);
        if (authOrgIds != null && !authOrgIds.isEmpty()) {
            DynamicObjectCollection coll;
            DynamicObjectCollection dynamicObjects1;
            DynamicObject dynamicObjects;
            if (authOrgIds.contains(org)) {
                dynamicObjects = BusinessDataServiceHelper.loadSingle((Object)org, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_org"));
                dynamicObjects1 = new DynamicObjectCollection();
                dynamicObjects1.add((Object)dynamicObjects);
                this.getModel().setValue("filter_company", (Object)dynamicObjects1);
            } else {
                dynamicObjects = BusinessDataServiceHelper.loadSingle(authOrgIds.get(0), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_org"));
                if (EmptyUtil.isNoEmpty((DynamicObject)dynamicObjects)) {
                    dynamicObjects1 = new DynamicObjectCollection();
                    dynamicObjects1.add((Object)dynamicObjects);
                    this.getModel().setValue("filter_company", (Object)dynamicObjects1);
                }
            }
            if (dynamicObjects != null && (coll = QueryServiceHelper.query((String)"queryCashInit", (String)"cas_cashmgtinit", (String)"exratetable,standardcurrency", (QFilter[])new QFilter[]{new QFilter("org", "=", dynamicObjects.getPkValue())}, null)) != null && !coll.isEmpty()) {
                this.getModel().setValue("filter_currencies", (Object)((DynamicObject)coll.get(0)).getLong("standardcurrency"));
            }
        }
    }
}

