/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.algo.datatype.DateType;
import kd.bos.algo.datatype.IntegerType;
import kd.bos.algo.datatype.LongType;
import kd.bos.algo.datatype.TimestampType;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.report.data.AbstractTmcListDataPlugin;

public class AccountMoneyDataHelper {
    private static final Log logger = LogFactory.getLog(AccountMoneyDataHelper.class);
    private static final List<String> TREELIST = Arrays.asList("rowid", "pid", "isgroupnode", "level", "sumlevel");
    private static final String LONGNUMBER = "longnumber";

    public static DataSet getBizDsWithOrgTree(DataSet bizDsBase, String lField, String rField, List<String> sumList, Map<String, String> vTreeBaseMap, Map<String, String> vbizBaseMap, List<Long> orgIdList) {
        return AccountMoneyDataHelper.getBizDsWithOrgTree(bizDsBase, lField, rField, sumList, vTreeBaseMap, vbizBaseMap, null, orgIdList);
    }

    public static DataSet getBizDsUpOrgTree(DataSet bizDsBase) {
        if (bizDsBase == null) {
            return bizDsBase;
        }
        return AccountMoneyDataHelper.updataRowId(bizDsBase.addFields(new String[]{String.valueOf(DBServiceHelper.genGlobalLongId()), "0", "'0'", "0"}, new String[]{"rowid", "pid", "isgroupnode", "level"}));
    }

    public static DataSet getBizDsWithOrgTree(DataSet bizDsBase, String lField, String rField, List<String> sumList, Map<String, String> vTreeBaseMap, Map<String, String> vbizBaseMap, Long companyViewId, List<Long> orgIdList) {
        DataSet orgDateSet;
        if (bizDsBase == null || lField == null || rField == null) {
            return bizDsBase;
        }
        if (vTreeBaseMap == null) {
            vTreeBaseMap = new HashMap<String, String>(0);
        }
        if (vbizBaseMap == null) {
            vbizBaseMap = new HashMap<String, String>(0);
        }
        if ((orgDateSet = AccountMoneyDataHelper.getOrgDateSet(companyViewId, orgIdList)) == null || bizDsBase.copy().isEmpty()) {
            return AccountMoneyDataHelper.getBizDsUpOrgTree(bizDsBase.addNullField(LONGNUMBER));
        }
        boolean islField = Arrays.stream(orgDateSet.getRowMeta().getFields()).anyMatch(o -> o.getName().equals(lField));
        boolean isrField = Arrays.stream(bizDsBase.getRowMeta().getFields()).anyMatch(o -> o.getName().equals(rField));
        if (!islField || !isrField) {
            return AccountMoneyDataHelper.updataRowId(bizDsBase.addFields(new String[]{String.valueOf(DBServiceHelper.genGlobalLongId()), "0", "'0'", "0", "0"}, new String[]{"rowid", "pid", "isgroupnode", "level", "sumlevel"}));
        }
        ArrayList<String> fieldList = new ArrayList<String>(TREELIST);
        fieldList.addAll(vTreeBaseMap.keySet());
        fieldList.addAll(vbizBaseMap.keySet());
        fieldList.addAll(sumList);
        fieldList.add(LONGNUMBER);
        String[] selectField = fieldList.toArray(new String[0]);
        String[] sumVel = (String[])sumList.stream().map(o -> "0").toArray(String[]::new);
        DataSet bizDsOrgs0 = orgDateSet.copy().join(bizDsBase.copy()).on(lField, rField).select(selectField).finish();
        ArrayList<String> bankAcctvgb = new ArrayList<String>(TREELIST);
        bankAcctvgb.addAll(vTreeBaseMap.keySet());
        bankAcctvgb.add(LONGNUMBER);
        DataSet bizDsOrgs1 = bizDsOrgs0.copy().where("isgroupnode='1'").groupBy(bankAcctvgb.toArray(new String[0])).finish();
        bizDsOrgs1 = AccountMoneyDataHelper.addMapFields(bizDsOrgs1, vbizBaseMap).addFields(sumVel, sumList.toArray(new String[0])).updateField("pid", "rowid").updateField("level", "level+1").select(selectField);
        bizDsOrgs1 = AccountMoneyDataHelper.updataRowId(bizDsOrgs1);
        Map<String, String> tPidMap = AccountMoneyDataHelper.getDsMap(bizDsOrgs1, "pid", "rowid");
        DataSet bizDsOrgs2 = bizDsOrgs0.copy().updateField("pid", "rowid").updateField("level", "level+" + (tPidMap.size() > 0 ? "2" : "1"));
        bizDsOrgs2 = AccountMoneyDataHelper.updataRowId(bizDsOrgs2);
        bizDsOrgs2 = AccountMoneyDataHelper.updataPId(bizDsOrgs2, tPidMap);
        if (bizDsOrgs2 == null) {
            return bizDsOrgs2;
        }
        DataSet orgDateSet1 = AccountMoneyDataHelper.addMapFields(orgDateSet, vbizBaseMap);
        orgDateSet1 = AccountMoneyDataHelper.addMapFields(orgDateSet1, vTreeBaseMap);
        orgDateSet1 = orgDateSet1.addFields(sumVel, sumList.toArray(new String[0])).select(selectField);
        DataSet allDateSet = bizDsOrgs2.union(new DataSet[]{bizDsOrgs1, orgDateSet1});
        return allDateSet;
    }

    public static Map<String, String> getBizBaseMap(DataSet bizDsBase, List<String> sumList, Map<String, String> vTreeBaseMap) {
        if (bizDsBase == null) {
            return new HashMap<String, String>(0);
        }
        Map<String, DataType> bizDsBaseAllFieldMap = Arrays.stream(bizDsBase.getRowMeta().getFields()).collect(Collectors.toMap(Field::getName, Field::getDataType));
        ArrayList<String> bizDsBaseAllFieldList = new ArrayList<String>(bizDsBaseAllFieldMap.keySet());
        if (vTreeBaseMap != null) {
            bizDsBaseAllFieldList.removeAll(vTreeBaseMap.keySet());
        }
        bizDsBaseAllFieldList.removeAll(sumList);
        bizDsBaseAllFieldList.removeAll(TREELIST);
        bizDsBaseAllFieldList.remove(LONGNUMBER);
        return bizDsBaseAllFieldList.stream().collect(Collectors.toMap(o -> o, o -> {
            DataType tDataType = (DataType)bizDsBaseAllFieldMap.get(o);
            if (tDataType instanceof BigDecimalType) {
                return "0.00";
            }
            if (tDataType instanceof IntegerType || tDataType instanceof LongType) {
                return "0";
            }
            if (tDataType instanceof TimestampType || tDataType instanceof DateType) {
                return "null";
            }
            return "''";
        }));
    }

    public static List<String> getFieldList(DataSet bizDsBase) {
        if (bizDsBase == null) {
            return new ArrayList<String>(0);
        }
        return Arrays.stream(bizDsBase.getRowMeta().getFields()).map(Field::getName).collect(Collectors.toList());
    }

    private static DataSet addMapFields(DataSet bizDataSet, Map<String, String> vTreeGbMap) {
        DataSet bizDS = bizDataSet.copy();
        if (vTreeGbMap.size() > 0) {
            ArrayList<String> vTreeGbKeyList = new ArrayList<String>(0);
            ArrayList<String> vTreeGbValueList = new ArrayList<String>(0);
            for (Map.Entry<String, String> vTreeGbEntry : vTreeGbMap.entrySet()) {
                vTreeGbKeyList.add(vTreeGbEntry.getKey());
                vTreeGbValueList.add(vTreeGbEntry.getValue());
            }
            bizDS = bizDS.addFields(vTreeGbValueList.toArray(new String[0]), vTreeGbKeyList.toArray(new String[0]));
        }
        return bizDS;
    }

    public static DataSet getSumDataSet(DataSet allDateSet, List<String> sumList, boolean isRemoveNoData, AbstractTmcListDataPlugin tAbstractTmcListDataPlugin) {
        if (allDateSet == null || allDateSet.copy().isEmpty()) {
            return allDateSet;
        }
        List<String> selectList = AccountMoneyDataHelper.getFieldList(allDateSet);
        selectList.removeAll(TREELIST);
        selectList.removeAll(sumList);
        DataSet bizDs = tAbstractTmcListDataPlugin.getSumDataSetByLevel(allDateSet.copy(), sumList, String.join((CharSequence)",", selectList.toArray(new String[0])));
        if (isRemoveNoData) {
            DataSet treeData = bizDs.copy();
            String[] fieldNames = treeData.getRowMeta().getFieldNames();
            treeData = treeData.copy().select(fieldNames);
            DataSet pidGroupDs = treeData.copy().groupBy(new String[]{"pid"}).finish().select("pid parentid");
            treeData = treeData.leftJoin(pidGroupDs).on("rowid", "parentid").select(fieldNames, new String[]{"parentid"}).finish();
            bizDs = treeData.updateField("isgroupnode", "case when parentid=null then '0' else '1' end ");
        }
        return bizDs;
    }

    private static DataSet updataPId(DataSet bizDsSet, Map<String, String> tPidMap) {
        List<String> rowFieldList = AccountMoneyDataHelper.getFieldList(bizDsSet);
        String pid = "pid";
        if (bizDsSet == null || bizDsSet.isEmpty() || !rowFieldList.contains("pid") || tPidMap == null || tPidMap.size() < 1) {
            return bizDsSet;
        }
        DataSet bizDs = bizDsSet.copy();
        DataSetBuilder bizDsBulider = Algo.create((String)AccountMoneyDataHelper.class.getSimpleName()).createDataSetBuilder(bizDs.getRowMeta());
        for (Row row : bizDs) {
            ArrayList updataRow = new ArrayList(rowFieldList.size());
            rowFieldList.forEach(rowField -> {
                if (rowField.equals("pid") && tPidMap.containsKey(row.getString(rowField))) {
                    updataRow.add(tPidMap.get(row.getString(rowField)));
                } else {
                    updataRow.add(row.get(rowField));
                }
            });
            bizDsBulider.append(updataRow.toArray());
        }
        bizDs.close();
        return bizDsBulider.build();
    }

    private static Map<String, String> getDsMap(DataSet bizDsSet, String keyField, String valueField) {
        HashMap<String, String> tDsMap = new HashMap<String, String>(0);
        List<String> rowFieldList = AccountMoneyDataHelper.getFieldList(bizDsSet);
        if (bizDsSet != null && !bizDsSet.isEmpty() && rowFieldList.contains(keyField) && rowFieldList.contains(valueField)) {
            DataSet bizDs = bizDsSet.copy();
            for (Row row : bizDs) {
                tDsMap.put(row.getString(keyField), row.getString(valueField));
            }
            bizDs.close();
        }
        return tDsMap;
    }

    private static DataSet updataRowId(DataSet bizDsSet) {
        List<String> rowFieldList = AccountMoneyDataHelper.getFieldList(bizDsSet);
        String rowid = "rowid";
        if (bizDsSet == null || bizDsSet.copy().isEmpty() || !rowFieldList.contains("rowid")) {
            return bizDsSet;
        }
        DataSet bizDs = bizDsSet.copy();
        DataSetBuilder bizDsBulider = Algo.create((String)AccountMoneyDataHelper.class.getSimpleName()).createDataSetBuilder(bizDs.getRowMeta());
        for (Row row : bizDs) {
            ArrayList updataRow = new ArrayList(rowFieldList.size());
            rowFieldList.forEach(rowField -> {
                if (rowField.equals("rowid")) {
                    updataRow.add(String.valueOf(DBServiceHelper.genGlobalLongId()));
                } else {
                    updataRow.add(row.get(rowField));
                }
            });
            bizDsBulider.append(updataRow.toArray());
        }
        return bizDsBulider.build();
    }

    public static void printDataSet(DataSet pDataSet) {
        DataSet pDS = pDataSet.copy();
        logger.info(pDS.getRowMeta().toString());
        for (Row row : pDS) {
            logger.info(row.toString());
        }
    }

    public static Map<String, Object> transQueryParam(ReportQueryParam param) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(param.getFilter().getFilterItems().size());
        for (FilterItemInfo filterItem : param.getFilter().getFilterItems()) {
            paramMap.put(filterItem.getPropName(), filterItem.getValue());
        }
        return paramMap;
    }

    private static DataSet getOrgDateSet(Long companyViewId, List<Long> orgIdList) {
        QFilter tQFilter = new QFilter("view.treetype", "=", (Object)"08");
        if (companyViewId != null) {
            tQFilter.and("view.id", "=", (Object)companyViewId);
        } else {
            tQFilter.and("view.number", "=", (Object)"08");
        }
        String selectFields = "org rowidals,org.name orgname,parent.id pid,parent.number pnumber,( case when isleaf='1' then '0' else '1' end ) isgroupnode,longnumber,level,sortcode,0 sumlevel";
        DataSet orgDataSet = QueryServiceHelper.queryDataSet((String)"tree-org", (String)"bos_org_structure", (String)selectFields, (QFilter[])tQFilter.toArray(), (String)"sortcode");
        if (orgIdList != null && orgIdList.size() > 0) {
            Map<String, String> tRowidPidMap = AccountMoneyDataHelper.getDsMap(orgDataSet, "rowidals", "pid");
            orgDataSet = orgDataSet.addField("rowidals", "rowid").where("rowid in (" + String.join((CharSequence)",", (CharSequence[])orgIdList.stream().map(Object::toString).toArray(String[]::new)) + ")");
            Map<String, String> orgidMap = AccountMoneyDataHelper.getDsMap(orgDataSet, "rowid", "pid");
            HashMap<String, String> tPidMap = new HashMap<String, String>(0);
            for (Map.Entry<String, String> orgidentry : orgidMap.entrySet()) {
                String treeOrg = AccountMoneyDataHelper.getPid(tRowidPidMap, orgidMap, orgidentry.getValue());
                if (treeOrg.equals(orgidentry.getValue())) continue;
                tPidMap.put(orgidentry.getValue(), treeOrg);
            }
            if (tPidMap.size() > 0) {
                orgDataSet = AccountMoneyDataHelper.updataPId(orgDataSet, tPidMap);
            }
        }
        return orgDataSet;
    }

    private static String getPid(Map<String, String> tRowidPidMap, Map<String, String> orgidMap, String treeOrg) {
        if (orgidMap.containsKey(treeOrg)) {
            return treeOrg;
        }
        if (tRowidPidMap.containsKey(treeOrg)) {
            treeOrg = tRowidPidMap.get(treeOrg);
            return AccountMoneyDataHelper.getPid(tRowidPidMap, orgidMap, treeOrg);
        }
        return "0";
    }

    public static void rebuildColumn(String[] feilds, ReportList listTable) {
        if (feilds == null || feilds.length < 1) {
            return;
        }
        List columns = listTable.getColumns();
        ArrayList<AbstractReportColumn> rebuildColumns = new ArrayList<AbstractReportColumn>();
        block0: for (int i = 0; i < feilds.length; ++i) {
            String field = feilds[i].trim();
            for (AbstractReportColumn column : columns) {
                logger.info("rebuildColumn field:(" + field + "),rebuildColumn column :" + column.getCaption().getLocaleValue());
                if (!column.getCaption().getLocaleValue().equalsIgnoreCase(field)) continue;
                rebuildColumns.add(column);
                continue block0;
            }
        }
        if (rebuildColumns.size() > 0) {
            columns.clear();
            columns.addAll(rebuildColumns);
        }
    }
}

