/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mon.report.form.funddaily.dao.QueryParam;

public class CountBalanceHelper {
    private static final Log LOGGER = LogFactory.getLog(CountBalanceHelper.class);

    public static DataSet getBalanceAmount(QueryParam queryParam) {
        DynamicObject period = queryParam.getPeriod();
        Long orgId = queryParam.getOrgId();
        Object currencyId = queryParam.getCurrencyId();
        Date endDate = queryParam.getDate();
        List<Long> accountIds = queryParam.getAccountIds();
        String radixStr = queryParam.getRadixStr();
        List<Long> openOrgIds = queryParam.getOpenOrgIds();
        BigDecimal bankBalanceAmount = BigDecimal.ZERO;
        QFilter qFilter = new QFilter("org", "=", (Object)orgId).and(new QFilter("accountbank", "in", accountIds)).and(new QFilter("currency", "=", currencyId)).and(new QFilter("type", "=", (Object)"2"));
        if (openOrgIds != null && openOrgIds.size() > 0) {
            qFilter.and(new QFilter("accountbank.bank.id", "in", openOrgIds));
        }
        DataSet periodDataSet = QueryServiceHelper.queryDataSet((String)(CountBalanceHelper.class.getName() + ".bankjournal"), (String)"cas_journalbalance", (String)"id, monthstart as factamt,org as fundorg, org.id as orgid", (QFilter[])new QFilter[]{qFilter}, null);
        DataSet groupPeriodDataSet = periodDataSet.copy().groupBy(new String[]{"fundorg", "orgid"}).sum("factamt").finish();
        Iterator periodIterator = groupPeriodDataSet.copy().iterator();
        while (periodIterator.hasNext()) {
            BigDecimal journalSum = ((Row)periodIterator.next()).getBigDecimal("factamt");
            bankBalanceAmount = bankBalanceAmount.add(CountBalanceHelper.dealBigDecimal(journalSum));
        }
        DataSet finalJournalDataSet = null;
        DataSet resultDataSet = null;
        try {
            if (EmptyUtil.isNoEmpty((DynamicObject)period)) {
                Date date = DateUtils.getDataFormat((Date)endDate, (boolean)true);
                QFilter qFilter1 = new QFilter("org", "=", (Object)orgId).and(new QFilter("accountbank", "in", accountIds)).and(new QFilter("currency", "=", currencyId)).and(new QFilter("bookdate", ">=", (Object)period.getDate("begindate"))).and(new QFilter("bookdate", "<", (Object)DateUtils.getNextDay((Date)date, (int)1)));
                DataSet balanceRawDataSet = QueryServiceHelper.queryDataSet((String)(CountBalanceHelper.class.getName() + ".bankjournal"), (String)"cas_bankjournal", (String)"org as fundorg, org.id as orgid,debitamount-creditamount as factamt", (QFilter[])new QFilter[]{qFilter1}, null);
                finalJournalDataSet = balanceRawDataSet.copy().groupBy(new String[]{"fundorg", "orgid"}).sum("factamt").finish();
                Iterator iterator = finalJournalDataSet.copy().iterator();
                while (iterator.hasNext()) {
                    BigDecimal journalSum = ((Row)iterator.next()).getBigDecimal("factamt");
                    bankBalanceAmount = bankBalanceAmount.add(CountBalanceHelper.dealBigDecimal(journalSum));
                }
                String[] resultBankSelector = (String[])Arrays.stream(finalJournalDataSet.copy().getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
                DataSet endDtaSet = null;
                endDtaSet = groupPeriodDataSet.copy().hasNext() ? groupPeriodDataSet.copy().join(finalJournalDataSet.copy(), JoinType.LEFT).on("orgid", "orgid").select(resultBankSelector).finish() : finalJournalDataSet.copy().join(groupPeriodDataSet.copy(), JoinType.LEFT).on("orgid", "orgid").select(resultBankSelector).finish();
                resultDataSet = endDtaSet.copy().addField(bankBalanceAmount + radixStr, "balance");
            } else {
                resultDataSet = groupPeriodDataSet.copy().addField(bankBalanceAmount + radixStr, "balance");
            }
            return resultDataSet;
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return null;
        }
    }

    public static DataSet bankBalanceAmountOrgAcc(QueryParam queryParam) {
        DynamicObject period = queryParam.getPeriod();
        Long orgId = queryParam.getOrgId();
        Object currencyId = queryParam.getCurrencyId();
        Date endDate = queryParam.getDate();
        String radixStr = queryParam.getRadixStr();
        Long accountId = queryParam.getAccountId();
        List<Long> openOrgIds = queryParam.getOpenOrgIds();
        BigDecimal bankBalanceAmount = BigDecimal.ZERO;
        QFilter qFilter = new QFilter("org", "=", (Object)orgId).and(new QFilter("accountbank", "=", (Object)accountId)).and(new QFilter("currency", "=", currencyId)).and(new QFilter("type", "=", (Object)"2"));
        if (openOrgIds != null && openOrgIds.size() > 0) {
            qFilter.and(new QFilter("accountbank.bank.id", "in", openOrgIds));
        }
        DataSet periodDataSet = QueryServiceHelper.queryDataSet((String)(CountBalanceHelper.class.getName() + ".bankjournal"), (String)"cas_journalbalance", (String)"id, monthstart as factamt,org as fundorg, org.id as orgid", (QFilter[])new QFilter[]{qFilter}, null);
        DataSet groupPeriodDataSet = periodDataSet.copy().groupBy(new String[]{"fundorg", "orgid"}).sum("factamt").finish();
        Iterator periodIterator = groupPeriodDataSet.copy().iterator();
        while (periodIterator.hasNext()) {
            BigDecimal journalSum = ((Row)periodIterator.next()).getBigDecimal("factamt");
            bankBalanceAmount = bankBalanceAmount.add(CountBalanceHelper.dealBigDecimal(journalSum));
        }
        DataSet finalJournalDataSet = null;
        DataSet resultDataSet = null;
        try {
            if (EmptyUtil.isNoEmpty((DynamicObject)period)) {
                Date date = DateUtils.getDataFormat((Date)endDate, (boolean)true);
                QFilter qFilter1 = new QFilter("org", "=", (Object)orgId).and(new QFilter("accountbank", "=", (Object)accountId)).and(new QFilter("currency", "=", currencyId)).and(new QFilter("bookdate", ">=", (Object)period.getDate("begindate"))).and(new QFilter("bookdate", "<", (Object)DateUtils.getNextDay((Date)date, (int)1)));
                if (openOrgIds != null && openOrgIds.size() > 0) {
                    qFilter1.and(new QFilter("accountbank.bank.id", "in", openOrgIds));
                }
                DataSet balanceRawDataSet = QueryServiceHelper.queryDataSet((String)(CountBalanceHelper.class.getName() + ".bankjournal"), (String)"cas_bankjournal", (String)"org as fundorg, org.id as orgid,debitamount-creditamount as factamt", (QFilter[])new QFilter[]{qFilter1}, null);
                finalJournalDataSet = balanceRawDataSet.copy().groupBy(new String[]{"fundorg", "orgid"}).sum("factamt").finish();
                Iterator iterator = finalJournalDataSet.copy().iterator();
                while (iterator.hasNext()) {
                    BigDecimal journalSum = ((Row)iterator.next()).getBigDecimal("factamt");
                    bankBalanceAmount = bankBalanceAmount.add(CountBalanceHelper.dealBigDecimal(journalSum));
                }
                String[] resultBankSelector = (String[])Arrays.stream(finalJournalDataSet.copy().getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
                DataSet endDtaSet = null;
                endDtaSet = groupPeriodDataSet.copy().hasNext() ? groupPeriodDataSet.copy().join(finalJournalDataSet.copy(), JoinType.LEFT).on("orgid", "orgid").select(resultBankSelector).finish() : finalJournalDataSet.copy().join(groupPeriodDataSet.copy(), JoinType.LEFT).on("orgid", "orgid").select(resultBankSelector).finish();
                resultDataSet = endDtaSet.copy().addField(bankBalanceAmount + radixStr, "balance");
            } else {
                resultDataSet = groupPeriodDataSet.copy().addField(bankBalanceAmount + radixStr, "balance");
            }
            return resultDataSet;
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return null;
        }
    }

    public static DataSet bankBalanceAmountOpOrg(QueryParam queryParam) {
        DynamicObject period = queryParam.getPeriod();
        Long orgId = queryParam.getOrgId();
        Object currencyId = queryParam.getCurrencyId();
        Date endDate = queryParam.getDate();
        String radixStr = queryParam.getRadixStr();
        List<Long> accountIds = queryParam.getAccountIds();
        List<Long> openOrgIds = queryParam.getOpenOrgIds();
        BigDecimal bankBalanceAmount = BigDecimal.ZERO;
        QFilter qFilter = new QFilter("org", "=", (Object)orgId).and(new QFilter("accountbank", "in", accountIds)).and(new QFilter("currency", "=", currencyId)).and(new QFilter("type", "=", (Object)"2"));
        if (openOrgIds != null && openOrgIds.size() > 0) {
            qFilter.and(new QFilter("accountbank.bank.id", "in", openOrgIds));
        }
        DataSet periodDataSet = QueryServiceHelper.queryDataSet((String)(CountBalanceHelper.class.getName() + ".bankjournal"), (String)"cas_journalbalance", (String)"id, monthstart as factamt,org as fundorg, org.id as orgid, accountbank.bank.id as openorgid", (QFilter[])new QFilter[]{qFilter}, null);
        DataSet groupPeriodDataSet = periodDataSet.copy().groupBy(new String[]{"fundorg", "orgid", "openorgid"}).sum("factamt").finish();
        Iterator periodIterator = groupPeriodDataSet.copy().iterator();
        while (periodIterator.hasNext()) {
            BigDecimal journalSum = ((Row)periodIterator.next()).getBigDecimal("factamt");
            bankBalanceAmount = bankBalanceAmount.add(CountBalanceHelper.dealBigDecimal(journalSum));
        }
        DataSet finalJournalDataSet = null;
        DataSet resultDataSet = null;
        try {
            if (EmptyUtil.isNoEmpty((DynamicObject)period)) {
                Date date = DateUtils.getDataFormat((Date)endDate, (boolean)true);
                QFilter qFilter1 = new QFilter("org", "=", (Object)orgId).and(new QFilter("accountbank", "in", accountIds)).and(new QFilter("currency", "=", currencyId)).and(new QFilter("bookdate", ">=", (Object)period.getDate("begindate"))).and(new QFilter("bookdate", "<", (Object)DateUtils.getNextDay((Date)date, (int)1)));
                if (openOrgIds != null && openOrgIds.size() > 0) {
                    qFilter1.and(new QFilter("accountbank.bank.id", "in", openOrgIds));
                }
                DataSet balanceRawDataSet = QueryServiceHelper.queryDataSet((String)(CountBalanceHelper.class.getName() + ".bankjournal"), (String)"cas_bankjournal", (String)"org as fundorg, org.id as orgid, accountbank.bank.id as openorgid,debitamount-creditamount as factamt", (QFilter[])new QFilter[]{qFilter1}, null);
                finalJournalDataSet = balanceRawDataSet.copy().groupBy(new String[]{"fundorg", "orgid", "openorgid"}).sum("factamt").finish();
                Iterator iterator = finalJournalDataSet.copy().iterator();
                while (iterator.hasNext()) {
                    BigDecimal journalSum = ((Row)iterator.next()).getBigDecimal("factamt");
                    bankBalanceAmount = bankBalanceAmount.add(CountBalanceHelper.dealBigDecimal(journalSum));
                }
                String[] resultBankSelector = (String[])Arrays.stream(finalJournalDataSet.copy().getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
                DataSet endDtaSet = null;
                endDtaSet = groupPeriodDataSet.copy().hasNext() ? groupPeriodDataSet.copy().join(finalJournalDataSet.copy(), JoinType.LEFT).on("openorgid", "openorgid").select(resultBankSelector).finish() : finalJournalDataSet.copy().join(groupPeriodDataSet.copy(), JoinType.LEFT).on("openorgid", "openorgid").select(resultBankSelector).finish();
                resultDataSet = endDtaSet.copy().addField(bankBalanceAmount + radixStr, "balance");
            } else {
                resultDataSet = groupPeriodDataSet.copy().addField(bankBalanceAmount + radixStr, "balance");
            }
            return resultDataSet;
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return null;
        }
    }

    public static DataSet journalCashBalanceAmount(QueryParam queryParam) {
        DynamicObject period = queryParam.getPeriod();
        List<Long> orgIds = queryParam.getOrgIds();
        Object currencyId = queryParam.getCurrencyId();
        Date endDate = queryParam.getDate();
        String radixStr = queryParam.getRadixStr();
        List<Long> accountCashIds = CountBalanceHelper.getUsableCashAccount(orgIds);
        BigDecimal cashBalanceAmount = BigDecimal.ZERO;
        QFilter[] journalBalanceFilters = new QFilter[]{new QFilter("accountcash", "in", accountCashIds), new QFilter("currency", "=", currencyId), new QFilter("type", "=", (Object)"1")};
        DataSet resultDataSet = null;
        DataSet cashDataSet = null;
        DataSet periodDataSet = QueryServiceHelper.queryDataSet((String)(CountBalanceHelper.class.getName() + ".bankjournal"), (String)"cas_journalbalance", (String)"id, monthstart as factamt,org as fundorg, org.id as orgid", (QFilter[])journalBalanceFilters, null);
        DataSet groupPeriodDataSet = periodDataSet.copy().groupBy(new String[]{"fundorg", "orgid"}).sum("factamt").finish();
        Iterator periodIterator = groupPeriodDataSet.copy().iterator();
        while (periodIterator.hasNext()) {
            BigDecimal journalSum = ((Row)periodIterator.next()).getBigDecimal("factamt");
            cashBalanceAmount = cashBalanceAmount.add(CountBalanceHelper.dealBigDecimal(journalSum));
        }
        DataSet finalJournalDataSet = null;
        try {
            if (EmptyUtil.isNoEmpty((DynamicObject)period)) {
                QFilter[] journalFilters = new QFilter[]{new QFilter("accountcash", "in", accountCashIds), new QFilter("currency", "=", currencyId), new QFilter("bookdate", ">=", (Object)period.getDate("begindate")), new QFilter("bookdate", "<=", (Object)endDate)};
                DataSet balanceRawDataSet = QueryServiceHelper.queryDataSet((String)(CountBalanceHelper.class.getName() + ".cashjournal"), (String)"cas_cashjournal", (String)"org as fundorg, org.id as orgid,debitamount-creditamount as factamt", (QFilter[])journalFilters, null);
                finalJournalDataSet = balanceRawDataSet.groupBy(new String[]{"fundorg", "orgid"}).sum("factamt").finish();
                Iterator iterator = finalJournalDataSet.copy().iterator();
                while (iterator.hasNext()) {
                    BigDecimal journalSum = ((Row)iterator.next()).getBigDecimal("factamt");
                    cashBalanceAmount = cashBalanceAmount.add(CountBalanceHelper.dealBigDecimal(journalSum));
                }
                String[] resultBankSelector = (String[])Arrays.stream(finalJournalDataSet.copy().getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
                cashDataSet = groupPeriodDataSet.copy().hasNext() ? groupPeriodDataSet.copy().join(finalJournalDataSet.copy(), JoinType.LEFT).on("orgid", "orgid").select(resultBankSelector).finish() : finalJournalDataSet.copy().join(groupPeriodDataSet.copy(), JoinType.LEFT).on("orgid", "orgid").select(resultBankSelector).finish();
                resultDataSet = cashDataSet.copy().addField(cashBalanceAmount + radixStr, "balance");
            } else {
                resultDataSet = groupPeriodDataSet.copy().addField(cashBalanceAmount + radixStr, "balance");
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
        return resultDataSet;
    }

    public static DataSet cashBalanceAmount(QueryParam queryParam) {
        DynamicObject period = queryParam.getPeriod();
        Long cashCountId = queryParam.getCashCountId();
        Object currencyId = queryParam.getCurrencyId();
        Date endDate = queryParam.getDate();
        BigDecimal cashBalanceAmount = BigDecimal.ZERO;
        String radixStr = queryParam.getRadixStr();
        QFilter[] journalBalanceFilters = new QFilter[]{new QFilter("accountcash", "=", (Object)cashCountId), new QFilter("currency", "=", currencyId), new QFilter("type", "=", (Object)"1")};
        DataSet resultDataSet = null;
        DataSet cashDataSet = null;
        DataSet periodDataSet = QueryServiceHelper.queryDataSet((String)(CountBalanceHelper.class.getName() + ".bankjournal"), (String)"cas_journalbalance", (String)"id, monthstart as factamt,org as fundorg, org.id as orgid", (QFilter[])journalBalanceFilters, null);
        DataSet groupPeriodDataSet = periodDataSet.copy().groupBy(new String[]{"fundorg", "orgid"}).sum("factamt").finish();
        Iterator periodIterator = groupPeriodDataSet.copy().iterator();
        while (periodIterator.hasNext()) {
            BigDecimal journalSum = ((Row)periodIterator.next()).getBigDecimal("factamt");
            cashBalanceAmount = cashBalanceAmount.add(CountBalanceHelper.dealBigDecimal(journalSum));
        }
        DataSet finalJournalDataSet = null;
        try {
            if (EmptyUtil.isNoEmpty((DynamicObject)period)) {
                QFilter[] journalFilters = new QFilter[]{new QFilter("accountcash", "=", (Object)cashCountId), new QFilter("currency", "=", currencyId), new QFilter("bookdate", ">=", (Object)period.getDate("begindate")), new QFilter("bookdate", "<=", (Object)endDate)};
                DataSet balanceRawDataSet = QueryServiceHelper.queryDataSet((String)(CountBalanceHelper.class.getName() + ".cashjournal"), (String)"cas_cashjournal", (String)"org as fundorg, org.id as orgid,debitamount-creditamount as factamt", (QFilter[])journalFilters, null);
                finalJournalDataSet = balanceRawDataSet.groupBy(new String[]{"fundorg", "orgid"}).sum("factamt").finish();
                Iterator iterator = finalJournalDataSet.copy().iterator();
                while (iterator.hasNext()) {
                    BigDecimal journalSum = ((Row)iterator.next()).getBigDecimal("factamt");
                    cashBalanceAmount = cashBalanceAmount.add(CountBalanceHelper.dealBigDecimal(journalSum));
                }
                String[] resultBankSelector = (String[])Arrays.stream(finalJournalDataSet.copy().getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
                cashDataSet = groupPeriodDataSet.copy().hasNext() ? groupPeriodDataSet.copy().join(finalJournalDataSet.copy(), JoinType.LEFT).on("orgid", "orgid").select(resultBankSelector).finish() : finalJournalDataSet.copy().join(groupPeriodDataSet.copy(), JoinType.LEFT).on("orgid", "orgid").select(resultBankSelector).finish();
                resultDataSet = cashDataSet.copy().addField(cashBalanceAmount + radixStr, "balance");
            } else {
                resultDataSet = groupPeriodDataSet.copy().addField(cashBalanceAmount + radixStr, "balance");
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
        return resultDataSet;
    }

    public static DataSet cashBalanceAmountOpenOrg(QueryParam queryParam) {
        DynamicObject period = queryParam.getPeriod();
        List<Long> orgIds = queryParam.getOrgIds();
        Object currencyId = queryParam.getCurrencyId();
        Date endDate = queryParam.getDate();
        List<Long> accountCashIds = CountBalanceHelper.getUsableCashAccount(orgIds);
        BigDecimal cashBalanceAmount = BigDecimal.ZERO;
        String radixStr = queryParam.getRadixStr();
        QFilter[] journalBalanceFilters = new QFilter[]{new QFilter("accountcash", "in", accountCashIds), new QFilter("currency", "=", currencyId), new QFilter("type", "=", (Object)"1")};
        DataSet resultDataSet = null;
        DataSet cashDataSet = null;
        DataSet periodDataSet = QueryServiceHelper.queryDataSet((String)(CountBalanceHelper.class.getName() + ".bankjournal"), (String)"cas_journalbalance", (String)"id, monthstart as factamt,org as fundorg, org.id as orgid", (QFilter[])journalBalanceFilters, null);
        DataSet groupPeriodDataSet = periodDataSet.copy().groupBy(new String[]{"fundorg", "orgid"}).sum("factamt").finish();
        Iterator periodIterator = groupPeriodDataSet.copy().iterator();
        while (periodIterator.hasNext()) {
            BigDecimal journalSum = ((Row)periodIterator.next()).getBigDecimal("factamt");
            cashBalanceAmount = cashBalanceAmount.add(CountBalanceHelper.dealBigDecimal(journalSum));
        }
        DataSet finalJournalDataSet = null;
        try {
            if (EmptyUtil.isNoEmpty((DynamicObject)period)) {
                QFilter[] journalFilters = new QFilter[]{new QFilter("accountcash", "in", accountCashIds), new QFilter("currency", "=", currencyId), new QFilter("bookdate", ">=", (Object)period.getDate("begindate")), new QFilter("bookdate", "<=", (Object)endDate)};
                DataSet balanceRawDataSet = QueryServiceHelper.queryDataSet((String)(CountBalanceHelper.class.getName() + ".cashjournal"), (String)"cas_cashjournal", (String)"org as fundorg, org.id as orgid,debitamount-creditamount as factamt", (QFilter[])journalFilters, null);
                finalJournalDataSet = balanceRawDataSet.groupBy(new String[]{"fundorg", "orgid"}).sum("factamt").finish();
                Iterator iterator = finalJournalDataSet.copy().iterator();
                while (iterator.hasNext()) {
                    BigDecimal journalSum = ((Row)iterator.next()).getBigDecimal("factamt");
                    cashBalanceAmount = cashBalanceAmount.add(CountBalanceHelper.dealBigDecimal(journalSum));
                }
                String[] resultBankSelector = (String[])Arrays.stream(finalJournalDataSet.copy().getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
                cashDataSet = groupPeriodDataSet.copy().hasNext() ? groupPeriodDataSet.copy().join(finalJournalDataSet.copy(), JoinType.LEFT).on("orgid", "orgid").select(resultBankSelector).finish() : finalJournalDataSet.copy().join(groupPeriodDataSet.copy(), JoinType.LEFT).on("orgid", "orgid").select(resultBankSelector).finish();
                resultDataSet = cashDataSet.copy().addField(cashBalanceAmount + radixStr, "balance");
            } else {
                resultDataSet = groupPeriodDataSet.copy().addField(cashBalanceAmount + radixStr, "balance");
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
        return resultDataSet;
    }

    public static DataSet countBalanceData(QueryParam queryParam) {
        List<Long> accountBankIds = queryParam.getAccountIds();
        List<Long> openOrgIds = queryParam.getOpenOrgIds();
        Object currencyId = queryParam.getCurrencyId();
        Date date = queryParam.getDate();
        BigDecimal balanceAmount = BigDecimal.ZERO;
        String radixStr = queryParam.getRadixStr();
        QFilter qFilter = new QFilter("accountbank", "in", accountBankIds).and(new QFilter("bizdate", ">=", (Object)DateUtils.getDataFormat((Date)date, (boolean)true))).and(new QFilter("bizdate", "<=", (Object)DateUtils.getDataFormat((Date)date, (boolean)false))).and(new QFilter("currency", "=", currencyId));
        if (openOrgIds != null && openOrgIds.size() > 0) {
            qFilter.and(new QFilter("accountbank.bank.id", "in", openOrgIds));
        }
        DataSet balanceRawDataSet = QueryServiceHelper.queryDataSet((String)(CountBalanceHelper.class.getName() + ".bankbalance"), (String)"bei_bankbalance", (String)"company as fundorg, company.id as orgid,amount as factamt", (QFilter[])new QFilter[]{qFilter}, null);
        DataSet dataSet = balanceRawDataSet.groupBy(new String[]{"fundorg", "orgid"}).sum("factamt").finish();
        Iterator iterator = dataSet.copy().iterator();
        while (iterator.hasNext()) {
            BigDecimal amount = ((Row)iterator.next()).getBigDecimal("factamt");
            balanceAmount = balanceAmount.add(CountBalanceHelper.dealBigDecimal(amount));
        }
        DataSet resultDataSet = dataSet.copy().addField(balanceAmount + radixStr, "balance");
        return resultDataSet;
    }

    public static DataSet countBalanceOpenOrg(QueryParam queryParam) {
        List<Long> accountBankIds = queryParam.getAccountIds();
        List<Long> openOrgIds = queryParam.getOpenOrgIds();
        Object currencyId = queryParam.getCurrencyId();
        Date date = queryParam.getDate();
        String radixStr = queryParam.getRadixStr();
        BigDecimal balanceAmount = BigDecimal.ZERO;
        QFilter qFilter = new QFilter("accountbank", "in", accountBankIds).and(new QFilter("bizdate", ">=", (Object)DateUtils.getDataFormat((Date)date, (boolean)true))).and(new QFilter("bizdate", "<=", (Object)DateUtils.getDataFormat((Date)date, (boolean)false))).and(new QFilter("currency", "=", currencyId));
        if (openOrgIds != null && openOrgIds.size() > 0) {
            qFilter.and(new QFilter("accountbank.bank.id", "in", openOrgIds));
        }
        DataSet balanceRawDataSet = QueryServiceHelper.queryDataSet((String)(CountBalanceHelper.class.getName() + ".bankbalance"), (String)"bei_bankbalance", (String)"company as fundorg, company.id as orgid,accountbank.bank.id as openorgid,amount as factamt", (QFilter[])new QFilter[]{qFilter}, null);
        DataSet dataSet = balanceRawDataSet.groupBy(new String[]{"fundorg", "orgid", "openorgid"}).sum("factamt").finish();
        Iterator iterator = dataSet.copy().iterator();
        while (iterator.hasNext()) {
            BigDecimal amount = ((Row)iterator.next()).getBigDecimal("factamt");
            balanceAmount = balanceAmount.add(CountBalanceHelper.dealBigDecimal(amount));
        }
        DataSet resultDataSet = dataSet.copy().addField(balanceAmount + radixStr, "balance");
        return resultDataSet;
    }

    public static DataSet countBankBalanceData(QueryParam queryParam) {
        Long accountBankId = queryParam.getAccountId();
        List<Long> openOrgIds = queryParam.getOpenOrgIds();
        Object currencyId = queryParam.getCurrencyId();
        Date date = queryParam.getDate();
        BigDecimal balanceAmount = BigDecimal.ZERO;
        String radixStr = queryParam.getRadixStr();
        QFilter qFilter = new QFilter("accountbank", "=", (Object)accountBankId).and(new QFilter("bizdate", ">=", (Object)DateUtils.getDataFormat((Date)date, (boolean)true))).and(new QFilter("bizdate", "<=", (Object)DateUtils.getDataFormat((Date)date, (boolean)false))).and(new QFilter("currency", "=", currencyId));
        if (openOrgIds != null && openOrgIds.size() > 0) {
            qFilter.and(new QFilter("accountbank.bank.id", "in", openOrgIds));
        }
        DataSet balanceRawDataSet = QueryServiceHelper.queryDataSet((String)(CountBalanceHelper.class.getName() + ".bankbalance"), (String)"bei_bankbalance", (String)"company as fundorg, company.id as orgid,amount as factamt", (QFilter[])new QFilter[]{qFilter}, null);
        DataSet dataSet = balanceRawDataSet.groupBy(new String[]{"fundorg", "orgid"}).sum("factamt").finish();
        Iterator iterator = dataSet.copy().iterator();
        while (iterator.hasNext()) {
            BigDecimal amount = ((Row)iterator.next()).getBigDecimal("factamt");
            balanceAmount = balanceAmount.add(CountBalanceHelper.dealBigDecimal(amount));
        }
        DataSet resultDataSet = dataSet.copy().addField(balanceAmount + radixStr, "balance");
        return resultDataSet;
    }

    private static BigDecimal dealBigDecimal(BigDecimal amount) {
        if (amount == null) {
            return BigDecimal.ZERO;
        }
        if (amount.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return amount;
    }

    public static DynamicObject getBeginPeriod(Long orgId, DynamicObject cPeriod, Date endDate) {
        if (cPeriod == null) {
            return null;
        }
        Date cPeriodEndDate = cPeriod.getDate("enddate");
        if (endDate.after(cPeriodEndDate)) {
            return cPeriod;
        }
        return CountBalanceHelper.getPeriodByDate(orgId, endDate);
    }

    public static DynamicObject getPeriodByDate(long orgId, Date date) {
        long periodTypeId = CountBalanceHelper.getPeriodTypeId(orgId);
        QFilter[] filters = new QFilter[]{new QFilter("begindate", "<=", (Object)date), new QFilter("enddate", ">=", (Object)date), new QFilter("periodtype", "=", (Object)periodTypeId)};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])filters);
    }

    public static long getPeriodTypeId(long orgId) {
        DynamicObject periodType = CountBalanceHelper.getPeriodType(orgId);
        return periodType == null ? 0L : periodType.getLong("id");
    }

    public static DynamicObject getPeriodType(long orgId) {
        DynamicObject systemStatusCtrol = CountBalanceHelper.getSystemStatusCtrol(orgId);
        return systemStatusCtrol == null ? null : systemStatusCtrol.getDynamicObject("periodtype");
    }

    public static DynamicObject getSystemStatusCtrol(long orgId) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId)};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"cas_cashmgtinit", (QFilter[])filters);
    }

    public static List<Long> getUsableAccountPks(Collection<Long> orgIds, List<Long> getOpenOrgIds) {
        QFilter filters = CountBalanceHelper.getUsableAccountQFilter(orgIds);
        if (getOpenOrgIds != null && getOpenOrgIds.size() > 0) {
            filters.and(new QFilter("bank.id", "in", getOpenOrgIds));
        }
        DynamicObject[] accounts = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{filters});
        ArrayList<Long> allAccountPks = new ArrayList<Long>(accounts.length);
        for (DynamicObject account : accounts) {
            allAccountPks.add((Long)account.getPkValue());
        }
        return allAccountPks;
    }

    public static Map<String, List<Long>> getUsableAccounts(Collection<Long> orgIds) {
        HashMap<String, List<Long>> result = new HashMap<String, List<Long>>(16);
        QFilter[] filters = CountBalanceHelper.getUsableAccountFilter(orgIds);
        DynamicObject[] accounts = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id, issetbankinterface", (QFilter[])filters);
        ArrayList<Long> account = new ArrayList<Long>(accounts.length);
        ArrayList<Long> bankInterface = new ArrayList<Long>(accounts.length);
        for (DynamicObject accountObject : accounts) {
            Boolean isBankInterface = accountObject.getBoolean("issetbankinterface");
            if (isBankInterface.booleanValue()) {
                bankInterface.add((Long)accountObject.getPkValue());
                continue;
            }
            account.add((Long)accountObject.getPkValue());
        }
        result.put("account", account);
        result.put("bankInterface", bankInterface);
        return result;
    }

    public static Map<String, List<Long>> getInterNormalAccountPks(Collection<Long> orgIds, List<Long> getOpenOrgIds) {
        HashMap<String, List<Long>> accountIds = new HashMap<String, List<Long>>(2);
        QFilter filters = CountBalanceHelper.getUsableAccountQFilter(orgIds);
        if (getOpenOrgIds != null && getOpenOrgIds.size() > 0) {
            filters.and(new QFilter("bank.id", "in", getOpenOrgIds));
        }
        DynamicObject[] accounts = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id, issetbankinterface", (QFilter[])new QFilter[]{filters});
        ArrayList<Long> bankInterfaceAccountPks = new ArrayList<Long>(accounts.length);
        ArrayList<Long> normalAccountPks = new ArrayList<Long>(accounts.length);
        for (DynamicObject account : accounts) {
            Boolean isSetBankInterface = account.getBoolean("issetbankinterface");
            if (isSetBankInterface.booleanValue()) {
                bankInterfaceAccountPks.add((Long)account.getPkValue());
                continue;
            }
            normalAccountPks.add((Long)account.getPkValue());
        }
        accountIds.put("interface", bankInterfaceAccountPks);
        accountIds.put("normal", normalAccountPks);
        return accountIds;
    }

    public static QFilter[] getUsableAccountFilter(Collection<Long> orgIds) {
        return new QFilter[]{CountBalanceHelper.getAccountBankFilterByOrg(orgIds), CountBalanceHelper.getUsableFilter()};
    }

    public static QFilter getUsableAccountQFilter(Collection<Long> orgIds) {
        QFilter qFilter = CountBalanceHelper.getAccountBankFilterByOrg(orgIds).and(CountBalanceHelper.getUsableFilter());
        return qFilter;
    }

    public static QFilter getAccountBankFilterByOrg(Collection<Long> orgIDs) {
        return BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountbanks", new ArrayList<Long>(orgIDs), (boolean)true);
    }

    public static QFilter getUsableFilter() {
        return new QFilter("acctstatus", "=", (Object)"normal");
    }

    public static List<Long> getUsableCashAccount(Collection<Long> orgIds) {
        QFilter companyQf = new QFilter("org", "in", orgIds);
        companyQf.and(new QFilter("closestatus", "=", (Object)"0"));
        companyQf.and(new QFilter("enable", "=", (Object)"1"));
        companyQf.and(new QFilter("status", "=", (Object)"C"));
        DynamicObject[] accts = BusinessDataServiceHelper.load((String)"cas_accountcash", (String)"id", (QFilter[])new QFilter[]{companyQf});
        ArrayList<Long> cashIds = new ArrayList<Long>(accts.length);
        for (DynamicObject acct : accts) {
            cashIds.add((Long)acct.getPkValue());
        }
        return cashIds;
    }

    public static List<DynamicObject> getCashAccount(Collection<Long> orgIds) {
        QFilter companyQf = new QFilter("org", "in", orgIds);
        companyQf.and(new QFilter("closestatus", "=", (Object)"0"));
        companyQf.and(new QFilter("enable", "=", (Object)"1"));
        companyQf.and(new QFilter("status", "=", (Object)"C"));
        DynamicObject[] accts = BusinessDataServiceHelper.load((String)"cas_accountcash", (String)"id, name", (QFilter[])new QFilter[]{companyQf});
        ArrayList<DynamicObject> cashIds = new ArrayList<DynamicObject>(accts.length);
        for (DynamicObject acct : accts) {
            cashIds.add(acct);
        }
        return cashIds;
    }
}

