/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.tmc.mon.report.data.DebtsdueDataBuilder;

public class DebtsReportHelper
extends AbstractReportFormPlugin {
    public static String getUnit(String currencyUnit) {
        String divisor = "1";
        switch (currencyUnit) {
            case "billion": {
                divisor = "100000000";
                break;
            }
            case "million": {
                divisor = "1000000";
                break;
            }
            case "tenthousand": {
                divisor = "10000";
                break;
            }
            case "thousand": {
                divisor = "1000";
                break;
            }
        }
        return divisor;
    }

    public static void setBizBillFilter(QFilter bizFilter, DebtsdueDataBuilder debtsObj, Map<String, DynamicObjectCollection> billGroupTypes, boolean isMult) {
        String debtsType;
        switch (debtsType = debtsObj.getDebteType()) {
            case "cdm": {
                bizFilter.and("draftbillstatus", "=", (Object)"registered");
                DynamicObjectCollection cdmbilltype = billGroupTypes.get("cdm");
                if (cdmbilltype != null && cdmbilltype.size() > 0) {
                    List<Long> cdmbilltypeIds = DebtsReportHelper.getIdList(cdmbilltype, isMult);
                    bizFilter.and(debtsObj.getCountbilltype(), "in", cdmbilltypeIds);
                    break;
                }
                bizFilter.and(debtsObj.getCountbilltype(), ">", (Object)0);
                break;
            }
            case "lc": {
                bizFilter.and("arrivalstatus", "=", (Object)"arrival_confirm").and("todoamount", ">", (Object)BigDecimal.ZERO);
                DynamicObjectCollection lcbillType = billGroupTypes.get("lc");
                if (lcbillType != null && lcbillType.size() > 0) {
                    List<Long> lcbillTypes = DebtsReportHelper.getIdList(lcbillType, isMult);
                    bizFilter.and(debtsObj.getCountbilltype(), "in", lcbillTypes);
                    break;
                }
                bizFilter.and(debtsObj.getCountbilltype(), ">", (Object)0);
                break;
            }
            case "cfmrepay": 
            case "cfminst": {
                bizFilter.and("loantype", "in", Arrays.asList("loan", "sl"));
                if ("cfmrepay".equals(debtsType)) {
                    bizFilter.and("repayplan_entry.enotrepayamount", ">", (Object)BigDecimal.ZERO);
                } else {
                    bizFilter.and("interest_entry.interestcalamount", ">", (Object)BigDecimal.ZERO);
                }
                DynamicObjectCollection financingvarieties = billGroupTypes.get("cfm");
                if (financingvarieties != null && financingvarieties.size() > 0) {
                    List<Long> financingIds = DebtsReportHelper.getIdList(financingvarieties, isMult);
                    bizFilter.and(debtsObj.getCountbilltype(), "in", financingIds);
                    break;
                }
                bizFilter.and(debtsObj.getCountbilltype(), ">", (Object)0);
                break;
            }
            case "bondrepay": 
            case "bondinst": {
                bizFilter.and("loantype", "=", (Object)"bond");
                if ("bondrepay".equals(debtsType)) {
                    bizFilter.and("repayplan_entry.enotrepayamount", ">", (Object)BigDecimal.ZERO);
                } else {
                    bizFilter.and("interest_entry.interestcalamount", ">", (Object)BigDecimal.ZERO);
                }
                DynamicObjectCollection bondvarieties = billGroupTypes.get("bond");
                if (bondvarieties != null && bondvarieties.size() > 0) {
                    List<Long> bondvarietIds = DebtsReportHelper.getIdList(bondvarieties, isMult);
                    bizFilter.and(debtsObj.getCountbilltype(), "in", bondvarietIds);
                    break;
                }
                bizFilter.and(debtsObj.getCountbilltype(), ">", (Object)0);
            }
        }
    }

    private static List<Long> getIdList(DynamicObjectCollection coll, boolean isMult) {
        ArrayList<Long> idList = new ArrayList<Long>(coll.size());
        if (isMult) {
            for (DynamicObject obj : coll) {
                if (null == obj) continue;
                idList.add((Long)obj.getDynamicObject("fbasedataid").getPkValue());
            }
        } else {
            for (DynamicObject obj : coll) {
                if (null == obj) continue;
                idList.add(obj.getLong("id"));
            }
        }
        return idList;
    }
}

