/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.helper.SystemStatusCtrolHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mon.common.enums.QueryTypeEnum;
import kd.tmc.mon.common.enums.ReportUnitEnum;
import kd.tmc.mon.report.helper.FinReportHelper;
import org.apache.commons.lang3.StringUtils;

public class MonReportHelper {
    public static final String COMMA_SEPARATOR = ",";
    public static final String UNDERLINE_SEPARATOR = "_";
    public static final String FBASEDATAID = "fbasedataid";

    @Deprecated
    public static boolean dealCompanyView(ReportQueryParam param, IReportView view) {
        String orgRootId;
        DynamicObject orgView = (DynamicObject)param.getFilter().getFilterItem("filter_orgview").getValue();
        String queryWay = (String)param.getFilter().getFilterItem("filter_queryway").getValue();
        long currUserId = RequestContext.get().getCurrUserId();
        String appId = view.getFormShowParameter().getAppId();
        String entityName = view.getModel().getDataEntity().getDynamicObjectType().getName();
        if (QueryTypeEnum.isOrgview((String)queryWay)) {
            String orgViewNum = orgView.getString("number");
            orgRootId = FinReportHelper.getOrgRootId(orgViewNum);
            TmcOrgDataHelper.checkFunctionPermission((String)appId, (long)currUserId, (long)Long.parseLong(orgRootId == null ? "0" : orgRootId), (String)entityName, (String)"47150e89000000ac");
            List allOrgIds = OrgUnitServiceHelper.getAllOrg((String)orgViewNum);
            if (EmptyUtil.isEmpty((Collection)allOrgIds)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7\u89c6\u56fe\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4e3a\u7a7a", (String)"GuaranteeStructFormListPlugin_0", (String)"tmc-mon-report", (Object[])new Object[0]));
                return false;
            }
            param.getFilter().addFilterItem("org", (Object)allOrgIds);
            param.getFilter().addFilterItem("filter_orgview", orgView.getPkValue());
        } else {
            List orgIds = (List)param.getFilter().getFilterItem("filter_org").getValue();
            if (orgIds != null) {
                param.getFilter().addFilterItem("org", (Object)orgIds);
            } else {
                List authorizedBankOrgId = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)currUserId, (String)appId, (String)entityName, (String)"47150e89000000ac");
                param.getFilter().addFilterItem("org", (Object)authorizedBankOrgId);
            }
            orgRootId = String.valueOf(RequestContext.get().getOrgId());
        }
        Long exchageTableId = MonReportHelper.getExchageTableId(Long.parseLong(orgRootId == null ? "0" : orgRootId));
        if (EmptyUtil.isEmpty((Long)exchageTableId)) {
            exchageTableId = MonReportHelper.getExchageTableId(Long.parseLong(Objects.requireNonNull(MonReportHelper.getOrgRootId("08"))));
        }
        if (EmptyUtil.isEmpty((Long)exchageTableId)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u6c47\u7387\u8868", (String)"MonReportHelper_01", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        param.getFilter().addFilterItem("EXCHANGETABELID", (Object)exchageTableId);
        param.getFilter().addFilterItem("orgRootId", (Object)orgRootId);
        return true;
    }

    public static QFilter getCreditortypeFilter(QFilter filter, String creditType, String loantype) {
        if ("sl".equals(loantype)) {
            filter.and(new QFilter("loantype", "=", (Object)"sl")).and(new QFilter("banksyndicate_entry.id", "!=", (Object)0));
        } else if ("bond".equals(loantype)) {
            filter.and(new QFilter("loantype", "=", (Object)"bond")).and(new QFilter("investor_entry.id", "!=", (Object)0));
        } else if ("finlease".equals(loantype)) {
            filter.and(new QFilter("loantype", "in", (Object)new String[]{"fl", "finlease"})).and(new QFilter("textcreditor", "!=", (Object)" "));
        } else {
            filter.and(new QFilter("loantype", "in", (Object)new String[]{"loan", "entrust", "ec"})).and(new QFilter("textcreditor", "!=", (Object)" "));
        }
        if (EmptyUtil.isNoEmpty((String)creditType)) {
            Set types = Arrays.stream(creditType.split(COMMA_SEPARATOR)).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
            if ("sl".equals(loantype)) {
                if (types.size() != 0 && !types.contains("bank")) {
                    return QFilter.of((String)"1 = 2", (Object[])new Object[0]);
                }
                return filter;
            }
            if ("bond".equals(loantype)) {
                filter.and(new QFilter("investor_entry.e_investortype", "in", types));
            } else {
                filter.and(new QFilter("creditortype", "in", types));
            }
        }
        return filter;
    }

    public static QFilter getCreditorFilter(Map<String, Object> paramMap, String loanType) {
        String creditor;
        QFilter typeFilter = null;
        String creditorType = (String)paramMap.get("filter_creditortype");
        if (EmptyUtil.isNoEmpty((String)creditorType)) {
            typeFilter = "bond".equals(loanType) ? new QFilter("investor_entry.e_investortype", "=", (Object)creditorType) : new QFilter("creditortype", "=", (Object)creditorType);
        }
        if (typeFilter != null && EmptyUtil.isNoEmpty((String)(creditor = (String)paramMap.get("filter_creditor")))) {
            QFilter credFilter;
            if (CreditorTypeEnum.OTHER.getValue().equals(creditorType)) {
                credFilter = MonReportHelper.getLikeCreditorNameFilter(loanType, creditor);
            } else {
                String creditorId = (String)paramMap.get("filter_creditorid");
                credFilter = MonReportHelper.getInCreditorIdFilter(loanType, creditorId);
            }
            typeFilter.and(credFilter);
        }
        return typeFilter;
    }

    private static QFilter getLikeCreditorNameFilter(String loanType, String creditor) {
        String creditorName = "%" + creditor + "%";
        QFilter credFilter = "sl".equals(loanType) ? new QFilter("banksyndicate_entry.e_bank.name", "like", (Object)creditorName) : ("bond".equals(loanType) ? new QFilter("investor_entry.e_investorname", "like", (Object)creditorName) : new QFilter("textcreditor", "like", (Object)creditorName));
        return credFilter;
    }

    private static QFilter getInCreditorIdFilter(String loanType, String creditorId) {
        String[] ids = StringUtils.split((String)creditorId, (String)";");
        List idList = Arrays.stream(ids).map(Long::valueOf).collect(Collectors.toList());
        QFilter credFilter = "sl".equals(loanType) ? new QFilter("banksyndicate_entry.e_bank.id", "in", idList) : ("bond".equals(loanType) ? new QFilter("investor_entry.e_investorid", "in", idList) : new QFilter("creditor", "in", idList));
        return credFilter;
    }

    @Deprecated
    public static Long getExchageTableId(Long orgId) {
        return TmcBusinessBaseHelper.getExchageTableId((Long)orgId);
    }

    public static String getOrgRootId(String orgViewNumber) {
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewNumber(orgViewNumber);
        TreeNode rootNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        return rootNode.getId();
    }

    public static String getUnit(String currencyUnit) {
        String divisor = "1";
        switch (currencyUnit) {
            case "Billion": {
                divisor = "100000000";
                break;
            }
            case "Mustlion": {
                divisor = "10000000";
                break;
            }
            case "Million": {
                divisor = "1000000";
                break;
            }
            case "TenThousand": {
                divisor = "10000";
                break;
            }
            case "Thousand": {
                divisor = "1000";
                break;
            }
        }
        return divisor;
    }

    public static DataSet createEmptyDs() {
        RowMeta rowMeta = new RowMeta(new String[]{"orgname"}, new DataType[]{DataType.StringType});
        return Algo.create((String)"EmptyDataSet").createDataSetBuilder(rowMeta).build();
    }

    public static BigDecimal getExchangeRate(Long sourceCurrencyId, Long targetCurrencyId, Long orgId, Date date) {
        if (sourceCurrencyId != null && sourceCurrencyId.equals(targetCurrencyId)) {
            return BigDecimal.ONE;
        }
        DynamicObject standardExRateTable = SystemStatusCtrolHelper.getStandardExRateTable((long)orgId);
        if (Objects.nonNull(standardExRateTable)) {
            return BaseDataServiceHelper.getExchangeRate((Long)((Long)standardExRateTable.getPkValue()), (Long)sourceCurrencyId, (Long)targetCurrencyId, (Date)date);
        }
        return null;
    }

    @Deprecated
    public static DataSet buildExchRateFromCashInit(DataSet finbalDS, Long orgId, Long toCurrency, Date ratedate) {
        DataSet currencyDS = finbalDS.copy().select("currency").distinct();
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field("fromcurrency", (DataType)DataType.LongType));
        fields.add(new Field("tocurrency", (DataType)DataType.LongType));
        fields.add(new Field("exchrate", (DataType)DataType.BigDecimalType));
        RowMeta rowMeta = new RowMeta(fields.toArray(new Field[0]));
        Algo algo = Algo.create((String)"");
        DataSetBuilder dsBuilder = algo.createDataSetBuilder(rowMeta);
        for (Row row : currencyDS) {
            BigDecimal rate;
            Long fromCurrency = row.getLong("currency");
            if (fromCurrency.equals(toCurrency)) {
                rate = BigDecimal.ONE;
            } else {
                rate = MonReportHelper.getExchangeRate(fromCurrency, toCurrency, orgId, ratedate);
                if (rate == null) {
                    DynamicObject fromCurrencyDO = BusinessDataServiceHelper.loadSingleFromCache((Object)fromCurrency, (String)"bd_currency", (String)"name");
                    DynamicObject toCurrencyDO = BusinessDataServiceHelper.loadSingleFromCache((Object)toCurrency, (String)"bd_currency", (String)"name");
                    DynamicObject orgDO = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org", (String)"name");
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u627e\u4e0d\u5230%2$s\u5151%3$s\u7684\u6c47\u7387", (String)"FinProdutSumDataListPlugin_01", (String)"tmc-mon-report", (Object[])new Object[0]), orgDO.getString("name"), fromCurrencyDO.getString("name"), toCurrencyDO.getString("name")));
                }
            }
            Object[] obj = new Object[]{fromCurrency, toCurrency, rate};
            dsBuilder.append(obj);
        }
        return dsBuilder.build();
    }

    public static boolean isEmpty(DataSet dataSet) {
        return null == dataSet || dataSet.isEmpty();
    }

    public static DataSet changeUnit(DataSet origDS, String unit, List<String> changeFields) {
        DataSet ds = origDS.copy();
        String divisor = ReportUnitEnum.getValueByUnitKey((String)unit);
        for (String changeField : changeFields) {
            DataSet tempData = ds.copy();
            ds = tempData.updateField(changeField, String.format("%s/%s", changeField, divisor));
            tempData.close();
        }
        return ds;
    }

    public static Date getCutOffDate(Map<String, Object> paramMap) {
        Date currentDate;
        String cutOffDateRange = (String)paramMap.get("filter_querycutoffdate");
        Date cutOffDate = currentDate = DateUtils.getCurrentDate();
        if (EmptyUtil.isEmpty((String)cutOffDateRange)) {
            return cutOffDate;
        }
        switch (cutOffDateRange) {
            case "thisday": {
                cutOffDate = currentDate;
                break;
            }
            case "lastday": {
                cutOffDate = DateUtils.getLastDay((Date)currentDate, (int)1);
                break;
            }
            case "lastweek": {
                cutOffDate = DateUtils.getLastDay((Date)DateUtils.getFirstDayOfWeek((Date)currentDate), (int)1);
                break;
            }
            case "lastmonth": {
                cutOffDate = DateUtils.getLastDateOfAnyMonth((Date)currentDate, (int)-1);
                break;
            }
            case "lastyear": {
                cutOffDate = DateUtils.getLastDay((Date)DateUtils.getFirstDayOfCurYear(), (int)1);
                break;
            }
            case "custom": {
                cutOffDate = (Date)paramMap.get("filter_cutoffdate");
                break;
            }
        }
        return cutOffDate;
    }
}

