/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class OrgServiceQueryHelper {
    public static OrgServiceQueryHelper getInstance() {
        return Singleton.instance;
    }

    public Map<String, Object> getAllOrgByViewNumber(String viewSchemaNumber) {
        QFilter viewFilter = new QFilter("view.number", "=", (Object)viewSchemaNumber);
        return this.getAllOrgByViewNumber(viewFilter, false);
    }

    private Map<String, Object> getAllOrgByViewNumber(QFilter viewFilter, boolean isIncludeDisable) {
        if (!isIncludeDisable) {
            viewFilter = viewFilter.and(new QFilter("org.enable", "=", (Object)Boolean.TRUE));
            viewFilter = viewFilter.and(new QFilter("isfreeze", "=", (Object)Boolean.FALSE));
        }
        QFilter[] filters = new QFilter[]{viewFilter};
        return this.getAllOrgByFilters(filters);
    }

    private Map<String, Object> getAllOrgByFilters(QFilter[] filters) {
        ArrayList<Long> resultList = new ArrayList<Long>(10000);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgServiceQueryImpl.getAllOrgByFilters", (String)"bos_org_structure", (String)"org, org.name as name", (QFilter[])filters, (String)"");
        Throwable var4 = null;
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        HashMap<Long, String> orgMap = new HashMap<Long, String>();
        try {
            for (Row row : dataSet) {
                resultList.add(row.getLong("org"));
                orgMap.put(row.getLong("org"), row.getString("name"));
            }
            returnMap.put("list", resultList);
            returnMap.put("map", orgMap);
        }
        catch (Throwable var14) {
            var4 = var14;
            throw var14;
        }
        finally {
            if (dataSet != null) {
                if (var4 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable var13) {
                        var4.addSuppressed(var13);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        return returnMap;
    }

    static class Singleton {
        private static final OrgServiceQueryHelper instance = new OrgServiceQueryHelper();

        Singleton() {
        }
    }
}

