/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.qing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.qing.EntryEntity;
import kd.bos.entity.qing.IQingDataProvider;
import kd.bos.entity.qing.QingData;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportTaskResult;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.qing.data.AbstractQingAnlsDataPlugin;

public class FinProductSumQingAnlsDataPlugin
extends AbstractQingAnlsDataPlugin
implements IQingDataProvider {
    private Map<String, String> finsourceNameMap = new HashMap<String, String>(16);

    private void initRefData() {
        MainEntityType entity = EntityMetadataCache.getDataEntityType((String)"cfm_financingvarieties");
        DynamicProperty prop = entity.getProperty("finsource");
        ComboProp comboProp = (ComboProp)entity.getProperty("finsource");
        List vms = comboProp.getComboItems();
        for (ValueMapItem vm : vms) {
            this.finsourceNameMap.put(vm.getValue(), vm.getName().getLocaleValue());
        }
    }

    protected Map<String, Integer> createDataIndex() {
        List<Object[]> colItems = this.getColumnItems();
        int presize = colItems.size();
        HashMap<String, Integer> index = new HashMap<String, Integer>(presize);
        for (int k = 0; k < presize; ++k) {
            Object[] column = colItems.get(k);
            index.put((String)column[0], k);
        }
        return index;
    }

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{"finsource", ResManager.loadKDString((String)"\u878d\u8d44\u6765\u6e90", (String)"FinProductSumQingAnlsDataPlugin_0", (String)"tmc-mon-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"finproductname", ResManager.loadKDString((String)"\u878d\u8d44\u54c1\u79cd", (String)"FinProductSumQingAnlsDataPlugin_1", (String)"tmc-mon-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        CachedDataSet cDS = this.getCachedDataSet();
        RowMeta rm = cDS.getRowMeta();
        List fields = Arrays.asList(rm.getFieldNames()).stream().filter(r -> r.startsWith("p_")).collect(Collectors.toList());
        for (String fname : fields) {
            if (fname.equals("p_3583")) {
                field.add(new Object[]{"p_3583", ResManager.loadKDString((String)"\u4e2d\u56fd\u5927\u9646\u4f59\u989d", (String)"FinProductSumQingAnlsDataPlugin_2", (String)"tmc-mon-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
            }
            if (fname.equals("p_3584")) {
                field.add(new Object[]{"p_3584", ResManager.loadKDString((String)"\u6e2f\u6fb3\u53f0\u4f59\u989d", (String)"FinProductSumQingAnlsDataPlugin_3", (String)"tmc-mon-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
            }
            if (!fname.equals("p_3585")) continue;
            field.add(new Object[]{"p_3585", ResManager.loadKDString((String)"\u5883\u5916\u4f59\u989d", (String)"FinProductSumQingAnlsDataPlugin_4", (String)"tmc-mon-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        }
        if (fields.size() > 1) {
            field.add(new Object[]{"rowsumamt", ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"FinProductSumQingAnlsDataPlugin_5", (String)"tmc-mon-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        }
        field.add(new Object[]{"ratio", ResManager.loadKDString((String)"\u6240\u5360\u6bd4\u4f8b(%)", (String)"FinProductSumQingAnlsDataPlugin_6", (String)"tmc-mon-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> map) {
        String rptPageId = this.getView().getFormShowParameter().getParentPageId();
        ReportTaskResult reportTaskResult = ReportCacheManager.getInstance().getCache().getReportTaskResult(rptPageId, "reportlistap");
        if (reportTaskResult != null) {
            int rowcount = reportTaskResult.getRowCount();
            DataSet dataSet = Algo.getCacheDataSet((String)reportTaskResult.getResultId()).toDataSet(Algo.create((String)"myalgo"), false);
            return dataSet;
        }
        return null;
    }

    private CachedDataSet getCachedDataSet() {
        String pPageId = this.getView().getFormShowParameter().getParentPageId();
        ReportTaskResult reportTaskResult = ReportCacheManager.getInstance().getCache().getReportTaskResult(pPageId, "reportlistap");
        CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)reportTaskResult.getResultId());
        return cacheDataSet;
    }

    public QingData getData(String qingPageId, int start, int limit) {
        QingData qingData = new QingData();
        qingData.setDataindex(this.createDataIndex());
        LinkedList<Object[]> data = new LinkedList<Object[]>();
        String pPageId = this.getView().getFormShowParameter().getParentPageId();
        ReportTaskResult reportTaskResult = ReportCacheManager.getInstance().getCache().getReportTaskResult(pPageId, "reportlistap");
        CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)reportTaskResult.getResultId());
        int rowCount = cacheDataSet.getRowCount();
        List list = null;
        list = start > rowCount ? new ArrayList(0) : cacheDataSet.getList(start - 1, limit);
        if (!EmptyUtil.isEmpty(list)) {
            this.initRefData();
            for (Row rs : list) {
                if ("2".equals(rs.getString("sumlevel"))) continue;
                List<Object[]> cols = this.getColumnItems();
                Object[] row = new Object[cols.size()];
                for (int index = 0; index < cols.size(); ++index) {
                    Object[] column = cols.get(index);
                    String field = (String)column[0];
                    Object value = rs.get(field);
                    if (value != null && QingFieldType.Date.toNumber() == ((Integer)column[2]).intValue()) {
                        Date date = (Date)rs.get(field);
                        value = date.getTime();
                    }
                    row[index] = value = this.translateCellDisplay(field, value, rs);
                }
                data.add(row);
            }
        }
        qingData.setRows(data);
        return qingData;
    }

    protected String getFieldPK() {
        return "finproductid";
    }

    protected EntryEntity createEntityMetas() {
        return null;
    }

    protected Object translateCellDisplay(String field, Object value, Row rs) {
        if ("finsource".equals(field) && EmptyUtil.isNoEmpty((Object)value)) {
            return this.finsourceNameMap.get(value);
        }
        return value;
    }
}

