/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.enums.ReportOrgQueryWayEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mon.common.enums.StatisCycleEnum;

public class FinOrgEvaService {
    private static final Long DEFAULTORGVIEWID = 8L;
    private static final Log logger = LogFactory.getLog(FinOrgEvaService.class);

    public static Map<String, Object> getTimeQFilter(Map<String, Object> paramMap) {
        HashMap<String, Object> timeMap = new HashMap<String, Object>(2);
        String filterStaperiod = (String)paramMap.get("filter_staperiod");
        Date startDate = null;
        Date endDate = null;
        Date currDate = DateUtils.getCurrentDate();
        if (StringUtils.equals((CharSequence)StatisCycleEnum.LASTYEAR.getCode(), (CharSequence)filterStaperiod)) {
            startDate = DateUtils.getFirstYearDate((Date)DateUtils.getLastYear((Date)currDate, (int)1));
            endDate = DateUtils.getFirstDayOfCurYear();
        } else if (StringUtils.equals((CharSequence)StatisCycleEnum.THISYEAR.getCode(), (CharSequence)filterStaperiod)) {
            startDate = DateUtils.getFirstDayOfCurYear();
            endDate = DateUtils.getFirstYearDate((Date)DateUtils.getNextYear((Date)currDate, (int)1));
        } else if (StringUtils.equals((CharSequence)StatisCycleEnum.LASTMONTH.getCode(), (CharSequence)filterStaperiod)) {
            startDate = DateUtils.getFirstDayOfMonth((Date)DateUtils.getLastMonth((Date)currDate, (int)1));
            endDate = DateUtils.getFirstDayOfCurMonth();
        } else if (StringUtils.equals((CharSequence)StatisCycleEnum.THISMONTH.getCode(), (CharSequence)filterStaperiod)) {
            startDate = DateUtils.getFirstDayOfCurMonth();
            endDate = DateUtils.getFirstDayOfMonth((Date)DateUtils.getNextMonth((Date)currDate, (int)1));
        } else if (StringUtils.equals((CharSequence)StatisCycleEnum.CONSTOM.getCode(), (CharSequence)filterStaperiod)) {
            startDate = (Date)paramMap.get("filter_perioddate_startdate");
            endDate = (Date)paramMap.get("filter_perioddate_enddate");
            endDate = DateUtils.getNextDay((Date)endDate, (int)1);
        } else {
            startDate = DateUtils.getFirstYearDate((Date)currDate);
            endDate = DateUtils.getLastYearDate((Date)currDate);
        }
        timeMap.put("startDate", startDate);
        timeMap.put("endDate", endDate);
        return timeMap;
    }

    public static QFilter initCurrencyQFilter(Map<String, Object> paramMap) {
        QFilter qFilter = null;
        DynamicObjectCollection filterCurrency = (DynamicObjectCollection)paramMap.get("filter_currency");
        if (filterCurrency != null) {
            qFilter = new QFilter("currency", "in", filterCurrency.stream().filter(EmptyUtil::isNoEmpty).map(e -> e.getLong("id")).collect(Collectors.toList()));
        }
        return qFilter;
    }

    public static DataSet getAcctBankDataSet(Map<String, Object> paramMap) {
        boolean statsInnerAcct = (Boolean)paramMap.get("statsinneracct");
        QFilter qFilter = new QFilter("enable", "=", (Object)true);
        if (!statsInnerAcct) {
            qFilter.and(new QFilter("inneracct", "=", (Object)0L));
        }
        String acctBankFiled = "id, bankaccountnumber,finorgtype as finorgtype, issetbankinterface,bank.id bankid, case when bank.bank_cate.name is null then bank.name else bank.bank_cate.name end as bank";
        DataSet acctBankDS = QueryServiceHelper.queryDataSet((String)"bd_accountbanks", (String)"bd_accountbanks", (String)acctBankFiled, (QFilter[])new QFilter[]{qFilter}, null);
        for (Row row : acctBankDS.copy()) {
            System.out.println(row);
        }
        return acctBankDS;
    }

    public static DataSet getAllBankDataSet() {
        String acctBankFiled = "id bankid,finorgtype.type as finorgtype, case when bank_cate.name is null then name else bank_cate.name end bank";
        DataSet allBankDS = QueryServiceHelper.queryDataSet((String)"bd_finorginfo", (String)"bd_finorginfo", (String)acctBankFiled, (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)true)}, null);
        for (Row row : allBankDS.copy()) {
            System.out.println(row);
        }
        allBankDS = allBankDS.groupBy(new String[]{"bankid", "bank", "finorgtype"}).finish();
        return allBankDS;
    }

    public static QFilter[] initBankJournalQFilter(Map<String, Object> paramMap) {
        Map<String, Object> timeMap = FinOrgEvaService.getTimeQFilter(paramMap);
        QFilter qFilterBookStartDate = new QFilter("bookdate", ">=", (Object)((Date)timeMap.get("startDate")));
        QFilter qFilterBookEndDate = new QFilter("bookdate", "<", (Object)((Date)timeMap.get("endDate")));
        QFilter qFilter = qFilterBookStartDate.and(qFilterBookEndDate);
        qFilter = qFilter.and(FinOrgEvaService.initCurrencyQFilter(paramMap));
        qFilter = qFilter.and(FinOrgEvaService.initOrgFilter(paramMap, "org"));
        return new QFilter[]{qFilter};
    }

    public static QFilter[] initTransDetailQFilter(Map<String, Object> paramMap) {
        Map<String, Object> timeMap = FinOrgEvaService.getTimeQFilter(paramMap);
        QFilter qFilterBookStartDate = new QFilter("bizdate", ">=", (Object)((Date)timeMap.get("startDate")));
        QFilter qFilterBookEndDate = new QFilter("bizdate", "<", (Object)((Date)timeMap.get("endDate")));
        QFilter qFilter = qFilterBookStartDate.and(qFilterBookEndDate);
        qFilter = qFilter.and(FinOrgEvaService.initCurrencyQFilter(paramMap));
        qFilter = qFilter.and(FinOrgEvaService.initOrgFilter(paramMap, "company"));
        return new QFilter[]{qFilter};
    }

    public static QFilter[] initCreditLimitQFilter(Map<String, Object> paramMap) {
        Map<String, Object> timeMap = FinOrgEvaService.getTimeQFilter(paramMap);
        QFilter qFilterStartDate = new QFilter("startdate", ">=", (Object)((Date)timeMap.get("startDate"))).and(new QFilter("startdate", "<", (Object)((Date)timeMap.get("endDate"))));
        QFilter qFilterEndDate = new QFilter("enddate", ">=", (Object)((Date)timeMap.get("startDate"))).and(new QFilter("enddate", "<", (Object)((Date)timeMap.get("endDate"))));
        QFilter qFilter = qFilterStartDate.or(qFilterEndDate);
        qFilter = qFilter.and(FinOrgEvaService.initCurrencyQFilter(paramMap));
        qFilter = qFilter.and(FinOrgEvaService.initOrgFilter(paramMap, "org"));
        qFilter = qFilter.and(new QFilter("banktype", "=", (Object)"bd_finorginfo"));
        return new QFilter[]{qFilter};
    }

    public static QFilter[] initLoanQFilter(Map<String, Object> paramMap) {
        Map<String, Object> timeMap = FinOrgEvaService.getTimeQFilter(paramMap);
        QFilter qFilterStartDate = new QFilter("startdate", ">=", (Object)((Date)timeMap.get("startDate"))).and(new QFilter("startdate", "<", (Object)((Date)timeMap.get("endDate"))));
        QFilter qFilterEndDate = new QFilter("enddate", ">=", (Object)((Date)timeMap.get("startDate"))).and(new QFilter("enddate", "<", (Object)((Date)timeMap.get("endDate"))));
        QFilter qFilter = qFilterStartDate.or(qFilterEndDate);
        qFilter = qFilter.and(FinOrgEvaService.initCurrencyQFilter(paramMap));
        qFilter = qFilter.and(FinOrgEvaService.initOrgFilter(paramMap, "org"));
        return new QFilter[]{qFilter};
    }

    public static QFilter[] initPayableBillQFilter(Map<String, Object> paramMap) {
        Map<String, Object> timeMap = FinOrgEvaService.getTimeQFilter(paramMap);
        QFilter qFilterStartDate = new QFilter("issuedate", ">=", (Object)((Date)timeMap.get("startDate"))).and(new QFilter("issuedate", "<", (Object)((Date)timeMap.get("endDate"))));
        QFilter qFilterEndDate = new QFilter("draftbillexpiredate", ">=", (Object)((Date)timeMap.get("startDate"))).and(new QFilter("draftbillexpiredate", "<", (Object)((Date)timeMap.get("endDate"))));
        QFilter qFilter = qFilterStartDate.or(qFilterEndDate);
        qFilter = qFilter.and(FinOrgEvaService.initCurrencyQFilter(paramMap));
        qFilter = qFilter.and(FinOrgEvaService.initOrgFilter(paramMap, "company"));
        return new QFilter[]{qFilter};
    }

    public static QFilter[] initDrafttradeBillQFilter(Map<String, Object> paramMap) {
        Map<String, Object> timeMap = FinOrgEvaService.getTimeQFilter(paramMap);
        QFilter qFilterStartDate = new QFilter("bizdate", ">=", (Object)((Date)timeMap.get("startDate")));
        QFilter qFilterEndDate = new QFilter("bizdate", "<", (Object)((Date)timeMap.get("endDate")));
        QFilter qFilter = qFilterStartDate.and(qFilterEndDate);
        qFilter = qFilter.and(FinOrgEvaService.initCurrencyQFilter(paramMap));
        qFilter = qFilter.and(FinOrgEvaService.initOrgFilter(paramMap, "company"));
        return new QFilter[]{qFilter};
    }

    public static DataSet getBankJournalDataSet(Map<String, Object> paramMap, DataSet acctBankDS) {
        DataSet bankJournalDS = FinOrgEvaService.getSettlementVolume(paramMap);
        for (Row row : bankJournalDS.copy()) {
            System.out.println(row);
        }
        DataSet joinDataSet = bankJournalDS.copy().join(acctBankDS, JoinType.INNER).on("bankaccountnumber", "bankaccountnumber").select(new String[]{"id", "bankaccountnumber", "createtime", "currency", "debitamount", "creditamount"}, new String[]{"bankid", "bank", "finorgtype"}).finish();
        DataSet exchRateDataSet = FinOrgEvaService.getExchRateDataSet(joinDataSet, paramMap, "debitamount");
        DataSet dataSet = joinDataSet.copy().join(exchRateDataSet, JoinType.LEFT).on("currency", "currency").select(joinDataSet.getRowMeta().getFieldNames(), new String[]{"exchrate"}).finish();
        dataSet = dataSet.addField("debitamount * exchrate/10000", "exchdebitamount").addField("creditamount * exchrate/10000", "exchcreditamount");
        dataSet = dataSet.addField("exchdebitamount + exchcreditamount", "amount_set").groupBy(new String[]{"bank", "finorgtype"}).sum("amount_set").finish();
        dataSet = dataSet.orderBy(new String[]{"amount_set desc"}).addField("amount_set", "sort_set");
        return dataSet;
    }

    private static DataSet getSettlementVolume(Map<String, Object> paramMap) {
        String datasource = (String)paramMap.get("datasource");
        String bankJournalFiled = "id, accountbank.bankaccountnumber bankaccountnumber, createtime, currency, debitamount, creditamount";
        String transDetailFiled = "id, accountbank.bankaccountnumber bankaccountnumber, biztime as createtime, currency, debitamount, creditamount";
        DataSet dataset = null;
        switch (datasource) {
            case "bankbalance": {
                QFilter[] transDetailQFilter = FinOrgEvaService.initTransDetailQFilter(paramMap);
                dataset = QueryServiceHelper.queryDataSet((String)"bei_transdetail", (String)"bei_transdetail", (String)transDetailFiled, (QFilter[])transDetailQFilter, null);
                break;
            }
            case "directconnacct": {
                boolean statsInnerAcct = (Boolean)paramMap.get("statsinneracct");
                QFilter qFilter = new QFilter("enable", "=", (Object)true);
                if (!statsInnerAcct) {
                    qFilter.and(new QFilter("inneracct", "=", (Object)0L));
                }
                DynamicObjectCollection acctColls = QueryServiceHelper.query((String)"am_accountbank", (String)"id,finorgtype,issetbankinterface", (QFilter[])new QFilter[]{qFilter});
                ArrayList<Long> directIds = new ArrayList<Long>();
                ArrayList<Long> noDirectIds = new ArrayList<Long>();
                for (DynamicObject acct : acctColls) {
                    Long id = acct.getLong("id");
                    String finorgtype = acct.getString("finorgtype");
                    boolean issetbankinterface = acct.getBoolean("issetbankinterface");
                    if ("1".equals(finorgtype) || "3".equals(finorgtype) || issetbankinterface) {
                        directIds.add(id);
                        continue;
                    }
                    noDirectIds.add(id);
                }
                QFilter[] normalFilter = FinOrgEvaService.initBankJournalQFilter(paramMap);
                ArrayList<QFilter> normalFilterList = new ArrayList<QFilter>();
                normalFilterList.addAll(Arrays.asList(normalFilter));
                normalFilterList.add(new QFilter("accountbank", "in", noDirectIds));
                DataSet journalDS = QueryServiceHelper.queryDataSet((String)"cas_bankjournal", (String)"cas_bankjournal", (String)bankJournalFiled, (QFilter[])normalFilterList.toArray(new QFilter[0]), null);
                QFilter[] transDetailFilter = FinOrgEvaService.initTransDetailQFilter(paramMap);
                ArrayList<QFilter> transDetailFilterList = new ArrayList<QFilter>();
                transDetailFilterList.addAll(Arrays.asList(transDetailFilter));
                transDetailFilterList.add(new QFilter("accountbank", "in", directIds));
                DataSet transDetailDS = QueryServiceHelper.queryDataSet((String)"bei_transdetail", (String)"bei_transdetail", (String)transDetailFiled, (QFilter[])transDetailFilterList.toArray(new QFilter[0]), null);
                dataset = journalDS.union(transDetailDS);
                break;
            }
            default: {
                QFilter[] bankJournalFilter = FinOrgEvaService.initBankJournalQFilter(paramMap);
                dataset = QueryServiceHelper.queryDataSet((String)"cas_bankjournal", (String)"cas_bankjournal", (String)bankJournalFiled, (QFilter[])bankJournalFilter, null);
            }
        }
        return dataset;
    }

    public static DataSet getCreditLimitDataSet(QFilter[] qFilters, Map<String, Object> paramMap, DataSet allBankDS) {
        String creditLimitFiled = "id, totalamt, currency, bank.id bankid, case when bank.bank_cate.name is null then bank.name else bank.bank_cate.name end as bank";
        DataSet creditLimitDS = QueryServiceHelper.queryDataSet((String)"creditlimit", (String)"cfm_creditlimit", (String)creditLimitFiled, (QFilter[])qFilters, null);
        for (Row row : creditLimitDS.copy()) {
            System.out.println(row);
        }
        DataSet creditLimitJoinBankDS = creditLimitDS.copy().join(allBankDS, JoinType.INNER).on("bankid", "bankid").select(creditLimitDS.getRowMeta().getFieldNames(), new String[]{"finorgtype"}).finish();
        DataSet exchangeRateDataSet = FinOrgEvaService.getExchRateDataSet(creditLimitDS, paramMap, "totalamt");
        DataSet dataSet = creditLimitJoinBankDS.copy().join(exchangeRateDataSet, JoinType.LEFT).on("currency", "currency").select(creditLimitJoinBankDS.getRowMeta().getFieldNames(), new String[]{"exchrate"}).finish();
        dataSet = dataSet.addField("totalamt * exchrate/10000", "amount_credit").groupBy(new String[]{"bank", "finorgtype"}).sum("amount_credit").finish();
        dataSet = dataSet.orderBy(new String[]{"amount_credit desc"}).addField("amount_credit", "sort_credit");
        return dataSet;
    }

    public static DataSet getLoanDataSet(QFilter[] qFilters, Map<String, Object> paramMap, DataSet allBankDS) {
        String loanFiled = "id, amount, currency, creditor bankid, lendernature";
        DataSet loanDS = QueryServiceHelper.queryDataSet((String)"loancontractbill", (String)"cfm_loancontractbill", (String)loanFiled, (QFilter[])qFilters, null);
        loanDS = loanDS.where("lendernature = 'outgroup'");
        for (Row row : loanDS.copy()) {
            System.out.println(row);
        }
        DataSet exchRateDataSet = FinOrgEvaService.getExchRateDataSet(loanDS, paramMap, "amount");
        DataSet loanDsBank = loanDS.copy().join(allBankDS, JoinType.INNER).on("bankid", "bankid").select(loanDS.getRowMeta().getFieldNames(), new String[]{"finorgtype", "bank bank"}).finish();
        DataSet dataSet = loanDsBank.copy().join(exchRateDataSet, JoinType.LEFT).on("currency", "currency").select(loanDsBank.getRowMeta().getFieldNames(), new String[]{"exchrate"}).finish();
        dataSet = dataSet.addField("amount * exchrate/10000", "amount_loan").groupBy(new String[]{"bank", "finorgtype"}).sum("amount_loan").finish();
        dataSet = dataSet.orderBy(new String[]{"amount_loan desc"}).addField("amount_loan", "sort_loan");
        return dataSet;
    }

    public static DataSet getPayableBillDataSet(QFilter[] qFilters, Map<String, Object> paramMap, DataSet acctBankDS) {
        String payableBillFiled = "id, draweraccount.bankaccountnumber bankaccountnumber, createtime, currency, amount";
        DataSet payableBillDS = QueryServiceHelper.queryDataSet((String)"payablebill", (String)"cdm_payablebill", (String)payableBillFiled, (QFilter[])qFilters, null);
        for (Row row : payableBillDS.copy()) {
            System.out.println(row);
        }
        DataSet joinDataSet = payableBillDS.copy().join(acctBankDS, JoinType.INNER).on("bankaccountnumber", "bankaccountnumber").select(payableBillDS.getRowMeta().getFieldNames(), new String[]{"bankid", "bank", "finorgtype"}).finish();
        DataSet exchRateDataSet = FinOrgEvaService.getExchRateDataSet(joinDataSet, paramMap, "amount");
        DataSet dataSet = joinDataSet.copy().join(exchRateDataSet, JoinType.LEFT).on("currency", "currency").select(joinDataSet.getRowMeta().getFieldNames(), new String[]{"exchrate"}).finish();
        dataSet = dataSet.addField("amount * exchrate/10000", "amount_acc").groupBy(new String[]{"bank", "finorgtype"}).sum("amount_acc").finish();
        dataSet = dataSet.orderBy(new String[]{"amount_acc desc"}).addField("amount_acc", "sort_acc");
        return dataSet;
    }

    public static DataSet getDrafttradeBillDataSet(QFilter[] qFilters, Map<String, Object> paramMap, DataSet acctBankDS) {
        String drafttradeBillFiled = "id, amount, currency, bankaccount.bankaccountnumber bankaccountnumber";
        DataSet drafttradeBillDS = QueryServiceHelper.queryDataSet((String)"drafttradebill", (String)"cdm_drafttradebill", (String)drafttradeBillFiled, (QFilter[])qFilters, null);
        DataSet joinDataSet = drafttradeBillDS.copy().join(acctBankDS, JoinType.INNER).on("bankaccountnumber", "bankaccountnumber").select(drafttradeBillDS.getRowMeta().getFieldNames(), new String[]{"bankid", "bank", "finorgtype"}).finish();
        DataSet exchRateDataSet = FinOrgEvaService.getExchRateDataSet(joinDataSet, paramMap, "amount");
        DataSet dataSet = joinDataSet.copy().join(exchRateDataSet, JoinType.LEFT).on("currency", "currency").select(joinDataSet.getRowMeta().getFieldNames(), new String[]{"exchrate"}).finish();
        dataSet = dataSet.addField("amount * exchrate/10000", "amount_dis").groupBy(new String[]{"bank", "finorgtype"}).sum("amount_dis").finish();
        dataSet = dataSet.orderBy(new String[]{"amount_dis desc"}).addField("amount_dis", "sort_dis");
        return dataSet;
    }

    public static DataSet addSortToDataSet(DataSet dataSet) {
        Algo algo = Algo.create((String)"addSort");
        DataSetBuilder datasetBuilder = algo.createDataSetBuilder(dataSet.getRowMeta());
        int i = 1;
        while (dataSet.hasNext()) {
            Object[] rowData = new Object[4];
            Row row = dataSet.next();
            rowData[0] = row.getString(0);
            rowData[1] = row.getString(1);
            rowData[2] = row.getString(2);
            rowData[3] = i;
            ++i;
            datasetBuilder.append(rowData);
        }
        dataSet = datasetBuilder.build();
        return dataSet;
    }

    public static DataSet getExchRateDataSet(DataSet DataSet2, Map<String, Object> paramMap, String exFiled) {
        DataSet currencySet = DataSet2.copy().groupBy(new String[]{"currency"}).sum(exFiled, "exchrate").finish();
        Long orgId = TmcOrgDataHelper.getCurrentOrgId();
        Date today = new Date();
        Algo algo = Algo.create((String)"getExchRate");
        DataSetBuilder datasetBuilder = algo.createDataSetBuilder(currencySet.getRowMeta());
        Long reportCurrencyId = ((DynamicObject)paramMap.get("filter_statcurrency")).getLong("id");
        Long exRateTableId = ((DynamicObject)paramMap.get("exratetable")).getLong("id");
        BigDecimal tempRate = null;
        Object[] rowData = null;
        Row row = null;
        Long currency = null;
        while (currencySet.hasNext()) {
            rowData = new Object[2];
            row = currencySet.next();
            currency = row.getLong("currency");
            tempRate = BaseDataServiceHelper.getExchangeRate((Long)exRateTableId, (Long)currency, (Long)reportCurrencyId, (Date)today);
            rowData[0] = currency;
            rowData[1] = !EmptyUtil.isEmpty((BigDecimal)tempRate) ? tempRate : BigDecimal.ONE;
            datasetBuilder.append(rowData);
        }
        DataSet exchRateDataSet = datasetBuilder.build();
        return exchRateDataSet;
    }

    public static QFilter initOrgFilter(Map<String, Object> paramMap, String orgProp) {
        List orgIds = new ArrayList(10);
        Long userId = RequestContext.get().getCurrUserId();
        String formId = (String)paramMap.get("formid");
        String appId = (String)paramMap.get("appid");
        String queryWay = (String)paramMap.get("filter_queryway");
        if (ReportOrgQueryWayEnum.ORGVIEW.getValue().equals(queryWay)) {
            DynamicObject orgView = (DynamicObject)paramMap.get("filter_orgview");
            if (EmptyUtil.isNoEmpty((DynamicObject)orgView)) {
                orgIds = (List)paramMap.get("filter_org");
                orgIds = EmptyUtil.isEmpty(orgIds) ? TmcOrgDataHelper.getAuthorizedAndSubordinateOrgByView((Long)orgView.getLong("id"), (Long)userId, (String)appId, (String)formId, (String)"47150e89000000ac", (boolean)true, (boolean)true) : TmcOrgDataHelper.getAllSubordinateOrgs((Long)orgView.getLong("id"), orgIds, (boolean)true, (boolean)true);
            }
        } else {
            orgIds = (List)paramMap.get("filter_org");
            if (EmptyUtil.isEmpty(orgIds)) {
                orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)formId, (String)"47150e89000000ac");
            }
            if (paramMap.containsKey("filter_isincludelower") && ((Boolean)paramMap.get("filter_isincludelower")).booleanValue()) {
                orgIds = TmcOrgDataHelper.getAllSubordinateOrgsForCache((Long)DEFAULTORGVIEWID, orgIds, (boolean)true);
            }
        }
        logger.info("\u6709\u6743\u9650\u7684\u7ec4\u7ec7id\uff1a" + orgIds);
        return new QFilter(orgProp, "in", orgIds);
    }
}

