/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.common.bean;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class IntBillExtInfo
extends IntBillInfo {
    private List<IntBillDetailExtInfo> extDetails;
    private BigDecimal floatInt = BigDecimal.ZERO;

    public List<IntBillDetailExtInfo> getExtDetails() {
        return this.extDetails;
    }

    public IntBillExtInfo setExtDetails(List<IntBillDetailExtInfo> details) {
        this.extDetails = details;
        return this;
    }

    public BigDecimal getFloatInt() {
        return this.floatInt;
    }

    public IntBillExtInfo setFloatInt(BigDecimal floatInt) {
        this.floatInt = floatInt;
        return this;
    }

    public IntBillExtInfo() {
    }

    public IntBillExtInfo(IntBillInfo billInfo) {
        this.setBizDate(billInfo.getBizDate());
        this.setBeginDate(billInfo.getBeginDate());
        this.setEndDate(billInfo.getEndDate());
        this.setAmount(billInfo.getAmount());
        this.setSeq(billInfo.getSeq());
    }

    public static IntBillExtInfo clone(IntBillInfo billInfo) {
        IntBillExtInfo extInfo = new IntBillExtInfo(billInfo);
        List details = billInfo.getDetails();
        if (EmptyUtil.isEmpty((Collection)details)) {
            return extInfo;
        }
        extInfo.setDetails(details);
        extInfo.initExtDetails(details);
        return extInfo;
    }

    public void initExtDetails(List<IntBillDetailInfo> details) {
        ArrayList<IntBillDetailExtInfo> extDetailList = new ArrayList<IntBillDetailExtInfo>(details.size());
        details.forEach(d -> extDetailList.add(IntBillDetailExtInfo.build(d)));
        this.setExtDetails(extDetailList);
    }

    public static class IntBillDetailExtInfo
    extends IntBillDetailInfo {
        private BigDecimal floatRate;
        private BigDecimal floatInt;
        private Date beginConfirmDate;
        private Date endConfirmDate;
        private int observeOffsetDay = 0;

        public static IntBillDetailExtInfo build(IntBillDetailInfo detailInfo) {
            IntBillDetailExtInfo extInfo = new IntBillDetailExtInfo();
            extInfo.setBeginDate(detailInfo.getBeginDate());
            extInfo.setEndDate(detailInfo.getEndDate());
            extInfo.setDays(detailInfo.getDays());
            extInfo.setPrinciple(detailInfo.getPrinciple());
            extInfo.setRate(detailInfo.getRate());
            extInfo.setBasisDay(detailInfo.getBasisDay());
            extInfo.setIntType(detailInfo.getIntType());
            extInfo.setAmount(detailInfo.getAmount());
            extInfo.setLastTotalInt(detailInfo.getLastTotalInt());
            extInfo.setSeq(detailInfo.getSeq());
            return extInfo;
        }

        public int getConfirmDays() {
            return this.beginConfirmDate != null && this.endConfirmDate != null ? DateUtils.getDiffDays((Date)this.beginConfirmDate, (Date)this.endConfirmDate) - this.observeOffsetDay : 0;
        }

        public BigDecimal getTotalInt() {
            return this.floatInt == null ? this.getAmount() : this.getAmount().add(this.floatInt);
        }

        public BigDecimal getFloatRate() {
            return this.floatRate;
        }

        public IntBillDetailExtInfo setFloatRate(BigDecimal floatRate) {
            this.floatRate = floatRate;
            return this;
        }

        public BigDecimal getFloatInt() {
            return this.floatInt;
        }

        public IntBillDetailExtInfo setFloatInt(BigDecimal floatInt) {
            this.floatInt = floatInt;
            return this;
        }

        public Date getBeginConfirmDate() {
            return this.beginConfirmDate;
        }

        public IntBillDetailExtInfo setBeginConfirmDate(Date beginConfirmDate) {
            this.beginConfirmDate = beginConfirmDate;
            return this;
        }

        public Date getEndConfirmDate() {
            return this.endConfirmDate;
        }

        public IntBillDetailExtInfo setEndConfirmDate(Date endConfirmDate) {
            this.endConfirmDate = endConfirmDate;
            return this;
        }

        public IntBillDetailExtInfo setObserveOffsetDay(int observeOffsetDay) {
            this.observeOffsetDay = observeOffsetDay;
            return this;
        }
    }
}

