/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.common.enums;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.tmc.fbp.common.enums.MultiLangEnumBridge;

public enum RateBillTypeEnum {
    CIM_DEPOSIT("cim_deposit", new MultiLangEnumBridge("\u5b9a\u671f\u5b58\u6b3e\u5904\u7406", "RateBillTypeEnum_1", "tmc-mrm-common"), "bd_finorginfo"),
    CIM_NOTICEDEPOSIT("cim_noticedeposit", new MultiLangEnumBridge("\u901a\u77e5\u5b58\u6b3e\u5904\u7406", "RateBillTypeEnum_2", "tmc-mrm-common"), "bd_finorginfo"),
    CIM_FINSUBSCRIBE("cim_finsubscribe", new MultiLangEnumBridge("\u7406\u8d22\u7533\u8d2d", "RateBillTypeEnum_3", "tmc-mrm-common"), "bd_finorginfo"),
    CFM_LOANBILL_BOND("cfm_loanbill_bond", new MultiLangEnumBridge("\u503a\u5238\u53d1\u884c", "RateBillTypeEnum_4", "tmc-mrm-common"), "bd_finorginfo"),
    CFM_LOANBILL_B_L("cfm_loanbill_b_l", new MultiLangEnumBridge("\u94f6\u884c\u63d0\u6b3e\u5904\u7406", "RateBillTypeEnum_5", "tmc-mrm-common"), "bd_finorginfo"),
    CFM_LOANBILL_E_L("cfm_loanbill_e_l", new MultiLangEnumBridge("\u4f01\u4e1a\u63d0\u6b3e\u5904\u7406", "RateBillTypeEnum_6", "tmc-mrm-common"), "bd_finorginfo"),
    BEI_BANKBALANCE("bei_bankbalance", new MultiLangEnumBridge("\u4f59\u989d\u67e5\u8be2", "RateBillTypeEnum_7", "tmc-mrm-common"), ""),
    IFM_ACCOUNTBALANCE("ifm_accountbalance", new MultiLangEnumBridge("\u5185\u90e8\u8d26\u6237\u4f59\u989d", "RateBillTypeEnum_8", "tmc-mrm-common"), "");

    String value;
    MultiLangEnumBridge name;
    String counterpartyBaseData;

    private RateBillTypeEnum(String value, MultiLangEnumBridge name, String counterpartyBaseSata) {
        this.value = value;
        this.name = name;
        this.counterpartyBaseData = counterpartyBaseSata;
    }

    public String getValue() {
        return this.value;
    }

    public String getName() {
        return this.name.loadKDString();
    }

    public String getCounterpartyBaseData() {
        return this.counterpartyBaseData;
    }

    public static RateBillTypeEnum getByValue(String value) {
        RateBillTypeEnum[] values;
        for (RateBillTypeEnum rateBillTypeEnum : values = RateBillTypeEnum.values()) {
            if (!rateBillTypeEnum.getValue().equals(value)) continue;
            return rateBillTypeEnum;
        }
        return null;
    }

    public static String getResName(String value) {
        switch (value) {
            case "cim_invest_loanbill": {
                return ResManager.loadKDString((String)"\u653e\u6b3e\u5904\u7406", (String)"RateBillTypeEnum_0", (String)"tmc-mrm-common", (Object[])new Object[0]);
            }
            case "cim_deposit": {
                return ResManager.loadKDString((String)"\u5b9a\u671f\u5b58\u6b3e\u5904\u7406", (String)"RateBillTypeEnum_1", (String)"tmc-mrm-common", (Object[])new Object[0]);
            }
            case "cim_noticedeposit": {
                return ResManager.loadKDString((String)"\u901a\u77e5\u5b58\u6b3e\u5904\u7406", (String)"RateBillTypeEnum_2", (String)"tmc-mrm-common", (Object[])new Object[0]);
            }
            case "cim_finsubscribe": {
                return ResManager.loadKDString((String)"\u7406\u8d22\u7533\u8d2d", (String)"RateBillTypeEnum_3", (String)"tmc-mrm-common", (Object[])new Object[0]);
            }
            case "cfm_loanbill_bond": {
                return ResManager.loadKDString((String)"\u503a\u5238\u53d1\u884c", (String)"RateBillTypeEnum_4", (String)"tmc-mrm-common", (Object[])new Object[0]);
            }
            case "cfm_loanbill_b_l": {
                return ResManager.loadKDString((String)"\u94f6\u884c\u63d0\u6b3e\u5904\u7406", (String)"RateBillTypeEnum_5", (String)"tmc-mrm-common", (Object[])new Object[0]);
            }
            case "cfm_loanbill_e_l": {
                return ResManager.loadKDString((String)"\u4f01\u4e1a\u63d0\u6b3e\u5904\u7406", (String)"RateBillTypeEnum_6", (String)"tmc-mrm-common", (Object[])new Object[0]);
            }
            case "bei_bankbalance": {
                return ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2", (String)"RateBillTypeEnum_7", (String)"tmc-mrm-common", (Object[])new Object[0]);
            }
            case "ifm_accountbalance": {
                return ResManager.loadKDString((String)"\u5185\u90e8\u8d26\u6237\u4f59\u989d", (String)"RateBillTypeEnum_8", (String)"tmc-mrm-common", (Object[])new Object[0]);
            }
        }
        return "";
    }

    public static boolean isBond(String value) {
        return CFM_LOANBILL_BOND.getValue().equals(value);
    }

    public static boolean isCfmBIllType(String value) {
        return CFM_LOANBILL_BOND.getValue().equals(value) || CFM_LOANBILL_B_L.getValue().equals(value) || CFM_LOANBILL_E_L.getValue().equals(value);
    }

    public static boolean isCimBIllType(String value) {
        return CIM_DEPOSIT.getValue().equals(value) || CIM_NOTICEDEPOSIT.getValue().equals(value) || CIM_FINSUBSCRIBE.getValue().equals(value);
    }

    public static boolean isFinsubscribeBIllType(String value) {
        return CIM_FINSUBSCRIBE.getValue().equals(value);
    }

    public static List<String> getValues() {
        RateBillTypeEnum[] values = RateBillTypeEnum.values();
        return Arrays.stream(values).map(RateBillTypeEnum::getValue).collect(Collectors.toList());
    }
}

