/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.common.enums;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.tmc.fbp.common.model.interest.RateInfo;

public class RateExtInfo
extends RateInfo {
    private BigDecimal floatRate;
    private BigDecimal normalRate;
    private Date confirmDate;

    public static RateExtInfo build(Date effectiveDate, BigDecimal rate) {
        RateExtInfo extInfo = new RateExtInfo();
        extInfo.setEffectiveDate(effectiveDate);
        extInfo.setRate(rate);
        return extInfo;
    }

    public static RateExtInfo clone(RateInfo rateInfo) {
        RateExtInfo extInfo = new RateExtInfo();
        extInfo.setRate(rateInfo.getRate());
        extInfo.setRateType(rateInfo.getRateType());
        extInfo.setEffectiveDate(rateInfo.getEffectiveDate());
        return extInfo;
    }

    public static Set<RateInfo> convertRateInfo(List<RateExtInfo> extInfoSet) {
        HashSet<RateInfo> rateInfos = new HashSet<RateInfo>(extInfoSet.size());
        extInfoSet.forEach(e -> {
            RateInfo info = new RateInfo();
            info.setRate(e.getRate());
            info.setRateType(e.getRateType());
            info.setEffectiveDate(e.getEffectiveDate());
            rateInfos.add(info);
        });
        return rateInfos;
    }

    public Date getConfirmDate() {
        return this.confirmDate;
    }

    public RateExtInfo setConfirmDate(Date confirmDate) {
        this.confirmDate = confirmDate;
        return this;
    }

    public BigDecimal getFloatRate() {
        return this.floatRate;
    }

    public RateExtInfo setFloatRate(BigDecimal floatRate) {
        this.floatRate = floatRate;
        return this;
    }

    public BigDecimal getNormalRate() {
        return this.normalRate;
    }

    public RateExtInfo setNormalRate(BigDecimal normalRate) {
        this.normalRate = normalRate;
        return this;
    }
}

