/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.common.helper;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;

public class DataGetDefFilterHelper {
    public static QFilter getDefQFilter(String sourceEntity, String sourcebilltype) {
        QFilter defQF = QFilter.of((String)"1=1", (Object[])new Object[0]);
        switch (sourceEntity) {
            case "cfm_loanbill_bond": {
                defQF.and(new QFilter("loantype", "=", (Object)"bond"));
                break;
            }
            case "cfm_loanbill": {
                if ("cfm_loanbill_e_l".equals(sourcebilltype)) {
                    defQF = new QFilter("org.id", ">", (Object)0L);
                    defQF.and(new QFilter("loantype", "in", (Object)new String[]{"entrust", "ec"}));
                    defQF.and(new QFilter("lendernature", "=", (Object)"ingroup").or(new QFilter("datasource", "!=", (Object)"invest")));
                }
                if (!"cfm_loanbill_b_l".equals(sourcebilltype)) break;
                defQF.and(new QFilter("loantype", "in", (Object)new String[]{"loan", "sl"}));
                break;
            }
            case "cim_invest_loanbill": {
                defQF = new QFilter("creditorg.id", ">", (Object)0L);
                defQF.and(new QFilter("loantype", "in", (Object)new String[]{"entrust", "ec"}));
                defQF.and(new QFilter("lendernature", "=", (Object)"ingroup").or(new QFilter("datasource", "=", (Object)"invest")));
                break;
            }
            case "tm_forex_options": {
                defQF.and(new QFilter("protecttype.id", "=", (Object)Long.valueOf(ProductTypeEnum.FOREXOPTION.getId())));
                break;
            }
            case "tm_forex_forward": {
                defQF.and(new QFilter("protecttype.id", "=", (Object)Long.valueOf(ProductTypeEnum.FOREXFORWARD.getId())));
                break;
            }
            case "tm_forex": {
                defQF.and(new QFilter("protecttype.id", "=", (Object)Long.valueOf(ProductTypeEnum.FOREXSPOT.getId())));
                break;
            }
            case "tm_forex_swaps": {
                defQF.and(new QFilter("protecttype.id", "=", (Object)Long.valueOf(ProductTypeEnum.FOREXSWAPS.getId())));
                break;
            }
            case "cim_deposit": {
                defQF.and(DataGetDefFilterHelper.getDepositTypeQF("fix"));
                break;
            }
            case "cim_noticedeposit": {
                defQF.and(DataGetDefFilterHelper.getDepositTypeQF("notice"));
                break;
            }
        }
        return defQF;
    }

    private static QFilter getDepositTypeQF(String type) {
        QFilter ftTypeQF = QFilter.of((String)"1=1", (Object[])new Object[0]);
        if ("notice".equals(type)) {
            ftTypeQF.and(new QFilter("investtype", "=", (Object)InvestTypeEnum.notice.getValue()));
        } else {
            ftTypeQF.and(new QFilter("investtype", "in", (Object)InvestTypeEnum.getFixedGroup()));
        }
        DynamicObjectCollection idCols = QueryServiceHelper.query((String)"cim_investvarieties", (String)"id", (QFilter[])ftTypeQF.toArray());
        List ids = idCols.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        return new QFilter("investvarieties.id", "in", ids);
    }
}

