/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.helper.MarketDataServiceHelper;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.model.interest.RateInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.inst.helper.IntSegmentHelper;
import org.apache.commons.lang3.tuple.Triple;

public class DepositHelper {
    public static void calIntPlan(DynamicObject bill) {
        IntBillInfo intBillInfo = DepositHelper.buildIntBillInfo(bill);
        DepositHelper.finBillWriteBack(intBillInfo, bill);
    }

    public static IntBillInfo buildIntBillInfo(DynamicObject bill) {
        Date startIntDate = bill.getDate("interestdate");
        Date endIntDate = bill.getDate("enddate");
        String rateType = bill.getString("ratetype");
        IntBillInfo intBillInfo = InterestTypeEnum.FIXED.getValue().equals(rateType) ? DepositHelper.buildFixDepositIntBillInfo(bill, startIntDate) : DepositHelper.buildFloatDepositIntBillInfo(bill, startIntDate, endIntDate);
        if (EmptyUtil.isNoEmpty((Object)intBillInfo.getDetails())) {
            intBillInfo.getDetails().stream().map(IntBillDetailInfo::getAmount).reduce(BigDecimal::add).ifPresent(arg_0 -> ((IntBillInfo)intBillInfo).setAmount(arg_0));
        }
        return intBillInfo;
    }

    private static IntBillInfo buildFixDepositIntBillInfo(DynamicObject finBill, Date beginDate) {
        IntBillInfo intBillInfo = new IntBillInfo();
        RoundingMode roundMode = RoundingMode.HALF_UP;
        int yearDay = TermHelper.getBasis_YearDay((int)1, (BasisEnum)BasisEnum.getEnum((String)finBill.getString("basis")));
        Date expireDate = finBill.getDate("enddate");
        Triple<Date, Date, Integer> dateTriple = DepositHelper.reCalBeginEndDate(beginDate, expireDate);
        intBillInfo.setBizDate((Date)dateTriple.getLeft());
        intBillInfo.setBeginDate((Date)dateTriple.getLeft());
        Date endDate = (Date)dateTriple.getMiddle();
        intBillInfo.setEndDate(endDate);
        ArrayList<IntBillDetailInfo> detailInfos = new ArrayList<IntBillDetailInfo>(2);
        detailInfos.add(DepositHelper.buildSingleIntBillDetailInfo(finBill, dateTriple, yearDay, roundMode));
        intBillInfo.setDetails(detailInfos);
        return intBillInfo;
    }

    private static IntBillInfo buildFloatDepositIntBillInfo(DynamicObject finBill, Date beginDate, Date endIntDate) {
        IntBillInfo intBillInfo = new IntBillInfo();
        Date endDate = finBill.getDate("enddate");
        Triple<Date, Date, Integer> dateTriple = DepositHelper.reCalBeginEndDate(beginDate, endDate);
        RoundingMode roundMode = RoundingMode.HALF_UP;
        int yearDay = TermHelper.getBasis_YearDay((int)1, (BasisEnum)BasisEnum.getEnum((String)finBill.getString("basis")));
        intBillInfo.setBizDate((Date)dateTriple.getLeft());
        intBillInfo.setBeginDate((Date)dateTriple.getLeft());
        intBillInfo.setEndDate((Date)dateTriple.getMiddle());
        List<IntBillDetailInfo> intBillDetailInfos = DepositHelper.buildFixFloatIntBillDetailInfo(finBill, dateTriple, yearDay, roundMode);
        intBillInfo.setDetails(intBillDetailInfos);
        return intBillInfo;
    }

    public static List<IntBillDetailInfo> buildFixFloatIntBillDetailInfo(DynamicObject finBill, Triple<Date, Date, Integer> dateTriple, int yearDay, RoundingMode roundMode) {
        String referRateNumber = Optional.ofNullable(finBill.getDynamicObject("referencerate")).map(r -> r.getString("number")).orElse("");
        if (EmptyUtil.isEmpty((String)referRateNumber)) {
            return Collections.EMPTY_LIST;
        }
        Map rateDateVal = MarketDataServiceHelper.referRate((String)referRateNumber, (Date)((Date)dateTriple.getLeft()), (Date)((Date)dateTriple.getMiddle()));
        if (CollectionUtils.isEmpty((Map)rateDateVal)) {
            throw DepositHelper.refferRateNotExistException();
        }
        BigDecimal rateFloatPoint = finBill.getBigDecimal("basepoint");
        BigDecimal rateFloat = rateFloatPoint.divide(new BigDecimal("100"), 6, RoundingMode.HALF_UP);
        HashSet<RateInfo> rateSet = new HashSet<RateInfo>(rateDateVal.size());
        for (Map.Entry entry : rateDateVal.entrySet()) {
            RateInfo info = new RateInfo();
            info.setEffectiveDate((Date)entry.getKey());
            info.setRate(((BigDecimal)entry.getValue()).add(rateFloat));
            rateSet.add(info);
        }
        List<IntBillDetailInfo> intDetailInfo = DepositHelper.getSubRate(rateSet, (Date)dateTriple.getLeft(), (Date)dateTriple.getMiddle());
        BigDecimal amount = finBill.getBigDecimal("amount");
        intDetailInfo.forEach(r -> {
            r.setBasisDay(yearDay);
            r.setPrinciple(amount);
            r.setAmount(amount.multiply(r.getRate()).multiply(BigDecimal.valueOf(r.getDays())).divide(BigDecimal.valueOf(yearDay).multiply(Constants.ONE_HUNDRED), 6, roundMode));
        });
        return intDetailInfo;
    }

    public static List<IntBillDetailInfo> getSubRate(Set<RateInfo> rateList, Date beginDate, Date endDate) {
        List detailList = IntSegmentHelper.getSubRate(rateList, (Date)beginDate, (Date)endDate);
        return IntSegmentHelper.orderAGenEndDateAndDays((List)detailList, (Date)endDate);
    }

    public static KDBizException refferRateNotExistException() {
        return new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u57fa\u7840\u8d44\u6599\u5e94\u7528\u4e0b\u7684\u53c2\u8003\u5229\u7387\u6570\u636e\u3002", (String)"DepositHelper_1", (String)"tmc-mrm-common", (Object[])new Object[0]));
    }

    private static Triple<Date, Date, Integer> reCalBeginEndDate(Date startDate, Date endDate) {
        endDate = DateUtils.getLastDay((Date)endDate, (int)1);
        return Triple.of((Object)startDate, (Object)endDate, (Object)DateUtils.getDiffDays((Date)startDate, (Date)endDate));
    }

    public static IntBillDetailInfo buildSingleIntBillDetailInfo(DynamicObject finBill, Triple<Date, Date, Integer> dateTriple, int yearDay, RoundingMode roundMode) {
        IntBillDetailInfo detailInfo = new IntBillDetailInfo();
        detailInfo.setBeginDate((Date)dateTriple.getLeft());
        detailInfo.setEndDate((Date)dateTriple.getMiddle());
        detailInfo.setDays(((Integer)dateTriple.getRight()).intValue());
        detailInfo.setBasisDay(yearDay);
        BigDecimal amount = finBill.getBigDecimal("amount");
        detailInfo.setPrinciple(amount);
        BigDecimal useInt = finBill.getBigDecimal("fixrate");
        detailInfo.setRate(useInt);
        BigDecimal rateAmount = amount.multiply(useInt.divide(Constants.ONE_HUNDRED, 6, roundMode)).multiply(BigDecimal.valueOf(((Integer)dateTriple.getRight()).intValue())).divide(BigDecimal.valueOf(yearDay), 6, roundMode);
        detailInfo.setAmount(rateAmount);
        return detailInfo;
    }

    private static void finBillWriteBack(IntBillInfo intBillInfo, DynamicObject finBill) {
        String basis = finBill.getString("basis");
        int yearDay = TermHelper.getBasis_YearDay((int)1, (BasisEnum)BasisEnum.getEnum((String)basis));
        DynamicObjectCollection interestEntryDC = finBill.getDynamicObjectCollection("incashflowtentry");
        interestEntryDC.clear();
        DynamicObject interestEntryDO = interestEntryDC.addNew();
        BigDecimal interestAmount = intBillInfo.getAmount();
        interestEntryDO.set("seq", (Object)1);
        interestEntryDO.set("indate", finBill.get("enddate"));
        interestEntryDO.set("inamount", (Object)interestAmount);
        List details = intBillInfo.getDetails();
        DynamicObjectCollection interestSubEntryDC = interestEntryDO.getDynamicObjectCollection("incashflowtsubentry");
        if (interestSubEntryDC != null) {
            interestSubEntryDC.clear();
            for (IntBillDetailInfo detail : details) {
                Date beginDate = detail.getBeginDate();
                Date endDate = detail.getEndDate();
                int days = detail.getDays();
                BigDecimal principle = detail.getPrinciple();
                BigDecimal yearRate = detail.getRate();
                BigDecimal rateAmount = detail.getAmount();
                DynamicObject interestSubEntryDO = interestSubEntryDC.addNew();
                interestSubEntryDO.set("seq", (Object)detail.getSeq());
                interestSubEntryDO.set("intereststartdate", (Object)beginDate);
                interestSubEntryDO.set("interestenddate", (Object)endDate);
                interestSubEntryDO.set("interestdates", (Object)days);
                interestSubEntryDO.set("interestbalance", (Object)principle);
                interestSubEntryDO.set("interestrate", (Object)yearRate);
                interestSubEntryDO.set("interestdays", (Object)yearDay);
                interestSubEntryDO.set("interestamount", (Object)rateAmount);
            }
        }
    }
}

