/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mrm.common.helper.OrgHelper;
import org.apache.commons.lang3.tuple.Pair;

public class ExRateGapAnalysisHelper {
    public static List<String> getExRateGapChangedProps(DynamicObject exRateGapAnalysis) {
        ArrayList<String> list = new ArrayList<String>();
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{exRateGapAnalysis.get("forexquote"), exRateGapAnalysis.get("forexquotetime")}) && exRateGapAnalysis.getDynamicObject("forexquote").getDate("modifyTime").getTime() / 1000L != exRateGapAnalysis.getDate("forexquotetime").getTime() / 1000L) {
            list.add(((IDataEntityProperty)exRateGapAnalysis.getDataEntityType().getProperties().get((Object)"forexquote")).getDisplayName().getLocaleValue());
        }
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{exRateGapAnalysis.get("subjectsystem"), exRateGapAnalysis.get("subjectsystemtime")}) && exRateGapAnalysis.getDynamicObject("subjectsystem").getDate("modifyTime").getTime() / 1000L != exRateGapAnalysis.getDate("subjectsystemtime").getTime() / 1000L) {
            list.add(((IDataEntityProperty)exRateGapAnalysis.getDataEntityType().getProperties().get((Object)"subjectsystem")).getDisplayName().getLocaleValue());
        }
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{exRateGapAnalysis.get("sectioncfg"), exRateGapAnalysis.get("sectioncfgtime")}) && exRateGapAnalysis.getDynamicObject("sectioncfg").getDate("modifyTime").getTime() / 1000L != exRateGapAnalysis.getDate("sectioncfgtime").getTime() / 1000L) {
            list.add(((IDataEntityProperty)exRateGapAnalysis.getDataEntityType().getProperties().get((Object)"sectioncfg")).getDisplayName().getLocaleValue());
        }
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{exRateGapAnalysis.get("currentanalysisobj"), exRateGapAnalysis.get("currentanalysisobjtime")}) && exRateGapAnalysis.getDynamicObject("currentanalysisobj").getDate("modifyTime").getTime() / 1000L != exRateGapAnalysis.getDate("currentanalysisobjtime").getTime() / 1000L) {
            list.add(((IDataEntityProperty)exRateGapAnalysis.getDataEntityType().getProperties().get((Object)"currentanalysisobj")).getDisplayName().getLocaleValue());
        } else {
            DynamicObject analysisObj = exRateGapAnalysis.getDynamicObject("currentanalysisobj");
            if (analysisObj != null) {
                DynamicObject draft = analysisObj.getDynamicObject("draft");
                DynamicObject draftBill = QueryServiceHelper.queryOne((String)"mrm_exrate_draft", (String)"modifyTime", (QFilter[])new QFilter("id", "=", draft.getPkValue()).toArray());
                Date modifyTime = draftBill.getDate("modifyTime");
                if (EmptyUtil.isNoEmpty((Object)exRateGapAnalysis.get("draftmodifytime")) && exRateGapAnalysis.getDate("draftmodifytime").getTime() / 1000L != modifyTime.getTime() / 1000L) {
                    list.add(((IDataEntityProperty)exRateGapAnalysis.getDataEntityType().getProperties().get((Object)"currentanalysisobj")).getDisplayName().getLocaleValue());
                }
            }
        }
        return list;
    }

    public static void queryAndCacheExRateGapChartData(IFormView view) {
        view.getFormShowParameter().getCustomParams().remove("currencyNumbers");
        view.getFormShowParameter().getCustomParams().remove("MultiCurInArr");
        view.getFormShowParameter().getCustomParams().remove("MultiCurOutArr");
        view.getFormShowParameter().getCustomParams().remove("MultiCurArr");
        view.getFormShowParameter().getCustomParams().remove("data");
        view.getFormShowParameter().getCustomParams().remove("inArr");
        view.getFormShowParameter().getCustomParams().remove("outArr");
        view.getFormShowParameter().getCustomParams().remove("arr");
        view.getFormShowParameter().getCustomParams().remove("sumArr");
        Long srcBillId = (Long)view.getModel().getValue("id");
        QFilter qFilter = new QFilter("srcBill", "=", (Object)srcBillId);
        String appId = view.getFormShowParameter().getServiceAppId();
        DynamicObject orgView = (DynamicObject)view.getModel().getValue("orgview");
        DynamicObjectCollection orgCol = (DynamicObjectCollection)view.getModel().getValue("orgs");
        List<Long> orgIds = OrgHelper.getPermOrgIds(orgView, orgCol, null, appId, "mrm_exrate_gap_analysis");
        if (orgIds != null) {
            qFilter.and("org", "in", orgIds);
        }
        ExRateGapAnalysisHelper.queryMultiCurChartData(view, qFilter);
        ExRateGapAnalysisHelper.queryGridData(view, qFilter);
        ExRateGapAnalysisHelper.querySingleCurChartData(view, qFilter);
        view.getFormShowParameter().setCustomParam("currentRequestTraceId", (Object)RequestContext.get().getTraceId());
    }

    private static void querySingleCurChartData(IFormView view, QFilter qFilter) {
        DataSet dataSet;
        BigDecimal amtUnit = new BigDecimal((String)view.getModel().getValue("amtunit"));
        DynamicObject currency = (DynamicObject)view.getModel().getValue("currency");
        if (currency != null) {
            qFilter.and("cashFlowCurrency", "=", (Object)currency.getLong("id"));
        }
        if ((dataSet = QueryServiceHelper.queryDataSet((String)"ExRateGapQingAnalysisPlugin", (String)"mrm_exrate_gap_detail", (String)String.join((CharSequence)",", "sectionIndex", "inOrOut", "gapAmount"), (QFilter[])qFilter.toArray(), (String)"sectionIndex")).isEmpty()) {
            return;
        }
        dataSet = dataSet.updateField("gapAmount", "gapAmount/" + amtUnit);
        dataSet = dataSet.groupBy(new String[]{"sectionIndex", "inOrOut"}).sum("gapAmount").finish();
        String titleStr = (String)view.getModel().getValue("amtcolumntitles");
        String[] titles = titleStr.split("_");
        int sectionCount = titles.length;
        BigDecimal[] inArr = ExRateGapAnalysisHelper.getArray(sectionCount);
        BigDecimal[] outArr = ExRateGapAnalysisHelper.getArray(sectionCount);
        BigDecimal[] arr = ExRateGapAnalysisHelper.getArray(sectionCount);
        BigDecimal[] sumArr = ExRateGapAnalysisHelper.getArray(sectionCount);
        while (dataSet.hasNext()) {
            BigDecimal temp;
            Row row = dataSet.next();
            String inOrOut = row.getString("inOrOut");
            Integer sectionIndex = row.getInteger("sectionIndex");
            BigDecimal gapAmount = row.getBigDecimal("gapAmount").setScale(2, RoundingMode.HALF_UP);
            if ("in".equals(inOrOut)) {
                temp = inArr[sectionIndex];
                inArr[sectionIndex.intValue()] = temp.add(gapAmount);
            }
            if ("out".equals(inOrOut)) {
                temp = outArr[sectionIndex];
                outArr[sectionIndex.intValue()] = temp.add(gapAmount);
            }
            temp = arr[sectionIndex];
            arr[sectionIndex.intValue()] = temp.add(gapAmount);
        }
        for (int i = 0; i < sumArr.length; ++i) {
            BigDecimal temp = BigDecimal.ZERO;
            for (int j = 0; j <= i; ++j) {
                temp = temp.add(arr[j] != null ? arr[j] : BigDecimal.ZERO);
            }
            sumArr[i] = temp;
        }
        view.getFormShowParameter().setCustomParam("inArr", (Object)inArr);
        view.getFormShowParameter().setCustomParam("outArr", (Object)outArr);
        view.getFormShowParameter().setCustomParam("arr", (Object)arr);
        view.getFormShowParameter().setCustomParam("sumArr", (Object)sumArr);
    }

    private static void queryMultiCurChartData(IFormView view, QFilter qFilter) {
        List currencyNumbers;
        BigDecimal amtUnit = new BigDecimal((String)view.getModel().getValue("amtunit"));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ExRateGapQingAnalysisPlugin", (String)"mrm_exrate_gap_detail", (String)String.join((CharSequence)",", "cashFlowCurrency.number as currencyNumber", "inOrOut", "reportGapAmount as gapAmount"), (QFilter[])qFilter.toArray(), (String)"sectionIndex");
        if (dataSet.isEmpty()) {
            return;
        }
        DataSet groupByCurrency = dataSet.copy().groupBy(new String[]{"currencyNumber"}).sum("gapAmount").finish();
        int topCurrencyCount = 4;
        ArrayList<Pair> list = new ArrayList<Pair>(topCurrencyCount);
        while (groupByCurrency.hasNext()) {
            Row row = groupByCurrency.next();
            String currencyNumber = row.getString("currencyNumber");
            BigDecimal gapAmount = row.getBigDecimal("gapAmount") != null ? row.getBigDecimal("gapAmount").abs() : BigDecimal.ZERO;
            list.add(Pair.of((Object)currencyNumber, (Object)gapAmount));
        }
        Collections.sort(list, (o1, o2) -> {
            if (((BigDecimal)o1.getValue()).compareTo((BigDecimal)o2.getValue()) > 0) {
                return -1;
            }
            if (((BigDecimal)o1.getValue()).compareTo((BigDecimal)o2.getValue()) == 0) {
                return 0;
            }
            return 1;
        });
        if (list.size() > topCurrencyCount) {
            List subList = list.subList(0, topCurrencyCount);
            currencyNumbers = subList.stream().map(o -> (String)o.getKey()).collect(Collectors.toList());
        } else {
            currencyNumbers = list.stream().map(o -> (String)o.getKey()).collect(Collectors.toList());
        }
        String other = ResManager.loadKDString((String)"\u5176\u4ed6", (String)"ExRateGapMultiCurHistogramQingAnalysisPlugin_7", (String)"tmc-mrm-report", (Object[])new Object[0]);
        HashMap<String, BigDecimal[]> data = new HashMap<String, BigDecimal[]>(5);
        dataSet = dataSet.groupBy(new String[]{"currencyNumber", "inOrOut"}).sum("gapAmount").finish();
        dataSet = dataSet.updateField("gapAmount", "gapAmount/" + amtUnit);
        while (dataSet.hasNext()) {
            BigDecimal temp;
            Row row = dataSet.next();
            String currencyNumber = currencyNumbers.contains(row.getString("currencyNumber")) ? row.getString("currencyNumber") : other;
            String inOrOut = row.getString("inOrOut");
            BigDecimal gapAmount = row.getBigDecimal("gapAmount").setScale(2, RoundingMode.HALF_UP);
            data.computeIfAbsent(currencyNumber, k -> ExRateGapAnalysisHelper.getArray(3));
            if ("in".equals(inOrOut)) {
                temp = ((BigDecimal[])data.get(currencyNumber))[0];
                ((BigDecimal[])data.get((Object)currencyNumber))[0] = temp.add(gapAmount);
            }
            if ("out".equals(inOrOut)) {
                temp = ((BigDecimal[])data.get(currencyNumber))[1];
                ((BigDecimal[])data.get((Object)currencyNumber))[1] = temp.add(gapAmount);
            }
            temp = ((BigDecimal[])data.get(currencyNumber))[2];
            ((BigDecimal[])data.get((Object)currencyNumber))[2] = temp.add(gapAmount);
        }
        if (list.size() > topCurrencyCount) {
            currencyNumbers.add(other);
        }
        BigDecimal[] MultiCurInArr = ExRateGapAnalysisHelper.getArray(currencyNumbers.size());
        BigDecimal[] MultiCurOutArr = ExRateGapAnalysisHelper.getArray(currencyNumbers.size());
        BigDecimal[] MultiCurArr = ExRateGapAnalysisHelper.getArray(currencyNumbers.size());
        for (Map.Entry e : data.entrySet()) {
            String currencyNumber = (String)e.getKey();
            BigDecimal[] arr = (BigDecimal[])e.getValue();
            int index = currencyNumbers.indexOf(currencyNumber);
            MultiCurInArr[index] = arr[0];
            MultiCurOutArr[index] = arr[1];
            MultiCurArr[index] = arr[2];
        }
        Collections.reverse(currencyNumbers);
        ExRateGapAnalysisHelper.reverse(MultiCurInArr);
        ExRateGapAnalysisHelper.reverse(MultiCurOutArr);
        ExRateGapAnalysisHelper.reverse(MultiCurArr);
        view.getFormShowParameter().setCustomParam("currencyNumbers", currencyNumbers);
        view.getFormShowParameter().setCustomParam("MultiCurInArr", (Object)MultiCurInArr);
        view.getFormShowParameter().setCustomParam("MultiCurOutArr", (Object)MultiCurOutArr);
        view.getFormShowParameter().setCustomParam("MultiCurArr", (Object)MultiCurArr);
    }

    private static void queryGridData(IFormView view, QFilter qFilter) {
        List currencyNumbers;
        BigDecimal amtUnit = new BigDecimal((String)view.getModel().getValue("amtunit"));
        int topCurrencyCount = 9;
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ExRateGapQingAnalysisPlugin", (String)"mrm_exrate_gap_detail", (String)String.join((CharSequence)",", "cashFlowCurrency.number as currencyNumber", "gapAmount", "reportGapAmount"), (QFilter[])qFilter.toArray(), (String)"sectionIndex");
        if (dataSet.isEmpty()) {
            return;
        }
        dataSet = dataSet.groupBy(new String[]{"currencyNumber"}).sum("gapAmount").sum("reportGapAmount").finish();
        DataSet ds = dataSet.copy();
        ArrayList<Pair> list = new ArrayList<Pair>(topCurrencyCount);
        while (ds.hasNext()) {
            Row row = ds.next();
            String currencyNumber = row.getString("currencyNumber");
            BigDecimal gapAmount = row.getBigDecimal("reportGapAmount") != null ? row.getBigDecimal("reportGapAmount").abs() : BigDecimal.ZERO;
            list.add(Pair.of((Object)currencyNumber, (Object)gapAmount));
        }
        Collections.sort(list, (o1, o2) -> {
            if (((BigDecimal)o1.getValue()).compareTo((BigDecimal)o2.getValue()) > 0) {
                return -1;
            }
            if (((BigDecimal)o1.getValue()).compareTo((BigDecimal)o2.getValue()) == 0) {
                return 0;
            }
            return 1;
        });
        if (list.size() > topCurrencyCount) {
            List subList = list.subList(0, topCurrencyCount);
            currencyNumbers = subList.stream().map(o -> (String)o.getKey()).collect(Collectors.toList());
        } else {
            currencyNumbers = list.stream().map(o -> (String)o.getKey()).collect(Collectors.toList());
        }
        String other = ResManager.loadKDString((String)"\u5176\u4ed6", (String)"ExRateGapMultiCurHistogramQingAnalysisPlugin_7", (String)"tmc-mrm-report", (Object[])new Object[0]);
        dataSet = dataSet.updateField("gapAmount", "gapAmount/" + amtUnit);
        dataSet = dataSet.updateField("reportGapAmount", "reportGapAmount/" + amtUnit);
        Map[] data = new Map[currencyNumbers.size() + 1];
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            String currencyNumber = currencyNumbers.contains(row.getString("currencyNumber")) ? row.getString("currencyNumber") : other;
            BigDecimal gapAmount = row.getBigDecimal("gapAmount").setScale(2, RoundingMode.HALF_UP);
            BigDecimal reportGapAmount = row.getBigDecimal("reportGapAmount").setScale(2, RoundingMode.HALF_UP);
            int i = currencyNumbers.indexOf(currencyNumber);
            if (i == -1) {
                i = currencyNumbers.size();
            }
            Map<String, BigDecimal> map = data[i] == null ? new HashMap() : data[i];
            map.put("currencynumber", (BigDecimal)((Object)currencyNumber));
            BigDecimal oldNet = map.get("net") != null ? (BigDecimal)map.get("net") : BigDecimal.ZERO;
            map.put("net", gapAmount.add(oldNet));
            BigDecimal oldTotalNet = map.get("totalnet") != null ? (BigDecimal)map.get("totalnet") : BigDecimal.ZERO;
            map.put("totalnet", reportGapAmount.add(oldTotalNet));
            data[i] = map;
        }
        view.getFormShowParameter().setCustomParam("data", (Object)data);
    }

    private static void reverse(BigDecimal[] array) {
        int length = array.length;
        int i = 0;
        for (int j = length - 1; i < j; ++i, --j) {
            BigDecimal temp = array[i];
            array[i] = array[j];
            array[j] = temp;
        }
    }

    public static void showExRateGapDetailList(IFormView view, QFilter qFilter) {
        DynamicObject orgView = (DynamicObject)view.getModel().getValue("orgview");
        DynamicObjectCollection orgCol = (DynamicObjectCollection)view.getModel().getValue("orgs");
        List<Long> orgIds = OrgHelper.getPermOrgIds(orgView, orgCol, null, view.getFormShowParameter().getServiceAppId(), "mrm_exrate_gap_analysis");
        qFilter.and("srcbill", "=", view.getModel().getValue("id"));
        if (orgIds != null) {
            qFilter.and("org", "in", orgIds);
        }
        ListShowParameter param = ShowFormHelper.createShowListForm((String)"mrm_exrate_gap_detail", (boolean)true, (int)0, (boolean)false);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ListFilterParameter filterParameter = new ListFilterParameter();
        filterParameter.setFilter(qFilter);
        param.setListFilterParameter(filterParameter);
        String titleStr = (String)view.getModel().getValue("amtcolumntitles");
        param.setCustomParam("titleStr", (Object)titleStr);
        view.showForm((FormShowParameter)param);
    }

    private static BigDecimal[] getArray(Integer count) {
        BigDecimal[] array = new BigDecimal[count.intValue()];
        Integer i = 0;
        while (i < count) {
            array[i.intValue()] = BigDecimal.ZERO;
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return array;
    }
}

