/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mrm.common.helper.OrgHelper;

public class GapAnalysisHelper {
    public static List<String> getChangedProps(DynamicObject gapAnalysis) {
        ArrayList<String> list = new ArrayList<String>();
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{gapAnalysis.get("forexquote"), gapAnalysis.get("forexquotetime")}) && gapAnalysis.getDynamicObject("forexquote").getDate("modifyTime").getTime() / 1000L != gapAnalysis.getDate("forexquotetime").getTime() / 1000L) {
            list.add(((IDataEntityProperty)gapAnalysis.getDataEntityType().getProperties().get((Object)"forexquote")).getDisplayName().getLocaleValue());
        }
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{gapAnalysis.get("subjectsystem"), gapAnalysis.get("subjectsystemtime")}) && gapAnalysis.getDynamicObject("subjectsystem").getDate("modifyTime").getTime() / 1000L != gapAnalysis.getDate("subjectsystemtime").getTime() / 1000L) {
            list.add(((IDataEntityProperty)gapAnalysis.getDataEntityType().getProperties().get((Object)"subjectsystem")).getDisplayName().getLocaleValue());
        }
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{gapAnalysis.get("sectioncfg"), gapAnalysis.get("sectioncfgtime")}) && gapAnalysis.getDynamicObject("sectioncfg").getDate("modifyTime").getTime() / 1000L != gapAnalysis.getDate("sectioncfgtime").getTime() / 1000L) {
            list.add(((IDataEntityProperty)gapAnalysis.getDataEntityType().getProperties().get((Object)"sectioncfg")).getDisplayName().getLocaleValue());
        }
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{gapAnalysis.get("currentanalysisobj"), gapAnalysis.get("currentanalysisobjtime")}) && gapAnalysis.getDynamicObject("currentanalysisobj").getDate("modifyTime").getTime() / 1000L != gapAnalysis.getDate("currentanalysisobjtime").getTime() / 1000L) {
            list.add(((IDataEntityProperty)gapAnalysis.getDataEntityType().getProperties().get((Object)"currentanalysisobj")).getDisplayName().getLocaleValue());
        } else if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{gapAnalysis.get("draft"), gapAnalysis.get("drafttime")}) && gapAnalysis.getDynamicObject("draft").getDate("modifyTime").getTime() / 1000L != gapAnalysis.getDate("drafttime").getTime() / 1000L) {
            list.add(((IDataEntityProperty)gapAnalysis.getDataEntityType().getProperties().get((Object)"currentanalysisobj")).getDisplayName().getLocaleValue());
        }
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{gapAnalysis.get("futureanalysisobj"), gapAnalysis.get("entryentity")})) {
            DynamicObjectCollection futureAnalysisObjCol = gapAnalysis.getDynamicObjectCollection("futureanalysisobj");
            for (int index = 0; index < futureAnalysisObjCol.size(); ++index) {
                if (((DynamicObject)futureAnalysisObjCol.get(index)).getDynamicObject("fBaseDataId").getDate("modifyTime").getTime() / 1000L == ((DynamicObject)gapAnalysis.getDynamicObjectCollection("entryentity").get(index)).getDate("e_futureanalysisobjtime").getTime() / 1000L) continue;
                list.add(((IDataEntityProperty)gapAnalysis.getDataEntityType().getProperties().get((Object)"futureanalysisobj")).getDisplayName().getLocaleValue());
                break;
            }
        }
        return list;
    }

    public static void showGapAnalysisDetail(IFormView view, QFilter qf) {
        Object id = view.getModel().getValue("id");
        DynamicObject orgView = (DynamicObject)view.getModel().getValue("orgview");
        DynamicObjectCollection orgCol = (DynamicObjectCollection)view.getModel().getValue("orgs");
        List<Long> orgIds = OrgHelper.getPermOrgIds(orgView, orgCol, OrgViewTypeEnum.IS_BANKROLL.getViewType(), view.getFormShowParameter().getAppId(), "mrm_gap_analysis");
        MulBasedataDynamicObjectCollection referenceRateCol = (MulBasedataDynamicObjectCollection)view.getModel().getValue("referencerate");
        Set referenceRateIdSet = referenceRateCol.stream().map(o -> o.getDynamicObject("fBaseDataId").getLong("id")).collect(Collectors.toSet());
        MulBasedataDynamicObjectCollection currencyCol = (MulBasedataDynamicObjectCollection)view.getModel().getValue("currency");
        Set currencyIdSet = currencyCol.stream().map(o -> o.getDynamicObject("fBaseDataId").getLong("id")).collect(Collectors.toSet());
        MulBasedataDynamicObjectCollection subjectCol = (MulBasedataDynamicObjectCollection)view.getModel().getValue("subjects");
        Set subjectIdSet = subjectCol.stream().map(o -> o.getDynamicObject("fBaseDataId").get("id")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("srcBillId", "=", id);
        if (EmptyUtil.isNoEmpty(referenceRateIdSet)) {
            qFilter.and("entryEntity.draftData.referenceRate", "in", referenceRateIdSet);
        }
        if (EmptyUtil.isNoEmpty(currencyIdSet)) {
            qFilter.and("entryEntity.entryCurrency", "in", currencyIdSet);
        }
        if (orgIds != null) {
            qFilter.and("entryEntity.draftData.org", "in", orgIds);
        }
        if (EmptyUtil.isNoEmpty(subjectIdSet)) {
            qFilter.and("subject", "in", subjectIdSet);
        }
        if (qf != null) {
            qFilter.and(qf);
        }
        ListShowParameter param = ShowFormHelper.createShowListForm((String)"mrm_gap_analysis_detail", (boolean)true, (int)0, (boolean)false);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ListFilterParameter filterParameter = new ListFilterParameter();
        filterParameter.setFilter(qFilter);
        param.setListFilterParameter(filterParameter);
        String titleStr = (String)view.getModel().getValue("amtcolumntitles");
        param.setCustomParam("titleStr", (Object)titleStr);
        view.showForm((FormShowParameter)param);
    }

    public static void queryAndCacheGapChartData(IFormView GapAnalysisView) {
        Long balanceSubjectId;
        boolean existsBalanceSubjectData;
        DynamicObject dbBill;
        Object subjectSystemId;
        DynamicObject balanceRow;
        DataSet dataSet;
        String traceId = RequestContext.get().getTraceId();
        GapAnalysisView.getFormShowParameter().setCustomParam("currentRequestTraceId", (Object)traceId);
        GapAnalysisView.getFormShowParameter().getCustomParams().remove("sumIn");
        GapAnalysisView.getFormShowParameter().getCustomParams().remove("sumOut");
        GapAnalysisView.getFormShowParameter().getCustomParams().remove("sum");
        GapAnalysisView.getFormShowParameter().getCustomParams().remove("inArr");
        GapAnalysisView.getFormShowParameter().getCustomParams().remove("outArr");
        GapAnalysisView.getFormShowParameter().getCustomParams().remove("arr");
        GapAnalysisView.getFormShowParameter().getCustomParams().remove("sumArr");
        DynamicObject gapAnalysisBill = GapAnalysisView.getModel().getDataEntity();
        Long srcBillId = gapAnalysisBill.getLong("id");
        BigDecimal amtUnit = new BigDecimal(gapAnalysisBill.getString("amtunit"));
        DynamicObject orgView = gapAnalysisBill.getDynamicObject("orgview");
        DynamicObjectCollection orgCol = gapAnalysisBill.getDynamicObjectCollection("orgs");
        String appId = GapAnalysisView.getFormShowParameter().getServiceAppId();
        List<Long> orgIds = OrgHelper.getPermOrgIds(orgView, orgCol, OrgViewTypeEnum.IS_BANKROLL.getViewType(), appId, "mrm_gap_analysis");
        MulBasedataDynamicObjectCollection referenceRateCol = (MulBasedataDynamicObjectCollection)gapAnalysisBill.getDynamicObjectCollection("referencerate");
        Set referenceRateIdSet = referenceRateCol.stream().map(o -> o.getDynamicObject("fBaseDataId").getLong("id")).collect(Collectors.toSet());
        MulBasedataDynamicObjectCollection currencyCol = (MulBasedataDynamicObjectCollection)gapAnalysisBill.getDynamicObjectCollection("currency");
        Set currencyIdSet = currencyCol.stream().map(o -> o.getDynamicObject("fBaseDataId").getLong("id")).collect(Collectors.toSet());
        MulBasedataDynamicObjectCollection subjectCol = (MulBasedataDynamicObjectCollection)gapAnalysisBill.getDynamicObjectCollection("subjects");
        boolean isCalcBalance = gapAnalysisBill.containsProperty("iscalcbalance_ext") ? gapAnalysisBill.getBoolean("iscalcbalance_ext") : false;
        Set subjectIdSet = subjectCol.stream().map(o -> o.getDynamicObject("fBaseDataId").get("id")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("srcBillId", "=", (Object)srcBillId);
        if (EmptyUtil.isNoEmpty(referenceRateIdSet)) {
            qFilter.and("entryEntity.draftData.referenceRate", "in", referenceRateIdSet);
        }
        if (EmptyUtil.isNoEmpty(currencyIdSet)) {
            qFilter.and("entryEntity.entryCurrency", "in", currencyIdSet);
        }
        if (orgIds != null) {
            qFilter.and("entryEntity.draftData.org", "in", orgIds);
        }
        if (EmptyUtil.isNoEmpty(subjectIdSet)) {
            qFilter.and("subject", "in", subjectIdSet);
        }
        if ((dataSet = QueryServiceHelper.queryDataSet((String)"GapQingAnalysisDataPlugin", (String)"mrm_gap_analysis_detail", (String)String.join((CharSequence)",", "sectionIndex", "subject", "subjectType", "entryEntity.gapAmount as gapAmount"), (QFilter[])qFilter.toArray(), (String)"sectionIndex")).isEmpty()) {
            GapAnalysisView.getFormShowParameter().setCustomParam("EmptyChartData", (Object)"YES");
            return;
        }
        GapAnalysisView.getFormShowParameter().getCustomParams().remove("EmptyChartData");
        dataSet = dataSet.groupBy(new String[]{"sectionIndex", "subject", "subjectType"}).sum("gapAmount").finish();
        int maxSectionIndex = 0;
        ArrayList<Object[]> list = new ArrayList<Object[]>(10);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Integer sectionIndex = row.getInteger("sectionIndex");
            maxSectionIndex = Math.max(maxSectionIndex, sectionIndex);
            list.add(new Object[]{sectionIndex, row.getLong("subject"), row.getString("subjectType"), row.getBigDecimal("gapAmount").setScale(2, RoundingMode.HALF_UP)});
        }
        if (isCalcBalance && (balanceRow = GapAnalysisHelper.getBalanceRow(subjectSystemId = (dbBill = QueryServiceHelper.queryOne((String)"mrm_gap_analysis", (String)"subjectSystem", (QFilter[])new QFilter("id", "=", (Object)srcBillId).toArray())).get("subjectSystem"))) != null && (existsBalanceSubjectData = QueryServiceHelper.exists((String)"mrm_gap_analysis_detail", (QFilter[])qFilter.and("subject", "=", (Object)(balanceSubjectId = Long.valueOf(balanceRow.getDynamicObject("subject").getLong("id")))).toArray())) && (subjectIdSet.isEmpty() || subjectIdSet.contains(balanceSubjectId))) {
            BigDecimal[] balanceArr = GapAnalysisHelper.calcBalance(maxSectionIndex, balanceSubjectId, list);
            String inOrOut = balanceRow.getString("direct");
            for (int sectionIndex = 0; sectionIndex < balanceArr.length; ++sectionIndex) {
                if (!EmptyUtil.isNoEmpty((BigDecimal)balanceArr[sectionIndex])) continue;
                list.add(new Object[]{sectionIndex, balanceSubjectId, inOrOut, balanceArr[sectionIndex]});
            }
        }
        for (Object[] array2 : list) {
            BigDecimal gapAmount = (BigDecimal)array2[3];
            gapAmount = gapAmount.divide(amtUnit, 10, RoundingMode.HALF_UP);
            array2[3] = gapAmount;
        }
        BigDecimal[] arr = GapAnalysisHelper.createArray(maxSectionIndex + 1);
        BigDecimal[] inArr = GapAnalysisHelper.createArray(maxSectionIndex + 1);
        BigDecimal[] outArr = GapAnalysisHelper.createArray(maxSectionIndex + 1);
        Map<Object, List<Object[]>> groupedBySection = list.stream().collect(Collectors.groupingBy(array -> array[0]));
        for (Map.Entry<Object, List<Object[]>> e : groupedBySection.entrySet()) {
            int sectionIndex = (Integer)e.getKey();
            List<Object[]> data = e.getValue();
            Optional<BigDecimal> o2 = data.stream().map(array -> (BigDecimal)array[3]).reduce(BigDecimal::add);
            arr[sectionIndex] = o2.orElse(BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP);
            Optional<BigDecimal> in = data.stream().filter(array -> "in".equals(array[2])).map(array -> (BigDecimal)array[3]).reduce(BigDecimal::add);
            inArr[sectionIndex] = in.orElse(BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP);
            Optional<BigDecimal> out = data.stream().filter(array -> "out".equals(array[2])).map(array -> (BigDecimal)array[3]).reduce(BigDecimal::add);
            outArr[sectionIndex] = out.orElse(BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP);
        }
        BigDecimal[] sumArr = GapAnalysisHelper.createArray(maxSectionIndex + 1);
        for (int i = 0; i <= maxSectionIndex; ++i) {
            BigDecimal sum = BigDecimal.ZERO;
            for (int j = 0; j <= i; ++j) {
                BigDecimal gapAmount = arr[j];
                if (!EmptyUtil.isNoEmpty((BigDecimal)gapAmount)) continue;
                sum = sum.add(gapAmount);
            }
            sumArr[i] = sum;
        }
        BigDecimal sumIn = Arrays.stream(inArr).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal sumOut = Arrays.stream(outArr).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal sum = Arrays.stream(arr).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        GapAnalysisView.getFormShowParameter().setCustomParam("sumIn", (Object)sumIn.setScale(2, RoundingMode.HALF_UP));
        GapAnalysisView.getFormShowParameter().setCustomParam("sumOut", (Object)sumOut.setScale(2, RoundingMode.HALF_UP));
        GapAnalysisView.getFormShowParameter().setCustomParam("sum", (Object)sum.setScale(2, RoundingMode.HALF_UP));
        GapAnalysisView.getFormShowParameter().setCustomParam("inArr", (Object)inArr);
        GapAnalysisView.getFormShowParameter().setCustomParam("outArr", (Object)outArr);
        GapAnalysisView.getFormShowParameter().setCustomParam("arr", (Object)arr);
        GapAnalysisView.getFormShowParameter().setCustomParam("sumArr", (Object)sumArr);
    }

    private static BigDecimal[] calcBalance(int maxSectionIndex, Long balanceSubjectId, List<Object[]> list) {
        BigDecimal[] otherArr = GapAnalysisHelper.createArray(maxSectionIndex + 1);
        BigDecimal[] balanceArr = GapAnalysisHelper.createArray(maxSectionIndex + 1);
        for (Object[] array2 : list) {
            BigDecimal old;
            int sectionIndex = (Integer)array2[0];
            BigDecimal gapAmount = (BigDecimal)array2[3];
            long subjectId = (Long)array2[1];
            if (subjectId == balanceSubjectId) {
                old = balanceArr[sectionIndex];
                balanceArr[sectionIndex] = old.add(gapAmount);
                array2[0] = -1;
                continue;
            }
            old = otherArr[sectionIndex];
            otherArr[sectionIndex] = old.add(gapAmount);
        }
        list.removeIf(array -> (Integer)array[0] == -1);
        Integer i = 1;
        while (i <= maxSectionIndex) {
            if (EmptyUtil.isEmpty((BigDecimal)balanceArr[i])) {
                BigDecimal balanceAmt;
                BigDecimal otherSubjectLastSectionSumGap = otherArr[i - 1] != null ? otherArr[i - 1] : BigDecimal.ZERO;
                BigDecimal lastBalanceGap = balanceArr[i - 1] != null ? balanceArr[i - 1] : BigDecimal.ZERO;
                balanceArr[i.intValue()] = balanceAmt = lastBalanceGap.add(otherSubjectLastSectionSumGap);
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return balanceArr;
    }

    private static DynamicObject getBalanceRow(Object subjectSystemId) {
        DynamicObject subjectSystem = BusinessDataServiceHelper.loadSingleFromCache((Object)subjectSystemId, (String)"mrm_subject_system");
        for (DynamicObject subjectTreeEntryRow : subjectSystem.getDynamicObjectCollection("subjecttreeentry")) {
            if (!subjectTreeEntryRow.getBoolean("isleaf")) continue;
            FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)subjectTreeEntryRow.getString("mapping_tag"), FilterCondition.class);
            List filterRow = condition.getFilterRow();
            SimpleFilterRow simpleFilterRows = (SimpleFilterRow)filterRow.get(0);
            List baseDataIds = simpleFilterRows.getBaseDataIds();
            for (FilterValue baseDataId : baseDataIds) {
                if (!"bei_bankbalance".equals(baseDataId.getValue())) continue;
                return subjectTreeEntryRow;
            }
        }
        return null;
    }

    private static BigDecimal[] createArray(Integer count) {
        BigDecimal[] array = new BigDecimal[count.intValue()];
        Integer i = 0;
        while (i < count) {
            array[i.intValue()] = BigDecimal.ZERO;
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return array;
    }
}

