/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.IntCalMethodEnum;
import kd.tmc.fbp.common.enums.IntHTRuleEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.SettleIntModeEnum;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.model.interest.BizBillInfo;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.model.interest.IntCalRequest;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.model.interest.RateInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.factory.IntCallFactory;
import kd.tmc.fbp.service.inst.bean.CalcIntInfo;
import kd.tmc.fbp.service.inst.interest.IIntCallStragety;
import kd.tmc.fbp.service.inst.plan.IntPlanCallStragety;
import kd.tmc.mrm.common.bean.IntBillExtInfo;
import kd.tmc.mrm.common.bean.InterestCalcParam;
import kd.tmc.mrm.common.enums.InschemeEnum;
import kd.tmc.mrm.common.enums.LookBackTypeEnum;
import kd.tmc.mrm.common.enums.RateExtInfo;
import kd.tmc.mrm.common.helper.RateAdjustHelper;
import org.apache.commons.lang3.tuple.Pair;

public class InterestCalHelper {
    public static List<PlanCallResult> updatePlanListByAdjustRule(List<PlanCallResult> callResults, String payIntRule, DynamicObjectCollection workCalendars) {
        if (EmptyUtil.isBlank((CharSequence)payIntRule) || AdjustMethodEnum.no_adjust.getValue().equals(payIntRule)) {
            return callResults;
        }
        if (EmptyUtil.isEmpty((DynamicObjectCollection)workCalendars)) {
            return callResults;
        }
        AdjustMethodEnum adjustMethod = AdjustMethodEnum.valueOf((String)payIntRule);
        Map<Date, PlanCallResult> datePlanMap = callResults.stream().collect(Collectors.toMap(PlanCallResult::getBizDate, r -> r));
        for (PlanCallResult callResult : callResults) {
            Date adjustBizDate;
            Date bizDate = callResult.getBizDate();
            if (bizDate.compareTo(adjustBizDate = TermHelper.callAdjustSettleDate((DynamicObjectCollection)workCalendars, (Date)bizDate, (AdjustMethodEnum)adjustMethod)) == 0) continue;
            datePlanMap.remove(bizDate);
            callResult.setBizDate(adjustBizDate);
            datePlanMap.put(adjustBizDate, callResult);
        }
        ArrayList<PlanCallResult> planList = new ArrayList<PlanCallResult>(datePlanMap.values());
        planList.sort(Comparator.comparing(PlanCallResult::getBizDate));
        return planList;
    }

    public static Pair<BigDecimal, List<IntBillExtInfo>> callIntCashFlow(DynamicObject bill) {
        Date beginDate = bill.getDate("interestdate");
        Date endDate = bill.getDate("enddate");
        DynamicObject intSchema = bill.getDynamicObject("interestsettledplan");
        if (intSchema != null && InschemeEnum.isCustom(intSchema.getString("intereststpd"))) {
            return Pair.of((Object)BigDecimal.ZERO, new ArrayList());
        }
        List<PlanCallResult> intPlanList = InterestCalHelper.callIntPlan(bill, endDate);
        return InterestCalHelper.genIntPlan(bill, intPlanList, beginDate);
    }

    public static List<PlanCallResult> callIntPlan(DynamicObject loanBill, Date endDate) {
        RepaymentWayEnum repayWay = RepaymentWayEnum.valueOf((String)loanBill.getString("repaymentway"));
        List<RateExtInfo> rateList = InterestCalHelper.getRateList(loanBill, null);
        BigDecimal balance = loanBill.getBigDecimal("amount");
        List<PlanCallResult> repayPlanList = InterestCalHelper.getAllRepayPlanList(loanBill, false);
        IntCalRequest request = new IntCalRequest();
        request.setRepayList(repayPlanList);
        Date beginDate = loanBill.getDate("interestdate");
        InterestCalcParam param = new InterestCalcParam().setPrinciple(balance).setBeginDate(beginDate).setEndDate(endDate).setRepayWay(repayWay);
        request.setBizBill(InterestCalHelper.getBizBill(loanBill, param));
        request.setRateList(RateExtInfo.convertRateInfo(rateList));
        List<PlanCallResult> callResults = new IntPlanCallStragety().callPlan(request);
        callResults = InterestCalHelper.updateBizDateByPayIntAdjustRule(loanBill, callResults);
        return callResults;
    }

    public static List<PlanCallResult> updateBizDateByPayIntAdjustRule(DynamicObject bill, List<PlanCallResult> callResults) {
        String payIntRule = bill.getString("payintadjustrule");
        DynamicObjectCollection workCalendars = bill.getDynamicObjectCollection("workcalendar");
        return InterestCalHelper.updatePlanListByAdjustRule(callResults, payIntRule, workCalendars);
    }

    private static Pair<BigDecimal, List<IntBillExtInfo>> genIntPlan(DynamicObject bill, List<PlanCallResult> intPlanList, Date startDate) {
        ArrayList<IntBillExtInfo> list = new ArrayList<IntBillExtInfo>(10);
        RepaymentWayEnum repayWay = RepaymentWayEnum.valueOf((String)bill.getString("repaymentway"));
        IntHTRuleEnum intHTRule = IntHTRuleEnum.headnotail;
        BigDecimal principle = bill.getBigDecimal("amount");
        List<RateExtInfo> rateList = InterestCalHelper.getRateList(bill, null);
        List<PlanCallResult> repayPlanList = InterestCalHelper.getAllRepayPlanList(bill, true);
        boolean isDebx = RepaymentWayEnum.debx.getValue().equals(bill.getString("repaymentway"));
        if (isDebx) {
            InterestCalHelper.initDebxPrinciple(repayPlanList);
        }
        List<RateExtInfo> floatRateList = InterestCalHelper.getFloatRateList(bill, rateList);
        BigDecimal totalAmt = BigDecimal.ZERO;
        intPlanList.sort(Comparator.comparing(PlanCallResult::getBizDate));
        int size = intPlanList.size();
        for (int index = 0; index < size; ++index) {
            BigDecimal amount;
            Date beginDate = startDate;
            PlanCallResult intPlan = intPlanList.get(index);
            Date endDate = intPlan.getBizDate();
            InterestCalcParam calcParam = InterestCalcParam.build(repayPlanList, rateList, beginDate, endDate, principle, index + 1, repayWay, intHTRule, false).setLastTotalInt(BigDecimal.ZERO).setFloatRateList(floatRateList);
            IntBillExtInfo intBillExt = InterestCalHelper.callLoanBillInt(bill, calcParam);
            if (null == intBillExt) continue;
            List<IntBillExtInfo.IntBillDetailExtInfo> details = intBillExt.getExtDetails();
            if (endDate.compareTo(intBillExt.getBizDate()) != 0) {
                intBillExt.setBizDate(endDate);
            }
            if (isDebx && EmptyUtil.isNoEmpty(details)) {
                repayPlanList.get(index).setPrinciple(details.get(0).getPrinciple());
            }
            if (EmptyUtil.isNoEmpty((BigDecimal)(amount = intBillExt.getAmount()))) {
                list.add(intBillExt);
                totalAmt = totalAmt.add(amount);
            }
            if (!intPlan.getBizDate().after(startDate)) continue;
            startDate = DateUtils.getNextDay((Date)intBillExt.getEndDate(), (int)1);
        }
        return Pair.of((Object)totalAmt, list);
    }

    private static IntBillExtInfo callLoanBillInt(DynamicObject bill, InterestCalcParam calcParam) {
        IntBillExtInfo intBillExt = InterestCalHelper.callLoanInt(bill, calcParam);
        if (intBillExt == null) {
            return null;
        }
        if (!InterestCalHelper.isSofrRate(bill)) {
            return intBillExt;
        }
        return InterestCalHelper.callLoanBillSofrInt(bill, calcParam);
    }

    private static IntBillExtInfo callLoanBillSofrInt(DynamicObject loanBill, InterestCalcParam calcParam) {
        IntBillExtInfo intBillExt;
        boolean isObserve = InterestCalHelper.isObserve(loanBill);
        if (isObserve) {
            calcParam.setScale(10);
        }
        if ((intBillExt = InterestCalHelper.callLoanInt(loanBill, calcParam)) == null) {
            return null;
        }
        InterestCalHelper.mergeFloatRateIntDetail(loanBill, calcParam, calcParam.getFloatRateList(), intBillExt);
        if (isObserve) {
            InterestCalHelper.calIntByObserve(loanBill, intBillExt);
            calcParam.setScale(null);
        } else {
            intBillExt.setAmount(intBillExt.getAmount().add(intBillExt.getFloatInt()));
            InterestCalHelper.updateComfirmDateNotObserve(loanBill, intBillExt.getExtDetails());
        }
        return intBillExt;
    }

    private static void updateComfirmDateNotObserve(DynamicObject bill, List<IntBillExtInfo.IntBillDetailExtInfo> extDetails) {
        DynamicObjectCollection workCalendars = bill.getDynamicObjectCollection("workcalendar");
        if (workCalendars == null) {
            return;
        }
        int rateResetDays = bill.getInt("rateresetdays");
        int size = extDetails.size();
        for (int i = 0; i < size; ++i) {
            IntBillExtInfo.IntBillDetailExtInfo detail = extDetails.get(i);
            detail.setObserveOffsetDay(1);
            Date beginDate = detail.getBeginDate();
            Date confirmDate = RateAdjustHelper.getConfirmDateByRateRestDays(workCalendars, rateResetDays, beginDate);
            detail.setBeginConfirmDate(confirmDate);
            Date endDate = DateUtils.getNextDay((Date)detail.getEndDate(), (int)1);
            detail.setEndConfirmDate(RateAdjustHelper.getConfirmDateByRateRestDays(workCalendars, rateResetDays, endDate));
        }
    }

    private static void calIntByObserve(DynamicObject bill, IntBillExtInfo intBillExt) {
        DynamicObjectCollection workCalendars = bill.getDynamicObjectCollection("workcalendar");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)workCalendars)) {
            return;
        }
        boolean isCompInt = IntCalMethodEnum.isCompcallint((String)bill.getString("intcalmethod"));
        boolean needReCalcInt = false;
        int scale = bill.getDynamicObject("currency").getInt("amtprecision");
        int rateResetDays = bill.getInt("rateresetdays");
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal lastTotalInt = BigDecimal.ZERO;
        List<IntBillExtInfo.IntBillDetailExtInfo> details = intBillExt.getExtDetails();
        int size = details.size();
        for (int i = 0; i < size; ++i) {
            IntBillExtInfo.IntBillDetailExtInfo detail = details.get(i);
            int days = detail.getDays();
            Date beginDate = detail.getBeginDate();
            Date confirmDate = RateAdjustHelper.getConfirmDateByRateRestDays(workCalendars, rateResetDays, beginDate);
            detail.setBeginConfirmDate(confirmDate);
            Date endDate = DateUtils.getNextDay((Date)detail.getEndDate(), (int)1);
            detail.setEndConfirmDate(RateAdjustHelper.getConfirmDateByRateRestDays(workCalendars, rateResetDays, endDate));
            detail.setObserveOffsetDay(1);
            int confirmDays = detail.getConfirmDays();
            BigDecimal amount = detail.getAmount();
            if (days != confirmDays) {
                BigDecimal dayDivice = BigDecimal.valueOf(confirmDays).divide(BigDecimal.valueOf(days), 10, 4);
                amount = dayDivice.multiply(amount).setScale(scale, RoundingMode.HALF_UP);
                needReCalcInt = true;
            } else {
                amount = amount.setScale(scale, RoundingMode.HALF_UP);
            }
            if (isCompInt && needReCalcInt) {
                BasisEnum basis = detail.getBasisDay() == 365 ? BasisEnum.Actual_365 : BasisEnum.Actual_360;
                Date endConfirmDate = DateUtils.getLastDay((Date)detail.getEndConfirmDate(), (int)1);
                CalcIntInfo calcIntInfo = CalcIntInfo.build((Date)detail.getBeginConfirmDate(), (Date)endConfirmDate, (BigDecimal)detail.getPrinciple(), (BigDecimal)detail.getRate(), (BasisEnum)basis, (IntCalMethodEnum)IntCalMethodEnum.compcallint);
                calcIntInfo.setLastTotalInt(lastTotalInt);
                amount = calcIntInfo.callCompInt(scale, 4);
            }
            detail.setAmount(amount);
            totalAmount = totalAmount.add(amount);
            detail.setLastTotalInt(lastTotalInt);
            lastTotalInt = lastTotalInt.add(amount);
        }
        intBillExt.setAmount(totalAmount.add(intBillExt.getFloatInt()));
    }

    public static boolean isObserve(DynamicObject bill) {
        return LookBackTypeEnum.isObserve(bill.getString("lookbacktype"));
    }

    private static void mergeFloatRateIntDetail(DynamicObject loanBill, InterestCalcParam calcParam, List<RateExtInfo> floatRateList, IntBillExtInfo intBill) {
        List<IntBillExtInfo.IntBillDetailExtInfo> details = intBill.getExtDetails();
        if (EmptyUtil.isEmpty(details) || EmptyUtil.isEmpty(floatRateList)) {
            return;
        }
        BigDecimal floatRate = floatRateList.get(0).getRate();
        Date beginDate = intBill.getBeginDate();
        InterestCalcParam param = calcParam.clone().setSofrFloatInt(true).setScale(10).setPeriod(0).setRateList(Collections.singletonList(RateExtInfo.build(beginDate, floatRate))).setLastTotalInt(BigDecimal.ZERO);
        IntBillInfo floatIntBill = InterestCalHelper.calcLoanBillInt(loanBill, param);
        if (floatIntBill == null) {
            return;
        }
        int days = 0;
        for (IntBillDetailInfo detail : floatIntBill.getDetails()) {
            days += detail.getDays();
        }
        int scale = loanBill.getDynamicObject("currency").getInt("amtprecision");
        int roundingMode = 4;
        BigDecimal floatAmount = BigDecimal.ZERO;
        BigDecimal divideAmount = floatIntBill.getAmount().divide(BigDecimal.valueOf(days), 10, 4);
        for (IntBillExtInfo.IntBillDetailExtInfo detail : details) {
            detail.setFloatRate(floatRate);
            BigDecimal floatInt = divideAmount.multiply(BigDecimal.valueOf(detail.getDays())).setScale(scale, roundingMode);
            detail.setFloatInt(floatInt);
            floatAmount = floatAmount.add(floatInt);
        }
        intBill.setFloatInt(floatAmount.setScale(scale, roundingMode));
    }

    private static IntBillInfo calcLoanBillInt(DynamicObject loanBill, InterestCalcParam param) {
        IntCalRequest request = new IntCalRequest();
        request.setRepayList(param.getRepayPlanList());
        BizBillInfo bizBill = InterestCalHelper.getBizBill(loanBill, param);
        request.setBizBill(bizBill);
        request.setRateList(RateExtInfo.convertRateInfo(param.getRateList()));
        request.setPreInt(param.isPreInt());
        InterestCalHelper.verifyInput(request);
        IIntCallStragety stragety = IntCallFactory.getInstance((RepaymentWayEnum)bizBill.getRepayWay());
        return stragety.callInt(request);
    }

    private static void verifyInput(IntCalRequest request) {
        Date beginDate = request.getBizBill().getBeginDate();
        for (RateInfo rate : request.getRateList()) {
            if (rate.getEffectiveDate().compareTo(beginDate) > 0) continue;
            return;
        }
        throw new TmcBizException(TmcErrorCode.COMMON, new Object[]{ResManager.loadKDString((String)"\u5229\u606f\u8ba1\u7b97\u5f00\u59cb\u65e5\u5fc5\u987b\u8981\u6709\u53ef\u7528\u5229\u7387", (String)"InterestCalHelper_0", (String)"tmc-mrm-common", (Object[])new Object[0])});
    }

    private static IntBillExtInfo callLoanInt(DynamicObject bill, InterestCalcParam calcParam) {
        Date expireDate;
        Date endDate = calcParam.getEndDate();
        Date callDate = endDate.after(expireDate = bill.getDate("enddate")) ? expireDate : endDate;
        IntBillInfo narmalInt = InterestCalHelper.calcLoanBillInt(bill, calcParam.clone().setEndDate(callDate));
        if (EmptyUtil.isNoEmpty((Object)narmalInt)) {
            InterestCalHelper.setCallIntDate(narmalInt);
        }
        if (EmptyUtil.isEmpty((Object)narmalInt)) {
            return null;
        }
        return IntBillExtInfo.clone(narmalInt);
    }

    private static void setCallIntDate(IntBillInfo intBill) {
        List detailList = intBill.getDetails();
        IntBillDetailInfo detail = detailList.stream().min(Comparator.comparing(v -> v.getBeginDate())).orElse(null);
        if (EmptyUtil.isNoEmpty((Object)detail)) {
            intBill.setBeginDate(detail.getBeginDate());
        }
        if (EmptyUtil.isNoEmpty((Object)(detail = (IntBillDetailInfo)detailList.stream().max(Comparator.comparing(v -> v.getEndDate())).orElse(null)))) {
            intBill.setEndDate(detail.getEndDate());
        }
    }

    private static List<RateExtInfo> getFloatRateList(DynamicObject bill, List<RateExtInfo> rateList) {
        ArrayList<RateExtInfo> floatRateList = new ArrayList<RateExtInfo>(rateList.size());
        boolean isSofrRate = InterestCalHelper.isSofrRate(bill);
        BigDecimal rateFloatPoint = bill.getBigDecimal("basepoint");
        if (!isSofrRate) {
            return floatRateList;
        }
        rateFloatPoint = rateFloatPoint.divide(Constants.ONE_HUNDRED);
        for (RateExtInfo rateInfo : rateList) {
            RateExtInfo floatRate = RateExtInfo.clone(rateInfo);
            floatRate.setConfirmDate(rateInfo.getConfirmDate());
            floatRate.setRate(rateFloatPoint);
            floatRateList.add(floatRate);
            rateInfo.setRate(rateInfo.getNormalRate());
        }
        return floatRateList;
    }

    public static boolean isSofrRate(DynamicObject bill) {
        return bill.getBoolean("issofrrate");
    }

    private static List<PlanCallResult> initDebxPrinciple(List<PlanCallResult> repayList) {
        for (PlanCallResult repayPlan : repayList) {
            repayPlan.setPrinciple(BigDecimal.ZERO);
        }
        return repayList;
    }

    private static List<RateExtInfo> getRateList(DynamicObject loanBill, Date overDate) {
        Date endDate = loanBill.getDate("enddate");
        BigDecimal rateFloatPoint = loanBill.getBigDecimal("basepoint");
        rateFloatPoint = rateFloatPoint != null ? rateFloatPoint.divide(Constants.ONE_HUNDRED) : BigDecimal.ZERO;
        Pair endRate = null;
        HashMap<Date, RateExtInfo> rateMap = new HashMap<Date, RateExtInfo>(10);
        DynamicObjectCollection rates = loanBill.getDynamicObjectCollection("rateadjustentry");
        for (DynamicObject rateInfo : rates) {
            Date confirmDate;
            RateExtInfo info = new RateExtInfo();
            Date effectDate = confirmDate = rateInfo.getDate("raconfirmdate");
            info.setEffectiveDate(effectDate);
            info.setConfirmDate(confirmDate);
            info.setRate(rateInfo.getBigDecimal("rarate"));
            info.setFloatRate(rateFloatPoint);
            BigDecimal rate = info.getRate().subtract(rateFloatPoint);
            rate = rate.compareTo(BigDecimal.ZERO) >= 0 ? rate : BigDecimal.ZERO;
            info.setNormalRate(rate);
            rateMap.put(effectDate, info);
            if (endRate == null) {
                endRate = Pair.of((Object)info.getEffectiveDate(), (Object)rate);
                continue;
            }
            if (info.getEffectiveDate().compareTo(endDate) > 0 || !((Date)endRate.getKey()).before(info.getEffectiveDate())) continue;
            endRate = Pair.of((Object)info.getEffectiveDate(), (Object)rate);
        }
        return new ArrayList<RateExtInfo>(rateMap.values());
    }

    private static List<PlanCallResult> getAllRepayPlanList(DynamicObject loanBill, boolean isContainRepayBill) {
        ArrayList<PlanCallResult> repayPlanList = new ArrayList<PlanCallResult>(10);
        DynamicObjectCollection colls = loanBill.getDynamicObjectCollection("capcashflowentry");
        for (DynamicObject repayPlan : colls) {
            PlanCallResult info = new PlanCallResult();
            info.setBizDate(repayPlan.getDate("capdate"));
            info.setPrinciple(repayPlan.getBigDecimal("capamount"));
            repayPlanList.add(info);
        }
        return repayPlanList;
    }

    private static BizBillInfo getBizBill(DynamicObject bill, InterestCalcParam param) {
        DynamicObject instSettledPlan;
        BizBillInfo bizBill = new BizBillInfo();
        bizBill.setLoanAmount(param.getPrinciple());
        bizBill.setBeginDate(param.getBeginDate());
        bizBill.setEndDate(param.getEndDate());
        DynamicObject stagePlan = bill.getDynamicObject("stageplan");
        if (EmptyUtil.isNoEmpty((DynamicObject)stagePlan)) {
            bizBill.setRepaySchemeId(stagePlan.getLong("id"));
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(instSettledPlan = bill.getDynamicObject("interestsettledplan")))) {
            bizBill.setIntSchemeId(instSettledPlan.getLong("id"));
        }
        bizBill.setRepayWay(param.getRepayWay());
        bizBill.setBasis(BasisEnum.getEnum((String)bill.getString("basis")));
        bizBill.setCurrencyId(bill.getDynamicObject("currency").getLong("id"));
        bizBill.setPeriod(param.getPeriod());
        SettleIntModeEnum settleMode = SettleIntModeEnum.valueOf((String)bill.getString("settleintmode"));
        bizBill.setSettleIntMode(settleMode);
        IntCalMethodEnum intCalMethod = IntCalMethodEnum.valueOf((String)bill.getString("intcalmethod"));
        bizBill.setIntCalMethod(param.isSofrFloatInt() ? IntCalMethodEnum.totalcallint : intCalMethod);
        bizBill.setHtRule(param.getIntHTRule());
        bizBill.setLastTotalInt(param.getLastTotalInt());
        bizBill.setScale(param.getScale());
        return bizBill;
    }
}

