/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.common.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.tmc.fbp.common.enums.CompanySysAuthScopeEnum;
import kd.tmc.fbp.common.enums.CompanySysAuthTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class OrgHelper {
    private OrgHelper() {
    }

    public static List<Long> getPermOrgIds(DynamicObject orgView, DynamicObjectCollection orgCol, String orgFunc, String appId, String entityNum) {
        if (EmptyUtil.isNoEmpty((DynamicObject)orgView) && orgView.containsProperty("treetypeid")) {
            DynamicObject treeType = orgView.getDynamicObject("treetypeid");
            orgFunc = treeType.getString("fnumber");
        } else if (orgFunc == null) {
            orgFunc = "15";
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)orgCol)) {
            return orgCol.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)orgView)) {
            Long orgViewId = orgView.getLong("id");
            return OrgHelper.getPermOrgIds(orgFunc, orgViewId, appId, entityNum);
        }
        return OrgHelper.getAllPermOrgIds(orgFunc, appId, entityNum);
    }

    private static List<Long> getPermOrgIds(String orgFunc, Long orgViewId, String appId, String entityNum) {
        DataSet orgDateSet = OrgHelper.getOrgDateSet(orgFunc, orgViewId);
        List<Long> allPermOrgIds = OrgHelper.getAllPermOrgIds(orgFunc, appId, entityNum);
        if (allPermOrgIds != null) {
            orgDateSet = orgDateSet.filter("orgid in orgIdList", Collections.singletonMap("orgIdList", allPermOrgIds));
        }
        ArrayList<Long> ids = new ArrayList<Long>(16);
        while (orgDateSet.hasNext()) {
            ids.add(orgDateSet.next().getLong("orgid"));
        }
        return ids;
    }

    private static DataSet getOrgDateSet(String orgFunc, Long orgViewId) {
        DataSet orgDataSet = QueryServiceHelper.queryDataSet((String)"tree-org", (String)"bos_org_structure", (String)"org orgid", (QFilter[])new QFilter[]{new QFilter("view.treetype", "=", (Object)orgFunc), new QFilter("view", "=", (Object)orgViewId)}, (String)"sortcode");
        return orgDataSet;
    }

    private static List<Long> getAllPermOrgIds(String orgFunc, String appId, String entityNum) {
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)orgFunc, (String)appId, (String)entityNum, (String)"47150e89000000ac");
        return result.hasAllOrgPerm() ? null : result.getHasPermOrgs();
    }

    public static DataSet getAuthorizedBankOrgViewDataSet(Long userId) {
        QFilter allOrSelf = new QFilter("enable", "=", (Object)"1");
        QFilter all = new QFilter("scope", "=", (Object)CompanySysAuthScopeEnum.ALL.getValue());
        QFilter self = new QFilter("scope", "=", (Object)CompanySysAuthScopeEnum.SELF.getValue()).and("creator", "=", (Object)userId);
        allOrSelf.and(all.or(self));
        DataSet allAndSelfDataSet = QueryServiceHelper.queryDataSet((String)"TmcBusinessBaseHelperfbd_companysysviewsch", (String)"fbd_companysysviewsch", (String)"id", (QFilter[])allOrSelf.toArray(), null);
        QFilter user = new QFilter("authtype", "=", (Object)CompanySysAuthTypeEnum.USER.getValue()).and("authuser", "=", (Object)userId);
        Set roles = PermissionServiceHelper.getRolesByUser((Long)userId);
        QFilter role = new QFilter("authtype", "=", (Object)CompanySysAuthTypeEnum.ROLE.getValue()).and("authrole", "in", (Object)roles);
        QFilter userOrRole = user.or(role);
        DataSet userAndRoleDataSet = QueryServiceHelper.queryDataSet((String)"TmcBusinessBaseHelperfbd_companysysauth", (String)"fbd_companysysauth", (String)"companysysview.id as id", (QFilter[])userOrRole.toArray(), null);
        DataSet dataSet = null;
        if (!allAndSelfDataSet.isEmpty() && !userAndRoleDataSet.isEmpty()) {
            dataSet = allAndSelfDataSet.union(userAndRoleDataSet).distinct();
        } else if (!allAndSelfDataSet.isEmpty()) {
            dataSet = allAndSelfDataSet;
        } else if (!userAndRoleDataSet.isEmpty()) {
            dataSet = userAndRoleDataSet;
        }
        return dataSet;
    }
}

