/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.helper.MarketDataServiceHelper;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.WorkCalendarHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mrm.common.bean.FloatRateCalBean;
import kd.tmc.mrm.common.bean.RateAdjustBean;
import kd.tmc.mrm.common.enums.RateAdjustCycleTypeEnum;
import kd.tmc.mrm.common.enums.RateAdjustStyleEnum;

public class RateAdjustHelper {
    public static void updateRateAdjustList(DynamicObject loanBill) {
        DynamicObjectCollection rateAdjustEntry = loanBill.getDynamicObjectCollection("rateadjustentry");
        List<RateAdjustBean> rateAdjustList = RateAdjustHelper.getRateAdjustList(loanBill);
        if (rateAdjustList != null && !rateAdjustList.isEmpty()) {
            rateAdjustEntry.clear();
            int seq = 1;
            rateAdjustList.sort(Comparator.comparing(RateAdjustBean::getEffectDate));
            for (RateAdjustBean rateAdjustBean : rateAdjustList) {
                DynamicObject rateAdjustEntryDo = rateAdjustEntry.addNew();
                rateAdjustEntryDo.set("seq", (Object)seq++);
                rateAdjustEntryDo.set("raconfirmdate", (Object)rateAdjustBean.getConfirmDate());
                rateAdjustEntryDo.set("rarate", (Object)rateAdjustBean.getYearRate());
                rateAdjustEntryDo.set("ramodifydate", (Object)rateAdjustBean.getModifyDate());
            }
        }
    }

    private static List<RateAdjustBean> getRateAdjustList(DynamicObject loanbill) {
        List<RateAdjustBean> rateAdjustBeanList = null;
        Date actStartIntDate = loanbill.getDate("interestdate");
        String interestType = loanbill.getString("ratetype");
        if (InterestTypeEnum.FLOAT.getValue().equals(interestType)) {
            rateAdjustBeanList = RateAdjustHelper.adjustRateByFloatRate(loanbill, actStartIntDate);
        } else if (InterestTypeEnum.FIXED.getValue().equals(interestType)) {
            rateAdjustBeanList = RateAdjustHelper.adjustRateByFixedRate(loanbill, actStartIntDate);
        }
        return rateAdjustBeanList;
    }

    private static List<RateAdjustBean> adjustRateByFloatRate(DynamicObject loanbill, Date actStartIntDate) {
        ArrayList<RateAdjustBean> rateAdjustBeanList = new ArrayList<RateAdjustBean>(10);
        int rateResetDays = loanbill.getInt("rateresetdays");
        ArrayList<FloatRateCalBean> floatRateBizSegmBeans = new ArrayList<FloatRateCalBean>(4);
        RateAdjustHelper.dealFloatRateAdjustList(floatRateBizSegmBeans, loanbill, actStartIntDate, rateResetDays);
        floatRateBizSegmBeans.sort(Comparator.comparing(FloatRateCalBean::getStartDate));
        for (FloatRateCalBean floatRateSegBean : floatRateBizSegmBeans) {
            List<RateAdjustBean> rateAdjustBeans = RateAdjustHelper.dealRowAdjustRate(floatRateSegBean, rateResetDays, loanbill);
            Date startDate = floatRateSegBean.getStartDate();
            for (RateAdjustBean rateAdjustBean : rateAdjustBeans) {
                RateAdjustHelper.definListAdd(rateAdjustBeanList, rateAdjustBean);
            }
        }
        return rateAdjustBeanList;
    }

    private static List<RateAdjustBean> dealRowAdjustRate(FloatRateCalBean floatRateSegBean, int rateResetDays, DynamicObject loanBill) {
        Date effectBeginDate = floatRateSegBean.getStartDate();
        Date endDate = floatRateSegBean.getEndDate();
        Date beginConfirmDate = floatRateSegBean.getConfirmDate();
        Date endConfirmDate = DateUtils.getLastDay((Date)endDate, (int)rateResetDays);
        Map rateDatas = MarketDataServiceHelper.referRate((String)floatRateSegBean.getRefrateNum(), (Date)DateUtils.getLastDay((Date)beginConfirmDate, (int)7), (Date)endDate);
        if (EmptyUtil.isEmpty((Object)rateDatas)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u57fa\u7840\u8d44\u6599\u5e94\u7528\u4e0b\u7684\u53c2\u8003\u5229\u7387\u6570\u636e\u3002", (String)"RateAdjustHelper_0", (String)"tmc-mrm-common", (Object[])new Object[0]));
        }
        String rateAdjustStyle = floatRateSegBean.getRateAdjustStyle();
        BigDecimal rateFloatPoint = floatRateSegBean.getRateBasePoint();
        BigDecimal rateFloat = rateFloatPoint.divide(new BigDecimal("100"), 6, RoundingMode.HALF_UP);
        BigDecimal firstEffectYearRate = RateAdjustHelper.getEffectYearRate(rateDatas, beginConfirmDate, rateFloat);
        if (EmptyUtil.isEmpty((BigDecimal)firstEffectYearRate)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u57fa\u7840\u8d44\u6599\u5e94\u7528\u4e0b\u7684\u53c2\u8003\u5229\u7387\u6570\u636e\u3002", (String)"RateAdjustHelper_0", (String)"tmc-mrm-common", (Object[])new Object[0]));
        }
        ArrayList<RateAdjustBean> rateAdjustBeanList = new ArrayList<RateAdjustBean>(16);
        Date adjustDate = floatRateSegBean.getFirstAdjustDate();
        if (!RateAdjustStyleEnum.isCycle(rateAdjustStyle) || RateAdjustStyleEnum.isCycle(rateAdjustStyle) && adjustDate.compareTo(effectBeginDate) >= 0) {
            RateAdjustHelper.definListAdd(rateAdjustBeanList, new RateAdjustBean(effectBeginDate, beginConfirmDate, firstEffectYearRate));
        }
        if (RateAdjustStyleEnum.isDeadline(rateAdjustStyle)) {
            RateAdjustHelper.dealRowAdjustRateByDeadline(rateAdjustBeanList, rateResetDays, beginConfirmDate, endConfirmDate, rateDatas, rateFloat);
        } else if (RateAdjustStyleEnum.isCycle(rateAdjustStyle)) {
            RateAdjustHelper.dealRowAdjustRateByCycle(rateAdjustBeanList, floatRateSegBean, rateResetDays, loanBill, endDate, rateDatas, rateFloat);
        }
        return RateAdjustHelper.updateEffectDateByRateResetAdjustRule(loanBill, rateDatas, rateFloat, rateAdjustBeanList);
    }

    private static List<RateAdjustBean> updateEffectDateByRateResetAdjustRule(DynamicObject loanBill, Map<Date, BigDecimal> rateDatas, BigDecimal rateFloat, List<RateAdjustBean> rateAdjustList) {
        String rateResetRule = loanBill.getString("rateresetadjustrule");
        if (EmptyUtil.isBlank((CharSequence)rateResetRule) || AdjustMethodEnum.no_adjust.getValue().equals(rateResetRule)) {
            return rateAdjustList;
        }
        DynamicObjectCollection workCalendars = loanBill.getDynamicObjectCollection("workcalendar");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)workCalendars)) {
            return rateAdjustList;
        }
        boolean isSofr = loanBill.getBoolean("issofrrate");
        int rateResetDays = loanBill.getInt("rateresetdays");
        AdjustMethodEnum adjustMethod = AdjustMethodEnum.valueOf((String)rateResetRule);
        ArrayList<Date> list = new ArrayList<Date>(rateAdjustList.size());
        Iterator<RateAdjustBean> iterator = rateAdjustList.iterator();
        while (iterator.hasNext()) {
            Date confirmDate;
            RateAdjustBean rateAdjustBean = iterator.next();
            Date effectDate = rateAdjustBean.getEffectDate();
            if (isSofr && rateResetDays > 0) {
                confirmDate = RateAdjustHelper.getConfirmDateByRateRestDays(workCalendars, rateResetDays, effectDate);
            } else {
                confirmDate = DateUtils.getLastDay((Date)effectDate, (int)rateResetDays);
                confirmDate = TermHelper.callAdjustSettleDate((DynamicObjectCollection)workCalendars, (Date)confirmDate, (AdjustMethodEnum)adjustMethod);
            }
            if (list.contains(confirmDate)) {
                iterator.remove();
                continue;
            }
            list.add(confirmDate);
            rateAdjustBean.setConfirmDate(confirmDate);
            rateAdjustBean.setYearRate(RateAdjustHelper.getEffectYearRate(rateDatas, confirmDate, rateFloat));
        }
        return rateAdjustList;
    }

    public static Date getConfirmDateByRateRestDays(DynamicObjectCollection workCalendars, int rateResetDays, Date confirmDate) {
        int resetDays = rateResetDays;
        while (resetDays > 0) {
            if (!WorkCalendarHelper.isWorkDay((DynamicObjectCollection)workCalendars, (Date)(confirmDate = DateUtils.getLastDay((Date)confirmDate, (int)1)))) continue;
            --resetDays;
        }
        return confirmDate;
    }

    private static void definListAdd(List<RateAdjustBean> rateAdjustBeanList, RateAdjustBean needAddObj) {
        List theSameRateAdjusts;
        if (EmptyUtil.isNoEmpty(rateAdjustBeanList) && EmptyUtil.isNoEmpty(theSameRateAdjusts = rateAdjustBeanList.stream().filter(o -> o.getEffectDate().compareTo(needAddObj.getEffectDate()) == 0).collect(Collectors.toList()))) {
            rateAdjustBeanList.removeAll(theSameRateAdjusts);
        }
        rateAdjustBeanList.add(needAddObj);
    }

    private static void dealRowAdjustRateByCycle(List<RateAdjustBean> rateAdjustBeanList, FloatRateCalBean floatRateSegBean, int rateResetDays, DynamicObject loanBill, Date endDate, Map<Date, BigDecimal> rateDatas, BigDecimal rateFloat) {
        int rateAdjustCycle;
        String rateAdjustCycleType;
        Date rateAdjustDate = floatRateSegBean.getFirstAdjustDate();
        List<Date> cycleDateList = RateAdjustHelper.getCycleDateList(rateAdjustDate, endDate, rateAdjustCycleType = floatRateSegBean.getRateAdjustType(), rateAdjustCycle = floatRateSegBean.getRateAdjustCycle().intValue());
        if (EmptyUtil.isEmpty(cycleDateList)) {
            return;
        }
        for (Date effectDate : cycleDateList) {
            Date confirmDate = DateUtils.getLastDay((Date)effectDate, (int)rateResetDays);
            BigDecimal confirmCurrRate = RateAdjustHelper.getEffectYearRate(rateDatas, confirmDate, rateFloat);
            RateAdjustHelper.definListAdd(rateAdjustBeanList, new RateAdjustBean(effectDate, confirmDate, confirmCurrRate));
        }
    }

    public static List<Date> getCycleDateList(Date beginDate, Date endDate, String rateAdjustCycleType, int rateAdjustCycle) {
        if (beginDate.after(endDate)) {
            return Collections.EMPTY_LIST;
        }
        RateAdjustCycleTypeEnum cycleTypeEnum = RateAdjustCycleTypeEnum.getByValue(rateAdjustCycleType);
        if (cycleTypeEnum == null || EmptyUtil.isEmpty((Integer)rateAdjustCycle)) {
            return Collections.singletonList(beginDate);
        }
        switch (cycleTypeEnum) {
            case D: {
                return RateAdjustHelper.getDayCycList(beginDate, endDate, rateAdjustCycle);
            }
            case W: {
                return RateAdjustHelper.getWeekCycList(beginDate, endDate, rateAdjustCycle);
            }
            case M: {
                return RateAdjustHelper.getMonthCycList(beginDate, endDate, rateAdjustCycle);
            }
        }
        return Collections.singletonList(beginDate);
    }

    public static List<Date> getMonthCycList(Date startDate, Date endDate, int monthCycle) {
        ArrayList<Date> cycleDateList = new ArrayList<Date>(10);
        if (EmptyUtil.isEmpty((Integer)monthCycle)) {
            return cycleDateList;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        int dateNum = cal.get(5);
        while (startDate.compareTo(endDate) <= 0) {
            cycleDateList.add(startDate);
            cal.add(2, monthCycle);
            int actualMaximum = cal.getActualMaximum(5);
            if (actualMaximum < dateNum) {
                cal.set(5, actualMaximum);
            } else {
                cal.set(5, dateNum);
            }
            startDate = cal.getTime();
        }
        return cycleDateList;
    }

    private static List<Date> getWeekCycList(Date startDate, Date endDate, int weekCycle) {
        ArrayList<Date> cycleDateList = new ArrayList<Date>(10);
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        while (startDate.compareTo(endDate) <= 0) {
            cycleDateList.add(startDate);
            cal.set(4, cal.get(4) + weekCycle);
            startDate = cal.getTime();
        }
        return cycleDateList;
    }

    private static List<Date> getDayCycList(Date startDate, Date endDate, int dayCycle) {
        ArrayList<Date> cycleDateList = new ArrayList<Date>(10);
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        while (startDate.compareTo(endDate) <= 0) {
            cycleDateList.add(startDate);
            cal.add(5, dayCycle);
            startDate = cal.getTime();
        }
        return cycleDateList;
    }

    private static void dealRowAdjustRateByDeadline(List<RateAdjustBean> rateAdjustBeanList, int rateResetDays, Date beginConfirmDate, Date endConfirmDate, Map<Date, BigDecimal> rateDatas, BigDecimal rateFloat) {
        TreeMap<Date, BigDecimal> deadLineRates = new TreeMap<Date, BigDecimal>(Date::compareTo);
        for (Map.Entry<Date, BigDecimal> entry : rateDatas.entrySet()) {
            Date key = entry.getKey();
            if (key.compareTo(beginConfirmDate) <= 0 || key.compareTo(endConfirmDate) >= 0) continue;
            deadLineRates.put(key, entry.getValue());
        }
        if (EmptyUtil.isEmpty(deadLineRates)) {
            return;
        }
        BigDecimal tempRate = rateAdjustBeanList.get(0).getYearRate().subtract(rateFloat);
        for (Map.Entry entry : deadLineRates.entrySet()) {
            if (((BigDecimal)entry.getValue()).compareTo(tempRate) == 0) continue;
            tempRate = (BigDecimal)entry.getValue();
            Date confirmDate = (Date)entry.getKey();
            Date effectDate = DateUtils.getNextDay((Date)confirmDate, (int)rateResetDays);
            RateAdjustHelper.definListAdd(rateAdjustBeanList, new RateAdjustBean(effectDate, confirmDate, tempRate.add(rateFloat)));
        }
    }

    private static BigDecimal getEffectYearRate(Map<Date, BigDecimal> refRates, Date effectRate, BigDecimal rateFloatPoint) {
        AtomicReference<BigDecimal> rate = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        refRates.entrySet().stream().filter(o -> ((Date)o.getKey()).compareTo(effectRate) <= 0).max(Comparator.comparing(Map.Entry::getKey)).ifPresent(o -> rate.set(((BigDecimal)o.getValue()).add(rateFloatPoint)));
        return rate.get();
    }

    private static void dealFloatRateAdjustList(List<FloatRateCalBean> floatRateBizSegmBeans, DynamicObject bill, Date beginDate, int rateResetDays) {
        String rateAdjustStyle = RateAdjustStyleEnum.CYCLE.getValue();
        Date endDate = bill.getDate("enddate");
        Date rateAdjustDate = bill.getDate("rateadjustdate");
        FloatRateCalBean floatRate = new FloatRateCalBean();
        floatRate.setConfirmDate(DateUtils.getLastDay((Date)beginDate, (int)rateResetDays));
        floatRate.setStartDate(beginDate);
        floatRate.setEndDate(endDate);
        floatRate.setRefrateNum(bill.getDynamicObject("referencerate").getString("number"));
        floatRate.setRateAdjustStyle(rateAdjustStyle);
        floatRate.setFirstAdjustDate(rateAdjustDate);
        floatRate.setFirstAdjust(true);
        floatRate.setRateAdjustType(bill.getString("rateadjustcycletype"));
        floatRate.setRateAdjustCycle(bill.getInt("rateadjustcycle"));
        floatRate.setRateBasePoint(bill.getBigDecimal("basepoint"));
        floatRateBizSegmBeans.add(floatRate);
    }

    private static List<RateAdjustBean> adjustRateByFixedRate(DynamicObject loanbill, Date actStartIntDate) {
        ArrayList<RateAdjustBean> rateAdjustBeanList = new ArrayList<RateAdjustBean>(10);
        RateAdjustHelper.definListAdd(rateAdjustBeanList, new RateAdjustBean(actStartIntDate, actStartIntDate, loanbill.getBigDecimal("fixrate")));
        return rateAdjustBeanList;
    }
}

