/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.common.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mrm.common.enums.RateBillTypeEnum;
import kd.tmc.mrm.common.enums.RateTypeEnum;
import kd.tmc.mrm.common.helper.DataGetDefFilterHelper;

public class RateDraftHelper {
    private static List<String> IGNORE_PREVIEW_LIST = new ArrayList<String>(6);

    public static Map<String, Object> genRateDraftDataExample(DynamicObject draftConfig) {
        return RateDraftHelper.genDraftDataExample(draftConfig, "mrm_rate_draft_data", "mrm_rate_draft", "ratedraft", 3);
    }

    public static Map<String, Object> genExRateDraftDataExample(DynamicObject draftConfig) {
        return RateDraftHelper.genDraftDataExample(draftConfig, "mrm_exrate_draft_data", "mrm_exrate_draft", "exratedraft", 1);
    }

    private static boolean isIgnorePreview(String source) {
        return IGNORE_PREVIEW_LIST.contains(source);
    }

    public static Map<String, Object> genDraftDataExample(DynamicObject draftConfig, String draftDataEntity, String draftentity, String draftName, int max) {
        DynamicObjectCollection entries = draftConfig.getDynamicObjectCollection("entryentity");
        DynamicObject rateDraft = BusinessDataServiceHelper.newDynamicObject((String)draftentity);
        long rateDraftId = DBServiceHelper.genGlobalLongId();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        rateDraft.set("id", (Object)rateDraftId);
        ArrayList datas = new ArrayList();
        ArrayList<String> msgs = new ArrayList<String>();
        for (DynamicObject row : entries) {
            ConvertOperationResult result;
            DynamicObject sourceBill;
            Map<String, String> sourceBillNumber;
            String sourceBilltypeNum;
            String ruleId = row.getString("ruleid");
            if (EmptyUtil.isEmpty((String)ruleId) || RateDraftHelper.isIgnorePreview(sourceBilltypeNum = (sourceBillNumber = RateDraftHelper.getSourceBillNumber(sourceBill = row.getDynamicObject("sourcebill"))).get("number")) || (result = RateDraftHelper.genRateDraftDataExample(sourceBilltypeNum, sourceBillNumber.get("baseDataNumber"), draftDataEntity, draftName, ruleId, rateDraft, max)) == null) continue;
            if (result.isSuccess()) {
                IRefrencedataProvider refDataProvider = BusinessDataServiceHelper::loadRefence;
                MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)draftDataEntity);
                List draftObjects = result.loadTargetDataObjects(refDataProvider, mainType);
                for (DynamicObject draftObject : draftObjects) {
                    draftObject.set(draftName, (Object)rateDraft);
                    if (!"mrm_rate_draft_data".equals(draftDataEntity)) continue;
                    if (RateTypeEnum.FIXED.getValue().equals(draftObject.get("ratetype"))) {
                        draftObject.set("referencerate", null);
                    }
                    if (!RateTypeEnum.FLOAT.getValue().equals(draftObject.get("ratetype")) || RateBillTypeEnum.isFinsubscribeBIllType(sourceBillNumber.get("baseDataNumber"))) continue;
                    draftObject.set("fixrate", null);
                }
                datas.addAll(draftObjects);
                continue;
            }
            String message = result.getMessage();
            String name = sourceBillNumber.get("baseDataName");
            msgs.add(name + ":" + message + "\n");
        }
        resultMap.put("rateDraftId", rateDraftId);
        if (msgs.size() > 0) {
            resultMap.put("error", String.join((CharSequence)"", msgs));
        } else {
            if (datas.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])datas.toArray(new DynamicObject[0]));
            }
            resultMap.put("error", null);
        }
        return resultMap;
    }

    private static ConvertOperationResult genRateDraftDataExample(String sourceBilltypeNum, String sourceEntity, String targetEntity, String draftName, String ruleId, DynamicObject rateDraft, int max) {
        QFilter qFilter = RateDraftHelper.getQFilter(sourceEntity, ruleId);
        QFilter defQF = DataGetDefFilterHelper.getDefQFilter(sourceEntity, sourceBilltypeNum);
        qFilter = defQF.and(qFilter);
        DynamicObjectCollection objects = QueryServiceHelper.query((String)sourceEntity, (String)"id", (QFilter[])new QFilter[]{qFilter}, (String)"id desc", (int)max);
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(objects.size());
        int lenth = Math.min(objects.size(), max);
        for (int i = 0; i < lenth; ++i) {
            DynamicObject info = (DynamicObject)objects.get(i);
            ListSelectedRow row = new ListSelectedRow();
            row.setPrimaryKeyValue(info.get("id"));
            selectedRows.add(row);
        }
        if (selectedRows.size() > 0) {
            PushArgs args = new PushArgs();
            args.setSourceEntityNumber(sourceEntity);
            args.setTargetEntityNumber(targetEntity);
            args.setSelectedRows(selectedRows);
            args.setRuleId(ruleId);
            ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)args);
            return result;
        }
        return null;
    }

    public static QFilter getQFilter(String sourceEntity, String ruleId) {
        QFilter qFilter = null;
        ConvertRuleElement convertRuleElement = ConvertMetaServiceHelper.loadRule((String)ruleId);
        if (convertRuleElement != null) {
            FilterCondition filterCondition = convertRuleElement.getFilterPolicy().getCondition().getFilterCondition();
            MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)sourceEntity);
            FilterBuilder fb = new FilterBuilder(dataType, filterCondition, true);
            fb.buildFilter(true);
            qFilter = fb.getQFilter();
            return qFilter;
        }
        return qFilter;
    }

    public static Map<String, String> getSourceBillNumber(DynamicObject sourceBill) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (!EmptyUtil.isEmpty((DynamicObject)sourceBill)) {
            DynamicObject sourcebill = sourceBill.getDynamicObject("sourcebill");
            DynamicObject sourceentity = sourceBill.getDynamicObject("sourceentity");
            map.put("number", sourcebill.getString("number"));
            map.put("baseDataNumber", sourceentity.getString("number"));
            map.put("baseDataName", sourceentity.getString("name"));
        }
        return map;
    }

    static {
        IGNORE_PREVIEW_LIST.add("bei_bankbalance");
        IGNORE_PREVIEW_LIST.add("ifm_accountbalance");
        IGNORE_PREVIEW_LIST.add("tm_forex");
        IGNORE_PREVIEW_LIST.add("tm_forex_forward");
        IGNORE_PREVIEW_LIST.add("tm_forex_options");
        IGNORE_PREVIEW_LIST.add("tm_forex_swaps");
    }
}

