/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.IntCalMethodEnum;
import kd.tmc.fbp.common.enums.IntHTRuleEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.RoundRuleEnum;
import kd.tmc.fbp.common.enums.SettleIntModeEnum;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.model.interest.BizBillInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.model.interest.IntCalRequest;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.model.interest.RateInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.factory.IntCallFactory;
import kd.tmc.fbp.service.inst.interest.IIntCallStragety;
import kd.tmc.fbp.service.inst.plan.IntPlanCallStragety;
import kd.tmc.mrm.common.enums.RateTypeEnum;
import kd.tmc.mrm.common.helper.InterestCalHelper;
import org.apache.commons.lang3.tuple.Pair;

public class RevenueCalcHelper {
    public static Pair<BigDecimal, List<IntBillInfo>> callIntPlan(DynamicObject bill) {
        Date beginDate = bill.getDate("interestdate");
        Date endDate = bill.getDate("enddate");
        List<PlanCallResult> intPlanList = RevenueCalcHelper.callIntPlan(bill, endDate);
        BigDecimal principle = RevenueCalcHelper.getIntCallPrinciple(bill);
        List<PlanCallResult> repayPlanList = RevenueCalcHelper.getAllRepayPlanList(bill, true);
        Pair<BigDecimal, List<IntBillInfo>> bigDecimalListPair = RevenueCalcHelper.genIntPlan(bill, repayPlanList, intPlanList, principle, beginDate);
        return bigDecimalListPair;
    }

    private static Pair<BigDecimal, List<IntBillInfo>> genIntPlan(DynamicObject finBill, List<PlanCallResult> repayPlanList, List<PlanCallResult> intPlanList, BigDecimal principle, Date stateDate) {
        BigDecimal totalAmt = BigDecimal.ZERO;
        ArrayList<IntBillInfo> list = new ArrayList<IntBillInfo>();
        Set<RateInfo> rateList = RevenueCalcHelper.getRateList(finBill);
        for (int index = 0; index < intPlanList.size(); ++index) {
            PlanCallResult intPlan = intPlanList.get(index);
            IntBillInfo intBill = RevenueCalcHelper.callInt(finBill, repayPlanList, rateList, stateDate, intPlan.getBizDate(), principle, index + 1, RepaymentWayEnum.zdyhk);
            if (EmptyUtil.isNoEmpty((Object)intBill)) {
                totalAmt = totalAmt.add(intBill.getAmount());
                if (EmptyUtil.isNoEmpty((BigDecimal)intBill.getAmount())) {
                    list.add(intBill);
                }
            }
            if (!intPlan.getBizDate().after(stateDate)) continue;
            stateDate = intPlan.getBizDate();
        }
        return Pair.of((Object)totalAmt, list);
    }

    private static IntBillInfo callInt(DynamicObject loanBill, List<PlanCallResult> repayPlanList, Set<RateInfo> rateList, Date beginDate, Date endDate, BigDecimal principle, int period, RepaymentWayEnum repauWay) {
        IntCalRequest request = new IntCalRequest();
        request.setRepayList(repayPlanList);
        BizBillInfo bizBill = RevenueCalcHelper.getBizBill(loanBill, principle, beginDate, endDate, period, repauWay);
        request.setBizBill(bizBill);
        request.setRateList(rateList);
        RevenueCalcHelper.verifyInput(request);
        IIntCallStragety stragety = IntCallFactory.getInstance((RepaymentWayEnum)RepaymentWayEnum.zdyhk);
        return stragety.callInt(request);
    }

    private static void verifyInput(IntCalRequest request) {
        boolean hasEffectiveRate = false;
        for (RateInfo rate : request.getRateList()) {
            if (rate.getEffectiveDate().compareTo(request.getBizBill().getBeginDate()) > 0) continue;
            hasEffectiveRate = true;
            break;
        }
        if (!hasEffectiveRate) {
            throw new TmcBizException(TmcErrorCode.COMMON, new Object[]{ResManager.loadKDString((String)"\u6536\u76ca\u8ba1\u7b97\u5f00\u59cb\u65e5\u5fc5\u987b\u8981\u6709\u53ef\u7528\u5229\u7387\u3002", (String)"RevenueCalcHelper_0", (String)"tmc-mrm-common", (Object[])new Object[0])});
        }
    }

    private static BigDecimal getIntCallPrinciple(DynamicObject finBill) {
        return finBill.getBigDecimal("amount");
    }

    private static List<PlanCallResult> callIntPlan(DynamicObject bill, Date endDate) {
        Set<RateInfo> rateList = RevenueCalcHelper.getRateList(bill);
        BigDecimal balance = bill.getBigDecimal("amount");
        List<PlanCallResult> repayPlanList = RevenueCalcHelper.getAllRepayPlanList(bill, false);
        IntCalRequest request = new IntCalRequest();
        request.setRepayList(repayPlanList);
        Date beginDate = bill.getDate("interestdate");
        request.setBizBill(RevenueCalcHelper.getBizBill(bill, balance, beginDate, endDate, 0, RepaymentWayEnum.zdyhk));
        request.setRateList(rateList);
        List planCallResults = new IntPlanCallStragety().callPlan(request);
        InterestCalHelper.updateBizDateByPayIntAdjustRule(bill, planCallResults);
        return planCallResults;
    }

    private static Set<RateInfo> getRateList(DynamicObject bill) {
        HashSet<RateInfo> rateList = new HashSet<RateInfo>();
        RateInfo info = new RateInfo();
        info.setEffectiveDate(bill.getDate("interestdate"));
        String rateType = bill.getString("ratetype");
        if (RateTypeEnum.FIXED.getValue().equals(rateType)) {
            info.setRate(bill.getBigDecimal("fixrate"));
        } else {
            info.setRate(bill.getBigDecimal("planrevenue"));
        }
        rateList.add(info);
        return rateList;
    }

    private static BizBillInfo getBizBill(DynamicObject bill, BigDecimal loanAmt, Date beginDate, Date endDate, int period, RepaymentWayEnum repauWay) {
        BizBillInfo bizBill = new BizBillInfo();
        bizBill.setLoanAmount(loanAmt);
        bizBill.setBeginDate(beginDate);
        bizBill.setEndDate(endDate);
        DynamicObject interestSettledPlan = bill.getDynamicObject("interestsettledplan");
        if (EmptyUtil.isNoEmpty((DynamicObject)interestSettledPlan)) {
            bizBill.setIntSchemeId(interestSettledPlan.getLong("id"));
        }
        bizBill.setRepayWay(repauWay);
        bizBill.setBasis(BasisEnum.getEnum((String)bill.getString("basis")));
        if (EmptyUtil.isNoEmpty((DynamicObject)bill.getDynamicObject("currency"))) {
            bizBill.setCurrencyId(bill.getDynamicObject("currency").getLong("id"));
        }
        bizBill.setPeriod(period);
        bizBill.setSettleIntMode(SettleIntModeEnum.gdpljx);
        bizBill.setHtRule(IntHTRuleEnum.headnotail);
        bizBill.setRound(RoundRuleEnum.rounded);
        bizBill.setIntCalMethod(IntCalMethodEnum.totalcallint);
        return bizBill;
    }

    private static List<PlanCallResult> getAllRepayPlanList(DynamicObject bill, boolean isContainRepayBill) {
        ArrayList<PlanCallResult> repayPlanList = new ArrayList<PlanCallResult>(10);
        DynamicObjectCollection capCashFlows = bill.getDynamicObjectCollection("capcashflowentry");
        if (isContainRepayBill) {
            for (DynamicObject capCashFlow : capCashFlows) {
                PlanCallResult info = new PlanCallResult();
                info.setPayInt(Boolean.FALSE.booleanValue());
                info.setBizDate(capCashFlow.getDate("capdate"));
                info.setPrinciple(capCashFlow.getBigDecimal("capamount"));
                repayPlanList.add(info);
            }
        }
        return repayPlanList;
    }
}

