/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.common.helper;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.mrm.common.helper.RevenueCalcHelper;
import org.apache.commons.lang3.tuple.Pair;

public class RevenuePlanCalHelper {
    public static void calRevenuePlan(DynamicObject bill) {
        Pair<BigDecimal, List<IntBillInfo>> intBills = RevenueCalcHelper.callIntPlan(bill);
        RevenuePlanCalHelper.finBillWriteBack(intBills, bill);
    }

    private static void finBillWriteBack(Pair<BigDecimal, List<IntBillInfo>> interestCals, DynamicObject finBill) {
        String basis = finBill.getString("basis");
        int yearDay = TermHelper.getBasis_YearDay((int)1, (BasisEnum)BasisEnum.getEnum((String)basis));
        List intBills = (List)interestCals.getValue();
        DynamicObjectCollection interestEntryDC = finBill.getDynamicObjectCollection("incashflowtentry");
        interestEntryDC.clear();
        int seq = 1;
        for (IntBillInfo intBill : intBills) {
            DynamicObject interestEntryDO = interestEntryDC.addNew();
            Date interestDate = intBill.getBizDate();
            BigDecimal interestAmount = intBill.getAmount();
            interestEntryDO.set("seq", (Object)seq++);
            interestEntryDO.set("indate", (Object)interestDate);
            interestEntryDO.set("inamount", (Object)interestAmount);
            List details = intBill.getDetails();
            DynamicObjectCollection interestSubEntryDC = interestEntryDO.getDynamicObjectCollection("incashflowtsubentry");
            interestSubEntryDC.clear();
            for (IntBillDetailInfo detail : details) {
                Date beginDate = detail.getBeginDate();
                Date endDate = detail.getEndDate();
                int days = detail.getDays();
                BigDecimal principle = detail.getPrinciple();
                BigDecimal yearRate = detail.getRate();
                BigDecimal rateAmount = detail.getAmount();
                DynamicObject interestSubEntryDO = interestSubEntryDC.addNew();
                interestSubEntryDO.set("seq", (Object)detail.getSeq());
                interestSubEntryDO.set("intereststartdate", (Object)beginDate);
                interestSubEntryDO.set("interestenddate", (Object)endDate);
                interestSubEntryDO.set("interestdates", (Object)days);
                interestSubEntryDO.set("interestbalance", (Object)principle);
                interestSubEntryDO.set("interestrate", (Object)yearRate);
                interestSubEntryDO.set("interestdays", (Object)yearDay);
                interestSubEntryDO.set("interestamount", (Object)rateAmount);
            }
        }
    }
}

