/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.common.helper;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TmcBaseDataServiceHelper {
    public static Map<String, Long> getBaseAccountingInfo(Long accountOrgID) {
        if (accountOrgID == 0L) {
            return new HashMap<String, Long>(0);
        }
        Map<String, Long> baseAccountingInfo = TmcBaseDataServiceHelper.getBaseAccountingInfo(Collections.singletonList(accountOrgID));
        if (baseAccountingInfo.isEmpty()) {
            baseAccountingInfo = TmcBaseDataServiceHelper.getBaseAccountingInfoByCashmgtinit(accountOrgID);
        }
        return baseAccountingInfo;
    }

    private static Map<String, Long> getBaseAccountingInfoByCashmgtinit(Long accountOrgID) {
        DynamicObjectCollection coll;
        HashMap<String, Long> baseAccountingInfo = new HashMap<String, Long>(2);
        if (!EmptyUtil.isEmpty((Long)accountOrgID) && (coll = QueryServiceHelper.query((String)"queryCashInit", (String)"cas_cashmgtinit", (String)"exratetable,standardcurrency", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)accountOrgID)}, null)) != null && !coll.isEmpty()) {
            baseAccountingInfo.put("baseCurrencyID", ((DynamicObject)coll.get(0)).getLong("standardcurrency"));
            baseAccountingInfo.put("exchangeRateTableID", ((DynamicObject)coll.get(0)).getLong("exratetable.id"));
        }
        return baseAccountingInfo;
    }

    private static Map<String, Long> getBaseAccountingInfo(List<Long> accountingOrgIds) {
        HashMap<String, Long> baseAccountingInfo = new HashMap<String, Long>(2);
        if (accountingOrgIds != null && !accountingOrgIds.isEmpty()) {
            String selectFields = "baseacctorg.id,exratetable.id,basecurrrency.id";
            QFilter orgFilter = new QFilter("baseacctorg", "in", accountingOrgIds);
            QFilter[] filters = new QFilter[]{orgFilter};
            Map accountingObjMap = BusinessDataServiceHelper.loadFromCache((String)"bd_accountingsys_base", (String)selectFields, (QFilter[])filters);
            if (accountingObjMap != null && !accountingObjMap.isEmpty()) {
                DynamicObject baseAccountingObj = null;
                if (accountingObjMap.size() == 1) {
                    baseAccountingObj = (DynamicObject)accountingObjMap.entrySet().iterator().next().getValue();
                } else {
                    HashMap<Long, DynamicObject> orgAccountingObjMap = new HashMap<Long, DynamicObject>(accountingObjMap.size());
                    for (DynamicObject accountingObj : accountingObjMap.values()) {
                        orgAccountingObjMap.put(accountingObj.getLong("baseacctorg.id"), accountingObj);
                    }
                    for (int i = accountingOrgIds.size() - 1; i >= 0 && (baseAccountingObj = (DynamicObject)orgAccountingObjMap.get(accountingOrgIds.get(i))) == null; --i) {
                    }
                }
                if (baseAccountingObj != null) {
                    baseAccountingInfo.put("baseCurrencyID", baseAccountingObj.getLong("basecurrrency.id"));
                    baseAccountingInfo.put("exchangeRateTableID", baseAccountingObj.getLong("exratetable.id"));
                }
                return baseAccountingInfo;
            }
            return baseAccountingInfo;
        }
        return baseAccountingInfo;
    }
}

