/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.common.model.section;

import java.util.Date;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.mrm.common.model.section.MatchResult;

public class Section {
    int index;
    boolean leftClosed;
    boolean rightClosed;
    Date leftDate;
    Date rightDate;

    public int getIndex() {
        return this.index;
    }

    public boolean isLeftClosed() {
        return this.leftClosed;
    }

    public boolean isRightClosed() {
        return this.rightClosed;
    }

    public Date getLeftDate() {
        return this.leftDate;
    }

    public Date getRightDate() {
        return this.rightDate;
    }

    public MatchResult match(Date date) {
        if (date == null) {
            if (this.rightDate == null) {
                String desc = this.genDesc(date);
                MatchResult matchResult = new MatchResult(this.index, desc);
                return matchResult;
            }
            return new MatchResult(-3, null);
        }
        if (date.after(this.leftDate) || this.leftClosed && date.compareTo(this.leftDate) == 0) {
            if (this.rightDate == null || date.before(this.rightDate) || this.rightClosed && date.compareTo(this.rightDate) == 0) {
                String desc = this.genDesc(date);
                MatchResult matchResult = new MatchResult(this.index, desc);
                return matchResult;
            }
            return new MatchResult(-2, null);
        }
        return new MatchResult(-1, null);
    }

    String genDesc(Date date) {
        if (this.rightDate != null) {
            if (date != null) {
                return String.format("Exposure date %s, within interval %s to %s; ", DateUtils.formatString((Date)date, (String)"yyyy/MM/dd"), DateUtils.formatString((Date)this.leftDate, (String)"yyyy/MM/dd"), DateUtils.formatString((Date)this.rightDate, (String)"yyyy/MM/dd"));
            }
            return String.format("Interval %s to %s; ", DateUtils.formatString((Date)this.leftDate, (String)"yyyy/MM/dd"), DateUtils.formatString((Date)this.rightDate, (String)"yyyy/MM/dd"));
        }
        if (date != null) {
            return String.format("Exposure date %s, within interval starting from %s; ", DateUtils.formatString((Date)date, (String)"yyyy/MM/dd"), DateUtils.formatString((Date)this.leftDate, (String)"yyyy/MM/dd"));
        }
        return String.format("Interval starting from %s; ", DateUtils.formatString((Date)this.leftDate, (String)"yyyy/MM/dd"));
    }
}

