/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.common.model.section;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mrm.common.model.section.MatchResult;
import kd.tmc.mrm.common.model.section.Section;

public class SectionCfgModel {
    private static final Date NULL_DATE_KEY = DateUtils.stringToDate((String)"9999-09-09", (String)"yyyy-MM-dd");
    private ConcurrentHashMap<Date, MatchResult> cache = new ConcurrentHashMap();
    private List<Section> sections;
    private String[] sectionTitles;

    public SectionCfgModel(DynamicObject sectionCfg, Date startDate, boolean isGenDesc) {
        this.init(sectionCfg, startDate);
    }

    public SectionCfgModel(DynamicObject sectionCfg, Date startDate) {
        this.init(sectionCfg, startDate);
    }

    private void init(DynamicObject sectionCfg, Date startDate) {
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{sectionCfg, startDate})) {
            throw new KDBizException("SectionCfgModel build Exception");
        }
        DynamicObjectCollection sectionEntry = sectionCfg.getDynamicObjectCollection("sectionentry");
        this.sections = new ArrayList<Section>(sectionEntry.size());
        for (int i = 0; i < sectionEntry.size(); ++i) {
            this.sections.add(new Section());
        }
        String unit = ((DynamicObject)sectionEntry.get(0)).getString("unit");
        this.sections.get((int)0).leftClosed = true;
        for (int i = 0; i < sectionEntry.size(); ++i) {
            this.sections.get((int)i).index = i;
            DynamicObject row = (DynamicObject)sectionEntry.get(i);
            int x = row.getInt("left");
            Date leftDate = "m".equals(unit) ? DateUtils.getNextMonth((Date)startDate, (int)x) : ("d".equals(unit) ? DateUtils.getNextDay((Date)startDate, (int)x) : DateUtils.getNextYear((Date)startDate, (int)x));
            this.sections.get((int)i).leftDate = leftDate;
            this.sections.get((int)i).rightClosed = ((DynamicObject)sectionEntry.get(i)).getBoolean("iscontains");
            if (i != 0) {
                this.sections.get((int)(i - 1)).rightDate = leftDate;
            }
            if (i <= 0) continue;
            this.sections.get((int)i).leftClosed = !((DynamicObject)sectionEntry.get(i - 1)).getBoolean("iscontains");
        }
        this.sections.get((int)(sectionEntry.size() - 1)).leftClosed = !this.sections.get((int)(sectionEntry.size() - 2)).rightClosed;
        this.sectionTitles = this.generateTitles(sectionEntry);
    }

    public MatchResult get(Date date) {
        int left = 0;
        int right = this.sections.size() - 1;
        while (left <= right) {
            int mid = (left + right) / 2;
            MatchResult matchResult = this.match(this.sections.get(mid), date);
            if (matchResult.getIndex() >= 0) {
                return matchResult;
            }
            if (matchResult.getIndex() == -2) {
                left = mid + 1;
                continue;
            }
            if (matchResult.getIndex() == -1) {
                right = mid - 1;
                continue;
            }
            if (matchResult.getIndex() == -3) {
                right = left = this.sections.size() - 1;
                continue;
            }
            throw new KDBizException("Code Logic Exception 1 of SectionCfgModel#get " + DateUtils.formatString((Date)date, (String)"yyyy-MM-dd"));
        }
        throw new KDBizException("Code Logic Exception 2 of SectionCfgModel#get " + DateUtils.formatString((Date)date, (String)"yyyy-MM-dd"));
    }

    public Section getSection(int index) {
        for (Section section : this.sections) {
            if (index != section.getIndex()) continue;
            return section;
        }
        return null;
    }

    private MatchResult match(Section section, Date date) {
        if (this.cache.containsKey(date == null ? NULL_DATE_KEY : date)) {
            return this.cache.get(date == null ? NULL_DATE_KEY : date);
        }
        MatchResult matchResult = section.match(date);
        if (section.getIndex() == matchResult.getIndex()) {
            Date dateKey = date == null ? NULL_DATE_KEY : date;
            this.cache.put(dateKey, matchResult);
        }
        return matchResult;
    }

    public String[] getSectionTitles() {
        return this.sectionTitles;
    }

    private String[] generateTitles(DynamicObjectCollection sectionEntry) {
        String[] columnTitles = new String[sectionEntry.size()];
        String unit = ((DynamicObject)sectionEntry.get(0)).getString("unit");
        for (int j = 0; j < sectionEntry.size(); ++j) {
            int x = ((DynamicObject)sectionEntry.get(j)).getInt("left");
            if (j == 0) {
                x = ((DynamicObject)sectionEntry.get(1)).getInt("left");
                columnTitles[j] = String.format("%s,,%s", x, unit);
                continue;
            }
            if (j != sectionEntry.size() - 1) {
                int y = ((DynamicObject)sectionEntry.get(j + 1)).getInt("left");
                columnTitles[j] = String.format("%s,%s,%s", x, y, unit);
                continue;
            }
            columnTitles[j] = String.format(",%s,%s", x, unit);
        }
        return columnTitles;
    }

    public static String generateTitlesName(String title) {
        if (title == null) {
            throw new KDBizException("BizException 1 of SectionCfgModel#generateTitlesName");
        }
        String[] ss = title.split(",");
        if (ss.length != 3) {
            throw new KDBizException("BizException 2 of SectionCfgModel#generateTitlesName:" + title);
        }
        String x = ss[0];
        String y = ss[1];
        String unit = ss[2];
        if (unit.length() == 0) {
            throw new KDBizException("BizException 3 of SectionCfgModel#generateTitlesName:" + title);
        }
        if (!("y".equals(unit) || "m".equals(unit) || "d".equals(unit))) {
            throw new KDBizException("BizException 4 of SectionCfgModel#generateTitlesName:" + title);
        }
        if (x.length() > 0 && y.length() == 0) {
            if ("m".equals(unit)) {
                return ResManager.loadKDString((String)"%s\u4e2a\u6708\u5185", (String)"SectionCfgModel_1", (String)"tmc-mrm-common", (Object[])new Object[]{x});
            }
            if ("d".equals(unit)) {
                return ResManager.loadKDString((String)"%s\u5929\u5185", (String)"SectionCfgModel_2", (String)"tmc-mrm-common", (Object[])new Object[]{x});
            }
            return ResManager.loadKDString((String)"%s\u5e74\u5185", (String)"SectionCfgModel_3", (String)"tmc-mrm-common", (Object[])new Object[]{x});
        }
        if (x.length() > 0 && y.length() > 0) {
            if ("m".equals(unit)) {
                return String.format(ResManager.loadKDString((String)"%1$s\u5230%2$s\u4e2a\u6708", (String)"SectionCfgModel_4", (String)"tmc-mrm-common", (Object[])new Object[0]), x, y);
            }
            if ("d".equals(unit)) {
                return String.format(ResManager.loadKDString((String)"%1$s\u5230%2$s\u5929", (String)"SectionCfgModel_5", (String)"tmc-mrm-common", (Object[])new Object[0]), x, y);
            }
            return String.format(ResManager.loadKDString((String)"%1$s\u5230%2$s\u5e74", (String)"SectionCfgModel_6", (String)"tmc-mrm-common", (Object[])new Object[0]), x, y);
        }
        if (x.length() == 0 && y.length() > 0) {
            if ("m".equals(unit)) {
                return ResManager.loadKDString((String)"%s\u4e2a\u6708\u4ee5\u4e0a", (String)"SectionCfgModel_7", (String)"tmc-mrm-common", (Object[])new Object[]{y});
            }
            if ("d".equals(unit)) {
                return ResManager.loadKDString((String)"%s\u5929\u4ee5\u4e0a", (String)"SectionCfgModel_8", (String)"tmc-mrm-common", (Object[])new Object[]{y});
            }
            return ResManager.loadKDString((String)"%s\u5e74\u4ee5\u4e0a", (String)"SectionCfgModel_9", (String)"tmc-mrm-common", (Object[])new Object[]{y});
        }
        throw new KDBizException("BizException 5 of SectionCfgModel#generateTitlesName:" + title);
    }
}

