/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.business.opservice.draft;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.mrm.business.service.integrate.draft.common.DataGetTaskLog;
import kd.tmc.mrm.common.enums.DraftLogTypeEnum;
import kd.tmc.mrm.common.enums.ExecObjEnum;
import kd.tmc.mrm.common.enums.ExecOpEnum;
import kd.tmc.mrm.common.enums.ExecTypeEnum;
import kd.tmc.mrm.common.helper.ResManagerHelper;

public class ExRateDraftDelOpService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billno");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        List id = Arrays.stream(dataEntities).map(e -> e.getLong("id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("exratedraft", "in", id);
        DeleteServiceHelper.delete((String)"mrm_exrate_draft_data", (QFilter[])qFilter.toArray());
        for (DynamicObject dataEntity : dataEntities) {
            this.recordDeleteLog(dataEntity);
        }
    }

    protected void recordDeleteLog(DynamicObject dataEntity) {
        DataGetTaskLog dataGetTaskLog = new DataGetTaskLog();
        String execType = ExecTypeEnum.MANUAL.getValue();
        if (this.getOperationVariable().containsKey("bycleartask")) {
            execType = ExecTypeEnum.AUTO.getValue();
        }
        dataGetTaskLog.deleteTask(DraftLogTypeEnum.EXRATE.getValue(), ExecObjEnum.EXRATE_DRAFT.getValue(), execType, ExecOpEnum.EXRATEDRAFT_DELETE.getValue(), dataEntity.getString("billno"), ResManagerHelper.getLocalString((LocaleString)ResManager.getLocaleString((String)"\u5220\u9664\u5e95\u7a3f\uff1a%s\u3002", (String)"ExRateDraftDelOpService_0", (String)"tmc-mrm-business"), (Object[])new Object[]{dataEntity.getString("billno")}));
        dataGetTaskLog.persist(false);
    }
}

