/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.business.opservice.draft;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ExRateDraftDetailSaveOpService
extends AbstractTmcBizOppService {
    public void beforeProcess(List<ExtendedDataEntity> dataEntities) throws KDException {
        super.beforeProcess(dataEntities);
        for (ExtendedDataEntity data : dataEntities) {
            DynamicObject dynamicObject = data.getDataEntity();
            this.processImportData(dynamicObject);
            this.counterPartyHandle(dynamicObject);
        }
    }

    private void processImportData(DynamicObject data) {
        Boolean importtag;
        Map option = this.operationVariable;
        Boolean bl = importtag = option.containsKey("importtag_of_datasource") ? Boolean.valueOf((String)option.get("importtag_of_datasource")) : Boolean.FALSE;
        if (importtag.booleanValue()) {
            this.deleteEntryForImport(data);
            this.importBalanceTypeHandle(data);
        }
    }

    private void importBalanceTypeHandle(DynamicObject data) {
        DynamicObject billType = data.getDynamicObject("billtype");
        if ("bei_bankbalance".equals(billType.getString("number")) || "ifm_accountbalance".equals(billType.getString("number"))) {
            this.fillCapCashFlowEntry(data);
            this.fillBalanceAccountBank(data);
        }
    }

    private void fillBalanceAccountBank(DynamicObject data) {
        DynamicObject[] accountbank = TmcDataServiceHelper.load((String)"bd_accountbanks", (String)"id,bank,openorg", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)data.getDynamicObject("bankaccount").getLong("id"))});
        DynamicObject billType = data.getDynamicObject("billtype");
        if ("bei_bankbalance".equals(billType.getString("number"))) {
            data.set("counterparty", accountbank[0].get("bank"));
        } else if ("ifm_accountbalance".equals(billType.getString("number"))) {
            data.set("counterparty", accountbank[0].get("openorg"));
        }
    }

    private void fillCapCashFlowEntry(DynamicObject data) {
        DynamicObject[] exrateDrafts = BusinessDataServiceHelper.load((String)"mrm_exrate_draft", (String)"id,billno,draftcreatedate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)data.getDynamicObject("exratedraft").getLong("id"))});
        DynamicObject exrateDraft = exrateDrafts[0];
        Date draftcreatedate = exrateDraft.getDate("draftcreatedate");
        data.set("startdate", (Object)draftcreatedate);
        DynamicObjectCollection capcashflowentry = data.getDynamicObjectCollection("capcashflowentry");
        capcashflowentry.clear();
        DynamicObject capcash = capcashflowentry.addNew();
        capcash.set("capdate", (Object)DateUtils.getNextDay((Date)draftcreatedate, (int)1));
        capcash.set("capamount", (Object)data.getBigDecimal("amount"));
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject data : dataEntities) {
            long sourceBillId;
            data.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            this.rearrangeDate(data);
            String bizDataSource = data.getString("bizdatasource");
            if (!"import".equals(bizDataSource) && !"manual".equals(bizDataSource) || !EmptyUtil.isEmpty((Long)(sourceBillId = data.getLong("sourcebillid")))) continue;
            long id = data.getLong("id");
            data.set("sourcebillid", (Object)id);
        }
        DynamicObject data = dataEntities[0];
        this.updateDraftModifyDate(data);
    }

    private void updateDraftModifyDate(DynamicObject detail) {
        DynamicObject exrateDraft = BusinessDataServiceHelper.loadSingle((String)"mrm_exrate_draft", (String)"id, modifytime", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)detail.getDynamicObject("exratedraft").getLong("id"))});
        exrateDraft.set("modifytime", (Object)new Date());
        SaveServiceHelper.update((DynamicObject)exrateDraft);
    }

    private void rearrangeDate(DynamicObject data) {
        DynamicObjectCollection capcashflowentry = data.getDynamicObjectCollection("capcashflowentry");
        TreeMap capcashflowentryMap = new TreeMap();
        ArrayList<DynamicObject> emptyDateCapcashflowentryList = new ArrayList<DynamicObject>();
        for (DynamicObject capcashflow : capcashflowentry) {
            Date date = capcashflow.getDate("capdate");
            if (!EmptyUtil.isEmpty((Object)date)) {
                capcashflowentryMap.put(date, capcashflow);
                continue;
            }
            emptyDateCapcashflowentryList.add(capcashflow);
        }
        NavigableSet capcashdates = capcashflowentryMap.navigableKeySet();
        capcashflowentry.clear();
        int seq = 1;
        for (DynamicObject capcashflow : emptyDateCapcashflowentryList) {
            capcashflow.set("seq", (Object)seq++);
            capcashflowentry.add((Object)capcashflow);
        }
        for (Date capcashdate : capcashdates) {
            DynamicObject dynamicObject = (DynamicObject)capcashflowentryMap.get(capcashdate);
            dynamicObject.set("seq", (Object)seq++);
            capcashflowentry.add((Object)dynamicObject);
        }
        DynamicObjectCollection incashflowtentry = data.getDynamicObjectCollection("incashflowtentry");
        TreeMap<Date, DynamicObject> incashflowtentryMap = new TreeMap<Date, DynamicObject>();
        for (DynamicObject incashflow : incashflowtentry) {
            incashflowtentryMap.put(incashflow.getDate("indate"), incashflow);
        }
        NavigableSet incashdates = incashflowtentryMap.navigableKeySet();
        incashflowtentry.clear();
        seq = 1;
        for (Date incashdate : incashdates) {
            DynamicObject dynamicObject = (DynamicObject)incashflowtentryMap.get(incashdate);
            dynamicObject.set("seq", (Object)seq++);
            incashflowtentry.add((Object)dynamicObject);
        }
    }

    private void deleteEntryForImport(DynamicObject data) {
        DynamicObjectCollection capcashflowentry = data.getDynamicObjectCollection("capcashflowentry");
        capcashflowentry.removeIf(capcashflow -> !EmptyUtil.isEmpty((Object)capcashflow.get("id")));
        DynamicObjectCollection incashflowentry = data.getDynamicObjectCollection("incashflowtentry");
        incashflowentry.removeIf(incashflow -> !EmptyUtil.isEmpty((Object)incashflow.get("id")));
    }

    private void counterPartyHandle(DynamicObject data) {
        if ("fbd_other".equals(data.get("counterpartytype"))) {
            if (!EmptyUtil.isEmpty((Object)data.get("counterparty"))) {
                data.set("counterparty", null);
            }
        } else if (!EmptyUtil.isEmpty((Object)data.get("counterparty"))) {
            DynamicObject counterParty = data.getDynamicObject("counterparty");
            if (!counterParty.getString("name").equals(data.get("counterpartytext"))) {
                data.set("counterpartytext", (Object)counterParty.getString("name"));
            }
        } else if (EmptyUtil.isEmpty((Object)data.get("counterparty")) && !EmptyUtil.isEmpty((Object)data.get("counterpartytext"))) {
            data.set("counterpartytext", null);
        }
    }
}

