/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.business.opservice.predict;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.model.interest.RepayPlanRequest;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.fbp.service.inst.plan.RepayPlanCallStragety;
import kd.tmc.mrm.common.bean.IntBillExtInfo;
import kd.tmc.mrm.common.enums.RateBillTypeEnum;
import kd.tmc.mrm.common.helper.DepositHelper;
import kd.tmc.mrm.common.helper.InterestCalHelper;
import kd.tmc.mrm.common.helper.RateAdjustHelper;
import kd.tmc.mrm.common.helper.RevenuePlanCalHelper;
import org.apache.commons.lang3.tuple.Pair;

public class PredictSaveOpService
extends AbstractTmcBizOppService {
    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntity : dataEntities) {
            this.calCashFlow(dataEntity);
        }
    }

    private void calCashFlow(DynamicObject bill) {
        DynamicObject billType = bill.getDynamicObject("billtype");
        if (billType != null) {
            String billTypeNumber = billType.getString("number");
            if (RateBillTypeEnum.isCfmBIllType((String)billTypeNumber)) {
                this.calCashFlowForCfm(bill);
            } else if (RateBillTypeEnum.isCimBIllType((String)billTypeNumber)) {
                this.calCashFlowForCim(bill);
            }
        }
    }

    private void calCashFlowForCfm(DynamicObject bill) {
        this.calCapCashFlowForCfm(bill);
        this.calRateAdjustForCfm(bill);
        this.calInsCashFlowForCfm(bill);
    }

    private void calCashFlowForCim(DynamicObject bill) {
        this.calCapCashFlowForCim(bill);
        this.calInCashFlowForCim(bill);
    }

    private void calInCashFlowForCim(DynamicObject bill) {
        String billTypeNumber = this.getBillTypeNumber(bill);
        if (RateBillTypeEnum.CIM_FINSUBSCRIBE.getValue().equals(billTypeNumber)) {
            RevenuePlanCalHelper.calRevenuePlan((DynamicObject)bill);
        } else {
            DepositHelper.calIntPlan((DynamicObject)bill);
        }
    }

    private String getBillTypeNumber(DynamicObject bill) {
        DynamicObject billType = bill.getDynamicObject("billtype");
        if (billType != null) {
            return billType.getString("number");
        }
        return "";
    }

    private void calCapCashFlowForCim(DynamicObject bill) {
        DynamicObjectCollection capCashFlows = bill.getDynamicObjectCollection("capcashflowentry");
        capCashFlows.clear();
        DynamicObject capCashFlow = capCashFlows.addNew();
        capCashFlow.set("capdate", (Object)bill.getDate("enddate"));
        capCashFlow.set("capamount", (Object)bill.getBigDecimal("amount"));
        capCashFlow.set("capmodifydate", (Object)TcDateUtils.getCurrentTime());
    }

    private void calCapCashFlowForCfm(DynamicObject bill) {
        RepayPlanRequest request = this.genRepayPlanRequest(bill);
        List repayPlanList = new RepayPlanCallStragety().callPlan(request);
        if (EmptyUtil.isNoEmpty((Object)repayPlanList)) {
            this.updateRepayPlanByAdjustRule(bill, repayPlanList);
            DynamicObjectCollection capCashFlows = bill.getDynamicObjectCollection("capcashflowentry");
            capCashFlows.clear();
            for (PlanCallResult repayPlan : repayPlanList) {
                DynamicObject dynamicObject = capCashFlows.addNew();
                dynamicObject.set("capdate", (Object)repayPlan.getBizDate());
                dynamicObject.set("capamount", (Object)repayPlan.getPrinciple());
                dynamicObject.set("capmodifydate", (Object)TcDateUtils.getCurrentTime());
            }
        }
    }

    private void updateRepayPlanByAdjustRule(DynamicObject bill, List<PlanCallResult> repayPlanList) {
        String adjustRule = null;
        adjustRule = bill.getString("loanexpireadjustrule");
        DynamicObjectCollection workCalendars = bill.getDynamicObjectCollection("workcalendar");
        InterestCalHelper.updatePlanListByAdjustRule(repayPlanList, (String)adjustRule, (DynamicObjectCollection)workCalendars);
    }

    private RepayPlanRequest genRepayPlanRequest(DynamicObject bill) {
        RepayPlanRequest request = new RepayPlanRequest();
        request.setLoanAmount(bill.getBigDecimal("amount"));
        request.setLoanDate(bill.getDate("startdate"));
        request.setExpiredate(bill.getDate("enddate"));
        request.setRepayScheme(bill.getDynamicObject("stageplan"));
        request.setRepayWay(RepaymentWayEnum.valueOf((String)bill.getString("repaymentway")));
        request.setCurrency(bill.getDynamicObject("currency"));
        return request;
    }

    private void calInsCashFlowForCfm(DynamicObject bill) {
        Pair intBills = null;
        intBills = InterestCalHelper.callIntCashFlow((DynamicObject)bill);
        PredictSaveOpService.loanBillWriteBack((Pair<BigDecimal, List<IntBillExtInfo>>)intBills, bill);
    }

    private void calRateAdjustForCfm(DynamicObject bill) {
        RateAdjustHelper.updateRateAdjustList((DynamicObject)bill);
    }

    public static void loanBillWriteBack(Pair<BigDecimal, List<IntBillExtInfo>> interestCals, DynamicObject loanBill) {
        String basis = loanBill.getString("basis");
        int yearDay = TermHelper.getBasis_YearDay((int)1, (BasisEnum)BasisEnum.getEnum((String)basis));
        List intBills = (List)interestCals.getValue();
        DynamicObjectCollection interestEntryDC = loanBill.getDynamicObjectCollection("incashflowtentry");
        interestEntryDC.clear();
        for (IntBillExtInfo intBill : intBills) {
            DynamicObject interestEntryDO = interestEntryDC.addNew();
            Date interestDate = intBill.getBizDate();
            BigDecimal interestAmount = intBill.getAmount();
            interestEntryDO.set("seq", (Object)intBill.getSeq());
            interestEntryDO.set("indate", (Object)interestDate);
            interestEntryDO.set("inamount", (Object)interestAmount);
            List details = intBill.getExtDetails();
            DynamicObjectCollection interestSubEntryDC = interestEntryDO.getDynamicObjectCollection("incashflowtsubentry");
            interestSubEntryDC.clear();
            for (IntBillExtInfo.IntBillDetailExtInfo detail : details) {
                Date beginDate = detail.getBeginDate();
                Date endDate = detail.getEndDate();
                int days = detail.getDays();
                BigDecimal principle = detail.getPrinciple();
                BigDecimal yearRate = detail.getRate();
                BigDecimal rateAmount = detail.getAmount();
                DynamicObject interestSubEntryDO = interestSubEntryDC.addNew();
                interestSubEntryDO.set("seq", (Object)detail.getSeq());
                interestSubEntryDO.set("intereststartdate", (Object)beginDate);
                interestSubEntryDO.set("interestenddate", (Object)endDate);
                interestSubEntryDO.set("interestdates", (Object)days);
                interestSubEntryDO.set("interestbalance", (Object)principle);
                interestSubEntryDO.set("interestrate", (Object)yearRate);
                interestSubEntryDO.set("interestdays", (Object)yearDay);
                interestSubEntryDO.set("interestamount", (Object)rateAmount);
                interestSubEntryDO.set("interestway", (Object)detail.getIntType().getValue());
                interestSubEntryDO.set("floatint", (Object)detail.getFloatInt());
                interestSubEntryDO.set("floatrate", (Object)detail.getFloatRate());
                interestSubEntryDO.set("lasttotalint", (Object)detail.getLastTotalInt());
                interestSubEntryDO.set("curtotalint", (Object)detail.getCurTotalInt());
                Date beginConfirmDate = detail.getBeginConfirmDate();
                Date endConfirmDate = detail.getEndConfirmDate();
                if (beginConfirmDate == null || endConfirmDate == null) continue;
                Integer lookDays = detail.getConfirmDays();
                interestSubEntryDO.set("confirmratedate", (Object)beginConfirmDate);
                interestSubEntryDO.set("lookdays", (Object)lookDays);
            }
        }
    }
}

