/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.business.opservice.sensitivityanalysis;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mrm.business.service.exrateopen.ExRateSensitivityAnalysisModel;

public class ExRateSensitivityAnalysisSaveService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("subjectsystem");
        selector.add("forexquote");
        selector.add("currentanalysisobj");
        selector.add("sectioncfg");
        selector.add("basecurrency");
        selector.add("scenariosimulation");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject[] bills;
            dataEntity.set("forexquotetime", dataEntity.getDynamicObject("forexquote").get("modifyTime"));
            dataEntity.set("currentanalysisobjtime", dataEntity.getDynamicObject("currentanalysisobj").get("modifyTime"));
            dataEntity.set("scenariosimulationtime", dataEntity.getDynamicObject("scenariosimulation").get("modifyTime"));
            if (dataEntity.getBoolean("useexsitgap")) {
                DynamicObject exRateGapBill = QueryServiceHelper.queryOne((String)"mrm_exrate_gap_analysis", (String)"modifyTime", (QFilter[])new QFilter("id", "=", dataEntity.getDynamicObject("exrategap").getPkValue()).toArray());
                dataEntity.set("gaptime", exRateGapBill.get("modifyTime"));
            }
            DynamicObject subjectSystem = BusinessDataServiceHelper.loadSingleFromCache((Object)dataEntity.getDynamicObject("subjectsystem").getPkValue(), (String)"mrm_subject_system");
            ExRateSensitivityAnalysisModel gapAnalysisModel = new ExRateSensitivityAnalysisModel(dataEntity.getDynamicObject("forexquote"), dataEntity.getDynamicObject("currentanalysisobj"), subjectSystem, dataEntity.getDynamicObject("sectioncfg"), dataEntity.getDynamicObject("basecurrency"), dataEntity.getDynamicObject("scenariosimulation").getLong("id"));
            String appId = EmptyUtil.isNoEmpty((String)((String)this.getOperationVariable().get("currbizappid"))) ? (String)this.getOperationVariable().get("currbizappid") : "mrm";
            gapAnalysisModel.analysis(appId);
            Set<String> tipPairs = gapAnalysisModel.getTipPairs();
            tipPairs = tipPairs.stream().map(o -> "\u201c" + o + "\u201d").collect(Collectors.toSet());
            if (!EmptyUtil.isEmpty(tipPairs)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d27\u5e01\u5bf9%1$s\u5728\u5916\u6c47\u62a5\u4ef7\u201c%2$s\u201d\u4e2d\u672a\u8bbe\u7f6e\u62a5\u4ef7\u65b9\u5f0f\uff0c\u8bf7\u8bbe\u7f6e\u62a5\u4ef7\u65b9\u5f0f\u6765\u83b7\u53d6\u5f53\u524d\u6c47\u7387\u3002", (String)"ExRateSensitivityAnalysisSaveService_0", (String)"tmc-mrm-business", (Object[])new Object[0]), String.join((CharSequence)"\u3001", tipPairs), dataEntity.getDynamicObject("forexquote").getString("number")));
            }
            for (DynamicObject bill : bills = gapAnalysisModel.getGapAnalysisDetails().toArray(new DynamicObject[0])) {
                bill.set("srcbillid", dataEntity.getPkValue());
            }
            DeleteServiceHelper.delete((String)"mrm_exrate_sens_detail", (QFilter[])new QFilter[]{new QFilter("srcbillid", "=", dataEntity.getPkValue())});
            SaveServiceHelper.save((DynamicObject[])bills);
        }
    }
}

