/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.business.service.exrateopen;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mrm.common.helper.OrgHelper;
import kd.tmc.mrm.common.helper.QFilterHelper;
import kd.tmc.mrm.common.model.section.SectionCfgModel;
import org.apache.commons.lang3.tuple.Pair;

public class ExRateGapAnalysisModel {
    public static final String SEPARATOR1 = "-,,,-";
    public static final String SEPARATOR2 = ",---,";
    private ConcurrentHashMap<String, Pair<BigDecimal, BigDecimal>> forexQuoteCache = new ConcurrentHashMap();
    public static final Long TOTAL_ENTRY_ROW_ID = 202310241024L;
    private Date draftTime;
    private SectionCfgModel sectionCfgModel;
    private Map<String, Object> billType2SubjectIdMap = new HashMap<String, Object>();
    private Map<Long, List<Long>> subSubjectsMap = new HashMap<Long, List<Long>>();
    private Map<Long, String> subjectId2inOrOutMap;
    private String[] titles;
    private Map<Long, BigDecimal[]> resultData = new LinkedHashMap<Long, BigDecimal[]>();
    private ConcurrentHashMap<String, DynamicObject> gapAnalysisDetails = new ConcurrentHashMap();
    private DynamicObject forexQuote;
    private DynamicObject analysisObj;
    private DynamicObject subjectSystem;
    private DynamicObject sectionCfg;
    private DynamicObject reportCurrency;
    private Set<String> tipPairs;

    public String[] getTitles() {
        return this.titles;
    }

    public Map<Long, BigDecimal[]> getResultData() {
        return this.resultData;
    }

    public ConcurrentMap<String, DynamicObject> getGapAnalysisDetails() {
        return this.gapAnalysisDetails;
    }

    public Map<Long, List<Long>> getSubSubjectsMap() {
        return this.subSubjectsMap;
    }

    public Set<String> getTipPairs() {
        return this.tipPairs;
    }

    public DynamicObject getSubjectSystem() {
        return this.subjectSystem;
    }

    public ExRateGapAnalysisModel(DynamicObject forexQuote, DynamicObject analysisObj, DynamicObject subjectSystem, DynamicObject sectionCfg, DynamicObject reportCurrency) {
        DynamicObject obj;
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{forexQuote, analysisObj, subjectSystem, sectionCfg, reportCurrency})) {
            throw new KDBizException("Build Gap Analysis Model Exception.");
        }
        this.forexQuote = forexQuote;
        this.analysisObj = obj = BusinessDataServiceHelper.loadSingle((Object)analysisObj.getPkValue(), (String)"mrm_exrate_analysisobj");
        this.subjectSystem = subjectSystem;
        this.sectionCfg = sectionCfg;
        this.reportCurrency = reportCurrency;
    }

    public ExRateGapAnalysisModel(Object billId) {
        if (EmptyUtil.isEmpty((Object)billId)) {
            throw new KDBizException("Build Gap Analysis Model Exception.");
        }
        DynamicObject dbBill = QueryServiceHelper.queryOne((String)"mrm_exrate_gap_analysis", (String)"subjectSystem,sectionCfg", (QFilter[])new QFilter("id", "=", billId).toArray());
        DynamicObject subjectSystem = BusinessDataServiceHelper.loadSingle((Object)dbBill.getLong("subjectSystem"), (String)"mrm_subject_system");
        DynamicObject sectionCfg = BusinessDataServiceHelper.loadSingle((Object)dbBill.getLong("sectionCfg"), (String)"mrm_section_cfg");
        this.subjectSystem = subjectSystem;
        this.sectionCfg = sectionCfg;
    }

    public void analysis(String appId) {
        List orgIds;
        this.initParams();
        String filterStr = this.analysisObj.getString("filterconditionstr_tag");
        DynamicObject draft = this.analysisObj.getDynamicObject("draft");
        if (draft == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5206\u6790\u5bf9\u8c61\u91cc\u7684%s\u4e3a\u7a7a\u3002", (String)"ExRateGapAnalysisModel_0", (String)"tmc-mrm-business", (Object[])new Object[]{((IDataEntityProperty)this.analysisObj.getDataEntityType().getProperties().get((Object)"draft")).getDisplayName().getLocaleValue()}));
        }
        QFilter filter = new QFilter("exratedraft", "=", draft.getPkValue());
        QFilter schemaFilter = QFilterHelper.getFilter((String)"mrm_exrate_draft_data", (String)filterStr);
        if (schemaFilter != null) {
            filter.and(schemaFilter);
        }
        if ((orgIds = OrgHelper.getPermOrgIds(null, null, null, (String)appId, (String)"mrm_exrate_gap_analysis")) != null) {
            filter.and("org", "in", (Object)orgIds);
        }
        filter.and("billType.number", "in", this.billType2SubjectIdMap.keySet());
        filter.and("org", ">", (Object)0);
        filter.and("currency", ">", (Object)0);
        filter.and("currency", "!=", this.reportCurrency.getPkValue());
        QFilter capDateFilter = QFilter.isNotNull((String)"capcashflowentry.capamount").and(QFilter.isNull((String)"capcashflowentry.capdate").or("capcashflowentry.capdate", ">=", (Object)this.draftTime));
        QFilter inDateFilter = QFilter.isNotNull((String)"incashflowtentry.inamount").and(QFilter.isNull((String)"incashflowtentry.indate").or("incashflowtentry.indate", ">=", (Object)this.draftTime));
        QFilter capFilter = capDateFilter.and(filter);
        QFilter inFilter = inDateFilter.and(filter);
        DataSet capDataSet = QueryServiceHelper.queryDataSet((String)"ExRateGapAnalysisModel.capital", (String)"mrm_exrate_draft_data", (String)String.join((CharSequence)",", "currency.id as currencyId", "currency.number as currencyNumber", "org.id as orgId", "billType.number as billTypeNumber", "fxcurrencydirect", "capCashFlowEntry.capDate as date", "capCashFlowEntry.capAmount as capAmount", "0 as inAmount"), (QFilter[])capFilter.toArray(), null);
        DataSet inDataSet = QueryServiceHelper.queryDataSet((String)"ExRateGapAnalysisModel.interest", (String)"mrm_exrate_draft_data", (String)String.join((CharSequence)",", "currency.id as currencyId", "currency.number as currencyNumber", "org.id as orgId", "billType.number as billTypeNumber", "fxcurrencydirect", "inCashFlowtEntry.inDate as date", "0 as capAmount", "inCashFlowtEntry.inAmount as inAmount"), (QFilter[])inFilter.toArray(), null);
        DataSet dataSet = capDataSet.union(inDataSet);
        dataSet = dataSet.groupBy(new String[]{"currencyId", "currencyNumber", "orgId", "billTypeNumber", "fxcurrencydirect", "date"}).sum("capAmount").sum("inAmount").finish();
        dataSet = this.addFields(dataSet, true);
        dataSet = dataSet.filter("sectionIndex != -1");
        dataSet = dataSet.groupBy(new String[]{"sectionIndex", "subjectId", "orgId", "currencyId", "currencyNumber", "inOrOut"}).sum("capAmount").sum("inAmount").sum("gapAmount").sum("reportGapAmount").finish();
        dataSet.forEach(row -> {
            int sectionIndex = row.getInteger("sectionIndex");
            String subjectIdStr = row.getString("subjectId");
            long subjectId = Long.parseLong(subjectIdStr);
            BigDecimal capAmount = row.getBigDecimal("capAmount");
            BigDecimal inAmount = row.getBigDecimal("inAmount");
            String inOrOut = row.getString("inOrOut");
            BigDecimal reportGapAmount = row.getBigDecimal("reportGapAmount");
            DynamicObject gapAnalysisDetail = BusinessDataServiceHelper.newDynamicObject((String)"mrm_exrate_gap_detail");
            long id = DBServiceHelper.genGlobalLongId();
            gapAnalysisDetail.set("id", (Object)id);
            gapAnalysisDetail.set("section", (Object)this.titles[sectionIndex]);
            gapAnalysisDetail.set("subject", (Object)subjectId);
            gapAnalysisDetail.set("inorout", (Object)inOrOut);
            gapAnalysisDetail.set("reportcurrency", this.reportCurrency.getPkValue());
            gapAnalysisDetail.set("sectionindex", (Object)sectionIndex);
            gapAnalysisDetail.set("org", row.get("orgId"));
            gapAnalysisDetail.set("cashflowcurrency", row.get("currencyId"));
            gapAnalysisDetail.set("capcashflow", (Object)capAmount);
            gapAnalysisDetail.set("lncashflow", (Object)inAmount);
            gapAnalysisDetail.set("gapamount", row.get("gapAmount"));
            gapAnalysisDetail.set("reportgapamount", (Object)reportGapAmount.setScale(2, RoundingMode.HALF_UP));
            String key = "" + row.get("sectionIndex") + subjectId + row.get("currencyId") + row.get("orgId");
            this.gapAnalysisDetails.put(key, gapAnalysisDetail);
        });
    }

    public boolean analysis(String appId, Object currencyId) {
        List orgIds;
        this.initParams();
        String filterStr = this.analysisObj.getString("filterconditionstr_tag");
        DynamicObject draft = this.analysisObj.getDynamicObject("draft");
        if (draft == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5206\u6790\u5bf9\u8c61\u91cc\u7684%s\u4e3a\u7a7a\u3002", (String)"ExRateGapAnalysisModel_0", (String)"tmc-mrm-business", (Object[])new Object[]{((IDataEntityProperty)this.analysisObj.getDataEntityType().getProperties().get((Object)"draft")).getDisplayName().getLocaleValue()}));
        }
        QFilter filter = new QFilter("exratedraft", "=", draft.getPkValue());
        QFilter schemaFilter = QFilterHelper.getFilter((String)"mrm_exrate_draft_data", (String)filterStr);
        if (schemaFilter != null) {
            filter.and(schemaFilter);
        }
        if ((orgIds = OrgHelper.getPermOrgIds(null, null, null, (String)appId, (String)"mrm_exrate_sensitivity")) != null) {
            filter.and("org", "in", (Object)orgIds);
        }
        filter.and("billType.number", "in", this.billType2SubjectIdMap.keySet());
        filter.and("org", ">", (Object)0);
        filter.and("currency", "=", currencyId);
        QFilter capDateFilter = QFilter.isNotNull((String)"capcashflowentry.capamount").and(QFilter.isNull((String)"capcashflowentry.capdate").or("capcashflowentry.capdate", ">=", (Object)this.draftTime));
        QFilter inDateFilter = QFilter.isNotNull((String)"incashflowtentry.inamount").and(QFilter.isNull((String)"incashflowtentry.indate").or("incashflowtentry.indate", ">=", (Object)this.draftTime));
        QFilter capFilter = capDateFilter.and(filter);
        QFilter inFilter = inDateFilter.and(filter);
        DataSet capDataSet = QueryServiceHelper.queryDataSet((String)"ExRateGapAnalysisModel.capital", (String)"mrm_exrate_draft_data", (String)String.join((CharSequence)",", "currency.id as currencyId", "currency.number as currencyNumber", "org.id as orgId", "billType.number as billTypeNumber", "fxcurrencydirect", "capCashFlowEntry.capDate as date", "capCashFlowEntry.capAmount as capAmount", "0 as inAmount"), (QFilter[])capFilter.toArray(), null);
        DataSet inDataSet = QueryServiceHelper.queryDataSet((String)"ExRateGapAnalysisModel.interest", (String)"mrm_exrate_draft_data", (String)String.join((CharSequence)",", "currency.id as currencyId", "currency.number as currencyNumber", "org.id as orgId", "billType.number as billTypeNumber", "fxcurrencydirect", "inCashFlowtEntry.inDate as date", "0 as capAmount", "inCashFlowtEntry.inAmount as inAmount"), (QFilter[])inFilter.toArray(), null);
        DataSet dataSet = capDataSet.union(inDataSet);
        dataSet = dataSet.groupBy(new String[]{"currencyId", "currencyNumber", "orgId", "billTypeNumber", "fxcurrencydirect", "date"}).sum("capAmount").sum("inAmount").finish();
        dataSet = this.addFields(dataSet, false);
        dataSet = dataSet.filter("sectionIndex != -1");
        dataSet = dataSet.groupBy(new String[]{"sectionIndex", "subjectId"}).sum("gapAmount").finish();
        if (dataSet.isEmpty()) {
            return false;
        }
        Integer sectionCount = ((Row)dataSet.copy().groupBy().max("sectionIndex").finish().iterator().next()).getInteger("sectionIndex") + 1;
        if (this.resultData.entrySet().iterator().next().getValue().length != sectionCount) {
            for (Map.Entry<Long, BigDecimal[]> entry : this.resultData.entrySet()) {
                entry.setValue(new BigDecimal[sectionCount.intValue()]);
            }
        }
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            if (this.resultData.get(row.getLong("subjectId")) == null) continue;
            this.resultData.get((Object)row.getLong((String)"subjectId"))[row.getInteger((String)"sectionIndex").intValue()] = row.getBigDecimal("gapAmount");
        }
        this.addUp();
        return true;
    }

    public DataSet addFields(DataSet dataSet, final boolean dealReportGapAmount) {
        dataSet = dataSet.addFields(new String[]{"-1", "''", "''", "0.0", "0.0"}, new String[]{"sectionIndex", "subjectId", "inOrOut", "gapAmount", "reportGapAmount"});
        final RowMeta rowMetas = dataSet.getRowMeta();
        dataSet = dataSet.map(new MapFunction(){

            public Object[] map(Row row) {
                ArrayList<Object> rowInfo = new ArrayList<Object>();
                int sectionIndex = -1;
                String billType = row.getString("billTypeNumber");
                Object subjectId = ExRateGapAnalysisModel.this.billType2SubjectIdMap.get(billType);
                String inOrOut = null;
                boolean isForex = "tm_forex".equals(billType) || "tm_forex_forward".equals(billType) || "tm_forex_swaps".equals(billType) || "tm_forex_options".equals(billType);
                Date date = row.getDate("date");
                if (isForex) {
                    String[] subjects = ((String)subjectId).split(ExRateGapAnalysisModel.SEPARATOR2);
                    String currencyDirect = row.getString("fxcurrencydirect");
                    for (String s : subjects) {
                        String[] ss = s.split(ExRateGapAnalysisModel.SEPARATOR1);
                        inOrOut = ss[0];
                        subjectId = ss[1];
                        if ((!"buy".equals(currencyDirect) || !"in".equals(inOrOut)) && (!"sell".equals(currencyDirect) || !"out".equals(inOrOut))) continue;
                        sectionIndex = ExRateGapAnalysisModel.this.sectionCfgModel.get(date).getIndex();
                        break;
                    }
                } else {
                    inOrOut = (String)ExRateGapAnalysisModel.this.subjectId2inOrOutMap.get(subjectId);
                    sectionIndex = ExRateGapAnalysisModel.this.sectionCfgModel.get(date).getIndex();
                }
                BigDecimal reportGapAmount = BigDecimal.ZERO;
                BigDecimal capAmount = row.getBigDecimal("capAmount");
                BigDecimal inAmount = row.getBigDecimal("inAmount");
                BigDecimal cashFlowAmount = capAmount.add(inAmount);
                if (dealReportGapAmount) {
                    String billCurrency = row.getString("currencyNumber");
                    reportGapAmount = ExRateGapAnalysisModel.this.getReportGapAmount(cashFlowAmount, inOrOut, billCurrency);
                }
                for (String fieldName : rowMetas.getFieldNames()) {
                    if (fieldName.equals("subjectId")) {
                        rowInfo.add(String.valueOf(subjectId));
                        continue;
                    }
                    if (fieldName.equals("inOrOut")) {
                        rowInfo.add(inOrOut);
                        continue;
                    }
                    if (fieldName.equals("gapAmount")) {
                        if ("out".equals(inOrOut)) {
                            rowInfo.add(cashFlowAmount.negate());
                            continue;
                        }
                        rowInfo.add(cashFlowAmount);
                        continue;
                    }
                    if (fieldName.equals("reportGapAmount")) {
                        rowInfo.add(reportGapAmount);
                        continue;
                    }
                    if (fieldName.equals("sectionIndex")) {
                        rowInfo.add(sectionIndex);
                        continue;
                    }
                    rowInfo.add(row.get(fieldName));
                }
                return rowInfo.toArray();
            }

            public RowMeta getResultRowMeta() {
                return rowMetas;
            }
        });
        return dataSet;
    }

    public boolean queryResult(Set<Long> currencyIdSet, List<Long> orgIds, Object id) {
        DataSet dataSet;
        DynamicObjectCollection sectionEntry = this.sectionCfg.getDynamicObjectCollection("sectionentry");
        this.initSubjectInfo(sectionEntry);
        QFilter qFilter = new QFilter("srcBill", "=", id);
        if (EmptyUtil.isNoEmpty(currencyIdSet)) {
            qFilter.and("cashFlowCurrency", "in", currencyIdSet);
        }
        if (orgIds != null) {
            qFilter.and("org", "in", orgIds);
        }
        if ((dataSet = QueryServiceHelper.queryDataSet((String)"GapAnalysisEdit", (String)"mrm_exrate_gap_detail", (String)String.join((CharSequence)",", "sectionIndex", "subject", "gapAmount"), (QFilter[])qFilter.toArray(), null).groupBy(new String[]{"sectionIndex", "subject"}).sum("gapAmount").finish()).isEmpty()) {
            return false;
        }
        int sectionCount = ((Row)dataSet.copy().groupBy().max("sectionIndex").finish().iterator().next()).getInteger("sectionIndex") + 1;
        if (this.resultData.entrySet().iterator().next().getValue().length != sectionCount) {
            for (Map.Entry<Long, BigDecimal[]> entry : this.resultData.entrySet()) {
                entry.setValue(new BigDecimal[sectionCount]);
            }
        }
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            if (this.resultData.get(row.getLong("subject")) == null) continue;
            this.resultData.get((Object)row.getLong((String)"subject"))[row.getInteger((String)"sectionIndex").intValue()] = row.getBigDecimal("gapAmount");
        }
        this.addUp();
        return true;
    }

    private void initParams() {
        DynamicObject obj = QueryServiceHelper.queryOne((String)"mrm_exrate_analysisobj", (String)"draft.draftCreateDate", (QFilter[])new QFilter("id", "=", this.analysisObj.getPkValue()).toArray());
        if (obj.getDate("draft.draftCreateDate") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5b58\u7eed\u5206\u6790\u5bf9\u8c61\u65e0\u5e95\u7a3f\u53d6\u6570\u65f6\u95f4\u3002", (String)"ExRateGapAnalysisModel_2", (String)"tmc-mrm-business", (Object[])new Object[0]));
        }
        this.draftTime = obj.getDate("draft.draftCreateDate");
        this.sectionCfgModel = new SectionCfgModel(this.sectionCfg, this.draftTime, false);
        this.titles = this.sectionCfgModel.getSectionTitles();
        DynamicObjectCollection sectionEntry = this.sectionCfg.getDynamicObjectCollection("sectionentry");
        this.initSubjectInfo(sectionEntry);
        this.tipPairs = new HashSet<String>(8);
    }

    private BigDecimal exChangeAmount(String billCurrency, String reportCurrency, DynamicObject forexQuote, BigDecimal amount) {
        BigDecimal buyPrice;
        BigDecimal sellPrice;
        String fxQuote;
        if (EmptyUtil.isEmpty((String)billCurrency)) {
            return amount;
        }
        String pair = billCurrency + "/" + reportCurrency;
        String inversePair = reportCurrency + "/" + billCurrency;
        if (this.forexQuoteCache.containsKey(pair)) {
            Pair<BigDecimal, BigDecimal> v = this.forexQuoteCache.get(pair);
            fxQuote = pair;
            sellPrice = (BigDecimal)v.getKey();
            buyPrice = (BigDecimal)v.getValue();
        } else if (this.forexQuoteCache.containsKey(inversePair)) {
            Pair<BigDecimal, BigDecimal> v = this.forexQuoteCache.get(inversePair);
            fxQuote = inversePair;
            sellPrice = (BigDecimal)v.getKey();
            buyPrice = (BigDecimal)v.getValue();
        } else {
            ForexQuoteInfo info = MarketDataServiceHelper.getForexQuoteInfoWithoutThrow((Long)forexQuote.getLong("id"), (String)pair, null, null);
            if (info == null) {
                this.tipPairs.add(pair);
                this.forexQuoteCache.put(pair, (Pair<BigDecimal, BigDecimal>)Pair.of((Object)BigDecimal.ONE, (Object)BigDecimal.ONE));
                return amount;
            }
            fxQuote = info.getFxquote();
            sellPrice = info.getSellPrice();
            buyPrice = info.getBuyPrice();
            this.forexQuoteCache.put(fxQuote, (Pair<BigDecimal, BigDecimal>)Pair.of((Object)sellPrice, (Object)buyPrice));
        }
        if (fxQuote.startsWith(reportCurrency)) {
            if (EmptyUtil.isEmpty((BigDecimal)sellPrice)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5916\u6c47\u62a5\u4ef7\u3010%1s\u3011\u4e2d\u8d27\u5e01\u5bf9\u4e3a\u3010%2s\u3011\u7684\u5356\u51fa\u4ef7\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ExRateGapAnalysisModel_4", (String)"tmc-mrm-business", (Object[])new Object[0]), forexQuote.get("number"), pair));
            }
            return amount.divide(sellPrice, 10, RoundingMode.HALF_UP);
        }
        return amount.multiply(buyPrice);
    }

    private BigDecimal getReportGapAmount(BigDecimal amount, String inOrOut, String billCurrency) {
        if (!this.reportCurrency.getString("number").equals(billCurrency)) {
            amount = this.exChangeAmount(billCurrency, this.reportCurrency.getString("number"), this.forexQuote, amount);
        }
        if ("out".equals(inOrOut)) {
            amount = amount.negate();
        }
        return amount;
    }

    private void addUp() {
        Optional<Integer> maxSubjectLevelOptional = this.subjectSystem.getDynamicObjectCollection("subjecttreeentry").stream().map(row -> row.getInt("level")).max(Comparator.comparingInt(o -> o));
        if (!maxSubjectLevelOptional.isPresent()) {
            throw new KDBizException("max subject level not find.");
        }
        int maxSubjectLevel = maxSubjectLevelOptional.get();
        for (int i = maxSubjectLevel - 1; i >= 1; --i) {
            for (DynamicObject row2 : this.subjectSystem.getDynamicObjectCollection("subjecttreeentry")) {
                List<Long> subSubjectIds;
                if (i != row2.getInt("level") || (subSubjectIds = this.subSubjectsMap.get(row2.getLong("id"))) == null) continue;
                Long subjectId = row2.getDynamicObject("subject").getLong("id");
                BigDecimal[] amounts = this.resultData.get(subjectId);
                for (Long subSubjectId : subSubjectIds) {
                    BigDecimal[] subAmounts = this.resultData.get(subSubjectId);
                    for (int j = 0; j < subAmounts.length; ++j) {
                        if (amounts[j] == null) {
                            amounts[j] = BigDecimal.ZERO;
                        }
                        if (subAmounts[j] == null) {
                            subAmounts[j] = BigDecimal.ZERO;
                        }
                        amounts[j] = amounts[j].add(subAmounts[j]);
                    }
                }
            }
        }
        this.addUpTotalRow();
    }

    private void addUpTotalRow() {
        BigDecimal[] amounts = this.resultData.get(TOTAL_ENTRY_ROW_ID);
        List<Long> subSubjectIds = this.subSubjectsMap.get(TOTAL_ENTRY_ROW_ID);
        for (Long subSubjectId : subSubjectIds) {
            BigDecimal[] subAmounts = this.resultData.get(subSubjectId);
            for (int j = 0; j < subAmounts.length; ++j) {
                if (amounts[j] == null) {
                    amounts[j] = BigDecimal.ZERO;
                }
                if (subAmounts[j] == null) {
                    subAmounts[j] = BigDecimal.ZERO;
                }
                amounts[j] = amounts[j].add(subAmounts[j]);
            }
        }
    }

    private void initSubjectInfo(DynamicObjectCollection sectionEntry) {
        this.subSubjectsMap.put(TOTAL_ENTRY_ROW_ID, new ArrayList());
        for (DynamicObject subjectTreeEntryRow : this.subjectSystem.getDynamicObjectCollection("subjecttreeentry")) {
            Long pid;
            Long subjectId = subjectTreeEntryRow.getDynamicObject("subject").getLong("id");
            if (subjectTreeEntryRow.getBoolean("isleaf") && EmptyUtil.isNoEmpty((String)subjectTreeEntryRow.getString("mapping_tag"))) {
                FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)subjectTreeEntryRow.getString("mapping_tag"), FilterCondition.class);
                List filterRow = condition.getFilterRow();
                SimpleFilterRow simpleFilterRows = (SimpleFilterRow)filterRow.get(0);
                List baseDataIds = simpleFilterRows.getBaseDataIds();
                for (FilterValue baseDataId : baseDataIds) {
                    String billType = (String)baseDataId.getValue();
                    if ("tm_forex".equals(billType) || "tm_forex_forward".equals(billType) || "tm_forex_swaps".equals(billType) || "tm_forex_options".equals(billType)) {
                        String inOrOut = subjectTreeEntryRow.getString("direct");
                        if (this.billType2SubjectIdMap.get(billType) != null) {
                            Object temp = this.billType2SubjectIdMap.get(billType);
                            temp = inOrOut + SEPARATOR1 + subjectId + SEPARATOR2 + temp;
                            this.billType2SubjectIdMap.put(billType, temp);
                            continue;
                        }
                        this.billType2SubjectIdMap.put(billType, inOrOut + SEPARATOR1 + subjectId);
                        continue;
                    }
                    this.billType2SubjectIdMap.put(billType, subjectId);
                }
                this.subSubjectsMap.get(TOTAL_ENTRY_ROW_ID).add(subjectId);
            }
            if (EmptyUtil.isNoEmpty((Long)(pid = Long.valueOf(subjectTreeEntryRow.getLong("pid"))))) {
                this.subSubjectsMap.computeIfAbsent(pid, k -> new ArrayList());
                this.subSubjectsMap.get(pid).add(subjectId);
            }
            this.resultData.put(subjectId, new BigDecimal[sectionEntry.size()]);
        }
        this.subjectId2inOrOutMap = new HashMap<Long, String>(8);
        for (DynamicObject row : this.subjectSystem.getDynamicObjectCollection("subjecttreeentry")) {
            this.subjectId2inOrOutMap.put(row.getDynamicObject("subject").getLong("id"), row.getString("direct"));
        }
        this.resultData.put(TOTAL_ENTRY_ROW_ID, new BigDecimal[sectionEntry.size()]);
    }
}

