/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.business.service.exrateopen;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.DynamicObjectUtil;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mrm.business.service.scenariosimulation.ExScenarioSimulationService;
import kd.tmc.mrm.common.helper.OrgHelper;
import kd.tmc.mrm.common.helper.QFilterHelper;
import kd.tmc.mrm.common.model.section.SectionCfgModel;
import org.apache.commons.lang3.tuple.Pair;

public class ExRateSensitivityAnalysisModel {
    private final Long exScenarioSimulationId;
    private ExScenarioSimulationService exScenarioSimulationService;
    public static final String SEPARATOR1 = "-,,,-";
    public static final String SEPARATOR2 = ",---,";
    private final ConcurrentHashMap<String, Pair<BigDecimal, BigDecimal>> forexQuoteCache = new ConcurrentHashMap();
    private Date draftTime;
    private SectionCfgModel sectionCfgModel;
    private final Map<String, String> billTypeToSubjectMap = new HashMap<String, String>();
    private Map<String, String> subjectName2inOrOutMap;
    private String[] titles;
    private List<DynamicObject> gapAnalysisDetails = new ArrayList<DynamicObject>();
    private final DynamicObject forexQuote;
    private final DynamicObject analysisObj;
    private final DynamicObject subjectSystem;
    private final DynamicObject sectionCfg;
    private final DynamicObject baseCurrency;
    private final BigDecimal exRate;
    private Set<String> tipPairs;

    public DynamicObject getForexQuote() {
        return this.forexQuote;
    }

    public final String[] getTitles() {
        return this.titles;
    }

    public final List<DynamicObject> getGapAnalysisDetails() {
        return this.gapAnalysisDetails;
    }

    public Set<String> getTipPairs() {
        return this.tipPairs;
    }

    public ExRateSensitivityAnalysisModel(Object sensitivityAnalysisBillId, Object currencyId) {
        DynamicObject sensitivityAnalysisBill = BusinessDataServiceHelper.loadSingle((String)"mrm_exrate_sensitivity", (String)"subjectSystem,forexQuote,currentAnalysisObj,sectionCfg,baseCurrency,scenarioSimulation", (QFilter[])new QFilter("id", "=", sensitivityAnalysisBillId).toArray());
        if (sensitivityAnalysisBill == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u53d1\u751f\u53d8\u52a8\uff0c\u8bf7\u5173\u95ed\u5f53\u524d\u9875\u9762\u3002", (String)"ExRateGapAnalysisModel_5", (String)"tmc-mrm-business", (Object[])new Object[0]));
        }
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{sensitivityAnalysisBill.get("forexquote"), sensitivityAnalysisBill.get("currentanalysisobj"), sensitivityAnalysisBill.get("subjectsystem"), sensitivityAnalysisBill.get("sectioncfg"), sensitivityAnalysisBill.get("baseCurrency"), sensitivityAnalysisBill.get("scenariosimulation")})) {
            throw new KDBizException("Build Sensitivity Analysis Model Exception.");
        }
        this.forexQuote = sensitivityAnalysisBill.getDynamicObject("forexquote");
        this.analysisObj = BusinessDataServiceHelper.loadSingle((Object)sensitivityAnalysisBill.getDynamicObject("currentanalysisobj").getPkValue(), (String)"mrm_exrate_analysisobj");
        this.subjectSystem = BusinessDataServiceHelper.loadSingleFromCache((Object)sensitivityAnalysisBill.getDynamicObject("subjectsystem").getPkValue(), (String)"mrm_subject_system");
        this.sectionCfg = sensitivityAnalysisBill.getDynamicObject("sectioncfg");
        this.baseCurrency = sensitivityAnalysisBill.getDynamicObject("baseCurrency");
        this.exScenarioSimulationId = sensitivityAnalysisBill.getDynamicObject("scenariosimulation").getLong("id");
        DynamicObject analysisDetailBill = QueryServiceHelper.queryOne((String)"mrm_exrate_sens_detail", (String)"exrate", (QFilter[])new QFilter("srcbillid", "=", sensitivityAnalysisBillId).and("cashflowcurrency", "=", currencyId).and("exrate", ">", (Object)0).toArray());
        if (analysisDetailBill == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u53d1\u751f\u53d8\u52a8\uff0c\u8bf7\u5173\u95ed\u5f53\u524d\u9875\u9762\u3002", (String)"ExRateGapAnalysisModel_5", (String)"tmc-mrm-business", (Object[])new Object[0]));
        }
        this.exRate = analysisDetailBill.getBigDecimal("exrate");
    }

    public ExRateSensitivityAnalysisModel(DynamicObject forexQuote, DynamicObject analysisObj, DynamicObject subjectSystem, DynamicObject sectionCfg, DynamicObject baseCurrency, Long exScenarioSimulationId) {
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{forexQuote, analysisObj, subjectSystem, sectionCfg, baseCurrency, exScenarioSimulationId})) {
            throw new KDBizException("Build Sensitivity Analysis Model Exception.");
        }
        this.exRate = null;
        this.forexQuote = forexQuote;
        this.analysisObj = BusinessDataServiceHelper.loadSingle((Object)analysisObj.getPkValue(), (String)"mrm_exrate_analysisobj");
        this.subjectSystem = subjectSystem;
        this.sectionCfg = sectionCfg;
        this.baseCurrency = baseCurrency;
        this.exScenarioSimulationId = exScenarioSimulationId;
    }

    public void analysis(String appId) {
        int i;
        this.initParams();
        QFilter filter = this.getBaseQFilter();
        List orgIds = OrgHelper.getPermOrgIds(null, null, null, (String)appId, (String)"mrm_exrate_sensitivity");
        if (orgIds != null) {
            filter.and("org", "in", (Object)orgIds);
        }
        filter.and("org", ">", (Object)0);
        Set<Long> currencySet = this.exScenarioSimulationService.getCurrencySet();
        if (EmptyUtil.isNoEmpty(currencySet)) {
            filter.and("currency", "in", currencySet);
        } else {
            filter.and("currency", ">", (Object)0L);
        }
        filter.and("currency", "!=", this.baseCurrency.getPkValue());
        filter.and(QFilter.isNotNull((String)"currency.number"));
        QFilter capDateFilter = QFilter.isNotNull((String)"capcashflowentry.capamount").and(QFilter.isNull((String)"capcashflowentry.capdate").or("capcashflowentry.capdate", ">=", (Object)this.draftTime));
        QFilter inDateFilter = QFilter.isNotNull((String)"incashflowtentry.inamount").and(QFilter.isNull((String)"incashflowtentry.indate").or("incashflowtentry.indate", ">=", (Object)this.draftTime));
        QFilter capFilter = capDateFilter.and(filter);
        QFilter inFilter = inDateFilter.and(filter);
        DataSet capDataSet = QueryServiceHelper.queryDataSet((String)"ExRateSensitivityAnalysisModel.capital", (String)"mrm_exrate_draft_data", (String)String.join((CharSequence)",", "currency.id as currencyId", "currency.number as currencyNumber", "org.id as orgId", "billType.number as billTypeNumber", "fxcurrencydirect", "capCashFlowEntry.capDate as date", "capCashFlowEntry.capAmount as capAmount", "0 as inAmount"), (QFilter[])capFilter.toArray(), null);
        DataSet inDataSet = QueryServiceHelper.queryDataSet((String)"ExRateSensitivityAnalysisModel.interest", (String)"mrm_exrate_draft_data", (String)String.join((CharSequence)",", "currency.id as currencyId", "currency.number as currencyNumber", "org.id as orgId", "billType.number as billTypeNumber", "fxcurrencydirect", "incashflowtentry.inDate as date", "0 as capAmount", "incashflowtentry.inAmount as inAmount"), (QFilter[])inFilter.toArray(), null);
        DataSet dataSet = capDataSet.union(inDataSet);
        dataSet = dataSet.groupBy(new String[]{"currencyId", "currencyNumber", "orgId", "billTypeNumber", "fxcurrencydirect", "date"}).sum("capAmount").sum("inAmount").finish();
        String[] simulateNameArr = this.exScenarioSimulationService.getSimulateNameArr();
        int simulationCount = simulateNameArr.length;
        dataSet = this.addFields(dataSet);
        dataSet = dataSet.filter("sectionIndex != -1");
        GroupbyDataSet groupedDataSet = dataSet.groupBy(new String[]{"orgId", "currencyId", "currencyNumber", "inOrOut"}).max("exRate").sum("reportGapAmount").sum("capAmount").sum("inAmount");
        for (i = 0; i < simulationCount; ++i) {
            groupedDataSet.sum("pl" + (i + 1));
        }
        for (i = 0; i < simulationCount; ++i) {
            groupedDataSet.sum("balance" + (i + 1));
        }
        dataSet = groupedDataSet.finish();
        DynamicObject currency = QueryServiceHelper.queryOne((String)"bd_currency", (String)"amtPrecision", (QFilter[])new QFilter("id", "=", this.baseCurrency.getPkValue()).toArray());
        int amtPrecision = currency.getInt("amtPrecision");
        dataSet.forEach(row -> {
            BigDecimal capAmount = row.getBigDecimal("capAmount");
            BigDecimal inAmount = row.getBigDecimal("inAmount");
            String inOrOut = row.getString("inOrOut");
            BigDecimal reportGapAmount = row.getBigDecimal("reportGapAmount");
            DynamicObject detail = BusinessDataServiceHelper.newDynamicObject((String)"mrm_exrate_sens_detail");
            long id = DBServiceHelper.genGlobalLongId();
            detail.set("id", (Object)id);
            detail.set("inorout", (Object)inOrOut);
            detail.set("baseCurrency", this.baseCurrency.getPkValue());
            detail.set("org", row.get("orgId"));
            detail.set("cashflowcurrency", row.get("currencyId"));
            BigDecimal gap = capAmount.add(inAmount);
            if ("out".equals(inOrOut)) {
                gap = gap.negate();
            }
            detail.set("exRate", row.get("exRate"));
            detail.set("gapamount", (Object)gap.setScale(amtPrecision, RoundingMode.HALF_UP));
            detail.set("reportgapamount", (Object)reportGapAmount.setScale(amtPrecision, RoundingMode.HALF_UP));
            for (int i = 1; i <= simulationCount; ++i) {
                detail.set("pl" + i, (Object)row.getBigDecimal("pl" + i).setScale(amtPrecision, RoundingMode.HALF_UP));
                detail.set("balance" + i, (Object)row.getBigDecimal("balance" + i).setScale(amtPrecision, RoundingMode.HALF_UP));
            }
            this.gapAnalysisDetails.add(detail);
        });
        Map<String, List<DynamicObject>> groupedData = this.gapAnalysisDetails.stream().collect(Collectors.groupingBy(o -> o.getLong("org") + "" + o.getLong("cashflowcurrency")));
        for (Map.Entry<String, List<DynamicObject>> e : groupedData.entrySet()) {
            List<DynamicObject> list = e.getValue();
            DynamicObject detail = BusinessDataServiceHelper.newDynamicObject((String)"mrm_exrate_sens_detail");
            DynamicObjectUtil.copy((DynamicObject)list.get(0), (DynamicObject)detail, (String[])new String[0]);
            detail.set("inorout", (Object)"sum");
            if (list.size() > 2) {
                throw new KDBizException("analysis inOrOut Exception");
            }
            if (list.size() == 2) {
                detail.set("gapamount", (Object)list.get(0).getBigDecimal("gapamount").add(list.get(1).getBigDecimal("gapamount")));
                detail.set("reportgapamount", (Object)list.get(0).getBigDecimal("reportgapamount").add(list.get(1).getBigDecimal("reportgapamount")));
                for (int i2 = 1; i2 <= simulationCount; ++i2) {
                    String plProp = "pl" + i2;
                    String balanceProp = "balance" + i2;
                    detail.set(plProp, (Object)list.get(0).getBigDecimal(plProp).add(list.get(1).getBigDecimal(plProp)));
                    detail.set(balanceProp, (Object)list.get(0).getBigDecimal(balanceProp).add(list.get(1).getBigDecimal(balanceProp)));
                }
            }
            this.gapAnalysisDetails.add(detail);
        }
    }

    public DataSet analysis(Object currencyId, List<Long> orgIds) {
        int i;
        this.initParams();
        QFilter filter = this.getBaseQFilter();
        if (orgIds != null) {
            filter.and("org", "in", orgIds);
        }
        filter.and("org", ">", (Object)0);
        filter.and("currency", "=", currencyId);
        QFilter capDateFilter = QFilter.isNotNull((String)"capcashflowentry.capamount").and(QFilter.isNull((String)"capcashflowentry.capdate").or("capcashflowentry.capdate", ">=", (Object)this.draftTime));
        QFilter inDateFilter = QFilter.isNotNull((String)"incashflowtentry.inamount").and(QFilter.isNull((String)"incashflowtentry.indate").or("incashflowtentry.indate", ">=", (Object)this.draftTime));
        QFilter capFilter = capDateFilter.and(filter);
        QFilter inFilter = inDateFilter.and(filter);
        DataSet capDataSet = QueryServiceHelper.queryDataSet((String)"ExRateSensitivityAnalysisModel.capital", (String)"mrm_exrate_draft_data", (String)String.join((CharSequence)",", "currency.id as currencyId", "currency.number as currencyNumber", "org.id as orgId", "billType.number as billTypeNumber", "fxcurrencydirect", "capCashFlowEntry.capDate as date", "capCashFlowEntry.capAmount as capAmount", "0 as inAmount"), (QFilter[])capFilter.toArray(), null);
        DataSet inDataSet = QueryServiceHelper.queryDataSet((String)"ExRateSensitivityAnalysisModel.interest", (String)"mrm_exrate_draft_data", (String)String.join((CharSequence)",", "currency.id as currencyId", "currency.number as currencyNumber", "org.id as orgId", "billType.number as billTypeNumber", "fxcurrencydirect", "incashflowtentry.inDate as date", "0 as capAmount", "incashflowtentry.inAmount as inAmount"), (QFilter[])inFilter.toArray(), null);
        DataSet dataSet = capDataSet.union(inDataSet);
        dataSet = dataSet.groupBy(new String[]{"currencyId", "currencyNumber", "orgId", "billTypeNumber", "fxcurrencydirect", "date"}).sum("capAmount").sum("inAmount").finish();
        String[] simulateNameArr = this.exScenarioSimulationService.getSimulateNameArr();
        int simulationCount = simulateNameArr.length;
        dataSet = this.addFields(dataSet);
        dataSet = dataSet.filter("sectionIndex != -1");
        GroupbyDataSet groupedDataSet = dataSet.groupBy(new String[]{"sectionIndex", "currencyId", "currencyNumber", "inOrOut"}).max("exRate").sum("reportGapAmount").sum("capAmount").sum("inAmount");
        for (i = 1; i <= simulationCount; ++i) {
            groupedDataSet.sum("pl" + i);
        }
        for (i = 1; i <= simulationCount; ++i) {
            groupedDataSet.sum("balance" + i);
        }
        dataSet = groupedDataSet.finish();
        return dataSet;
    }

    public DataSet analysis(Object orgId, Long currencyId, int simulationNo, Map<String, Object> reportQueryParam) {
        this.initParams();
        QFilter filter = this.getBaseQFilter();
        filter.and("org", "=", orgId);
        filter.and("currency", "=", (Object)currencyId);
        filter.and("org", ">", (Object)0);
        String bizDataSource = (String)reportQueryParam.get("bizDataSource");
        MulBasedataDynamicObjectCollection billTypeCol = (MulBasedataDynamicObjectCollection)reportQueryParam.get("billType");
        String gapDirect = (String)reportQueryParam.get("gapDirect");
        Date startDate = (Date)reportQueryParam.get("startDate");
        Date endDate = (Date)reportQueryParam.get("endDate");
        BigDecimal minAmount = (BigDecimal)reportQueryParam.get("minAmount");
        BigDecimal maxAmount = (BigDecimal)reportQueryParam.get("maxAmount");
        if (EmptyUtil.isNoEmpty((String)bizDataSource)) {
            filter.and("bizdatasource", "in", (Object)bizDataSource.split(","));
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)billTypeCol)) {
            Set billTypeIdSet = billTypeCol.stream().map(o -> o.getDynamicObject("fBaseDataId").get("id")).collect(Collectors.toSet());
            filter.and("billtype", "in", billTypeIdSet);
        }
        QFilter capDateFilter = QFilter.isNull((String)"capcashflowentry.capdate").or("capcashflowentry.capdate", ">=", (Object)this.draftTime);
        QFilter inDateFilter = QFilter.isNull((String)"incashflowtentry.indate").or("incashflowtentry.indate", ">=", (Object)this.draftTime);
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{startDate, endDate})) {
            capDateFilter.and("capcashflowentry.capdate", ">=", (Object)startDate).and("capcashflowentry.capdate", "<=", (Object)endDate);
            inDateFilter.and("incashflowtentry.indate", ">=", (Object)startDate).and("incashflowtentry.indate", "<=", (Object)endDate);
        }
        if (EmptyUtil.isNoEmpty((BigDecimal)minAmount) || EmptyUtil.isNoEmpty((BigDecimal)maxAmount)) {
            if (EmptyUtil.isNoEmpty((BigDecimal)minAmount)) {
                capDateFilter = capDateFilter.and("capcashflowentry.capamount", ">=", (Object)minAmount);
                inDateFilter = inDateFilter.and("incashflowtentry.inamount", ">=", (Object)minAmount);
            }
            if (EmptyUtil.isNoEmpty((BigDecimal)maxAmount)) {
                capDateFilter = capDateFilter.and("capcashflowentry.capamount", "<=", (Object)maxAmount);
                inDateFilter = inDateFilter.and("incashflowtentry.inamount", "<=", (Object)maxAmount);
            }
        } else {
            capDateFilter = capDateFilter.and(QFilter.isNotNull((String)"capcashflowentry.capamount"));
            inDateFilter = inDateFilter.and(QFilter.isNotNull((String)"incashflowtentry.inamount"));
        }
        QFilter capFilter = capDateFilter.and(filter);
        QFilter inFilter = inDateFilter.and(filter);
        DataSet capDataSet = QueryServiceHelper.queryDataSet((String)"ExRateSensitivityAnalysisModel.capital", (String)"mrm_exrate_draft_data", (String)String.join((CharSequence)",", "id as bill", "billType.number as billTypeNumber", "fxcurrencydirect", "'cap' as type", "capCashFlowEntry.seq as no", "capCashFlowEntry.capDate as date", "capCashFlowEntry.capAmount as amount"), (QFilter[])capFilter.toArray(), null);
        DataSet inDataSet = QueryServiceHelper.queryDataSet((String)"ExRateSensitivityAnalysisModel.interest", (String)"mrm_exrate_draft_data", (String)String.join((CharSequence)",", "id as bill", "billType.number as billTypeNumber", "fxcurrencydirect", "'in' as type", "incashflowtentry.seq as no", "incashflowtentry.inDate as date", "incashflowtentry.inAmount as amount"), (QFilter[])inFilter.toArray(), null);
        DataSet dataSet = capDataSet.union(inDataSet);
        DynamicObject currency = QueryServiceHelper.queryOne((String)"bd_currency", (String)"number", (QFilter[])new QFilter("id", "=", (Object)currencyId).toArray());
        dataSet = this.addFields(dataSet, simulationNo, currencyId, currency.getString("number"));
        dataSet = dataSet.filter("sectionIndex != -1");
        if (EmptyUtil.isNoEmpty((String)gapDirect)) {
            dataSet = dataSet.filter("inOrOut = '" + gapDirect + "'");
        }
        return dataSet;
    }

    public DataSet addFields(DataSet dataSet) {
        final BigDecimal currentExRate = this.exRate;
        dataSet = dataSet.addFields(new String[]{"-1", "-1", "''", "''", "0.0"}, new String[]{"exRate", "sectionIndex", "subjectName", "inOrOut", "reportGapAmount"});
        String[] simulateNameArr = this.exScenarioSimulationService.getSimulateNameArr();
        final int simulationCount = simulateNameArr.length;
        String[] expressionArray = new String[simulationCount];
        String[] PlArray = new String[simulationCount];
        String[] BalanceArray = new String[simulationCount];
        for (int i = 0; i < simulationCount; ++i) {
            expressionArray[i] = "-1";
            PlArray[i] = "pl" + (i + 1);
            BalanceArray[i] = "balance" + (i + 1);
        }
        dataSet = dataSet.addFields(expressionArray, PlArray);
        dataSet = dataSet.addFields(expressionArray, BalanceArray);
        final RowMeta rowMetas = dataSet.getRowMeta();
        dataSet = dataSet.map(new MapFunction(){

            public Object[] map(Row row) {
                List<BigDecimal> simulateExRateList;
                ArrayList<Object> rowInfo = new ArrayList<Object>();
                int sectionIndex = -1;
                String billType = row.getString("billTypeNumber");
                String subjectName = (String)ExRateSensitivityAnalysisModel.this.billTypeToSubjectMap.get(billType);
                String inOrOut = null;
                boolean isForex = "tm_forex".equals(billType) || "tm_forex_forward".equals(billType) || "tm_forex_swaps".equals(billType) || "tm_forex_options".equals(billType);
                Date date = row.getDate("date");
                if (isForex) {
                    String[] subjects = subjectName.split(ExRateSensitivityAnalysisModel.SEPARATOR2);
                    String currencyDirect = row.getString("fxcurrencydirect");
                    for (String s : subjects) {
                        String[] ss = s.split(ExRateSensitivityAnalysisModel.SEPARATOR1);
                        inOrOut = ss[0];
                        subjectName = ss[1];
                        if ((!"buy".equals(currencyDirect) || !"in".equals(inOrOut)) && (!"sell".equals(currencyDirect) || !"out".equals(inOrOut))) continue;
                        sectionIndex = ExRateSensitivityAnalysisModel.this.sectionCfgModel.get(date).getIndex();
                        break;
                    }
                } else {
                    inOrOut = (String)ExRateSensitivityAnalysisModel.this.subjectName2inOrOutMap.get(subjectName);
                    sectionIndex = ExRateSensitivityAnalysisModel.this.sectionCfgModel.get(date).getIndex();
                }
                BigDecimal capAmount = row.getBigDecimal("capAmount");
                BigDecimal inAmount = row.getBigDecimal("inAmount");
                BigDecimal cashFlowAmount = capAmount.add(inAmount);
                String billCurrency = row.getString("currencyNumber");
                Long currencyId = row.getLong("currencyId");
                BigDecimal exRate = currentExRate != null ? currentExRate : ExRateSensitivityAnalysisModel.this.getExRate(billCurrency, ExRateSensitivityAnalysisModel.this.baseCurrency.getString("number"), ExRateSensitivityAnalysisModel.this.forexQuote);
                BigDecimal reportGapAmount = cashFlowAmount.multiply(exRate).setScale(10, RoundingMode.HALF_UP);
                if ("out".equals(inOrOut)) {
                    reportGapAmount = reportGapAmount.negate();
                }
                if (EmptyUtil.isEmpty(simulateExRateList = ExRateSensitivityAnalysisModel.this.exScenarioSimulationService.getSimulateExRateList(currencyId, date, exRate))) {
                    simulateExRateList = new ArrayList<BigDecimal>(5);
                    for (int i = 0; i < simulationCount; ++i) {
                        simulateExRateList.add(exRate);
                    }
                }
                ArrayList<BigDecimal> BalanceList = new ArrayList<BigDecimal>();
                ArrayList<BigDecimal> PlList = new ArrayList<BigDecimal>();
                for (BigDecimal simulateExRate : simulateExRateList) {
                    if ("out".equals(inOrOut)) {
                        BalanceList.add(cashFlowAmount.negate().multiply(simulateExRate).setScale(10, RoundingMode.HALF_UP));
                        PlList.add(cashFlowAmount.negate().multiply(simulateExRate.subtract(exRate)).setScale(10, RoundingMode.HALF_UP));
                        continue;
                    }
                    BalanceList.add(cashFlowAmount.multiply(simulateExRate).setScale(10, RoundingMode.HALF_UP));
                    PlList.add(cashFlowAmount.multiply(simulateExRate.subtract(exRate)).setScale(10, RoundingMode.HALF_UP));
                }
                block3: for (String fieldName : rowMetas.getFieldNames()) {
                    int i;
                    if (fieldName.equals("exRate")) {
                        rowInfo.add(exRate);
                        continue;
                    }
                    if (fieldName.equals("reportGapAmount")) {
                        rowInfo.add(reportGapAmount);
                        continue;
                    }
                    if (fieldName.equals("subjectName")) {
                        rowInfo.add(subjectName);
                        continue;
                    }
                    if (fieldName.equals("inOrOut")) {
                        rowInfo.add(inOrOut);
                        continue;
                    }
                    if (fieldName.equals("sectionIndex")) {
                        rowInfo.add(sectionIndex);
                        continue;
                    }
                    if (fieldName.contains("pl")) {
                        for (i = 0; i < simulationCount; ++i) {
                            if (!fieldName.equals("pl" + (i + 1))) continue;
                            rowInfo.add(PlList.get(i));
                            continue block3;
                        }
                        continue;
                    }
                    if (fieldName.contains("balance")) {
                        for (i = 0; i < simulationCount; ++i) {
                            if (!fieldName.equals("balance" + (i + 1))) continue;
                            rowInfo.add(BalanceList.get(i));
                            continue block3;
                        }
                        continue;
                    }
                    rowInfo.add(row.get(fieldName));
                }
                return rowInfo.toArray();
            }

            public RowMeta getResultRowMeta() {
                return rowMetas;
            }
        });
        return dataSet;
    }

    public DataSet addFields(DataSet dataSet, final int simulationNo, final Long currencyId, final String currencyNumber) {
        dataSet = dataSet.addFields(new String[]{"0.0", "-1", "''", "0.0", "0.0", "0.0", "0.0", this.baseCurrency.getPkValue() + "+''", currencyId + "+''"}, new String[]{"exRate", "sectionIndex", "inOrOut", "simulateExRate", "reportAmount", "pl", "gap", "reportCurrency", "billCurrency"});
        final BigDecimal currentExRate = this.exRate;
        final RowMeta rowMetas = dataSet.getRowMeta();
        dataSet = dataSet.map(new MapFunction(){

            public Object[] map(Row row) {
                ArrayList<Object> rowInfo = new ArrayList<Object>();
                int sectionIndex = -1;
                String billType = row.getString("billTypeNumber");
                String subjectName = (String)ExRateSensitivityAnalysisModel.this.billTypeToSubjectMap.get(billType);
                String inOrOut = null;
                boolean isForex = "tm_forex".equals(billType) || "tm_forex_forward".equals(billType) || "tm_forex_swaps".equals(billType) || "tm_forex_options".equals(billType);
                Date date = row.getDate("date");
                BigDecimal exRate = currentExRate != null ? currentExRate : ExRateSensitivityAnalysisModel.this.getExRate(currencyNumber, ExRateSensitivityAnalysisModel.this.baseCurrency.getString("number"), ExRateSensitivityAnalysisModel.this.forexQuote);
                BigDecimal simulateExRate = ExRateSensitivityAnalysisModel.this.exScenarioSimulationService.getSimulateExRateByIndex(currencyId, date, exRate, simulationNo);
                if (EmptyUtil.isEmpty((BigDecimal)simulateExRate)) {
                    simulateExRate = exRate;
                }
                if (isForex) {
                    String[] subjects = subjectName.split(ExRateSensitivityAnalysisModel.SEPARATOR2);
                    String currencyDirect = row.getString("fxcurrencydirect");
                    String[] stringArray = subjects;
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String s = stringArray[i];
                        String[] ss = s.split(ExRateSensitivityAnalysisModel.SEPARATOR1);
                        inOrOut = ss[0];
                        if ((!"buy".equals(currencyDirect) || !"in".equals(inOrOut)) && (!"sell".equals(currencyDirect) || !"out".equals(inOrOut))) continue;
                        sectionIndex = ExRateSensitivityAnalysisModel.this.sectionCfgModel.get(date).getIndex();
                        break;
                    }
                } else {
                    inOrOut = (String)ExRateSensitivityAnalysisModel.this.subjectName2inOrOutMap.get(subjectName);
                    sectionIndex = ExRateSensitivityAnalysisModel.this.sectionCfgModel.get(date).getIndex();
                }
                BigDecimal amount = row.getBigDecimal("amount");
                for (String fieldName : rowMetas.getFieldNames()) {
                    if (fieldName.equals("inOrOut")) {
                        rowInfo.add(inOrOut);
                        continue;
                    }
                    if (fieldName.equals("sectionIndex")) {
                        rowInfo.add(sectionIndex);
                        continue;
                    }
                    if (fieldName.equals("simulateExRate")) {
                        rowInfo.add(simulateExRate);
                        continue;
                    }
                    if (fieldName.equals("exRate")) {
                        rowInfo.add(exRate);
                        continue;
                    }
                    if (fieldName.equals("gap")) {
                        if ("out".equals(inOrOut)) {
                            rowInfo.add(amount.negate());
                            continue;
                        }
                        rowInfo.add(amount);
                        continue;
                    }
                    if (fieldName.equals("reportAmount")) {
                        if ("out".equals(inOrOut)) {
                            rowInfo.add(amount.negate().multiply(exRate).setScale(10, RoundingMode.HALF_UP));
                            continue;
                        }
                        rowInfo.add(amount.multiply(exRate).setScale(10, RoundingMode.HALF_UP));
                        continue;
                    }
                    if (fieldName.equals("pl")) {
                        if ("out".equals(inOrOut)) {
                            rowInfo.add(amount.negate().multiply(simulateExRate.subtract(exRate)).setScale(10, RoundingMode.HALF_UP));
                            continue;
                        }
                        rowInfo.add(amount.multiply(simulateExRate.subtract(exRate)).setScale(10, RoundingMode.HALF_UP));
                        continue;
                    }
                    rowInfo.add(row.get(fieldName));
                }
                return rowInfo.toArray();
            }

            public RowMeta getResultRowMeta() {
                return rowMetas;
            }
        });
        return dataSet;
    }

    private void initParams() {
        DynamicObject obj = QueryServiceHelper.queryOne((String)"mrm_exrate_analysisobj", (String)"draft.draftCreateDate", (QFilter[])new QFilter("id", "=", this.analysisObj.getPkValue()).toArray());
        if (obj.getDate("draft.draftCreateDate") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5b58\u7eed\u5206\u6790\u5bf9\u8c61\u65e0\u5e95\u7a3f\u53d6\u6570\u65f6\u95f4\u3002", (String)"ExRateGapAnalysisModel_2", (String)"tmc-mrm-business", (Object[])new Object[0]));
        }
        this.draftTime = obj.getDate("draft.draftCreateDate");
        this.exScenarioSimulationService = new ExScenarioSimulationService(this.exScenarioSimulationId, this.draftTime);
        this.sectionCfgModel = new SectionCfgModel(this.sectionCfg, this.draftTime, false);
        this.titles = this.sectionCfgModel.getSectionTitles();
        this.initSubjectInfo();
        this.tipPairs = new HashSet<String>(8);
    }

    private QFilter getBaseQFilter() {
        String filterStr = this.analysisObj.getString("filterconditionstr_tag");
        DynamicObject draft = this.analysisObj.getDynamicObject("draft");
        if (draft == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5206\u6790\u5bf9\u8c61\u91cc\u7684%s\u4e3a\u7a7a\u3002", (String)"ExRateGapAnalysisModel_0", (String)"tmc-mrm-business", (Object[])new Object[]{((IDataEntityProperty)this.analysisObj.getDataEntityType().getProperties().get((Object)"draft")).getDisplayName().getLocaleValue()}));
        }
        QFilter filter = new QFilter("exratedraft", "=", draft.getPkValue());
        QFilter schemaFilter = QFilterHelper.getFilter((String)"mrm_exrate_draft_data", (String)filterStr);
        if (schemaFilter != null) {
            filter.and(schemaFilter);
        }
        filter.and("billType.number", "in", this.billTypeToSubjectMap.keySet());
        return filter;
    }

    private BigDecimal getExRate(String billCurrency, String baseCurrency, DynamicObject forexQuote) {
        BigDecimal buyPrice;
        BigDecimal sellPrice;
        String fxQuote;
        if (EmptyUtil.isEmpty((String)billCurrency)) {
            throw new KDBizException("billCurrency is null.");
        }
        String pair = billCurrency + "/" + baseCurrency;
        String inversePair = baseCurrency + "/" + billCurrency;
        if (this.forexQuoteCache.containsKey(pair)) {
            Pair<BigDecimal, BigDecimal> v = this.forexQuoteCache.get(pair);
            fxQuote = pair;
            sellPrice = (BigDecimal)v.getKey();
            buyPrice = (BigDecimal)v.getValue();
        } else if (this.forexQuoteCache.containsKey(inversePair)) {
            Pair<BigDecimal, BigDecimal> v = this.forexQuoteCache.get(inversePair);
            fxQuote = inversePair;
            sellPrice = (BigDecimal)v.getKey();
            buyPrice = (BigDecimal)v.getValue();
        } else {
            ForexQuoteInfo info = MarketDataServiceHelper.getForexQuoteInfoWithoutThrow((Long)forexQuote.getLong("id"), (String)pair, null, null);
            if (info == null) {
                this.tipPairs.add(pair);
                fxQuote = pair;
                sellPrice = BigDecimal.ONE;
                buyPrice = BigDecimal.ONE;
            } else {
                fxQuote = info.getFxquote();
                sellPrice = info.getSellPrice();
                buyPrice = info.getBuyPrice();
            }
            this.forexQuoteCache.put(fxQuote, (Pair<BigDecimal, BigDecimal>)Pair.of((Object)sellPrice, (Object)buyPrice));
        }
        if (fxQuote.startsWith(billCurrency)) {
            return buyPrice;
        }
        return BigDecimal.ONE.divide(sellPrice, 10, RoundingMode.HALF_UP);
    }

    private void initSubjectInfo() {
        for (DynamicObject subjectTreeEntryRow : this.subjectSystem.getDynamicObjectCollection("subjecttreeentry")) {
            String subjectName = subjectTreeEntryRow.getDynamicObject("subject").getString("name");
            if (!subjectTreeEntryRow.getBoolean("isleaf") || !EmptyUtil.isNoEmpty((String)subjectTreeEntryRow.getString("mapping_tag"))) continue;
            FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)subjectTreeEntryRow.getString("mapping_tag"), FilterCondition.class);
            List filterRow = condition.getFilterRow();
            SimpleFilterRow simpleFilterRows = (SimpleFilterRow)filterRow.get(0);
            List baseDataIds = simpleFilterRows.getBaseDataIds();
            for (FilterValue baseDataId : baseDataIds) {
                String billType = (String)baseDataId.getValue();
                if ("tm_forex".equals(billType) || "tm_forex_forward".equals(billType) || "tm_forex_swaps".equals(billType) || "tm_forex_options".equals(billType)) {
                    String inOrOut = subjectTreeEntryRow.getString("direct");
                    if (this.billTypeToSubjectMap.get(billType) != null) {
                        String tempSubjectName = this.billTypeToSubjectMap.get(billType);
                        tempSubjectName = inOrOut + SEPARATOR1 + subjectName + SEPARATOR2 + tempSubjectName;
                        this.billTypeToSubjectMap.put(billType, tempSubjectName);
                        continue;
                    }
                    this.billTypeToSubjectMap.put(billType, inOrOut + SEPARATOR1 + subjectName);
                    continue;
                }
                this.billTypeToSubjectMap.put(billType, subjectName);
            }
        }
        this.subjectName2inOrOutMap = new HashMap<String, String>(8);
        for (DynamicObject row : this.subjectSystem.getDynamicObjectCollection("subjecttreeentry")) {
            this.subjectName2inOrOutMap.put(row.getDynamicObject("subject").getString("name"), row.getString("direct"));
        }
    }
}

