/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.business.service.integrate.draft.common;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.mrm.business.service.integrate.draft.common.IdPaginator;

public class AcctBalPaginator
extends IdPaginator {
    private List<Object> listIds = new ArrayList<Object>();
    private int lastIdx = 0;

    public AcctBalPaginator(String entity, QFilter qFilter) {
        super(entity, qFilter);
    }

    @Override
    public List<Object> nextPageIds() {
        if (this.listIds.size() == 0) {
            QFilter acctStatusQ = new QFilter("acctstatus", "!=", (Object)"closed");
            DataSet accDS = QueryServiceHelper.queryDataSet((String)"query-accountbank-id", (String)"bd_accountbanks", (String)"id,bankaccountnumber", (QFilter[])acctStatusQ.toArray(), null);
            ArrayList acctIds = new ArrayList();
            accDS.forEach(row -> acctIds.add(row.get("id")));
            QFilter acctQ = new QFilter("accountbank.id", "in", acctIds);
            Date currentDate = DateUtils.getCurrentDate();
            acctQ.and("bizdate", ">", (Object)DateUtils.getLastMonth((Date)currentDate, (int)1));
            acctQ.and("bizdate", "<", (Object)DateUtils.getNextDay((Date)currentDate, (int)1));
            acctQ.and(this.getQFilter());
            DataSet balDS = QueryServiceHelper.queryDataSet((String)"query-bankbalance-n", (String)"bei_bankbalance", (String)"id, accountbank,currency,bizdate, amount", (QFilter[])acctQ.toArray(), null);
            DataSet maxBalDS = balDS.copy().groupBy(new String[]{"accountbank", "currency"}).max("bizdate").finish();
            DataSet finalBalDS = maxBalDS.join(balDS).on("accountbank", "accountbank").on("currency", "currency").on("bizdate", "bizdate").select(new String[]{"id", "accountbank", "amount"}).finish();
            finalBalDS = finalBalDS.filter("amount!=0");
            finalBalDS.forEach(row -> this.listIds.add(row.get("id")));
        }
        if (this.listIds.size() < this.getPageSize()) {
            this.lastIdx = this.listIds.size();
            return this.listIds;
        }
        int toIndex = Math.min(this.lastIdx + this.getPageSize(), this.listIds.size());
        List<Object> subListIds = this.listIds.subList(this.lastIdx, toIndex);
        this.lastIdx = toIndex;
        return subListIds;
    }

    @Override
    public boolean hasNext() {
        return this.lastIdx < this.listIds.size() - 1;
    }
}

