/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.business.service.integrate.draft.common;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.service.botp.convert.ConvertEngine;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mrm.business.service.integrate.draft.common.DataGetResult;

public class BotpConvertor {
    private static final int BOTP_MAX_COUNT = 500;
    private String sourceEntity;
    private String targetEntity;
    private String botpRuleId;
    private int failedCount;
    private List<Object> failedBillIds;
    private List<Object> failedBillNos;
    private List<String> errorMsg;

    public int getFailedCount() {
        return this.failedCount;
    }

    public void setFailedCount(int failedCount) {
        this.failedCount = failedCount;
    }

    public List<Object> getFailedBillIds() {
        return this.failedBillIds;
    }

    public List<Object> getFailedBillNos() {
        return this.failedBillNos;
    }

    public void addFailedBillIds(Object id) {
        if (this.failedBillIds == null) {
            this.failedBillIds = new ArrayList<Object>(10);
        }
        this.failedBillIds.add(id);
    }

    public void addFailedBillNo(String msg) {
        if (this.failedBillNos == null) {
            this.failedBillNos = new ArrayList<Object>(10);
        }
        this.failedBillNos.add(msg);
    }

    public List<String> getErrorMsg() {
        return this.errorMsg;
    }

    public void addErrorMsg(String msg) {
        if (this.errorMsg == null) {
            this.errorMsg = new ArrayList<String>(10);
        }
        this.errorMsg.add(msg);
    }

    public BotpConvertor(String sourceEntity, String targetEntity, String botpRuleId) {
        this.sourceEntity = sourceEntity;
        this.targetEntity = targetEntity;
        this.botpRuleId = botpRuleId;
    }

    public DataGetResult doConvert(List<Object> listIds) {
        PushArgs args = new PushArgs();
        args.setSourceEntityNumber(this.getSourceEntity());
        args.setTargetEntityNumber(this.getTargetEntity());
        DataGetResult dResult = new DataGetResult();
        int srcIdCount = listIds.size();
        int botpMaxCount = this.getBotpMaxCount();
        int botpLoop = srcIdCount / botpMaxCount + (srcIdCount % botpMaxCount > 0 ? 1 : 0);
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>(srcIdCount);
        IRefrencedataProvider refDataProvider = BusinessDataServiceHelper::loadRefence;
        for (int i = 0; i < botpLoop; ++i) {
            int begin = i * botpMaxCount;
            int end = Math.min(begin + botpMaxCount, srcIdCount);
            ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(end - begin);
            for (int j = begin; j < end; ++j) {
                ListSelectedRow row = new ListSelectedRow();
                row.setPrimaryKeyValue(listIds.get(j));
                selectedRows.add(row);
            }
            args.setRuleId(this.getBotpRuleId());
            args.setSelectedRows(selectedRows);
            ConvertEngine engine = new ConvertEngine();
            ConvertOperationResult result = engine.push(args);
            if (result.isSuccess()) {
                MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)this.getTargetEntity());
                resultList.addAll(result.loadTargetDataObjects(refDataProvider, mainType));
            }
            List sReports = result.getBillReports();
            int failCount = 0;
            for (int k = 0; k < sReports.size(); ++k) {
                SourceBillReport rp = (SourceBillReport)sReports.get(k);
                if (rp.isSuccess()) continue;
                if (EmptyUtil.isNoEmpty((String)rp.getFailMessage())) {
                    ++failCount;
                }
                if (this.getErrorMsg() != null && this.getErrorMsg().size() >= 100) continue;
                this.addErrorMsg(rp.getFailMessage());
                this.addFailedBillNo(rp.getBillNo());
                this.addFailedBillIds(rp.getBillId());
            }
            this.setFailedCount(this.getFailedCount() + failCount);
        }
        dResult.setSuccessObjs(resultList);
        dResult.setSuccessCount(dResult.getSuccessCount() + resultList.size());
        return dResult;
    }

    public String getSourceEntity() {
        return this.sourceEntity;
    }

    public String getTargetEntity() {
        return this.targetEntity;
    }

    public String getBotpRuleId() {
        return this.botpRuleId;
    }

    protected int getBotpMaxCount() {
        return 500;
    }
}

