/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.business.service.integrate.draft.common;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mrm.common.entry.DraftCfgEntry;
import kd.tmc.mrm.common.enums.ExecStatusEnum;

public class DataGetTaskLog {
    private static Log logger = LogFactory.getLog(DataGetTaskLog.class);
    private DynamicObject taskLogDO;
    private Map<Long, DynamicObject> subTaskMap = new HashMap<Long, DynamicObject>(15);

    public static DataGetTaskLog createTaskLog() {
        return new DataGetTaskLog();
    }

    public static DataGetTaskLog createFailLog(DynamicObject draft, String taskid, String riskType, String execobjtype, String execType, Date execdate, String op, LocaleString message) {
        DataGetTaskLog log = new DataGetTaskLog();
        log.initMainTask(taskid, riskType, execobjtype, execType, execdate, op);
        log.initDraft(draft);
        log.endTaskLog(ExecStatusEnum.FAILED.getValue(), message);
        log.persist(true);
        return log;
    }

    public void initMainTask(String taskid, String riskType, String execobjtype, String execType, Date execdate, String op) {
        this.taskLogDO = BusinessDataServiceHelper.newDynamicObject((String)"mrm_rate_draft_log");
        long id = DBServiceHelper.genGlobalLongId();
        this.taskLogDO.set("id", (Object)id);
        this.taskLogDO.set("billno", (Object)String.valueOf(id));
        this.taskLogDO.set("risktype", (Object)riskType);
        this.taskLogDO.set("exectype", (Object)execType);
        this.taskLogDO.set("execobjtype", (Object)execobjtype);
        this.taskLogDO.set("execop", (Object)op);
        this.taskLogDO.set("execdate", (Object)execdate);
        this.taskLogDO.set("execstatus", (Object)ExecStatusEnum.EXECUTING.getValue());
        this.taskLogDO.set("starttime", (Object)new Date());
        this.taskLogDO.set("creator", (Object)RequestContext.get().getCurrUserId());
        this.taskLogDO.set("billstatus", (Object)TcBillStatusEnum.AUDIT.getValue());
        this.taskLogDO.set("taskid", (Object)taskid);
    }

    public void deleteTask(String riskType, String execobjtype, String execType, String op, String billNo, LocaleString msg) {
        this.taskLogDO = BusinessDataServiceHelper.newDynamicObject((String)"mrm_rate_draft_log");
        long id = DBServiceHelper.genGlobalLongId();
        this.taskLogDO.set("id", (Object)id);
        this.taskLogDO.set("billno", (Object)String.valueOf(id));
        this.taskLogDO.set("risktype", (Object)riskType);
        this.taskLogDO.set("exectype", (Object)execType);
        this.taskLogDO.set("execobjtype", (Object)execobjtype);
        this.taskLogDO.set("execop", (Object)op);
        this.taskLogDO.set("execdate", (Object)new Date());
        this.taskLogDO.set("execstatus", (Object)ExecStatusEnum.SUCCESSFUL.getValue());
        this.taskLogDO.set("starttime", (Object)new Date());
        this.taskLogDO.set("creator", (Object)RequestContext.get().getCurrUserId());
        this.taskLogDO.set("billstatus", (Object)TcBillStatusEnum.AUDIT.getValue());
        this.taskLogDO.set("draftno", (Object)billNo);
        this.taskLogDO.set("endtime", (Object)new Date());
        this.taskLogDO.set("loginfo_tag", (Object)msg);
    }

    public void initDraft(DynamicObject draftDO) {
        if (draftDO != null) {
            this.taskLogDO.set("draftid", (Object)draftDO.getLong("id"));
            this.taskLogDO.set("draftno", (Object)draftDO.getString("billno"));
        }
    }

    public void initSubTask(List<DraftCfgEntry> subTasks) {
        for (DraftCfgEntry sub : subTasks) {
            DynamicObjectCollection dc = this.taskLogDO.getDynamicObjectCollection("entryentity");
            DynamicObject entry = dc.addNew();
            entry.set("e_datasource", (Object)sub.getSourceId());
            entry.set("e_execstatus", (Object)ExecStatusEnum.INIT.getValue());
            this.subTaskMap.put(sub.getSourceId(), entry);
        }
    }

    public void beginSubTaskLog(Long subtaskKey) {
        DynamicObject subTaskLogDO = this.subTaskMap.get(subtaskKey);
        if (subTaskLogDO != null) {
            subTaskLogDO.set("e_starttime", (Object)new Date());
            subTaskLogDO.set("e_execstatus", (Object)ExecStatusEnum.EXECUTING.getValue());
        }
    }

    public void endSubTaskLog(Long subtaskKey, String status, String message, int count, int failedCount) {
        DynamicObject subTaskLogDO = this.subTaskMap.get(subtaskKey);
        Date endtime = new Date();
        subTaskLogDO.set("e_endtime", (Object)endtime);
        subTaskLogDO.set("e_execstatus", (Object)status);
        subTaskLogDO.set("e_detail_tag", (Object)message);
        subTaskLogDO.set("e_count", (Object)count);
        subTaskLogDO.set("e_failcount", (Object)failedCount);
        long costtime = endtime.getTime() - subTaskLogDO.getDate("e_starttime").getTime();
        subTaskLogDO.set("e_costtime", (Object)(costtime / 1000L));
    }

    public void endSubTaskLog(Long logEntrykey, int totalCount, int failedTotalCount, List<String> errorMsgs) {
        if (totalCount > 0 && failedTotalCount > 0) {
            this.endSubTaskLog(logEntrykey, ExecStatusEnum.PARTIALSUCCESS.getValue(), errorMsgs.stream().collect(Collectors.joining()), totalCount, failedTotalCount);
        }
        if (totalCount <= 0 && failedTotalCount > 0) {
            this.endSubTaskLog(logEntrykey, ExecStatusEnum.FAILED.getValue(), errorMsgs.stream().collect(Collectors.joining()), totalCount, failedTotalCount);
        }
        if (failedTotalCount <= 0) {
            this.endSubTaskLog(logEntrykey, ExecStatusEnum.DONE.getValue(), errorMsgs.stream().collect(Collectors.joining()), totalCount, failedTotalCount);
        }
    }

    public void setStatus() {
        Collection<DynamicObject> values = this.subTaskMap.values();
        boolean done = values.stream().allMatch(e -> ExecStatusEnum.isDone((String)e.getString("e_execstatus")));
        boolean fail = values.stream().allMatch(e -> ExecStatusEnum.isFailed((String)e.getString("e_execstatus")));
        if (done) {
            this.taskLogDO.set("execstatus", (Object)ExecStatusEnum.SUCCESSFUL.getValue());
        } else if (fail) {
            this.taskLogDO.set("execstatus", (Object)ExecStatusEnum.FAILED.getValue());
        } else {
            this.taskLogDO.set("execstatus", (Object)ExecStatusEnum.PARTIALSUCCESS.getValue());
        }
    }

    public void endTaskLog(String status, LocaleString message) {
        if (EmptyUtil.isEmpty((String)status)) {
            this.setStatus();
        } else {
            this.taskLogDO.set("execstatus", (Object)status);
        }
        this.taskLogDO.set("endtime", (Object)new Date());
        this.taskLogDO.set("loginfo_tag", (Object)message);
        long costtime = this.taskLogDO.getDate("endtime").getTime() - this.taskLogDO.getDate("starttime").getTime();
        this.taskLogDO.set("costtime", (Object)(costtime / 1000L));
    }

    public void persist(boolean newTrans) {
        if (newTrans) {
            try (TXHandle tx = TX.requiresNew((String)"mrm.dataget.log");){
                try {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.taskLogDO});
                }
                catch (Exception e) {
                    tx.markRollback();
                    logger.error((Throwable)e);
                }
            }
        } else {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.taskLogDO});
        }
    }
}

