/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.business.service.integrate.draft.common;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mrm.business.service.integrate.draft.common.DataGetParam;
import kd.tmc.mrm.common.entry.DraftCfgEntry;
import kd.tmc.mrm.common.enums.ExecOpEnum;

public class DraftCfgParser {
    public static List<DraftCfgEntry> parseInrateRuleCfg(DynamicObject draftConfig, String targetEntity, DataGetParam param) {
        List<Long> sourceIds;
        DynamicObjectCollection entries = draftConfig.getDynamicObjectCollection("entryentity");
        ArrayList<DraftCfgEntry> entryList = new ArrayList<DraftCfgEntry>(entries.size());
        if (ExecOpEnum.isInratedraft_update((String)param.getExecOpEnum().getValue()) && (sourceIds = param.getSourceIds()) != null && sourceIds.size() > 0) {
            entries.removeIf(e -> !sourceIds.contains(e.getDynamicObject("sourcebill").getLong("id")));
        }
        for (DynamicObject row : entries) {
            String ruleId = row.getString("ruleid");
            DynamicObject sourceBill = row.getDynamicObject("sourcebill");
            DraftCfgEntry draftCfgEntry = DraftCfgParser.buildDraftCfgEntry(sourceBill, targetEntity, ruleId);
            if (draftCfgEntry == null) continue;
            entryList.add(draftCfgEntry);
        }
        return entryList;
    }

    private static DraftCfgEntry buildDraftCfgEntry(DynamicObject sourceBill, String targetEntity, String ruleId) {
        if (!EmptyUtil.isEmpty((DynamicObject)sourceBill)) {
            DynamicObject sourcebill = sourceBill.getDynamicObject("sourcebill");
            DynamicObject sourceentity = sourceBill.getDynamicObject("sourceentity");
            return new DraftCfgEntry(Long.valueOf(sourceBill.getLong("id")), sourcebill.getString("number"), sourcebill.getString("name"), sourceentity.getString("number"), targetEntity, ruleId);
        }
        return null;
    }
}

