/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.business.service.integrate.draft.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.mrm.business.service.integrate.draft.common.AcctBalPaginator;
import kd.tmc.mrm.business.service.integrate.draft.common.InnerAcctBalPaginator;

public class IdPaginator {
    private static Log logger = LogFactory.getLog(IdPaginator.class);
    private static final int DB_PAGE_SIZE = 10000;
    private String sourceEntity;
    private QFilter qFilter;
    protected Long lastId;
    protected List<Object> currentIds;
    protected Map<Long, Map<String, Object>> idPropDataMap = new HashMap<Long, Map<String, Object>>();

    public Object getByIdAndProp(Long id, String prop) {
        Map<String, Object> propData = this.idPropDataMap.get(id);
        if (propData != null) {
            return propData.get(prop);
        }
        return null;
    }

    public IdPaginator(String entity, QFilter qFilter) {
        this.sourceEntity = entity;
        this.qFilter = qFilter;
        this.lastId = 0L;
    }

    public List<Object> nextPageIds() {
        logger.info("\u5206\u6279\u53d6id\u5f00\u59cb\u3002\u3002");
        ArrayList<Object> listIds = new ArrayList<Object>();
        QFilter pageFilter = new QFilter("id", ">", (Object)this.lastId);
        try (DataSet idDs = QueryServiceHelper.queryDataSet((String)"batch-query-id", (String)this.getSourceEntity(), (String)"id", (QFilter[])new QFilter[]{this.qFilter, pageFilter}, (String)"id asc", (int)this.getPageSize());){
            idDs.forEach(row -> listIds.add(row.get("id")));
        }
        logger.info("\u5206\u6279\u53d6id\u7ed3\u675f\u3002\u3002");
        if (listIds.size() > 0) {
            this.lastId = (Long)listIds.get(listIds.size() - 1);
        }
        this.currentIds = listIds;
        return listIds;
    }

    public boolean hasNext() {
        if (this.currentIds.isEmpty()) {
            return false;
        }
        return this.getPageSize() <= this.currentIds.size();
    }

    protected int getPageSize() {
        return 10000;
    }

    public String getSourceEntity() {
        return this.sourceEntity;
    }

    public QFilter getQFilter() {
        return this.qFilter;
    }

    public static IdPaginator createPaginatorBy(String entity, QFilter qFilter) {
        switch (entity) {
            case "bei_bankbalance": {
                return new AcctBalPaginator(entity, qFilter);
            }
            case "ifm_accountbalance": {
                return new InnerAcctBalPaginator(entity, qFilter);
            }
        }
        return new IdPaginator(entity, qFilter);
    }
}

