/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.business.service.integrate.draft.common;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.mrm.business.service.integrate.draft.common.IdPaginator;

public class InnerAcctBalPaginator
extends IdPaginator {
    private List<Object> listIds = new ArrayList<Object>();
    private int lastIdx = 0;

    public InnerAcctBalPaginator(String entity, QFilter qFilter) {
        super(entity, qFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> nextPageIds() {
        if (this.listIds.size() == 0) {
            DynamicObject[] innerAcctDO;
            this.idPropDataMap.clear();
            ArrayList acctIds = new ArrayList();
            HashMap bankInnerAccountMap = new HashMap();
            QFilter acctStatusQ = new QFilter("acctstatus", "!=", (Object)"closed");
            acctStatusQ = acctStatusQ.and("inneracct", "!=", (Object)0);
            DynamicObject[] dynamicObjectArray = null;
            try (DataSet accDS = QueryServiceHelper.queryDataSet((String)"query-accountbank-id", (String)"bd_accountbanks", (String)"id,bankaccountnumber,inneracct", (QFilter[])acctStatusQ.toArray(), null);){
                accDS.forEach(row -> {
                    acctIds.add(row.get("id"));
                    bankInnerAccountMap.putIfAbsent(row.getLong("inneracct"), row.getLong("id"));
                });
            }
            catch (Throwable object) {
                dynamicObjectArray = object;
                throw object;
            }
            acctStatusQ = new QFilter("acctstatus", "!=", (Object)"closed");
            acctStatusQ = acctStatusQ.and("id", "in", bankInnerAccountMap.keySet());
            for (DynamicObject innerAcct : innerAcctDO = BusinessDataServiceHelper.load((String)"ifm_inneracct", (String)"id,org", (QFilter[])acctStatusQ.toArray())) {
                HashMap<String, DynamicObject> accountIdScOrgMap = new HashMap<String, DynamicObject>();
                accountIdScOrgMap.put("inneracctorg", innerAcct.getDynamicObject("org"));
                this.idPropDataMap.put(bankInnerAccountMap.get(innerAcct.getLong("id")), accountIdScOrgMap);
            }
            QFilter acctQ = new QFilter("accountbank.id", "in", acctIds);
            Date currentDate = DateUtils.getCurrentDate();
            acctQ.and("bizdate", ">", (Object)DateUtils.getLastMonth((Date)currentDate, (int)1));
            acctQ.and("bizdate", "<", (Object)DateUtils.getNextDay((Date)currentDate, (int)1));
            acctQ.and(this.getQFilter());
            DataSet balDS = null;
            DataSet finalBalDS = null;
            DataSet maxBalDS = null;
            try {
                balDS = QueryServiceHelper.queryDataSet((String)"query-ifmaccountbalance-n", (String)"ifm_accountbalance", (String)"id, accountbank,currency,bizdate, amount", (QFilter[])acctQ.toArray(), null);
                maxBalDS = balDS.copy().groupBy(new String[]{"accountbank", "currency"}).max("bizdate").finish();
                finalBalDS = maxBalDS.join(balDS).on("accountbank", "accountbank").on("currency", "currency").on("bizdate", "bizdate").select(new String[]{"id", "accountbank", "amount"}).finish();
                finalBalDS = finalBalDS.filter("amount!=0");
                finalBalDS.forEach(row -> this.listIds.add(row.get("id")));
                this.closeDS(balDS);
                this.closeDS(maxBalDS);
                this.closeDS(finalBalDS);
            }
            catch (Throwable throwable) {
                this.closeDS(balDS);
                this.closeDS(maxBalDS);
                this.closeDS(finalBalDS);
                throw throwable;
            }
        }
        if (this.listIds.size() < this.getPageSize()) {
            this.lastIdx = this.listIds.size();
            return this.listIds;
        }
        int toIndex = Math.min(this.lastIdx + this.getPageSize(), this.listIds.size());
        List<Object> subListIds = this.listIds.subList(this.lastIdx, toIndex);
        this.lastIdx = toIndex;
        return subListIds;
    }

    private void closeDS(DataSet ds) {
        if (ds != null) {
            ds.close();
        }
    }

    @Override
    public boolean hasNext() {
        return this.lastIdx < this.listIds.size() - 1;
    }
}

