/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mrm.business.service.integrate.draft.exrate;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mrm.business.service.integrate.draft.common.DataGetContext;
import kd.tmc.mrm.business.service.integrate.draft.common.DataGetParam;
import kd.tmc.mrm.business.service.integrate.draft.common.DataGetTaskLog;
import kd.tmc.mrm.business.service.integrate.draft.exrate.ExRateDataGetHandlerFactory;
import kd.tmc.mrm.business.service.integrate.draft.exrate.handler.ExRateDataGetHandler;
import kd.tmc.mrm.common.entry.DraftCfgEntry;
import kd.tmc.mrm.common.enums.DraftLogTypeEnum;
import kd.tmc.mrm.common.enums.DraftStatusEnum;
import kd.tmc.mrm.common.enums.ExecObjEnum;
import kd.tmc.mrm.common.enums.ExecOpEnum;
import kd.tmc.mrm.common.enums.ExecStatusEnum;
import kd.tmc.mrm.common.helper.ResManagerHelper;

public class ExRateDataGetService {
    private static Log logger = LogFactory.getLog(ExRateDataGetService.class);
    private static final String LOCKID = "exrate_drafttask_lockid";
    private static final String LOCKKEY = "GetExRateDraftData";
    private DynamicObject draftDO;
    private DataGetTaskLog taskLog = DataGetTaskLog.createTaskLog();

    protected DynamicObject readDraftConfig() {
        QFilter filter = new QFilter("enable", "=", (Object)true);
        DynamicObjectCollection configs = QueryServiceHelper.query((String)"mrm_exrate_draft_cfg", (String)"id", (QFilter[])filter.toArray());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)configs)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u542f\u7528\u7684\u201c\u6c47\u7387\u5e95\u7a3f\u914d\u7f6e\u201d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ExRateDataGetService_0", (String)"tmc-mrm-business", (Object[])new Object[0]));
        }
        if (configs.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u591a\u6761\u542f\u7528\u7684\u201c\u6c47\u7387\u5e95\u7a3f\u914d\u7f6e\u201d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ExRateDataGetService_1", (String)"tmc-mrm-business", (Object[])new Object[0]));
        }
        return BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)configs.get(0)).get("id"), (String)"mrm_exrate_draft_cfg");
    }

    public void execute(DataGetParam param) {
        boolean isLock = MutexServiceHelper.request((String)LOCKID, (String)"mrm_exrate_draft", (String)LOCKKEY);
        try {
            if (isLock) {
                this.doExecute(param);
            } else {
                Long draftId = param.getDraftId();
                DynamicObject draft = null;
                if (draftId != null && draftId > 0L) {
                    draft = TmcDataServiceHelper.loadSingle((Object)draftId, (String)"mrm_exrate_draft");
                }
                DataGetTaskLog.createFailLog(draft, param.getTaskId(), DraftLogTypeEnum.EXRATE.getValue(), ExecObjEnum.EXRATE_DRAFT.getValue(), param.getExecTypeEnum().getValue(), DateUtils.getCurrentDate(), param.getExecOpEnum().getValue(), ResManagerHelper.getLocalString((LocaleString)ResManager.getLocaleString((String)"\u83b7\u53d6\u4e0d\u5230\u7f51\u7edc\u4e92\u65a5\uff0c\u53ef\u80fd\u5b58\u5728\u6b63\u5728\u6267\u884c\u7684\u4efb\u52a1\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ExRateDataGetService_7", (String)"tmc-mrm-business"), (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
        finally {
            if (isLock) {
                MutexServiceHelper.release((String)LOCKID, (String)"mrm_exrate_draft", (String)LOCKKEY);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExecute(DataGetParam param) {
        boolean hasError;
        int totalCount;
        long beginTime;
        block25: {
            List<DraftCfgEntry> ruleCfgEntryList;
            String execType = param.getExecTypeEnum().getValue();
            beginTime = System.currentTimeMillis();
            this.taskLog.initMainTask(param.getTaskId(), DraftLogTypeEnum.EXRATE.getValue(), ExecObjEnum.EXRATE_DRAFT.getValue(), param.getExecTypeEnum().getValue(), DateUtils.getCurrentDate(), param.getExecOpEnum().getValue());
            try {
                DynamicObject draftConfig = this.readDraftConfig();
                ruleCfgEntryList = this.parseRuleCfg(draftConfig, param);
                if (EmptyUtil.isEmpty(ruleCfgEntryList)) {
                    logger.info("\u6ca1\u6709\u914d\u7f6e\u6570\u636e\u6e90\u3002");
                    this.taskLog.endTaskLog(ExecStatusEnum.FAILED.getValue(), ResManagerHelper.getLocalString((LocaleString)ResManager.getLocaleString((String)"\u6ca1\u6709\u914d\u7f6e\u6570\u636e\u6e90\u3002", (String)"ExRateDataGetService_2", (String)"tmc-mrm-business"), (Object[])new Object[0]));
                    this.taskLog.persist(true);
                    return;
                }
            }
            catch (Exception e) {
                this.taskLog.endTaskLog(ExecStatusEnum.FAILED.getValue(), new LocaleString(e.getMessage()));
                this.taskLog.persist(true);
                return;
            }
            LocaleString errorMsg = this.checkIfTaskRunning(param);
            if (errorMsg != null) {
                this.taskLog.endTaskLog(ExecStatusEnum.FAILED.getValue(), errorMsg);
                this.taskLog.persist(true);
                return;
            }
            logger.info("\u5f00\u59cb\u62bd\u53d6\u5e95\u7a3f\u6570\u636e");
            totalCount = 0;
            int copyCount = 0;
            int deleteCount = 0;
            String previousVersionDraftNumber = "";
            hasError = false;
            this.buildRateDraft(param);
            this.taskLog.initSubTask(ruleCfgEntryList);
            this.taskLog.initDraft(this.draftDO);
            try {
                if (!ExecOpEnum.isExratedraft_update((String)param.getExecOpEnum().getValue())) {
                    DynamicObject previousVersionDraft = this.getPreviousVersionDraft(this.draftDO);
                    if (previousVersionDraft != null) {
                        previousVersionDraftNumber = previousVersionDraft.getString("billno");
                    }
                    copyCount = this.copyDataFromPreviousVersion(this.draftDO, previousVersionDraft);
                }
                for (DraftCfgEntry cfg : ruleCfgEntryList) {
                    DataGetContext cxt = new DataGetContext();
                    cxt.setDraftDO(this.draftDO);
                    cxt.setCurrentRuleCfg(cfg);
                    cxt.setExecType(execType);
                    cxt.setParam(param);
                    cxt.setTaskLog(this.taskLog);
                    ExRateDataGetHandler handler = ExRateDataGetHandlerFactory.createDraftDataGetHandler(cfg);
                    handler.initContext(cxt);
                    int count = handler.doExtract();
                    this.insertDraftEntry(this.draftDO, cfg.getSourceId(), count);
                    totalCount += count;
                    deleteCount += handler.getDeleteCount();
                }
                if (hasError) break block25;
            }
            catch (Exception e) {
                block26: {
                    try {
                        hasError = true;
                        this.taskLog.endTaskLog(null, this.failedMsg(e));
                        this.taskLog.persist(true);
                        logger.error((Throwable)e);
                        if (hasError) break block26;
                    }
                    catch (Throwable throwable) {
                        if (!hasError) {
                            if (ExecOpEnum.isExratedraft_update((String)param.getExecOpEnum().getValue())) {
                                this.taskLog.endTaskLog(null, ResManagerHelper.getLocalString((LocaleString)ResManager.getLocaleString((String)"\u672c\u6b21\u6210\u529f\u66f4\u65b0\u5e95\u7a3f\u5171\u3010%s\u3011\u6761\u5b58\u7eed\u6c47\u7387\u4e1a\u52a1\u660e\u7ec6\u3002", (String)"ExRateDataGetService_8", (String)"tmc-mrm-business"), (Object[])new Object[]{totalCount}));
                            } else if (EmptyUtil.isEmpty((String)previousVersionDraftNumber)) {
                                this.taskLog.endTaskLog(null, ResManagerHelper.getLocalString((LocaleString)ResManager.getLocaleString((String)"\u6839\u636e\u5e95\u7a3f\u914d\u7f6e\u4ece\u63a5\u53e3\u6210\u529f\u83b7\u53d6\u3010%s\u3011\u6761\u4e1a\u52a1\u6570\u636e\u3002", (String)"ExRateDataGetService_9", (String)"tmc-mrm-business"), (Object[])new Object[]{totalCount}));
                            } else {
                                this.taskLog.endTaskLog(null, ResManagerHelper.getLocalString((LocaleString)ResManager.getLocaleString((String)"\u6839\u636e\u5e95\u7a3f\u914d\u7f6e\u4ece\u63a5\u53e3\u6210\u529f\u83b7\u53d6\u3010%1$s\u3011\u6761\u4e1a\u52a1\u6570\u636e\uff1b\u4ece\u5e95\u7a3f%2$s\u6210\u529f\u83b7\u53d6\u3010%3$s\u3011\u6761\u624b\u5de5\u5bfc\u5165\u6216\u65b0\u589e\u7684\u672a\u5230\u671f\u7684\u4e1a\u52a1\u6570\u636e\u3002", (String)"ExRateDataGetService_4", (String)"tmc-mrm-business"), (Object[])new Object[]{totalCount, previousVersionDraftNumber, copyCount - deleteCount}));
                            }
                            this.taskLog.persist(true);
                        }
                        this.draftDO.set("draftstatus", (Object)DraftStatusEnum.FINISH.getValue());
                        this.draftDO.set("modifytime", (Object)new Date());
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.draftDO});
                        throw throwable;
                    }
                    if (ExecOpEnum.isExratedraft_update((String)param.getExecOpEnum().getValue())) {
                        this.taskLog.endTaskLog(null, ResManagerHelper.getLocalString((LocaleString)ResManager.getLocaleString((String)"\u672c\u6b21\u6210\u529f\u66f4\u65b0\u5e95\u7a3f\u5171\u3010%s\u3011\u6761\u5b58\u7eed\u6c47\u7387\u4e1a\u52a1\u660e\u7ec6\u3002", (String)"ExRateDataGetService_8", (String)"tmc-mrm-business"), (Object[])new Object[]{totalCount}));
                    } else if (EmptyUtil.isEmpty((String)previousVersionDraftNumber)) {
                        this.taskLog.endTaskLog(null, ResManagerHelper.getLocalString((LocaleString)ResManager.getLocaleString((String)"\u6839\u636e\u5e95\u7a3f\u914d\u7f6e\u4ece\u63a5\u53e3\u6210\u529f\u83b7\u53d6\u3010%s\u3011\u6761\u4e1a\u52a1\u6570\u636e\u3002", (String)"ExRateDataGetService_9", (String)"tmc-mrm-business"), (Object[])new Object[]{totalCount}));
                    } else {
                        this.taskLog.endTaskLog(null, ResManagerHelper.getLocalString((LocaleString)ResManager.getLocaleString((String)"\u6839\u636e\u5e95\u7a3f\u914d\u7f6e\u4ece\u63a5\u53e3\u6210\u529f\u83b7\u53d6\u3010%1$s\u3011\u6761\u4e1a\u52a1\u6570\u636e\uff1b\u4ece\u5e95\u7a3f%2$s\u6210\u529f\u83b7\u53d6\u3010%3$s\u3011\u6761\u624b\u5de5\u5bfc\u5165\u6216\u65b0\u589e\u7684\u672a\u5230\u671f\u7684\u4e1a\u52a1\u6570\u636e\u3002", (String)"ExRateDataGetService_4", (String)"tmc-mrm-business"), (Object[])new Object[]{totalCount, previousVersionDraftNumber, copyCount - deleteCount}));
                    }
                    this.taskLog.persist(true);
                }
                this.draftDO.set("draftstatus", (Object)DraftStatusEnum.FINISH.getValue());
                this.draftDO.set("modifytime", (Object)new Date());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.draftDO});
            }
            if (ExecOpEnum.isExratedraft_update((String)param.getExecOpEnum().getValue())) {
                this.taskLog.endTaskLog(null, ResManagerHelper.getLocalString((LocaleString)ResManager.getLocaleString((String)"\u672c\u6b21\u6210\u529f\u66f4\u65b0\u5e95\u7a3f\u5171\u3010%s\u3011\u6761\u5b58\u7eed\u6c47\u7387\u4e1a\u52a1\u660e\u7ec6\u3002", (String)"ExRateDataGetService_8", (String)"tmc-mrm-business"), (Object[])new Object[]{totalCount}));
            } else if (EmptyUtil.isEmpty((String)previousVersionDraftNumber)) {
                this.taskLog.endTaskLog(null, ResManagerHelper.getLocalString((LocaleString)ResManager.getLocaleString((String)"\u6839\u636e\u5e95\u7a3f\u914d\u7f6e\u4ece\u63a5\u53e3\u6210\u529f\u83b7\u53d6\u3010%s\u3011\u6761\u4e1a\u52a1\u6570\u636e\u3002", (String)"ExRateDataGetService_9", (String)"tmc-mrm-business"), (Object[])new Object[]{totalCount}));
            } else {
                this.taskLog.endTaskLog(null, ResManagerHelper.getLocalString((LocaleString)ResManager.getLocaleString((String)"\u6839\u636e\u5e95\u7a3f\u914d\u7f6e\u4ece\u63a5\u53e3\u6210\u529f\u83b7\u53d6\u3010%1$s\u3011\u6761\u4e1a\u52a1\u6570\u636e\uff1b\u4ece\u5e95\u7a3f%2$s\u6210\u529f\u83b7\u53d6\u3010%3$s\u3011\u6761\u624b\u5de5\u5bfc\u5165\u6216\u65b0\u589e\u7684\u672a\u5230\u671f\u7684\u4e1a\u52a1\u6570\u636e\u3002", (String)"ExRateDataGetService_4", (String)"tmc-mrm-business"), (Object[])new Object[]{totalCount, previousVersionDraftNumber, copyCount - deleteCount}));
            }
            this.taskLog.persist(true);
        }
        this.draftDO.set("draftstatus", (Object)DraftStatusEnum.FINISH.getValue());
        this.draftDO.set("modifytime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.draftDO});
        long endTime = System.currentTimeMillis();
        logger.info("\u5b8c\u6210\u62bd\u53d6\u6570{},\u8017\u65f6{}ms", (Object)totalCount, (Object)(endTime - beginTime));
        if (!hasError) {
            this.updateAnalysisObj(param);
        }
    }

    private DynamicObject getPreviousVersionDraft(DynamicObject draftDO) {
        long id = draftDO.getLong("id");
        QFilter draftFilter = new QFilter("id", "!=", (Object)id);
        DynamicObjectCollection draft = QueryServiceHelper.query((String)"mrm_exrate_draft", (String)"id,billno", (QFilter[])draftFilter.toArray(), (String)"draftcreatedate desc", (int)1);
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)draft)) {
            return (DynamicObject)draft.get(0);
        }
        return null;
    }

    private int copyDataFromPreviousVersion(DynamicObject draftDO, DynamicObject previousVersionDraft) {
        int copyCount = 0;
        Date draftCreateDate = draftDO.getDate("draftcreatedate");
        if (!EmptyUtil.isEmpty((DynamicObject)previousVersionDraft)) {
            QFilter draftDataFilter = new QFilter("exratedraft", "=", (Object)previousVersionDraft.getLong("id"));
            draftDataFilter.and("bizdatasource", "in", (Object)new String[]{"import", "manual"});
            DynamicObjectCollection draftDatas = QueryServiceHelper.query((String)"mrm_exrate_draft_data", (String)"id", (QFilter[])draftDataFilter.toArray());
            Object[] draftDataIds = draftDatas.stream().map(e -> e.getLong("id")).toArray();
            Object[] draftDataArr = TmcDataServiceHelper.load((Object[])draftDataIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"mrm_exrate_draft_data"));
            if (!EmptyUtil.isEmpty((Object[])draftDataArr)) {
                ArrayList<DynamicObject> cloneDraftDatas = new ArrayList<DynamicObject>(draftDataArr.length);
                for (int i = 0; i < draftDataArr.length; ++i) {
                    Object draftData = draftDataArr[i];
                    Date date = draftData.getDate("enddate");
                    if (date != null && date.before(draftCreateDate)) continue;
                    DynamicObject cloneDraftData = TmcDataServiceHelper.clone((DynamicObject)draftData);
                    cloneDraftData.set("exratedraft", (Object)draftDO);
                    cloneDraftDatas.add(cloneDraftData);
                }
                copyCount = cloneDraftDatas.size();
                try (TXHandle tx = TX.requiresNew();){
                    try {
                        TmcDataServiceHelper.save((DynamicObject[])cloneDraftDatas.toArray(new DynamicObject[0]));
                    }
                    catch (Exception e2) {
                        tx.markRollback();
                    }
                }
            }
        }
        return copyCount;
    }

    private LocaleString failedMsg(Exception e) {
        return ResManagerHelper.getLocalString((LocaleString)ResManager.getLocaleString((String)"\u5931\u8d25\u539f\u56e0\uff1a%s", (String)"IntRateDataGetService_2", (String)"tmc-mrm-business"), (Object[])new Object[]{ExceptionUtils.getExceptionStackTraceMessage((Exception)e)});
    }

    private List<DraftCfgEntry> parseRuleCfg(DynamicObject draftConfig, DataGetParam param) {
        List<Long> sourceIds;
        DynamicObjectCollection entries = draftConfig.getDynamicObjectCollection("entryentity");
        ArrayList<DraftCfgEntry> entryList = new ArrayList<DraftCfgEntry>(entries.size());
        if (ExecOpEnum.isExratedraft_update((String)param.getExecOpEnum().getValue()) && (sourceIds = param.getSourceIds()) != null && sourceIds.size() > 0) {
            entries.removeIf(e -> !sourceIds.contains(e.getDynamicObject("sourcebill").getLong("id")));
        }
        for (DynamicObject row : entries) {
            String ruleId = row.getString("ruleid");
            DynamicObject sourceBill = row.getDynamicObject("sourcebill");
            DraftCfgEntry draftCfgEntry = this.getDraftCfgEntry(sourceBill, ruleId);
            if (draftCfgEntry == null) continue;
            entryList.add(draftCfgEntry);
        }
        return entryList;
    }

    private DraftCfgEntry getDraftCfgEntry(DynamicObject sourceBill, String ruleId) {
        String targetEntity = ExRateDataGetService.getTargetEntity();
        if (!EmptyUtil.isEmpty((DynamicObject)sourceBill)) {
            DynamicObject sourcebill = sourceBill.getDynamicObject("sourcebill");
            DynamicObject sourceentity = sourceBill.getDynamicObject("sourceentity");
            return new DraftCfgEntry(Long.valueOf(sourceBill.getLong("id")), sourcebill.getString("number"), sourcebill.getString("name"), sourceentity.getString("number"), targetEntity, ruleId);
        }
        return null;
    }

    protected LocaleString checkIfTaskRunning(DataGetParam param) {
        LocaleString msg = null;
        if (ExecOpEnum.isExratedraft_update((String)param.getExecOpEnum().getValue())) {
            Long draftId = param.getDraftId();
            QFilter filter = new QFilter("id", "=", (Object)draftId);
            DynamicObject draft = QueryServiceHelper.queryOne((String)"mrm_exrate_draft", (String)"billno,draftstatus", (QFilter[])filter.toArray());
            if (draft != null) {
                String draftStatus = draft.getString("draftstatus");
                if (DraftStatusEnum.RUNNING.getValue().equals(draftStatus)) {
                    msg = ResManager.getLocaleString((String)"\u53d6\u6570\u5931\u8d25\uff0c\u5b58\u5728\u6b63\u5728\u6267\u884c\u7684\u5e95\u7a3f\u53d6\u6570\u4efb\u52a1\uff0c\u8bf7\u7ed3\u675f\u540e\u518d\u8bd5\u3002", (String)"ExRateDataGetService_3", (String)"tmc-mrm-business");
                }
            }
        } else {
            QFilter filter = new QFilter("draftcreatedate", "=", (Object)DateUtils.getCurrentDate());
            DynamicObject draft = QueryServiceHelper.queryOne((String)"mrm_exrate_draft", (String)"billno,draftstatus", (QFilter[])filter.toArray());
            if (draft != null) {
                msg = ResManager.getLocaleString((String)"\u5f53\u524d\u7cfb\u7edf\u65e5\u671f\u5df2\u5b58\u5728\u6c47\u7387\u5e95\u7a3f\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6267\u884c\u3002", (String)"ExRateDataGetService_5", (String)"tmc-mrm-business");
            }
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAnalysisObj(DataGetParam param) {
        QFilter filter = null;
        filter = !ExecOpEnum.isExratedraft_update((String)param.getExecOpEnum().getValue()) ? new QFilter("enable", "=", (Object)"1").and("isautoupdate", "=", (Object)"1") : new QFilter("isautoupdate", "=", (Object)"1").or("draft", "=", (Object)this.draftDO.getLong("id"));
        DataGetTaskLog anlTaskLog = DataGetTaskLog.createTaskLog();
        anlTaskLog.initMainTask("", DraftLogTypeEnum.EXRATE.getValue(), ExecObjEnum.EXRATE_ANALYSISOBJ.getValue(), param.getExecTypeEnum().getValue(), DateUtils.getCurrentDate(), param.getExecOpEnum().getValue());
        anlTaskLog.initDraft(this.draftDO);
        anlTaskLog.persist(true);
        try (TXHandle tx = TX.requiresNew();){
            try {
                Object[] anlyObjs = TmcDataServiceHelper.load((String)"mrm_exrate_analysisobj", (String)"draft,isautoupdate,modifytime", (QFilter[])(filter == null ? new QFilter[]{} : filter.toArray()));
                if (EmptyUtil.isEmpty((Object[])anlyObjs) || anlyObjs.length == 0) {
                    anlTaskLog.endTaskLog(ExecStatusEnum.SUCCESSFUL.getValue(), ResManagerHelper.getLocalString((LocaleString)ResManager.getLocaleString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u9700\u8981\u66f4\u65b0\u7684\u5206\u6790\u5bf9\u8c61\u3002", (String)"IntRateDataGetService_3", (String)"tmc-mrm-business"), (Object[])new Object[0]));
                } else {
                    int count = 0;
                    long currDraftId = this.draftDO.getLong("id");
                    for (Object analysisObj : anlyObjs) {
                        long draftId = 0L;
                        if (!ExecOpEnum.isExratedraft_update((String)param.getExecOpEnum().getValue())) {
                            draftId = this.draftDO.getLong("id");
                            analysisObj.set("draft", (Object)draftId);
                        } else {
                            DynamicObject draft = analysisObj.getDynamicObject("draft");
                            if (draft != null) {
                                draftId = draft.getLong("id");
                            }
                        }
                        boolean isautoupdate = analysisObj.getBoolean("isautoupdate");
                        if (isautoupdate || draftId == currDraftId) {
                            ++count;
                        }
                        analysisObj.set("modifytime", (Object)new Date());
                    }
                    SaveServiceHelper.save((DynamicObject[])anlyObjs);
                    anlTaskLog.endTaskLog(ExecStatusEnum.SUCCESSFUL.getValue(), ResManagerHelper.getLocalString((LocaleString)ResManager.getLocaleString((String)"\u5e95\u7a3f\u7248\u672c\u6570\u636e\u66f4\u65b0\uff0c\u7cfb\u7edf\u81ea\u52a8\u66f4\u65b0\u3010%s\u3011\u6761\u6c47\u7387\u4e1a\u52a1\u5206\u6790\u5bf9\u8c61\u3002", (String)"ExRateDataGetService_6", (String)"tmc-mrm-business"), (Object[])new Object[]{count}));
                }
            }
            catch (Exception e) {
                tx.markRollback();
                anlTaskLog.endTaskLog(ExecStatusEnum.FAILED.getValue(), this.failedMsg(e));
                logger.error((Throwable)e);
            }
            finally {
                anlTaskLog.persist(true);
            }
        }
    }

    protected DynamicObject buildRateDraft(DataGetParam param) {
        Long draftid = param.getDraftId();
        if (draftid != null && draftid > 0L) {
            this.draftDO = TmcDataServiceHelper.loadSingle((Object)draftid, (String)"mrm_exrate_draft");
            this.draftDO.set("draftstatus", (Object)DraftStatusEnum.RUNNING.getValue());
            this.save(this.draftDO, true);
            return this.draftDO;
        }
        DynamicObject rateDraft = this.createDraft();
        this.save(rateDraft, true);
        this.draftDO = rateDraft;
        return rateDraft;
    }

    private DynamicObject createDraft() {
        DynamicObject rateDraft = BusinessDataServiceHelper.newDynamicObject((String)"mrm_exrate_draft");
        Long id = DBServiceHelper.genGlobalLongId();
        rateDraft.set("id", (Object)id);
        String billNo = CodeRuleServiceHelper.getNumber((String)"mrm_exrate_draft", (DynamicObject)rateDraft, null);
        rateDraft.set("billno", (Object)billNo);
        rateDraft.set("billstatus", (Object)TcBillStatusEnum.AUDIT.getValue());
        rateDraft.set("draftcreatedate", (Object)DateUtils.getCurrentDate());
        rateDraft.set("draftstatus", (Object)DraftStatusEnum.RUNNING.getValue());
        rateDraft.set("creator", (Object)RequestContext.get().getCurrUserId());
        return rateDraft;
    }

    private void save(DynamicObject dyObj, boolean newTrans) {
        block15: {
            if (newTrans) {
                try (TXHandle tx = TX.requiresNew();){
                    try {
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyObj});
                        break block15;
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        logger.error((Throwable)e);
                        throw e;
                    }
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyObj});
        }
    }

    protected static String getTargetEntity() {
        return "mrm_exrate_draft_data";
    }

    private void insertDraftEntry(DynamicObject draft, Long sourceId, int count) {
        if (draft == null) {
            return;
        }
        DynamicObjectCollection entries = draft.getDynamicObjectCollection("entryentity");
        boolean insert = true;
        for (DynamicObject entry : entries) {
            DynamicObject data;
            Long datasourceId;
            Object datasource = entry.get("datasource");
            if (datasource instanceof Long && (datasourceId = (Long)datasource).equals(sourceId)) {
                entry.set("count", (Object)count);
                insert = false;
            }
            if (!(datasource instanceof DynamicObject) || (data = (DynamicObject)datasource).getLong("id") != sourceId.longValue()) continue;
            entry.set("count", (Object)count);
            insert = false;
        }
        if (insert) {
            DynamicObject dynamicObject = entries.addNew();
            dynamicObject.set("datasource", (Object)sourceId);
            dynamicObject.set("count", (Object)count);
        }
    }
}

